/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DesignElementPropsTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testImageProperties() throws Exception {
        List list = this.getProperties("Image");
        DesignElementPropsTest.assertTrue((boolean)this.compareListWithGoldenFile(list, "ImagePropsTest_golden.txt"));
        list = this.getLocalProperties("Image");
        DesignElementPropsTest.assertTrue((boolean)this.compareListWithGoldenFile(list, "ImageLocalPropsTest_golden.txt"));
    }

    public void testTableProperties() throws Exception {
        List list = this.getProperties("Table");
        DesignElementPropsTest.assertTrue((boolean)this.compareListWithGoldenFile(list, "TableItemPropsTest_golden.txt"));
        list = this.getLocalProperties("Table");
        DesignElementPropsTest.assertTrue((boolean)this.compareListWithGoldenFile(list, "TableItemLocalPropsTest_golden.txt"));
    }

    public void testCellProperties() throws Exception {
        List list = this.getProperties("Cell");
        DesignElementPropsTest.assertTrue((boolean)this.compareListWithGoldenFile(list, "CellPropsTest_golden.txt"));
        list = this.getLocalProperties("Cell");
        DesignElementPropsTest.assertTrue((boolean)this.compareListWithGoldenFile(list, "CellLocalPropsTest_golden.txt"));
    }

    private List getProperties(String elementName) throws Exception {
        IMetaDataDictionary dictionary = DesignEngine.getMetaDataDictionary();
        IElementDefn eDefn = dictionary.getElement(elementName);
        List list = eDefn.getProperties();
        return list;
    }

    private List getLocalProperties(String elementName) throws Exception {
        IMetaDataDictionary dictionary = DesignEngine.getMetaDataDictionary();
        IElementDefn eDefn = dictionary.getElement(elementName);
        List list = eDefn.getLocalProperties();
        return list;
    }

    private boolean compareListWithGoldenFile(List list, String goldenFile) throws Exception {
        boolean isIdentical = true;
        goldenFile = "golden/" + goldenFile;
        InputStream is = this.getResourceAStream(goldenFile);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        int i = 0;
        while (i < list.size()) {
            String line;
            String item = ((PropertyDefn)list.get(i)).getName();
            if (!item.equals(line = reader.readLine())) {
                System.out.print("line number:" + i);
                System.out.println("\t");
                System.out.println("item:" + item + "\tline:" + line + "\n");
                isIdentical = false;
                break;
            }
            ++i;
        }
        String line = reader.readLine();
        if (line != null) {
            return false;
        }
        return isIdentical;
    }
}

