/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ModuleTest
extends BaseTestCase {
    private static final String fileName = "ModuleTest.xml";
    private static final String idFileName = "ModuleTest_2.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.sessionHandle = engine.newSessionHandle(ULocale.ENGLISH);
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        dd.enableElementID();
        this.designHandle = this.sessionHandle.createDesign("myDesign");
        this.design = (ReportDesign)this.designHandle.getModule();
    }

    protected void tearDown() throws Exception {
        this.design = null;
        this.designHandle = null;
    }

    public void testElementID() {
        Style element = new Style();
        element.setName("element");
        element.setID(this.design.getNextID());
        this.design.addElementID((DesignElement)element);
        DesignElement o = this.design.getElementByID(element.getID());
        ModuleTest.assertEquals((Object)element, (Object)o);
        this.design.dropElementID((DesignElement)element);
        o = this.design.getElementByID(element.getID());
        ModuleTest.assertNull((Object)o);
    }

    public void testIDWithParser() throws Exception {
        this.openDesign(fileName);
        ModuleTest.assertEquals((long)1L, (long)this.designHandle.getID());
        MasterPageHandle page = this.designHandle.findMasterPage("page");
        ModuleTest.assertEquals((long)2L, (long)page.getID());
        FreeFormHandle parent = (FreeFormHandle)this.designHandle.findElement("parent");
        ModuleTest.assertEquals((long)3L, (long)parent.getID());
        LabelHandle label = (LabelHandle)this.designHandle.findElement("label");
        ModuleTest.assertEquals((long)4L, (long)label.getID());
        FreeFormHandle child = (FreeFormHandle)this.designHandle.findElement("child");
        ModuleTest.assertEquals((long)5L, (long)child.getID());
        LabelHandle labelTwo = (LabelHandle)this.designHandle.findElement("labelTwo");
        ModuleTest.assertEquals((long)6L, (long)labelTwo.getID());
        ModuleTest.assertEquals((Object)this.designHandle, (Object)this.designHandle.getElementByID(1L));
        ModuleTest.assertEquals((Object)page, (Object)this.designHandle.getElementByID(2L));
        ModuleTest.assertEquals((Object)parent, (Object)this.designHandle.getElementByID(3L));
        ModuleTest.assertEquals((Object)label, (Object)this.designHandle.getElementByID(4L));
        ModuleTest.assertEquals((Object)child, (Object)this.designHandle.getElementByID(5L));
        ModuleTest.assertEquals((Object)labelTwo, (Object)this.designHandle.getElementByID(6L));
        this.designHandle.close();
        this.openDesign(idFileName);
        ModuleTest.assertNotNull((Object)this.designHandle);
        this.save();
        ModuleTest.assertTrue((boolean)this.compareFile("ModuleTest_golden_2.xml"));
    }

    public void testIDWithWriter() throws Exception {
        this.openDesign(fileName);
        String goldenFileName = "ModuleTest_golden.xml";
        this.save();
        ModuleTest.assertTrue((boolean)this.compareFile(goldenFileName));
    }

    public void testIDWithCommand() throws Exception {
        this.openDesign(fileName);
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table", 0, 0, 1, 0);
        ModuleTest.assertNotNull((Object)table);
        LabelHandle label = this.designHandle.getElementFactory().newLabel("label");
        ModuleTest.assertNotNull((Object)label);
        CellHandle cell = this.designHandle.getElementFactory().newCell();
        ModuleTest.assertNotNull((Object)cell);
        RowHandle row = (RowHandle)table.getDetail().get(0);
        cell.addElement((DesignElementHandle)label, 0);
        ModuleTest.assertEquals((long)0L, (long)label.getID());
        row.addElement((DesignElementHandle)cell, 0);
        ModuleTest.assertEquals((long)0L, (long)cell.getID());
        ModuleTest.assertEquals((long)0L, (long)table.getID());
        this.designHandle.addElement((DesignElementHandle)table, 6);
        ModuleTest.assertEquals((long)7L, (long)table.getID());
        ModuleTest.assertEquals((long)8L, (long)row.getID());
        ModuleTest.assertEquals((long)9L, (long)cell.getID());
        ModuleTest.assertEquals((long)10L, (long)label.getID());
        ModuleTest.assertEquals((Object)table, (Object)this.designHandle.getElementByID(7L));
        ModuleTest.assertEquals((Object)row, (Object)this.designHandle.getElementByID(8L));
        ModuleTest.assertEquals((Object)cell, (Object)this.designHandle.getElementByID(9L));
        ModuleTest.assertEquals((Object)label, (Object)this.designHandle.getElementByID(10L));
        this.designHandle.getCommandStack().undo();
        ModuleTest.assertEquals((long)7L, (long)table.getID());
        ModuleTest.assertEquals((long)8L, (long)row.getID());
        ModuleTest.assertEquals((long)9L, (long)cell.getID());
        ModuleTest.assertEquals((long)10L, (long)label.getID());
        ModuleTest.assertNull((Object)this.designHandle.getElementByID(7L));
        ModuleTest.assertNull((Object)this.designHandle.getElementByID(8L));
        ModuleTest.assertNull((Object)this.designHandle.getElementByID(9L));
        ModuleTest.assertNull((Object)this.designHandle.getElementByID(10L));
        this.designHandle.close();
        this.openDesign("ModuleTest_1.xml");
        table = this.designHandle.getElementFactory().newTableItem("table", 0, 0, 1, 0);
        ModuleTest.assertNotNull((Object)table);
        label = this.designHandle.getElementFactory().newLabel("label");
        ModuleTest.assertNotNull((Object)label);
        cell = this.designHandle.getElementFactory().newCell();
        ModuleTest.assertNotNull((Object)cell);
        row = (RowHandle)table.getDetail().get(0);
        cell.addElement((DesignElementHandle)label, 0);
        ModuleTest.assertEquals((long)0L, (long)label.getID());
        row.addElement((DesignElementHandle)cell, 0);
        ModuleTest.assertEquals((long)0L, (long)cell.getID());
        ModuleTest.assertEquals((long)0L, (long)table.getID());
        this.designHandle.addElement((DesignElementHandle)table, 6);
        ModuleTest.assertEquals((long)12L, (long)table.getID());
        ModuleTest.assertEquals((long)13L, (long)row.getID());
        ModuleTest.assertEquals((long)14L, (long)cell.getID());
        ModuleTest.assertEquals((long)15L, (long)label.getID());
    }

    public void testDragDataSourceAndDataSet() throws Exception {
        this.openDesign("ModuleTest_3.xml");
        SlotHandle slotHandle = this.designHandle.getDataSources();
        DataSourceHandle dsHandle2 = this.designHandle.findDataSource("Data Source2");
        IDesignElement ds = dsHandle2.copy();
        this.designHandle.rename(ds.getHandle((Module)this.design));
        slotHandle.paste(ds, 1);
        DataSourceHandle dsHandle = (DataSourceHandle)slotHandle.get(0);
        ModuleTest.assertEquals((String)"Data Source2", (String)dsHandle.getName());
        dsHandle = (DataSourceHandle)slotHandle.get(1);
        ModuleTest.assertEquals((String)"Data Source21", (String)dsHandle.getName());
        dsHandle = (DataSourceHandle)slotHandle.get(2);
        ModuleTest.assertEquals((String)"Data Source3", (String)dsHandle.getName());
        dsHandle = (DataSourceHandle)slotHandle.get(3);
        ModuleTest.assertEquals((String)"Data Source4", (String)dsHandle.getName());
        slotHandle = this.designHandle.getDataSets();
        DataSetHandle setHandle1 = this.designHandle.findDataSet("Data Set");
        IDesignElement set = setHandle1.copy();
        this.designHandle.rename(set.getHandle((Module)this.design));
        slotHandle.paste(set, 1);
        DataSetHandle setHandle = (DataSetHandle)slotHandle.get(0);
        ModuleTest.assertEquals((String)"Data Set", (String)setHandle.getName());
        setHandle = (DataSetHandle)slotHandle.get(1);
        ModuleTest.assertEquals((String)"Data Set3", (String)setHandle.getName());
        setHandle = (DataSetHandle)slotHandle.get(2);
        ModuleTest.assertEquals((String)"Data Set1", (String)setHandle.getName());
        setHandle = (DataSetHandle)slotHandle.get(3);
        ModuleTest.assertEquals((String)"Data Set2", (String)setHandle.getName());
    }

    public void testGetMessage() throws Exception {
        this.openDesign("ModuleTest_4.xml", ULocale.ENGLISH);
        LabelHandle handle1 = (LabelHandle)this.designHandle.findElement("label1");
        ModuleTest.assertEquals((String)"label1 in i18n", (String)handle1.getRoot().getMessage(handle1.getTextKey()));
        LabelHandle handle2 = (LabelHandle)this.designHandle.findElement("label2");
        ModuleTest.assertEquals((String)"label2 in i18n", (String)handle2.getRoot().getMessage(handle2.getTextKey()));
    }

    public void testGetMessageKeys() throws Exception {
        this.openDesign("ModuleTest_4.xml", ULocale.ENGLISH);
        List keyList = this.designHandle.getMessageKeys();
        ModuleTest.assertEquals((Object)"a1", keyList.get(0));
        ModuleTest.assertEquals((Object)"a2", keyList.get(1));
    }
}

