/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.JointDataSet;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class SemanticErrorTest
extends BaseTestCase {
    public void testErrorMessages() throws Exception {
        TableItem table = new TableItem();
        this.os = new ByteArrayOutputStream();
        table.setName("customerTable");
        this.print((DesignElement)table, "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT");
        this.print((DesignElement)table, "Error.SemanticError.INCONSISTENT_GRID_COL_COUNT");
        this.print2((DesignElement)table, new String[]{"Table", "test table"}, "Error.SemanticError.OVERLAPPING_CELLS");
        String[] stringArray = new String[2];
        stringArray[0] = "Table";
        this.print2((DesignElement)table, stringArray, "Error.SemanticError.OVERLAPPING_CELLS");
        this.print((DesignElement)table, "Error.SemanticError.INVALID_PAGE_SIZE");
        this.print((DesignElement)table, "Error.SemanticError.MISSING_PAGE_SIZE");
        this.print((DesignElement)table, "Error.SemanticError.CANNOT_SPECIFY_PAGE_SIZE");
        this.print((DesignElement)table, "Error.SemanticError.INVALID_PAGE_MARGINS");
        this.print((DesignElement)table, "Error.SemanticError.MISSING_MASTER_PAGE");
        this.print((DesignElement)table, "Error.SemanticError.INVALID_MULTI_COLUMN");
        this.print2((DesignElement)table, new String[]{"dataSet", "unresolvedDataSet"}, "Error.SemanticError.INVALID_ELEMENT_REF");
        this.print((DesignElement)table, "Error.SemanticError.MISSING_SQL_STMT");
        this.print((DesignElement)table, "Error.SemanticError.MISSING_DATA_SET");
        this.print1((DesignElement)table, "inexsistent.bmp", "Error.SemanticError.IMAGE_FILE_NOT_FOUND");
        this.print1((DesignElement)table, "abc", "Error.SemanticError.INVALID_PROPERTY_NAME");
        this.print((DesignElement)table, "Error.SemanticError.AT_LEAST_ONE_COLUMN");
        this.print((DesignElement)table, "Error.SemanticError.UNSUPPORTED_ELEMENT");
        this.print1((DesignElement)table, "group1", "Error.SemanticError.DUPLICATE_GROUP_NAME");
        this.print1((DesignElement)table, "red", "Error.SemanticError.INVALID_CUSTOM_COLOR_NAME");
        this.print1((DesignElement)table, "BgColor", "Error.SemanticError.DUPLICATE_CUSTOM_COLOR_NAME");
        this.print2((DesignElement)table, new String[]{"test"}, "Error.SemanticError.VALUE_FORBIDDEN");
        TemplateParameterDefinition param = new TemplateParameterDefinition("test");
        this.print1((DesignElement)param, param.getIdentifier(), "Error.SemanticError.MISSING_TEMPLATE_PARAMETER_TYPE");
        param.setAllowedType("FreeForm");
        Label label = new Label("label");
        param.getSlot(0).add((DesignElement)label);
        this.print2((DesignElement)param, new String[]{param.getIdentifier(), label.getIdentifier(), "FreeForm"}, "Error.SemanticError.INCONSISTENT_TEMPLATE_PARAMETER_TYPE");
        JointDataSet jointDataSet = new JointDataSet("JointDataSet");
        this.print2((DesignElement)jointDataSet, new String[]{"jointDataSet", "leftDataSet"}, "Error.SemanticError.DATA_SET_MISSED_IN_JOINT_DATA_SET");
        this.os.close();
        SemanticErrorTest.assertTrue((boolean)this.compareFile("SemanticError.golden.txt"));
    }

    private void print(DesignElement element, String errorCode) {
        block3: {
            SemanticError error = new SemanticError(element, errorCode);
            String code = error.getErrorCode();
            try {
                this.os.write(code.getBytes());
                int i = code.length();
                while (i < 60) {
                    this.os.write(32);
                    ++i;
                }
                this.os.write(error.getMessage().getBytes());
                this.os.write(10);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private void print1(DesignElement element, String value, String errorCode) {
        block3: {
            SemanticError error = new SemanticError(element, new String[]{value}, errorCode);
            String code = error.getErrorCode();
            try {
                this.os.write(code.getBytes());
                int i = code.length();
                while (i < 60) {
                    this.os.write(32);
                    ++i;
                }
                this.os.write(error.getMessage().getBytes());
                this.os.write(10);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private void print2(DesignElement element, String[] params, String errorCode) {
        block3: {
            SemanticError error = new SemanticError(element, params, errorCode);
            String code = error.getErrorCode();
            try {
                this.os.write(code.getBytes());
                int i = code.length();
                while (i < 60) {
                    this.os.write(32);
                    ++i;
                }
                this.os.write(error.getMessage().getBytes());
                this.os.write(10);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }
}

