/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension;

import java.util.List;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.extension.IEncryptionHelper;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.extension.ExtensionTestUtil;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.SimpleEncryptionHelper;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class EncryptionHelperExtensionTest
extends BaseTestCase {
    private static final String propName = "pswd";
    private static final String FILE_NAME = "EncryptionExtensionTest.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testMetaData() {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        List helpers = dd.getEncryptionHelpers();
        EncryptionHelperExtensionTest.assertTrue((helpers.size() >= 4 ? 1 : 0) != 0);
        IEncryptionHelper helper = dd.getEncryptionHelper("oneEncryptionHelper");
        EncryptionHelperExtensionTest.assertEquals((String)"org.eclipse.birt.report.model.tests.encryptionHelper.EncryptionHelperImpl", (String)helper.getClass().getName());
        String testString = "something";
        EncryptionHelperExtensionTest.assertEquals((String)"_ab_something", (String)helper.encrypt(testString));
        EncryptionHelperExtensionTest.assertEquals((String)testString, (String)helper.decrypt(helper.encrypt(testString)));
        helper = dd.getEncryptionHelper("base64");
        EncryptionHelperExtensionTest.assertEquals((Object)helper, (Object)SimpleEncryptionHelper.getInstance());
        EncryptionHelperExtensionTest.assertNull((Object)dd.getEncryptionHelper("wrong_en"));
        EncryptionHelperExtensionTest.assertEquals((String)"oneEncryptionHelper", (String)dd.getDefaultEncryptionHelperID());
    }

    private ElementPropertyDefn getPropertyDefn(DesignElementHandle item) {
        return (ElementPropertyDefn)item.getPropertyDefn(propName);
    }

    public void testParser() throws Exception {
        this.openDesign(FILE_NAME);
        DesignElementHandle item = this.designHandle.findElement("item_1");
        EncryptionHelperExtensionTest.assertEquals((String)"New Password", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertEquals((String)"base64", (String)item.getElement().getLocalEncryptionID(this.getPropertyDefn(item)));
        EncryptionHelperExtensionTest.assertEquals((Object)"TmV3IFBhc3N3b3Jk", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        EncryptionHelperExtensionTest.assertEquals((String)"base64", (String)item.getElement().getLocalEncryptionID(this.getPropertyDefn(item)));
        EncryptionHelperExtensionTest.assertEquals((String)"New Password", (String)SimpleEncryptionHelper.getInstance().decrypt("TmV3IFBhc3N3b3Jk"));
        item = this.designHandle.findElement("item_3");
        EncryptionHelperExtensionTest.assertEquals((String)"myown", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((Object)"_b_myown", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement().getExtendsElement()), (String)propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalEncryptionID(this.getPropertyDefn(item)));
        EncryptionHelperExtensionTest.assertEquals((String)"encryption_b", (String)item.getElement().getEncryptionID(this.getPropertyDefn(item)));
        item = this.designHandle.findElement("item_2");
        EncryptionHelperExtensionTest.assertEquals((String)"mypswd", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        EncryptionHelperExtensionTest.assertEquals((Object)"_ab_mypswd", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        EncryptionHelperExtensionTest.assertEquals((String)"oneEncryptionHelper", (String)item.getElement().getEncryptionID(this.getPropertyDefn(item)));
        item = this.designHandle.findElement("item_4");
        EncryptionHelperExtensionTest.assertEquals((String)"mypswd", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        EncryptionHelperExtensionTest.assertEquals((String)"encryption_b", (String)item.getElement().getEncryptionID(this.getPropertyDefn(item)));
        EncryptionHelperExtensionTest.assertEquals((Object)"_b_mypswd", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        item = this.designHandle.findElement("item_5");
        EncryptionHelperExtensionTest.assertEquals((String)"_ab_mypswd", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertEquals((String)"no_encryption", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        EncryptionHelperExtensionTest.assertEquals((Object)"_ab_mypswd", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
    }

    public void testCompatibility() throws Exception {
        this.openDesign("EncryptionExtensionTest_1.xml");
        this.save();
        EncryptionHelperExtensionTest.assertTrue((boolean)this.compareFile("EncryptionExtensionTest_golden.xml"));
    }

    public void testCommand() throws Exception {
        this.openDesign(FILE_NAME);
        DesignElementHandle item = this.designHandle.findElement("item_1");
        try {
            item.setEncryption("dataSet", "e");
            EncryptionHelperExtensionTest.fail();
        }
        catch (SemanticException e) {
            EncryptionHelperExtensionTest.assertEquals((String)"Error.EncryptionException.INVALID_ENCRYPTABLE_PROPERTY", (String)e.getErrorCode());
        }
        try {
            item.setEncryption(propName, "no_encryption");
            EncryptionHelperExtensionTest.fail();
        }
        catch (SemanticException e) {
            EncryptionHelperExtensionTest.assertEquals((String)"Error.EncryptionException.INVALID_ENCRYPTION", (String)e.getErrorCode());
        }
        CommandStack stack = this.designHandle.getCommandStack();
        item.setEncryption(propName, "encryption_a");
        EncryptionHelperExtensionTest.assertEquals((String)"New Password", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertEquals((String)"encryption_a", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        EncryptionHelperExtensionTest.assertEquals((Object)"_a_New Password", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        stack.undo();
        EncryptionHelperExtensionTest.assertEquals((String)"New Password", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertEquals((String)"base64", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        EncryptionHelperExtensionTest.assertEquals((Object)"TmV3IFBhc3N3b3Jk", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        stack.redo();
        EncryptionHelperExtensionTest.assertEquals((String)"New Password", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertEquals((String)"encryption_a", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        EncryptionHelperExtensionTest.assertEquals((Object)"_a_New Password", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        item = this.designHandle.findElement("item_2");
        EncryptionHelperExtensionTest.assertEquals((String)"mypswd", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        EncryptionHelperExtensionTest.assertEquals((Object)"_ab_mypswd", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        item.setEncryption(propName, "encryption_b");
        EncryptionHelperExtensionTest.assertEquals((String)"mypswd", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertEquals((String)"encryption_b", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        EncryptionHelperExtensionTest.assertEquals((Object)"_b_mypswd", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        item = this.designHandle.findElement("item_3");
        EncryptionHelperExtensionTest.assertEquals((String)"myown", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((Object)"_b_myown", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement().getExtendsElement()), (String)propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        item.setEncryption(propName, "encryption_a");
        EncryptionHelperExtensionTest.assertEquals((String)"myown", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertEquals((Object)"_a_myown", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        EncryptionHelperExtensionTest.assertEquals((String)"encryption_a", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        stack.undo();
        EncryptionHelperExtensionTest.assertEquals((String)"myown", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((Object)"_b_myown", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement().getExtendsElement()), (String)propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        stack.redo();
        EncryptionHelperExtensionTest.assertEquals((String)"myown", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertEquals((Object)"_a_myown", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        EncryptionHelperExtensionTest.assertEquals((String)"encryption_a", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
    }

    public void testSetProperty() throws Exception {
        this.openDesign(FILE_NAME);
        CommandStack stack = this.designHandle.getCommandStack();
        String value = "newValue";
        DesignElementHandle item = this.designHandle.findElement("item_1");
        EncryptionHelperExtensionTest.assertEquals((Object)"New Password", (Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((String)"base64", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        item.setProperty(propName, (Object)value);
        EncryptionHelperExtensionTest.assertEquals((Object)value, (Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((String)"base64", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        stack.undo();
        EncryptionHelperExtensionTest.assertEquals((Object)"New Password", (Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((String)"base64", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        item = this.designHandle.findElement("item_2");
        EncryptionHelperExtensionTest.assertEquals((Object)"mypswd", (Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((Object)"_ab_mypswd", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        item.setProperty(propName, (Object)value);
        EncryptionHelperExtensionTest.assertEquals((Object)value, (Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((Object)("_ab_" + value), (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        EncryptionHelperExtensionTest.assertEquals((String)"oneEncryptionHelper", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        stack.undo();
        EncryptionHelperExtensionTest.assertEquals((Object)"mypswd", (Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((Object)"_ab_mypswd", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        EncryptionHelperExtensionTest.assertEquals((String)"oneEncryptionHelper", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        item = this.designHandle.findElement("item_3");
        EncryptionHelperExtensionTest.assertEquals((String)"myown", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((Object)"_b_myown", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement().getExtendsElement()), (String)propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        item.setProperty(propName, (Object)value);
        EncryptionHelperExtensionTest.assertEquals((Object)value, (Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((Object)("_b_" + value), (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement()), (String)propName));
        EncryptionHelperExtensionTest.assertEquals((String)"encryption_b", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
        stack.undo();
        EncryptionHelperExtensionTest.assertEquals((String)"myown", (String)item.getStringProperty(propName));
        EncryptionHelperExtensionTest.assertNull((Object)item.getElement().getLocalProperty((Module)this.design, propName));
        EncryptionHelperExtensionTest.assertEquals((Object)"_b_myown", (Object)ExtensionTestUtil.getLocalExtensionMapValue((ExtendedItem)((ExtendedItem)item.getElement().getExtendsElement()), (String)propName));
        EncryptionHelperExtensionTest.assertEquals((String)"encryption_b", (String)item.getElement().getLocalEncryptionID((ElementPropertyDefn)item.getPropertyDefn(propName)));
    }

    private void copyAndInsertItem(DesignElementHandle item) throws Exception {
        String prefix = "copyOf";
        SlotHandle bodyHandle = this.designHandle.getBody();
        IDesignElement copiedItem = item.copy();
        copiedItem.getHandle((Module)this.design).setName(String.valueOf(prefix) + item.getName());
        bodyHandle.add(copiedItem.getHandle((Module)this.design));
    }

    public void testClone() throws Exception {
        this.openDesign(FILE_NAME);
        this.copyAndInsertItem(this.designHandle.findElement("item_1"));
        this.copyAndInsertItem(this.designHandle.findElement("item_2"));
        this.copyAndInsertItem(this.designHandle.findElement("item_3"));
        this.copyAndInsertItem(this.designHandle.findElement("item_4"));
        this.copyAndInsertItem(this.designHandle.findElement("item_5"));
        this.save();
        EncryptionHelperExtensionTest.assertTrue((boolean)this.compareFile("EncryptionExtensionTest_golden_1.xml"));
    }

    public void testDocumentSerialize() throws Exception {
        this.openDesign(FILE_NAME);
        this.serializeDocument();
        this.save();
        EncryptionHelperExtensionTest.assertTrue((boolean)this.compareFile("EncryptionExtensionTest_golden_2.xml"));
    }
}

