/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IPropertyType;
import org.eclipse.birt.report.model.api.olap.TabularMeasureGroupHandle;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.i18n.BaseMessageFileTest;
import org.eclipse.birt.report.model.i18n.MessageConstants;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFileTest
extends BaseMessageFileTest {
    @Override
    protected InputStream getMessageFileInputStream() {
        return ThreadResources.class.getResourceAsStream("Messages.properties");
    }

    @Override
    protected void loadRomFile() throws IOException {
        this.loadResourceKeys("rom.def", ReportDesign.class.getResourceAsStream("rom.def"));
    }

    protected void loadMessageConstants() throws Exception {
        this.loadResourceKeys(MessageConstants.class);
    }

    protected void loadMetaDatas() {
        MetaDataDictionary metaData = MetaDataDictionary.getInstance();
        for (IPropertyType type : metaData.getPropertyTypes()) {
            this.resourceKeyMap.put(type.getDisplayNameKey(), type.getClass().getName());
        }
        for (IClassInfo classInfo : metaData.getClasses()) {
            this.resourceKeyMap.put(classInfo.getDisplayNameKey(), classInfo.getName());
            for (IMemberInfo member : classInfo.getMembers()) {
                this.resourceKeyMap.put(member.getDisplayNameKey(), member.getName());
            }
        }
        for (IMethodInfo methodInfo : metaData.getFunctions()) {
            this.resourceKeyMap.put(methodInfo.getDisplayNameKey(), methodInfo.getName());
        }
    }

    protected void loadResourceKeys(Class<?> constantsClass) throws IllegalArgumentException, IllegalAccessException {
        int PUBLIC_FINAL_STATIC = 25;
        Field[] fields = constantsClass.getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (PUBLIC_FINAL_STATIC == field.getModifiers()) {
                String resourceKey = (String)fields[i].get(null);
                this.resourceKeyMap.put(resourceKey, String.valueOf(constantsClass.getName()) + "." + fields[i].getName());
            }
            ++i;
        }
    }

    public void testMetaDatas() {
        this.loadMetaDatas();
        this.checkResourceKeyMap();
    }

    public void testMessageConstants() throws Exception {
        this.loadMessageConstants();
        this.checkResourceKeyMap();
    }

    public void testDisplayNameOfTabularMeasureGroup() throws Exception {
        this.createDesign();
        TabularMeasureGroupHandle measureGroupHandle = this.designHandle.getElementFactory().newTabularMeasureGroup("");
        MessageFileTest.assertEquals((String)"Summary Field", (String)measureGroupHandle.getName());
        measureGroupHandle = this.designHandle.getElementFactory().newTabularMeasureGroup("");
        MessageFileTest.assertEquals((String)"Summary Field1", (String)measureGroupHandle.getName());
    }
}

