/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.ThemeException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LibraryThemeTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCssStyleSheet() throws Exception {
        this.openLibrary("BlankLibrary.xml");
        ThemeHandle themeHandle = (ThemeHandle)this.libraryHandle.getThemes().get(0);
        LibraryThemeTest.assertTrue((boolean)themeHandle.canAddCssStyleSheet(this.getResource("input/base.css").getFile()));
        LibraryThemeTest.assertTrue((boolean)themeHandle.canAddCssStyleSheet("base.css"));
        CssStyleSheetHandle sheetHandle = this.libraryHandle.openCssStyleSheet(this.getResource("input/base.css").getFile());
        LibraryThemeTest.assertNull((Object)sheetHandle.getContainerHandle());
        themeHandle.addCss(sheetHandle);
        LibraryThemeTest.assertFalse((boolean)themeHandle.canAddCssStyleSheet(sheetHandle));
        LibraryThemeTest.assertFalse((boolean)themeHandle.canAddCssStyleSheet(this.getResource("input/base.css").getFile()));
        List styles = themeHandle.getAllStyles();
        LibraryThemeTest.assertEquals((int)9, (int)styles.size());
        LibraryThemeTest.assertNotNull((Object)sheetHandle.getContainerHandle());
        try {
            themeHandle.addCss(sheetHandle);
            LibraryThemeTest.fail();
        }
        catch (CssException e) {
            LibraryThemeTest.assertEquals((String)"Error.CSSException.DUPLICATE_CSS", (String)e.getErrorCode());
        }
        LabelHandle labelHandle = this.libraryHandle.getElementFactory().newLabel("label");
        this.libraryHandle.getComponents().add((DesignElementHandle)labelHandle);
        labelHandle.setStyle((SharedStyleHandle)styles.get(0));
        LibraryThemeTest.assertTrue((boolean)themeHandle.canDropCssStyleSheet(sheetHandle));
        LibraryThemeTest.assertNotNull((Object)labelHandle.getStyle());
        themeHandle.dropCss(sheetHandle);
        LibraryThemeTest.assertNull(themeHandle.includeCssesIterator().next());
        LibraryThemeTest.assertNull((Object)labelHandle.getStyle());
        LibraryThemeTest.assertNull((Object)labelHandle.getElement().getStyle());
        LibraryThemeTest.assertFalse((boolean)themeHandle.canDropCssStyleSheet(sheetHandle));
        LibraryThemeTest.assertNull((Object)sheetHandle.getContainerHandle());
        themeHandle.addCss("base.css");
        styles = themeHandle.getAllStyles();
        LibraryThemeTest.assertEquals((int)9, (int)styles.size());
        CssStyleSheetHandle stylySheetHandle = themeHandle.findCssStyleSheetHandleByName("base.css");
        LibraryThemeTest.assertNotNull((Object)stylySheetHandle);
        LibraryThemeTest.assertEquals((String)"base.css", (String)stylySheetHandle.getFileName());
        IncludedCssStyleSheetHandle includedStylySheetHandle = themeHandle.findIncludedCssStyleSheetHandleByName("base.css");
        LibraryThemeTest.assertNotNull((Object)includedStylySheetHandle);
        LibraryThemeTest.assertEquals((String)"base.css", (String)includedStylySheetHandle.getFileName());
        IncludedCssStyleSheet cssStruct = StructureFactory.createIncludedCssStyleSheet();
        cssStruct.setFileName("base1.css");
        themeHandle.addCss(cssStruct);
        cssStruct = (IncludedCssStyleSheet)themeHandle.getListProperty("cssStyleSheets").get(1);
        LibraryThemeTest.assertEquals((String)"base1.css", (String)cssStruct.getFileName());
    }

    public void testChangeTheme() throws Exception {
        this.openDesign("LibraryThemeTest_ChangeTheme.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label");
        LibraryThemeTest.assertEquals((String)"left", (String)labelHandle.getStyle().getTextAlign());
        LibraryHandle libHandle = this.designHandle.getLibrary("LibraryThemeTest_TwoTheme");
        ThemeHandle themeHandle = (ThemeHandle)libHandle.getThemes().get(1);
        LibraryThemeTest.assertEquals((String)"theme2", (String)themeHandle.getName());
        this.designHandle.setTheme(themeHandle);
        LibraryThemeTest.assertEquals((String)"center", (String)labelHandle.getStyle().getTextAlign());
        StyleHandle styleHandle = themeHandle.findStyle("code");
        LibraryThemeTest.assertNotNull((Object)styleHandle);
        List rules = labelHandle.getListProperty("highlightRules");
        HighlightRule rule = (HighlightRule)rules.get(0);
        ElementRefValue value = (ElementRefValue)rule.getProperty((Module)this.design, "style");
        LibraryThemeTest.assertEquals((Object)styleHandle.getElement(), (Object)value.getElement());
        rule = (HighlightRule)rules.get(1);
        value = (ElementRefValue)rule.getProperty((Module)this.design, "style");
        LibraryThemeTest.assertEquals((Object)styleHandle.getElement(), (Object)value.getElement());
        rule = (HighlightRule)rules.get(2);
        value = (ElementRefValue)rule.getProperty((Module)this.design, "style");
        LibraryThemeTest.assertEquals((Object)styleHandle.getElement(), (Object)value.getElement());
        LibraryThemeTest.assertEquals((int)4, (int)((StyleElement)styleHandle.getElement()).getClientList().size());
        this.designHandle.setTheme(null);
    }

    public void testGetProperty() throws Exception {
        this.openDesign("DesignWithThemeInLibrary.xml");
        LabelHandle label1 = (LabelHandle)this.designHandle.findElement("label1");
        LabelHandle label2 = (LabelHandle)this.designHandle.findElement("label2");
        LabelHandle label3 = (LabelHandle)this.designHandle.findElement("label3");
        ListHandle list1 = (ListHandle)this.designHandle.findElement("list1");
        LibraryThemeTest.assertEquals((Object)"silver", (Object)label1.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"lime", (Object)label2.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"maroon", (Object)label3.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"gray", (Object)list1.getProperty("color"));
    }

    public void testSetTheme() throws Exception {
        this.openDesign("DesignWithThemeInLibrary.xml");
        LabelHandle label2 = (LabelHandle)this.designHandle.findElement("label2");
        ListHandle list1 = (ListHandle)this.designHandle.findElement("list1");
        LibraryThemeTest.assertEquals((Object)"lime", (Object)label2.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"gray", (Object)list1.getProperty("color"));
        ThemeHandle theme2 = this.designHandle.findTheme("Theme.theme2");
        LibraryThemeTest.assertNotNull((Object)theme2);
        this.designHandle.setTheme(theme2);
        LibraryThemeTest.assertEquals((Object)"aqua", (Object)label2.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"blue", (Object)list1.getProperty("color"));
        this.designHandle.getCommandStack().undo();
        LibraryThemeTest.assertEquals((Object)"lime", (Object)label2.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"gray", (Object)list1.getProperty("color"));
        this.designHandle.getCommandStack().redo();
        LibraryThemeTest.assertEquals((Object)"aqua", (Object)label2.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"blue", (Object)list1.getProperty("color"));
        MyListener listener = new MyListener();
        MyListener labelListener = new MyListener();
        label2.addListener((Listener)labelListener);
        this.designHandle.addListener((Listener)listener);
        this.designHandle.setThemeName("Theme.theme1");
        LibraryThemeTest.assertEquals((int)1, (int)listener.counter);
        LibraryThemeTest.assertEquals((int)1, (int)labelListener.counter);
        this.designHandle.getCommandStack().undo();
        LibraryThemeTest.assertEquals((int)2, (int)listener.counter);
        this.designHandle.getCommandStack().redo();
        LibraryThemeTest.assertEquals((int)3, (int)listener.counter);
        this.libraryHandle = this.designHandle.getLibrary("Theme");
        ThemeHandle theme = this.libraryHandle.getElementFactory().newTheme("Theme3");
        try {
            this.designHandle.setTheme(theme);
            LibraryThemeTest.fail();
        }
        catch (ThemeException e) {
            LibraryThemeTest.assertEquals((String)"Error.ThemeException.NOT_FOUND", (String)e.getErrorCode());
            LibraryThemeTest.assertEquals((Object)"Theme.Theme3", (Object)e.getTheme());
        }
        try {
            this.designHandle.setProperty("theme", (Object)theme);
            LibraryThemeTest.fail();
        }
        catch (ThemeException e) {
            LibraryThemeTest.assertEquals((String)"Error.ThemeException.NOT_FOUND", (String)e.getErrorCode());
            LibraryThemeTest.assertEquals((Object)"Theme.Theme3", (Object)e.getTheme());
        }
        try {
            this.designHandle.setProperty("theme", (Object)theme.getElement());
            LibraryThemeTest.fail();
        }
        catch (ThemeException e) {
            LibraryThemeTest.assertEquals((String)"Error.ThemeException.NOT_FOUND", (String)e.getErrorCode());
            LibraryThemeTest.assertEquals((Object)"Theme.Theme3", (Object)e.getTheme());
        }
    }

    public void testAddRemoveStyleLocally() throws Exception {
        this.openLibrary("LibraryTheme.xml");
        ThemeHandle theme1 = this.libraryHandle.findTheme("theme1");
        LibraryThemeTest.assertNotNull((Object)theme1);
        SharedStyleHandle myStyle1 = this.libraryHandle.getElementFactory().newStyle("libStyle2");
        myStyle1.getColor().setStringValue("navy");
        MyListener listener = new MyListener();
        LabelHandle label1 = (LabelHandle)this.libraryHandle.findElement("label1");
        label1.addListener((Listener)listener);
        theme1.getStyles().add((DesignElementHandle)myStyle1);
        LibraryThemeTest.assertEquals((Object)"navy", (Object)label1.getProperty("color"));
        LibraryThemeTest.assertEquals((int)0, (int)listener.counter);
        TextItemHandle text1 = (TextItemHandle)this.libraryHandle.findElement("text1");
        SharedStyleHandle textSelector = this.libraryHandle.getElementFactory().newStyle("text");
        textSelector.getColor().setStringValue("navy");
        listener = new MyListener();
        text1.addListener((Listener)listener);
        theme1.getStyles().add((DesignElementHandle)textSelector);
        LibraryThemeTest.assertEquals((Object)"navy", (Object)text1.getProperty("color"));
        LibraryThemeTest.assertEquals((int)1, (int)listener.counter);
        this.libraryHandle.getCommandStack().undo();
        LibraryThemeTest.assertEquals((Object)"black", (Object)text1.getProperty("color"));
        LibraryThemeTest.assertEquals((int)2, (int)listener.counter);
    }

    public void testAddRemoveThemeLocally() throws Exception {
        this.openLibrary("LibraryTheme.xml");
        LibraryThemeTest.assertNotNull((Object)this.libraryHandle.getTheme());
        SharedStyleHandle libStyle1 = this.libraryHandle.findStyle("libStyle1");
        libStyle1.drop();
        this.libraryHandle.getCommandStack().undo();
        LabelHandle label3 = (LabelHandle)this.libraryHandle.findElement("label3");
        LibraryThemeTest.assertEquals((String)"lime", (String)label3.getStringProperty("color"));
        ThemeHandle theme1 = this.libraryHandle.findTheme("theme1");
        LibraryThemeTest.assertNotNull((Object)theme1);
        TextItemHandle text1 = (TextItemHandle)this.libraryHandle.findElement("text1");
        LabelHandle label1 = (LabelHandle)this.libraryHandle.findElement("label1");
        LabelHandle label2 = (LabelHandle)this.libraryHandle.findElement("label2");
        LibraryThemeTest.assertEquals((Object)"black", (Object)text1.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"red", (Object)label1.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"red", (Object)label2.getProperty("color"));
        this.libraryHandle.getThemes().drop((DesignElementHandle)theme1);
        LibraryThemeTest.assertEquals((Object)"black", (Object)text1.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"black", (Object)label1.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"black", (Object)label2.getProperty("color"));
        LibraryThemeTest.assertNotNull((Object)label3.getProperty("style"));
        this.libraryHandle.getCommandStack().undo();
        LibraryThemeTest.assertEquals((Object)"red", (Object)label1.getProperty("color"));
        this.libraryHandle.getCommandStack().redo();
        LibraryThemeTest.assertEquals((Object)"black", (Object)label1.getProperty("color"));
        this.libraryHandle.getCommandStack().undo();
        this.libraryHandle.getThemes().dropAndClear((DesignElementHandle)theme1);
        LibraryThemeTest.assertNull((Object)label3.getProperty("style"));
    }

    public void testSetPropertyOnSeclector() throws Exception {
        this.openLibrary("LibraryTheme.xml");
        TextItemHandle text1 = (TextItemHandle)this.libraryHandle.findElement("text1");
        ThemeHandle theme3 = this.libraryHandle.findTheme("theme3");
        LibraryThemeTest.assertNotNull((Object)theme3);
        this.libraryHandle.setTheme(theme3);
        MyListener listener = new MyListener();
        text1.addListener((Listener)listener);
        StyleHandle textSelector = theme3.findStyle("text");
        LibraryThemeTest.assertNotNull((Object)textSelector);
        textSelector.getColor().setStringValue("blue");
        LibraryThemeTest.assertEquals((int)1, (int)listener.counter);
        LibraryThemeTest.assertEquals((Object)"blue", (Object)text1.getProperty("color"));
    }

    public void testThemeWithAddRemoveLibrary() throws Exception {
        this.openDesign("DesignWithThemeInLibrary.xml");
        LabelHandle label2 = (LabelHandle)this.designHandle.findElement("label2");
        ListHandle list1 = (ListHandle)this.designHandle.findElement("list1");
        LibraryThemeTest.assertEquals((Object)"lime", (Object)label2.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"gray", (Object)list1.getProperty("color"));
        LibraryHandle libTheme = this.designHandle.getLibrary("Theme");
        this.designHandle.dropLibrary(libTheme);
        LibraryThemeTest.assertEquals((Object)"maroon", (Object)label2.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"black", (Object)list1.getProperty("color"));
        this.designHandle.getCommandStack().undo();
        LibraryThemeTest.assertEquals((Object)"lime", (Object)label2.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"gray", (Object)list1.getProperty("color"));
        this.designHandle.getCommandStack().redo();
        LibraryThemeTest.assertEquals((Object)"maroon", (Object)label2.getProperty("color"));
        LibraryThemeTest.assertEquals((Object)"black", (Object)list1.getProperty("color"));
    }

    public void testWriter() throws Exception {
        this.openDesign("DesignWithThemeInLibrary.xml");
        LibraryThemeTest.assertEquals((String)"theme1", (String)this.designHandle.getTheme().getName());
        ThemeHandle theme2 = this.designHandle.findTheme("Theme.theme2");
        LibraryThemeTest.assertNotNull((Object)theme2);
        this.designHandle.setTheme(theme2);
        this.save();
        LibraryThemeTest.assertTrue((boolean)this.compareFile("DesignWithThemeInLibrary_golden.xml"));
    }

    public void testCompatibleLibraryWithStyles() throws Exception {
        this.openLibrary("CompatibleLibraryTheme.xml");
        this.saveLibrary();
        LibraryThemeTest.assertTrue((boolean)this.compareFile("CompatibleLibraryTheme_golden.xml"));
    }

    public void testCanContainStyle() throws Exception {
        this.createLibrary();
        ThemeHandle theme = this.libraryHandle.getElementFactory().newTheme("testTheme");
        SharedStyleHandle style1 = this.libraryHandle.getElementFactory().newStyle("sytle1");
        SharedStyleHandle style2 = this.libraryHandle.getElementFactory().newStyle("sytle1");
        theme.getStyles().add((DesignElementHandle)style1);
        try {
            theme.getStyles().add((DesignElementHandle)style2);
            LibraryThemeTest.fail();
        }
        catch (NameException e) {
            LibraryThemeTest.assertEquals((String)"Error.NameException.DUPLICATE", (String)e.getErrorCode());
        }
        style2.setName("style2");
        theme.getStyles().add((DesignElementHandle)style2);
    }

    public void testCreateLibrary() throws Exception {
        this.createLibrary();
        LibraryThemeTest.assertEquals((int)1, (int)this.libraryHandle.getThemes().getCount());
        this.saveLibrary();
        LibraryThemeTest.assertTrue((boolean)this.compareFile("CompatibleLibraryThemeEmpty_golden.xml"));
    }

    public void testCompatibleLibraryWithoutStyles() throws Exception {
        this.openLibrary("CompatibleLibraryThemeWithoutStyles.xml");
        this.saveLibrary();
        LibraryThemeTest.assertTrue((boolean)this.compareFile("CompatibleLibraryThemeWithoutStyles_golden.xml"));
    }

    public void testClone() throws Exception {
        this.createLibrary();
        ThemeHandle theme1 = this.libraryHandle.getElementFactory().newTheme("theme1");
        this.libraryHandle.getThemes().add((DesignElementHandle)theme1);
        ThemeHandle themeCloned = (ThemeHandle)theme1.copy().getHandle(this.libraryHandle.getModule());
        SharedStyleHandle style1 = this.libraryHandle.getElementFactory().newStyle("style1");
        theme1.getStyles().add((DesignElementHandle)style1);
        LibraryThemeTest.assertEquals((int)1, (int)theme1.getStyles().getCount());
        LibraryThemeTest.assertEquals((int)0, (int)themeCloned.getStyles().getCount());
    }

    public void testAddStyleWithThemeInLibrary() throws Exception {
        this.createLibrary();
        ElementFactory libFactory = this.libraryHandle.getElementFactory();
        ThemeHandle theme = libFactory.newTheme("them1");
        theme.getStyles().add((DesignElementHandle)libFactory.newStyle("style1"));
        this.libraryHandle.getThemes().add((DesignElementHandle)theme);
        Library library = (Library)this.libraryHandle.getModule();
        LibraryThemeTest.assertEquals((int)2, (int)library.getNameHelper().getNameSpace(6).getCount());
        LibraryThemeTest.assertEquals((int)0, (int)library.getNameHelper().getNameSpace(0).getCount());
        theme.getStyles().add((DesignElementHandle)libFactory.newStyle("style2"));
        LibraryThemeTest.assertEquals((int)0, (int)library.getNameHelper().getNameSpace(0).getCount());
    }

    public void testCreateLibraryAndSetTheme() throws Exception {
        this.openDesign("DesignWithThemesInTwoLibraries.xml");
        this.designHandle.includeLibrary("LibraryAIncludeTheme.xml", "libA");
        this.designHandle.includeLibrary("LibraryBIncludeTheme.xml", "libB");
        this.designHandle.setThemeName("libA.theme1");
        TableHandle table = (TableHandle)this.designHandle.findElement("mytable");
        LabelHandle label = (LabelHandle)this.designHandle.findElement("mylabel");
        LibraryThemeTest.assertNotNull((Object)table);
        LibraryThemeTest.assertNotNull((Object)label);
        LibraryThemeTest.assertEquals((String)"#FF0000", (String)table.getStringProperty("color"));
        LibraryThemeTest.assertEquals((String)"black", (String)label.getStringProperty("color"));
    }

    public void testGetDisplayLabel() throws Exception {
        this.openDesign("DesignWithThemesInTwoLibraries.xml");
        this.designHandle.includeLibrary("LibraryAIncludeTheme.xml", "libA");
        LibraryThemeTest.assertEquals((String)"libA.theme1", (String)((ThemeHandle)this.designHandle.getVisibleThemes(1).get(1)).getDisplayLabel(2));
        LibraryThemeTest.assertEquals((String)"libA.theme1", (String)((ThemeHandle)this.designHandle.getVisibleThemes(1).get(1)).getDisplayLabel());
        LibraryThemeTest.assertEquals((String)"libA.theme1", (String)((ThemeHandle)this.designHandle.getVisibleThemes(1).get(1)).getDisplayLabel(0));
    }

    public void testGetAllThemes() throws Exception {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("LibraryIncludingTwoLibraries.xml", "CompsiteLib");
        List list = this.designHandle.getVisibleThemes(1);
        LibraryThemeTest.assertEquals((int)0, (int)list.size());
        this.libraryHandle = this.designHandle.getLibrary("CompsiteLib");
        LibraryThemeTest.assertEquals((int)2, (int)this.libraryHandle.getVisibleThemes(1).size());
        LibraryThemeTest.assertEquals((int)0, (int)this.libraryHandle.getVisibleThemes(0).size());
    }

    public void testRenameStyleInTheme() throws Exception {
        this.createLibrary();
        ElementFactory libFactory = this.libraryHandle.getElementFactory();
        ThemeHandle theme = libFactory.newTheme("them1");
        this.libraryHandle.getThemes().add((DesignElementHandle)theme);
        SharedStyleHandle style = libFactory.newStyle("style1");
        theme.getStyles().add((DesignElementHandle)style);
        style = libFactory.newStyle("style2");
        theme.getStyles().add((DesignElementHandle)style);
        try {
            style.setName("style1");
            LibraryThemeTest.fail();
        }
        catch (NameException e) {
            LibraryThemeTest.assertEquals((String)"Error.NameException.DUPLICATE", (String)e.getErrorCode());
        }
    }

    public void testRemoveStyleInTheme() throws Exception {
        this.openDesign("LibraryThemeTest.xml");
        LibraryHandle libHandle = (LibraryHandle)this.designHandle.getLibraries().get(0);
        LabelHandle labelHandle = (LabelHandle)this.designHandle.getElementByID(7L);
        LibraryThemeTest.assertNotNull((Object)labelHandle.getStyle());
        MyListener listener = new MyListener();
        labelHandle.addListener((Listener)listener);
        this.designHandle.dropLibrary(libHandle);
        LibraryThemeTest.assertNull((Object)labelHandle.getStyle());
        LibraryThemeTest.assertEquals((int)1, (int)listener.getCounter());
    }

    public void testAddNonExistingTheme() throws Exception {
        this.openDesign("DesignWithInvalidTheme.xml");
        LibraryThemeTest.assertEquals((int)1, (int)this.design.getAllExceptions().size());
        LibraryThemeTest.assertTrue((boolean)(this.design.getAllExceptions().get(0) instanceof ThemeException));
        ThemeException e = (ThemeException)((Object)this.design.getAllExceptions().get(0));
        LibraryThemeTest.assertEquals((String)"Error.ThemeException.NOT_FOUND", (String)e.getErrorCode());
    }

    class MyListener
    implements Listener {
        int counter = 0;

        MyListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev.getEventType() == 6 || ev.getEventType() == 15) {
                ++this.counter;
            }
        }

        public int getCounter() {
            return this.counter;
        }
    }
}

