/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoicePropertyType;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.PropertyTypeTestCase;

public class ChoicePropertyTypeTest
extends PropertyTypeTestCase {
    ChoicePropertyType type = new ChoicePropertyType();
    PropertyDefn propDefn = new PropertyDefnFake();

    protected void setUp() throws Exception {
        super.setUp();
        ChoiceSet choiceSet = new ChoiceSet("fontFamily");
        Choice[] choice = new Choice[]{new Choice("sans-serif", "Choices.fontFamily.sans-serif"), new Choice("cursive", "Choices.fontFamily.cursive"), new Choice("fantasy", "Choices.fontFamily.fantasy")};
        choiceSet.setChoices((IChoice[])choice);
        this.propDefn.setDetails((Object)choiceSet);
        this.propDefn.setType(MetaDataDictionary.getInstance().getPropertyType(5));
    }

    public void testGetTypeCode() {
        ChoicePropertyTypeTest.assertEquals((int)5, (int)this.type.getTypeCode());
    }

    public void testGetName() {
        ChoicePropertyTypeTest.assertEquals((String)"choice", (String)this.type.getName());
    }

    public void testValidateValue() throws PropertyValueException {
        ChoicePropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, null));
        ChoicePropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)""));
        ChoicePropertyTypeTest.assertEquals((Object)"sans-serif", (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"sans-serif"));
        try {
            this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"none-exsit-choice-name");
            ChoicePropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            ChoicePropertyTypeTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testValidateInputString() throws PropertyValueException {
        ChoicePropertyTypeTest.assertEquals((Object)"sans-serif", (Object)this.type.validateInputString((Module)this.design, null, this.propDefn, "sans-serif"));
        ChoicePropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, null, this.propDefn, " "));
        ChoicePropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, null, this.propDefn, ""));
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        ChoicePropertyTypeTest.assertEquals((Object)"cursive", (Object)this.type.validateInputString((Module)this.design, null, this.propDefn, "\u8fde\u4f53"));
    }

    public void testValidateXml() throws PropertyValueException {
        ChoicePropertyTypeTest.assertEquals((Object)"sans-serif", (Object)this.type.validateXml((Module)this.design, null, this.propDefn, (Object)"sans-serif"));
        ChoicePropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, null));
        ChoicePropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, (Object)""));
    }

    public void testToDouble() {
        ChoicePropertyTypeTest.assertEquals((double)0.0, (double)this.type.toDouble((Module)this.design, (Object)"any-choice-name"), (double)1.0);
    }

    public void testToInteger() {
        ChoicePropertyTypeTest.assertEquals((int)0, (int)this.type.toInteger((Module)this.design, (Object)"any-choice-name"));
    }

    public void testToXml() {
        ChoicePropertyTypeTest.assertEquals(null, (String)this.type.toXml((Module)this.design, this.propDefn, null));
        ChoicePropertyTypeTest.assertEquals((String)"cursive", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)"cursive"));
    }

    public void testToString() {
        ChoicePropertyTypeTest.assertEquals(null, (String)this.type.toString((Module)this.design, this.propDefn, null));
        ChoicePropertyTypeTest.assertEquals((String)"cursive", (String)this.type.toString((Module)this.design, this.propDefn, (Object)"cursive"));
    }

    public void testToDisplayString() {
        ChoicePropertyTypeTest.assertEquals(null, (String)this.type.toDisplayString((Module)this.design, this.propDefn, null));
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        ChoicePropertyTypeTest.assertEquals((String)"Cursive", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)"cursive"));
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        ChoicePropertyTypeTest.assertEquals((String)"\u8fde\u4f53", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)"cursive"));
    }

    public void testToNumber() {
        ChoicePropertyTypeTest.assertEquals((double)0.0, (double)this.type.toNumber((Module)this.design, (Object)"any-choice-name").doubleValue(), (double)1.0);
    }

    public void testToBoolean() {
        ChoicePropertyTypeTest.assertEquals((boolean)false, (boolean)this.type.toBoolean((Module)this.design, (Object)"any-choice-name"));
    }
}

