/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.math.BigDecimal;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.IntegerPropertyType;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.PropertyTypeTestCase;

public class IntegerPropertyTypeTest
extends PropertyTypeTestCase {
    IntegerPropertyType type = new IntegerPropertyType();
    PropertyDefn propDefn = new PropertyDefnFake();

    public void testGetTypeCode() {
        IntegerPropertyTypeTest.assertEquals((int)2, (int)this.type.getTypeCode());
    }

    public void testGetName() {
        IntegerPropertyTypeTest.assertEquals((String)"integer", (String)this.type.getName());
    }

    public void testValidateValue() throws PropertyValueException {
        IntegerPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, null));
        IntegerPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)""));
        IntegerPropertyTypeTest.assertEquals((int)100, (int)((Integer)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)new Integer(100))));
        IntegerPropertyTypeTest.assertEquals((int)100, (int)((Integer)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)new Float(100.01f))));
        IntegerPropertyTypeTest.assertEquals((int)100, (int)((Integer)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)new Double(100.01))));
        IntegerPropertyTypeTest.assertEquals((int)1001, (int)((Integer)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)new BigDecimal(1001.01))));
        IntegerPropertyTypeTest.assertEquals((int)1, (int)((Integer)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)Boolean.TRUE)));
        IntegerPropertyTypeTest.assertEquals((int)0, (int)((Integer)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)Boolean.FALSE)));
        IntegerPropertyTypeTest.assertEquals((int)100, (int)((Integer)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"100")));
        try {
            this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"abcdef");
            IntegerPropertyTypeTest.fail();
        }
        catch (PropertyValueException propertyValueException) {}
    }

    public void testValidateInputString() throws PropertyValueException {
        IntegerPropertyTypeTest.assertEquals((int)100, (int)((Integer)this.type.validateInputString((Module)this.design, null, this.propDefn, "100")));
        IntegerPropertyTypeTest.assertEquals((int)1234, (int)((Integer)this.type.validateInputString((Module)this.design, null, this.propDefn, "1,234")));
    }

    public void testValidateXml() throws PropertyValueException {
        IntegerPropertyTypeTest.assertEquals((int)100, (int)((Integer)this.type.validateXml((Module)this.design, null, this.propDefn, (Object)"100")));
        try {
            this.type.validateXml((Module)this.design, null, this.propDefn, (Object)"1,234");
            IntegerPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            IntegerPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testToDouble() {
        IntegerPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toDouble((Module)this.design, null), (double)1.0);
        IntegerPropertyTypeTest.assertEquals((double)100.0, (double)this.type.toDouble((Module)this.design, (Object)new Integer(100)), (double)1.0);
    }

    public void testToInteger() {
        IntegerPropertyTypeTest.assertEquals((int)0, (int)this.type.toInteger((Module)this.design, null));
        IntegerPropertyTypeTest.assertEquals((int)100, (int)this.type.toInteger((Module)this.design, (Object)new Integer(100)));
    }

    public void testToXml() {
        IntegerPropertyTypeTest.assertEquals(null, (String)this.type.toXml((Module)this.design, this.propDefn, null));
        IntegerPropertyTypeTest.assertEquals((String)"123456", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)new Integer(123456)));
    }

    public void testToString() {
        IntegerPropertyTypeTest.assertEquals(null, (String)this.type.toString((Module)this.design, this.propDefn, null));
        IntegerPropertyTypeTest.assertEquals((String)"123456", (String)this.type.toString((Module)this.design, this.propDefn, (Object)new Integer(123456)));
    }

    public void testToDisplayString() {
        IntegerPropertyTypeTest.assertEquals(null, (String)this.type.toDisplayString((Module)this.design, this.propDefn, null));
        IntegerPropertyTypeTest.assertEquals((String)"123,456", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)new Integer("123456")));
    }

    public void testToNumber() {
    }

    public void testToBoolean() {
    }

    public void testValidXml() throws PropertyValueException {
        IntegerPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, null));
        IntegerPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, (Object)""));
        Integer n = null;
        n = (Integer)this.type.validateXml(null, null, null, (Object)"100");
        IntegerPropertyTypeTest.assertTrue((100 == n ? 1 : 0) != 0);
    }

    public void testInvalidValue() throws PropertyValueException {
        IntegerPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, null));
        IntegerPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, (Object)""));
        try {
            this.type.validateValue(null, null, null, (Object)"abcdef");
            IntegerPropertyTypeTest.fail();
        }
        catch (PropertyValueException propertyValueException) {}
    }

    public void testInvalidXml() throws PropertyValueException {
        IntegerPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, null));
        IntegerPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, (Object)""));
        try {
            this.type.validateXml(null, null, null, (Object)"abcdef");
            IntegerPropertyTypeTest.fail();
        }
        catch (PropertyValueException propertyValueException) {}
    }
}

