/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.AbstractMetaTest;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaDataReader;

public class MetaDataReaderTest
extends AbstractMetaTest {
    protected MetaDataReader reader = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.reader = new MetaDataReader();
        MetaDataDictionary.reset();
        MetaDataDictionary.getInstance();
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
    }

    public void testReadNotExistingFile() {
        try {
            MetaDataReader.read((String)"notexistingfile.xml");
            MetaDataReaderTest.fail();
        }
        catch (MetaDataParserException e) {
            MetaDataReaderTest.assertEquals((String)"FILE_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testIncorrentFile() {
        try {
            MetaDataReader.read((InputStream)MetaDataReaderTest.class.getResourceAsStream("input/MetaDataReaderTest.xml"));
            MetaDataReaderTest.fail();
        }
        catch (MetaDataParserException metaDataParserException) {}
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.reader = null;
    }
}

