/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.AbstractMetaTest;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetadataTestUtil;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;

public class PropertyDefnTest
extends AbstractMetaTest {
    private PropertyDefn propertyDefn = null;
    private static final String VALIDATOR_TEST_INPUT = "ValidatorTest.xml";
    private static final String VALIDATOR_TEST_INPUT1 = "ValidatorTest1.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.propertyDefn = new PropertyDefnFake();
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
    }

    public void testGetterSetters() {
        this.propertyDefn.setName("TestProperty");
        this.propertyDefn.setDisplayNameID("Element.ReportDesign.author");
        MetadataTestUtil.setPropertyDefnDefault((PropertyDefn)this.propertyDefn, (Object)"Default");
        this.propertyDefn.setType(MetaDataDictionary.getInstance().getPropertyType(0));
        PropertyDefnTest.assertEquals((String)"TestProperty", (String)this.propertyDefn.getName());
        PropertyDefnTest.assertEquals((int)0, (int)this.propertyDefn.getTypeCode());
        PropertyDefnTest.assertEquals((String)"Element.ReportDesign.author", (String)this.propertyDefn.getDisplayNameID());
        PropertyDefnTest.assertEquals((String)"Author", (String)this.propertyDefn.getDisplayName());
        PropertyDefnTest.assertEquals((Object)"Default", (Object)this.propertyDefn.getDefault());
        PropertyDefnTest.assertTrue((boolean)this.propertyDefn.isSystemProperty());
        PropertyDefnTest.assertFalse((boolean)this.propertyDefn.isUserProperty());
        PropertyDefnTest.assertFalse((boolean)this.propertyDefn.isIntrinsic());
    }

    public void testBuild() {
        try {
            this.propertyDefn.setType(MetaDataDictionary.getInstance().getPropertyType(5));
            MetadataTestUtil.buildPropertyDefn((PropertyDefn)this.propertyDefn);
            PropertyDefnTest.fail();
        }
        catch (MetaDataException metaDataException) {}
        try {
            this.propertyDefn.setType(MetaDataDictionary.getInstance().getPropertyType(0));
            MetadataTestUtil.buildPropertyDefn((PropertyDefn)this.propertyDefn);
        }
        catch (MetaDataException metaDataException) {
            PropertyDefnTest.fail();
        }
    }

    public void testChoice() {
        Choice[] choices = new Choice[]{new Choice("1", "TestChoice1"), new Choice("2", "TestChoice2")};
        ChoiceSet choiceSet = new ChoiceSet("Choice Set");
        choiceSet.setChoices((IChoice[])choices);
        this.propertyDefn.setType(MetaDataDictionary.getInstance().getPropertyType(5));
        PropertyDefnTest.assertNull((Object)this.propertyDefn.getChoices());
        this.propertyDefn.setDetails((Object)choiceSet);
        PropertyDefnTest.assertSame((Object)choiceSet, (Object)this.propertyDefn.getChoices());
        PropertyDefnTest.assertTrue((choices.length == this.propertyDefn.getChoices().getChoices().length ? 1 : 0) != 0);
    }

    public void testGetAllowedUnits() throws MetaDataParserException {
        this.loadMetaData(((Object)((Object)this)).getClass().getResourceAsStream("input/AllowedChoicesTest.def"));
        IElementDefn styleDefn = MetaDataDictionary.getInstance().getElement("Style");
        ElementPropertyDefn propDefn = (ElementPropertyDefn)styleDefn.getProperty("fontStyle");
        IChoiceSet choices = propDefn.getAllowedChoices();
        PropertyDefnTest.assertEquals((int)2, (int)choices.getChoices().length);
        PropertyDefnTest.assertEquals((String)"normal", (String)choices.getChoices()[0].getName());
        PropertyDefnTest.assertEquals((String)"italic", (String)choices.getChoices()[1].getName());
        propDefn = (ElementPropertyDefn)styleDefn.getProperty("fontSize");
        choices = propDefn.getAllowedUnits();
        PropertyDefnTest.assertEquals((int)2, (int)choices.getChoices().length);
        PropertyDefnTest.assertEquals((String)"in", (String)choices.getChoices()[0].getName());
        PropertyDefnTest.assertEquals((String)"cm", (String)choices.getChoices()[1].getName());
        propDefn = (ElementPropertyDefn)styleDefn.getProperty("backgroundPositionX");
        choices = propDefn.getAllowedUnits();
        PropertyDefnTest.assertEquals((int)9, (int)choices.getChoices().length);
    }

    public void testValidator() throws DesignFileException, SemanticException {
        this.openDesign(VALIDATOR_TEST_INPUT);
        List errors = this.designHandle.getErrorList();
        PropertyDefnTest.assertEquals((int)1, (int)errors.size());
        PropertyDefnTest.assertEquals((String)"Error.PropertyValueException.NEGATIVE_VALUE", (String)((ErrorDetail)errors.get(0)).getErrorCode());
        LabelHandle handle = (LabelHandle)this.designHandle.findElement("Label1");
        PropertyDefnTest.assertEquals((String)"-1mm", (String)handle.getWidth().getStringValue());
        PropertyDefnTest.assertEquals((String)"-1mm", (String)handle.getStringProperty("width"));
        this.openDesign(VALIDATOR_TEST_INPUT1);
        LabelHandle label1 = (LabelHandle)this.designHandle.findElement("Label1");
        label1.setWidth("2pt");
        try {
            label1.setWidth("-2pt");
            PropertyDefnTest.fail();
        }
        catch (SemanticException e1) {
            PropertyDefnTest.assertTrue((boolean)(e1 instanceof PropertyValueException));
            PropertyDefnTest.assertEquals((String)"Error.PropertyValueException.NEGATIVE_VALUE", (String)e1.getErrorCode());
        }
    }

    public void testParseRom() throws MetaDataParserException {
        IElementDefn ed = MetaDataDictionary.getInstance().getElement("SimpleDataSet");
        SystemPropertyDefn defn = (SystemPropertyDefn)ed.getProperty("afterClose");
        PropertyDefnTest.assertTrue((boolean)defn.isEditable());
        ed = MetaDataDictionary.getInstance().getElement("Style");
        defn = (SystemPropertyDefn)ed.getProperty("fontSize");
        PropertyDefnTest.assertTrue((boolean)defn.isEditable());
        defn = (SystemPropertyDefn)ed.getProperty("fontVariant");
        PropertyDefnTest.assertFalse((boolean)defn.isEditable());
        defn = (SystemPropertyDefn)ed.getProperty("fontVariant");
        PropertyDefnTest.assertFalse((boolean)defn.isEditable());
        defn = (SystemPropertyDefn)ed.getProperty("backgroundColor");
        PropertyDefnTest.assertTrue((boolean)defn.isEditable());
    }

    public void testSemanticValidator() throws MetaDataParserException {
        IElementDefn masterPageDefn = MetaDataDictionary.getInstance().getElement("MasterPage");
        PropertyDefn typeDefn = (PropertyDefn)masterPageDefn.getProperty("type");
        List validators = typeDefn.getTriggerDefnSet().getTriggerList();
        PropertyDefnTest.assertTrue((boolean)this.hasValidator(validators, "MasterPageSizeValidator"));
        PropertyDefnTest.assertTrue((boolean)this.hasValidator(validators, "MasterPageTypeValidator"));
        PropertyDefnTest.assertTrue((boolean)this.hasValidator(validators, "MasterPageMultiColumnValidator"));
    }

    private boolean hasValidator(List validators, String name) {
        for (SemanticTriggerDefn defn : validators) {
            if (!defn.getValidatorName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void testGetAllowedChoices() throws MetaDataParserException {
        IElementDefn groupDefn = MetaDataDictionary.getInstance().getElement("ListingGroup");
        ElementPropertyDefn propDefn = (ElementPropertyDefn)groupDefn.getProperty("pageBreakAfter");
        IChoiceSet choices = propDefn.getAllowedChoices();
        PropertyDefnTest.assertEquals((int)4, (int)choices.getChoices().length);
        PropertyDefnTest.assertEquals((String)"auto", (String)choices.getChoices()[0].getName());
        PropertyDefnTest.assertEquals((String)"always", (String)choices.getChoices()[1].getName());
        PropertyDefnTest.assertEquals((String)"avoid", (String)choices.getChoices()[2].getName());
        PropertyDefnTest.assertEquals((String)"always-excluding-last", (String)choices.getChoices()[3].getName());
        IElementDefn labelDefn = MetaDataDictionary.getInstance().getElement("Label");
        propDefn = (ElementPropertyDefn)labelDefn.getProperty("pageBreakAfter");
        choices = propDefn.getAllowedChoices();
        PropertyDefnTest.assertEquals((int)3, (int)choices.getChoices().length);
        PropertyDefnTest.assertEquals((String)"auto", (String)choices.getChoices()[0].getName());
        PropertyDefnTest.assertEquals((String)"always", (String)choices.getChoices()[1].getName());
        PropertyDefnTest.assertEquals((String)"avoid", (String)choices.getChoices()[2].getName());
    }
}

