/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class PropertyValueExceptionTest
extends BaseTestCase {
    private PrintWriter writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.os = new ByteArrayOutputStream();
        this.writer = new PrintWriter(this.os);
    }

    public void testErrorMessages() throws Exception {
        TableItem table = new TableItem();
        table.setName("customerTable");
        String value = "badValue";
        PropertyValueException error = new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 6);
        this.print(error);
        error = new PropertyValueException((Object)value, "Error.PropertyValueException.CHOICE_NOT_FOUND", 5);
        this.print(error);
        error = new PropertyValueException((DesignElement)table, "bookmark", null, "Error.PropertyValueException.NOT_LIST_TYPE");
        this.print(error);
        error = new PropertyValueException((DesignElement)table, "bookmark", null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        this.print(error);
        error = new PropertyValueException((DesignElement)table, "visibility", (Object)new EmbeddedImage(), "Error.PropertyValueException.WRONG_ITEM_TYPE");
        this.print(error);
        error = new PropertyValueException((Object)table.getName(), "Error.PropertyValueException.WRONG_ELEMENT_TYPE", 15);
        this.print(error);
        error = new PropertyValueException((DesignElement)table, "visibility", (Object)"var1", "Error.PropertyValueException.VALUE_EXISTS");
        this.print(error);
        error = new PropertyValueException((DesignElement)table, "captionID", null, "Error.PropertyValueException.VALUE_REQUIRED");
        this.print(error);
        error = new PropertyValueException((DesignElement)table, "visibility", (Object)value, "Error.PropertyValueException.VALUE_LOCKED");
        this.print(error);
        error = new PropertyValueException((DesignElement)table, "visibility", (Object)value, "Error.PropertyValueException.UNIT_NOT_ALLOWED");
        this.print(error);
        error = new PropertyValueException((Object)value, "Error.PropertyValueException.CHOICE_NOT_ALLOWED", 5);
        this.print(error);
        error = new PropertyValueException(null, (IPropertyDefn)table.getPropertyDefn("height"), (Object)new DimensionValue(-12.0, "cm"), "Error.PropertyValueException.NEGATIVE_VALUE");
        this.print(error);
        error = new PropertyValueException(null, (IPropertyDefn)table.getPropertyDefn("height"), (Object)new DimensionValue(-12.0, "cm"), "Error.PropertyValueException.NON_POSITIVE_VALUE");
        this.print(error);
        this.writer.close();
        PropertyValueExceptionTest.assertTrue((boolean)this.compareFile("PropertyValueExceptionError.golden.txt"));
    }

    private void print(PropertyValueException error) {
        this.writer.write(error.getErrorCode());
        int i = error.getErrorCode().length();
        while (i < 60) {
            this.writer.write(" ");
            ++i;
        }
        this.writer.println(error.getMessage());
    }
}

