/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.StringPropertyType;
import org.eclipse.birt.report.model.metadata.TextualPropertyTypeTestCase;

public class StringPropertyTypeTest
extends TextualPropertyTypeTestCase {
    StringPropertyType type = new StringPropertyType();
    PropertyDefnFake propDefn = new PropertyDefnFake();

    public void testGetTypeCode() {
        StringPropertyTypeTest.assertEquals((int)0, (int)this.type.getTypeCode());
    }

    public void testGetName() {
        StringPropertyTypeTest.assertEquals((String)"string", (String)this.type.getName());
    }

    public void testValidateValue() throws PropertyValueException {
        int optionValue = 6;
        this.propDefn.setTrimOption(optionValue);
        StringPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, (PropertyDefn)this.propDefn, null));
        StringPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, (PropertyDefn)this.propDefn, (Object)""));
        StringPropertyTypeTest.assertNull((Object)this.type.validateValue((Module)this.design, null, (PropertyDefn)this.propDefn, (Object)"    "));
        StringPropertyTypeTest.assertEquals((Object)"abc", (Object)this.type.validateValue((Module)this.design, null, (PropertyDefn)this.propDefn, (Object)"abc"));
        StringPropertyTypeTest.assertEquals((Object)"123", (Object)this.type.validateValue((Module)this.design, null, (PropertyDefn)this.propDefn, (Object)new Integer(123)));
        StringPropertyTypeTest.assertEquals((Object)"123.0", (Object)this.type.validateValue((Module)this.design, null, (PropertyDefn)this.propDefn, (Object)new Float(123.0f)));
        StringPropertyTypeTest.assertEquals((Object)"123.0", (Object)this.type.validateValue((Module)this.design, null, (PropertyDefn)this.propDefn, (Object)new Double(123.0)));
    }

    public void testValidateInputString() throws PropertyValueException {
    }

    public void testValidateXml() throws PropertyValueException {
        int optionValue = 6;
        this.propDefn.setTrimOption(optionValue);
        StringPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, (PropertyDefn)this.propDefn, null));
        StringPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, (PropertyDefn)this.propDefn, (Object)""));
        StringPropertyTypeTest.assertNull((Object)this.type.validateValue((Module)this.design, null, (PropertyDefn)this.propDefn, (Object)"    "));
        StringPropertyTypeTest.assertEquals((Object)"any-input", (Object)this.type.validateXml((Module)this.design, null, (PropertyDefn)this.propDefn, (Object)"any-input"));
    }

    public void testToDouble() {
        StringPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toDouble((Module)this.design, (Object)"any-input"), (double)1.0);
    }

    public void testToInteger() {
        StringPropertyTypeTest.assertEquals((int)123, (int)this.type.toInteger((Module)this.design, (Object)"123"));
        StringPropertyTypeTest.assertEquals((int)0, (int)this.type.toInteger((Module)this.design, null));
    }

    public void testToXml() {
        StringPropertyTypeTest.assertEquals((String)"any-input", (String)this.type.toXml((Module)this.design, (PropertyDefn)this.propDefn, (Object)"any-input"));
    }

    public void testToString() {
        StringPropertyTypeTest.assertEquals((String)"any-input", (String)this.type.toString((Module)this.design, (PropertyDefn)this.propDefn, (Object)"any-input"));
        Expression expression = new Expression((Object)"test1", "javascript");
        StringPropertyTypeTest.assertEquals((String)"test1", (String)this.type.toString((Module)this.design, (PropertyDefn)this.propDefn, (Object)expression));
    }

    public void testToDisplayString() {
        StringPropertyTypeTest.assertEquals((String)"any-input", (String)this.type.toDisplayString((Module)this.design, (PropertyDefn)this.propDefn, (Object)"any-input"));
    }

    public void testToNumber() {
    }

    public void testToBoolean() {
    }

    public void testValidateHideRule() throws SemanticException {
        this.createDesign();
        LabelHandle label = this.designHandle.getElementFactory().newLabel(null);
        PropertyHandle propHandle = label.getPropertyHandle("visibility");
        HideRule rule = StructureFactory.createHideRule();
        rule.setFormat("ab.cd");
        propHandle.addItem((IStructure)rule);
    }
}

