/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SearchKeyHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ActionParseTest
extends BaseTestCase {
    String goldenFileName = "action_test_golden.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("action_test.xml");
        ActionParseTest.assertNotNull((Object)this.design);
    }

    public void testGetLinkExpr() throws Exception {
        ActionHandle actionHandle = ((ImageHandle)this.designHandle.findElement("Image1")).getActionHandle();
        ActionParseTest.assertEquals((String)"Window2", (String)actionHandle.getTargetWindow());
        ActionParseTest.assertEquals((String)"hyperlink", (String)actionHandle.getLinkType());
        ActionParseTest.assertEquals((String)"www.rock.com.cn/haha/test.html", (String)actionHandle.getURI());
        actionHandle = ((ImageHandle)this.designHandle.findElement("Image2")).getActionHandle();
        ActionParseTest.assertEquals((String)"drill-through", (String)actionHandle.getLinkType());
        ActionParseTest.assertEquals((String)"www.rock.com/bookmarks/1.jsp", (String)actionHandle.getTargetBookmark());
        actionHandle = ((ImageHandle)this.designHandle.findElement("Image4")).getActionHandle();
        ActionParseTest.assertEquals((String)"bookmark-link", (String)actionHandle.getLinkType());
        ActionParseTest.assertEquals((String)"www.rock.com.cn/haha/index.html/bookmarklink1", (String)actionHandle.getTargetBookmark());
    }

    public void testToolTip() throws Exception {
        ActionHandle actionHandle = ((ImageHandle)this.designHandle.findElement("Image1")).getActionHandle();
        ActionParseTest.assertEquals((String)"toolTip", (String)actionHandle.getToolTip());
    }

    public void testGetDrillthroughParameters() throws Exception {
        ActionHandle actionHandle = ((ImageHandle)this.designHandle.findElement("Image1")).getActionHandle();
        Iterator parameters = actionHandle.paramBindingsIterator();
        ActionParseTest.assertFalse((boolean)parameters.hasNext());
        actionHandle = ((ImageHandle)this.designHandle.findElement("Image2")).getActionHandle();
        String linkType = actionHandle.getLinkType();
        ActionParseTest.assertEquals((String)"drill-through", (String)linkType);
        String drillThroughReportName = actionHandle.getReportName();
        ActionParseTest.assertEquals((String)"Another report", (String)drillThroughReportName);
        String bookmark = actionHandle.getTargetBookmark();
        ActionParseTest.assertEquals((String)"www.rock.com/bookmarks/1.jsp", (String)bookmark);
        parameters = actionHandle.paramBindingsIterator();
        ActionParseTest.assertNotNull((Object)parameters);
        ParamBindingHandle param1 = (ParamBindingHandle)parameters.next();
        ActionParseTest.assertEquals((String)"param1", (String)param1.getParamName());
        ActionParseTest.assertEquals((String)"1+1=3", (String)param1.getExpression());
        ActionParseTest.assertNotNull(parameters.next());
        ActionParseTest.assertNull(parameters.next());
    }

    public void testGetDrillthroughSearchKeys() throws Exception {
        ActionHandle actionHandle = ((ImageHandle)this.designHandle.findElement("Image1")).getActionHandle();
        Iterator searchKeys = actionHandle.searchIterator();
        ActionParseTest.assertFalse((boolean)searchKeys.hasNext());
        actionHandle = ((ImageHandle)this.designHandle.findElement("Image3")).getActionHandle();
        searchKeys = actionHandle.searchIterator();
        ActionParseTest.assertNotNull((Object)searchKeys);
        SearchKeyHandle key = (SearchKeyHandle)searchKeys.next();
        ActionParseTest.assertEquals((String)"searchKey1", (String)key.getExpression());
        ActionParseTest.assertNotNull(searchKeys.next());
        ActionParseTest.assertNull(searchKeys.next());
    }

    public void testGetDrillthroughReportName() throws Exception {
        ActionHandle actionHandle = ((ImageHandle)this.designHandle.findElement("Image1")).getActionHandle();
        ActionParseTest.assertNull((Object)actionHandle.getReportName());
        actionHandle = ((ImageHandle)this.designHandle.findElement("Image3")).getActionHandle();
        ActionParseTest.assertEquals((String)"iserver/report1", (String)actionHandle.getReportName());
    }

    public void testWriter() throws Exception {
        ActionHandle actionHandle = ((ImageHandle)this.designHandle.findElement("Image1")).getActionHandle();
        actionHandle.setToolTip("new toolTip");
        this.save();
        ActionParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testListAction() throws Exception {
        this.openDesign("action_test_1.xml");
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("Image1");
        PropertyHandle propHandle = imageHandle.getPropertyHandle("action");
        Iterator iter = imageHandle.actionsIterator();
        ActionHandle actionHandle = (ActionHandle)iter.next();
        ActionParseTest.assertNotSame((Object)actionHandle.getStructure(), (Object)((ActionHandle)iter.next()).getStructure());
        propHandle.addItem(actionHandle.getStructure());
        this.save();
        ActionParseTest.assertTrue((boolean)this.compareFile("action_test_golden_1.xml"));
    }

    public void testDealAction() throws Exception {
        this.openDesign("action_test_2.xml");
        this.save();
    }
}

