/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.parser.ParserTestCase;

public class GridItemParseTest
extends ParserTestCase {
    String fileName = "GridItemParseTest.xml";
    String goldenFileName = "GridItemParseTest_golden.xml";
    String semanticCheckFileName = "GridItemParseTest_1.xml";

    public void testParser() throws Exception {
        this.openDesign(this.fileName);
        SlotHandle body = this.designHandle.getBody();
        GridHandle grid = (GridHandle)this.designHandle.findElement("My grid");
        GridItemParseTest.assertNotNull((Object)grid);
        GridItemParseTest.assertEquals((int)0, (int)body.findPosn((DesignElementHandle)grid));
        GridItemParseTest.assertEquals((String)"summary", (String)grid.getSummary());
        GridItemParseTest.assertEquals((String)"bluehero", (String)grid.getCaption());
        GridItemParseTest.assertEquals((String)"blue he", (String)grid.getCaptionKey());
        SlotHandle columns = grid.getColumns();
        GridItemParseTest.assertEquals((int)2, (int)columns.getCount());
        ColumnHandle column = (ColumnHandle)columns.get(0);
        GridItemParseTest.assertEquals((double)2.5, (double)column.getWidth().getMeasure(), (double)0.1);
        GridItemParseTest.assertEquals((int)3, (int)column.getRepeatCount());
        GridItemParseTest.assertEquals((String)"My-Style", (String)column.getStyle().getName());
        GridItemParseTest.assertNull((Object)column.getPropertyDefn("pageBreakInside"));
        SlotHandle rows = grid.getRows();
        GridItemParseTest.assertEquals((int)2, (int)rows.getCount());
        RowHandle row = (RowHandle)rows.get(0);
        GridItemParseTest.assertEquals((double)5.0, (double)row.getHeight().getMeasure(), (double)1.0);
        GridItemParseTest.assertEquals((String)"This is bookmark for section.", (String)row.getBookmark());
        GridItemParseTest.assertEquals((String)"My-Style", (String)row.getStyle().getName());
        SlotHandle cells = row.getCells();
        GridItemParseTest.assertEquals((int)2, (int)cells.getCount());
        CellHandle cell = (CellHandle)cells.get(0);
        GridItemParseTest.assertEquals((String)"none", (String)cell.getDiagonalStyle());
        GridItemParseTest.assertEquals((String)"none", (String)cell.getAntidiagonalStyle());
        GridItemParseTest.assertEquals((int)0, (int)cell.getDiagonalNumber());
        GridItemParseTest.assertEquals((int)0, (int)cell.getAntidiagonalNumber());
        GridItemParseTest.assertEquals((String)"black", (String)cell.getDiagonalColor().getStringValue());
        GridItemParseTest.assertEquals((String)"black", (String)cell.getAntidiagonalColor().getStringValue());
        DimensionHandle dimensionHandle = cell.getDiagonalThickness();
        GridItemParseTest.assertEquals((String)"medium", (String)dimensionHandle.getStringValue());
        dimensionHandle = cell.getAntidiagonalThickness();
        GridItemParseTest.assertEquals((String)"medium", (String)dimensionHandle.getStringValue());
        cell = (CellHandle)cells.get(1);
        GridItemParseTest.assertEquals((int)2, (int)cell.getColumn());
        GridItemParseTest.assertEquals((int)3, (int)cell.getColumnSpan());
        GridItemParseTest.assertEquals((int)1, (int)cell.getRowSpan());
        GridItemParseTest.assertEquals((String)"all", (String)cell.getDrop());
        GridItemParseTest.assertEquals((String)"1.5mm", (String)cell.getHeight().getStringValue());
        GridItemParseTest.assertEquals((String)"2mm", (String)cell.getWidth().getStringValue());
        GridItemParseTest.assertEquals((String)"red", (String)cell.getPrivateStyle().getBackgroundColor().getStringValue());
        SlotHandle content = cell.getContent();
        LabelHandle label = (LabelHandle)content.get(0);
        GridItemParseTest.assertEquals((String)"address", (String)label.getName());
        GridItemParseTest.assertEquals((String)"solid", (String)cell.getDiagonalStyle());
        GridItemParseTest.assertEquals((String)"dashed", (String)cell.getAntidiagonalStyle());
        GridItemParseTest.assertEquals((int)10, (int)cell.getDiagonalNumber());
        GridItemParseTest.assertEquals((int)20, (int)cell.getAntidiagonalNumber());
        GridItemParseTest.assertEquals((String)"red", (String)cell.getDiagonalColor().getStringValue());
        GridItemParseTest.assertEquals((String)"blue", (String)cell.getAntidiagonalColor().getStringValue());
        dimensionHandle = cell.getDiagonalThickness();
        GridItemParseTest.assertEquals((String)"10mm", (String)dimensionHandle.getStringValue());
        dimensionHandle = cell.getAntidiagonalThickness();
        GridItemParseTest.assertEquals((String)"20mm", (String)dimensionHandle.getStringValue());
        GridItemParseTest.assertEquals((String)"rowgroup", (String)cell.getScope());
        GridItemParseTest.assertEquals((String)"bookmark for cell", (String)cell.getBookmark());
        GridItemParseTest.assertEquals((String)"headers for cell", (String)cell.getHeaders());
        grid = (GridHandle)this.designHandle.findElement("componentsGrid");
        GridItemParseTest.assertNotNull((Object)grid);
        grid = (GridHandle)this.designHandle.findElement("scratchpadGrid");
        GridItemParseTest.assertNotNull((Object)grid);
        grid = (GridHandle)this.designHandle.findElement("simplemasterpageHeaderGrid");
        GridItemParseTest.assertNotNull((Object)grid);
        grid = (GridHandle)this.designHandle.findElement("freeformGrid");
        GridItemParseTest.assertNotNull((Object)grid);
        grid = (GridHandle)this.designHandle.findElement("listHeaderGrid");
        GridItemParseTest.assertNotNull((Object)grid);
        grid = (GridHandle)this.designHandle.findElement("listDetailGrid");
        GridItemParseTest.assertNotNull((Object)grid);
        grid = (GridHandle)this.designHandle.findElement("listFooterGrid");
        GridItemParseTest.assertNotNull((Object)grid);
        grid = (GridHandle)this.designHandle.findElement("listgroupHeaderGrid");
        GridItemParseTest.assertNotNull((Object)grid);
        grid = (GridHandle)this.designHandle.findElement("listgroupFooterGrid");
        GridItemParseTest.assertNotNull((Object)grid);
        grid = (GridHandle)this.designHandle.findElement("cellGrid");
        GridItemParseTest.assertNotNull((Object)grid);
    }

    public void testWriter() throws Exception {
        this.openDesign(this.fileName);
        GridHandle grid = (GridHandle)this.designHandle.findElement("My grid");
        grid.setCaption("new caption");
        grid.setCaptionKey("new caption key");
        grid.setSummary("new summary");
        SlotHandle rows = grid.getRows();
        RowHandle row = (RowHandle)rows.get(0);
        SlotHandle cells = row.getCells();
        CellHandle cell = (CellHandle)cells.get(1);
        cell.setDiagonalStyle("inset");
        cell.setAntidiagonalStyle("outset");
        cell.setDiagonalNumber(20);
        cell.setAntidiagonalNumber(30);
        cell.setProperty("diagonalThickness", (Object)"1.5mm");
        cell.setProperty("antidiagonalThickness", (Object)"2.5mm");
        ColorHandle colorHandle = cell.getDiagonalColor();
        colorHandle.setStringValue("yellow");
        colorHandle = cell.getAntidiagonalColor();
        colorHandle.setStringValue("olive");
        cell.setScope("col");
        cell.setBookmark("new bookmark for cell");
        cell.setHeaders("new headers for cell");
        this.save();
        GridItemParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testSemanticCheck() throws Exception {
        this.openDesign(this.semanticCheckFileName);
        List errors = this.design.getErrorList();
        GridItemParseTest.assertEquals((int)3, (int)errors.size());
        int i = 0;
        ErrorDetail error = (ErrorDetail)errors.get(i++);
        GridItemParseTest.assertEquals((String)"First grid", (String)error.getElement().getName());
        GridItemParseTest.assertEquals((String)"Error.SemanticError.INCONSISTENT_GRID_COL_COUNT", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        GridItemParseTest.assertEquals((String)"Error.SemanticError.OVERLAPPING_CELLS", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        GridItemParseTest.assertEquals((String)"Error.SemanticError.OVERLAPPING_CELLS", (String)error.getErrorCode());
    }
}

