/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.parser.ParserTestCase;

public class LabelItemParserTest
extends ParserTestCase {
    String fileName = "LabelItemParseTest.xml";
    String goldenFileName = "LabelItemParseTest_golden.xml";
    String semanticCheckFileName = "LabelItemParseTest_1.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        LabelHandle labelHandle = this.getLabel();
        LabelItemParserTest.assertEquals((String)"6mm", (String)labelHandle.getStringProperty("x"));
        LabelItemParserTest.assertEquals((String)"0.5mm", (String)labelHandle.getStringProperty("y"));
        LabelItemParserTest.assertEquals((String)"0.25mm", (String)labelHandle.getStringProperty("height"));
        LabelItemParserTest.assertEquals((String)"1mm", (String)labelHandle.getStringProperty("width"));
        LabelItemParserTest.assertEquals((String)"Today's Date", (String)labelHandle.getStringProperty("text"));
        OdaDataSet dataSet = (OdaDataSet)this.design.findDataSet("firstDataSet");
        LabelItemParserTest.assertNotNull((Object)dataSet);
        LabelItemParserTest.assertEquals((Object)dataSet.getName(), (Object)labelHandle.getProperty("dataSet"));
        LabelItemParserTest.assertEquals((String)"red", (String)labelHandle.getStringProperty("color"));
        LabelItemParserTest.assertEquals((String)"\"labelFace\"", (String)labelHandle.getStringProperty("fontFamily"));
        LabelItemParserTest.assertEquals((String)"4mm", (String)labelHandle.getStringProperty("fontSize"));
        LabelItemParserTest.assertEquals((String)"bold", (String)labelHandle.getStringProperty("fontWeight"));
        LabelItemParserTest.assertEquals((String)"none", (String)labelHandle.getStringProperty("textUnderline"));
        LabelItemParserTest.assertEquals(null, (String)labelHandle.getStringProperty("highlightRules"));
        ActionHandle action = labelHandle.getActionHandle();
        LabelItemParserTest.assertNotNull((Object)action);
        LabelItemParserTest.assertEquals((String)"hyperlink", (String)action.getLinkType());
        LabelItemParserTest.assertEquals((String)"http://localhost:8080/", (String)action.getURI());
        labelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel");
        LabelItemParserTest.assertEquals((String)"<hello></hello><test><test1></test1></test>", (String)labelHandle.getCustomXml());
        LabelItemParserTest.assertEquals((String)"yellow", (String)labelHandle.getStringProperty("color"));
        LabelItemParserTest.assertEquals((String)"Body's slot", (String)labelHandle.getText());
        LabelItemParserTest.assertEquals((String)"label help text", (String)labelHandle.getHelpText());
        LabelItemParserTest.assertEquals((String)"help key", (String)labelHandle.getHelpTextKey());
        LabelItemParserTest.assertEquals((String)"text key", (String)labelHandle.getTextKey());
        LabelItemParserTest.assertEquals((int)6, (int)labelHandle.getContainer().findContentSlot((DesignElementHandle)labelHandle));
        labelHandle = (LabelHandle)this.designHandle.findElement("child1");
        LabelItemParserTest.assertEquals((String)"Today's Date", (String)labelHandle.getText());
        LabelItemParserTest.assertEquals((String)"label help text", (String)labelHandle.getHelpText());
        LabelItemParserTest.assertEquals((String)"help key", (String)labelHandle.getHelpTextKey());
        labelHandle = (LabelHandle)this.designHandle.findElement("label3");
        LabelItemParserTest.assertEquals((String)"Customer Name", (String)labelHandle.getText());
        labelHandle = (LabelHandle)this.designHandle.findElement("listHeaderLabel");
        LabelItemParserTest.assertEquals((String)"list header", (String)labelHandle.getText());
        LabelItemParserTest.assertTrue((boolean)labelHandle.pushDown());
        labelHandle = (LabelHandle)this.designHandle.findElement("listDetailLabel");
        LabelItemParserTest.assertEquals((String)"list detail", (String)labelHandle.getText());
        LabelItemParserTest.assertTrue((boolean)labelHandle.pushDown());
        labelHandle = (LabelHandle)this.designHandle.findElement("listFooterLabel");
        LabelItemParserTest.assertEquals((String)"list footer", (String)labelHandle.getText());
        labelHandle = (LabelHandle)this.designHandle.findElement("headerLabel");
        LabelItemParserTest.assertEquals((String)"Customer Name", (String)labelHandle.getText());
        labelHandle = (LabelHandle)this.designHandle.findElement("detailLabel");
        LabelItemParserTest.assertEquals((String)"Address", (String)labelHandle.getText());
        labelHandle = (LabelHandle)this.designHandle.findElement("footerLabel");
        LabelItemParserTest.assertEquals((String)"Address4", (String)labelHandle.getText());
        labelHandle = (LabelHandle)this.designHandle.findElement("scratchpadLabel");
        LabelItemParserTest.assertEquals((String)"scratch", (String)labelHandle.getText());
    }

    public void testWriter() throws Exception {
        LabelHandle labelHandle = this.getLabel();
        labelHandle.setProperty("x", (Object)"7mm");
        labelHandle.setProperty("height", (Object)"0.5mm");
        labelHandle.setProperty("style", null);
        OdaDataSet dataSet = (OdaDataSet)this.design.findDataSet("secondDataSet");
        LabelItemParserTest.assertNotNull((Object)dataSet);
        labelHandle.setProperty("dataSet", null);
        labelHandle.setProperty("name", (Object)"labelTestWriter");
        ActionHandle action = labelHandle.getActionHandle();
        LabelItemParserTest.assertNotNull((Object)action);
        action.setURI("www.myhost.com");
        labelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel");
        LabelItemParserTest.assertEquals((int)6, (int)labelHandle.getContainer().findContentSlot((DesignElementHandle)labelHandle));
        labelHandle.setProperty("color", (Object)"blue");
        LabelItemParserTest.assertEquals((int)6, (int)labelHandle.getContainer().findContentSlot((DesignElementHandle)labelHandle));
        labelHandle.setText("Final day");
        labelHandle.setWidth("5.0mm");
        labelHandle.setTextKey("new text resource key");
        labelHandle.setHelpText("new help text");
        labelHandle.setHelpTextKey("new help text key");
        labelHandle.setCustomXml("new custom <text> </text> for bodyLabel");
        labelHandle.setProperty("widows", (Object)"5");
        labelHandle.setProperty("orphans", (Object)"4");
        LabelItemParserTest.assertEquals((int)6, (int)labelHandle.getContainer().findContentSlot((DesignElementHandle)labelHandle));
        labelHandle = (LabelHandle)this.designHandle.findElement("listDetailLabel");
        labelHandle.setPushDown(true);
        this.save();
        LabelItemParserTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testSemanticCheck() {
        try {
            this.openDesign(this.semanticCheckFileName);
        }
        catch (DesignFileException e) {
            List list = e.getErrorList();
            ErrorDetail detail = (ErrorDetail)list.get(0);
            LabelItemParserTest.assertEquals((String)detail.getErrorCode(), (String)"Error.NameException.DUPLICATE");
        }
    }

    private LabelHandle getLabel() throws Exception {
        this.openDesign(this.fileName);
        MasterPageHandle masterPageHandle = (MasterPageHandle)this.designHandle.getMasterPages().get(0);
        LabelItemParserTest.assertEquals((int)2, (int)masterPageHandle.getSlot(0).getCount());
        Iterator it = masterPageHandle.getSlot(0).iterator();
        LabelItemParserTest.assertEquals((String)"label1", (String)((LabelHandle)it.next()).getName());
        LabelHandle labelHandle = (LabelHandle)it.next();
        LabelItemParserTest.assertEquals((String)"label2", (String)labelHandle.getName());
        return labelHandle;
    }
}

