/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.elements.structures.DateTimeFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.NumberFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.StringFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ReportItemParseTest
extends BaseTestCase {
    DesignElement element;

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("ReportItemParseTest.xml");
    }

    public void testParseProperties() throws Exception {
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel");
        ReportItemParseTest.assertEquals((String)"birt.js.labelHandler", (String)labelHandle.getEventHandlerClass());
        ReportItemParseTest.assertEquals((String)"Bookmark Display Name", (String)labelHandle.getBookmarkDisplayName());
        ReportItemParseTest.assertEquals((int)2, (int)labelHandle.getZIndex());
        ReportItemParseTest.assertEquals((Object)this.designHandle.findCube("testCube"), (Object)labelHandle.getCube());
        ReportItemParseTest.assertEquals((String)"hello, show me on create.", (String)labelHandle.getOnCreate());
        ReportItemParseTest.assertEquals((String)"hello, show me on render.", (String)labelHandle.getOnRender());
        ReportItemParseTest.assertEquals((String)"hello, show me on prepare.", (String)labelHandle.getOnPrepare());
        ReportItemParseTest.assertEquals((String)"hello, show me on page break.", (String)labelHandle.getOnPageBreak());
        Iterator rules = labelHandle.visibilityRulesIterator();
        StructureHandle structHandle = (StructureHandle)rules.next();
        ReportItemParseTest.assertNotNull((Object)structHandle);
        MemberHandle memberHandle = structHandle.getMember("format");
        ReportItemParseTest.assertEquals((String)"pdf", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("valueExpr");
        ReportItemParseTest.assertEquals((String)"word, 10 people", (String)memberHandle.getStringValue());
        structHandle = (StructureHandle)rules.next();
        ReportItemParseTest.assertNotNull((Object)structHandle);
        memberHandle = structHandle.getMember("format");
        ReportItemParseTest.assertEquals((String)"all", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("valueExpr");
        ReportItemParseTest.assertEquals((String)"excel, 10 people", (String)memberHandle.getStringValue());
        structHandle = (StructureHandle)rules.next();
        ReportItemParseTest.assertNull((Object)structHandle);
        Iterator bindings = labelHandle.paramBindingsIterator();
        structHandle = (StructureHandle)bindings.next();
        ReportItemParseTest.assertNull((Object)structHandle);
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.findElement("bodyData");
        ReportItemParseTest.assertEquals((String)"birt.js.dataHandler", (String)dataHandle.getEventHandlerClass());
        ReportItemParseTest.assertEquals((String)"hello, show data on prepare.", (String)dataHandle.getOnPrepare());
        ReportItemParseTest.assertEquals((String)"hello, show data on render.", (String)dataHandle.getOnRender());
        ReportItemParseTest.assertEquals(null, (String)dataHandle.getOnCreate());
        ReportItemParseTest.assertEquals((String)"acl expression test", (String)dataHandle.getACLExpression());
        ReportItemParseTest.assertTrue((boolean)((Boolean)dataHandle.getElement().getLocalProperty((Module)this.design, "cascadeACL")));
        ReportItemParseTest.assertFalse((boolean)dataHandle.cascadeACL());
        ReportItemParseTest.assertFalse((boolean)dataHandle.canCascadeACL());
        ReportItemParseTest.assertFalse((boolean)((Boolean)dataHandle.getProperty("cascadeACL")));
        ReportItemParseTest.assertFalse((boolean)dataHandle.getBooleanProperty("cascadeACL"));
        rules = dataHandle.visibilityRulesIterator();
        structHandle = (StructureHandle)rules.next();
        memberHandle = structHandle.getMember("format");
        ReportItemParseTest.assertEquals((String)"all", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("valueExpr");
        ReportItemParseTest.assertNull((Object)memberHandle.getStringValue());
        structHandle = (StructureHandle)rules.next();
        ReportItemParseTest.assertNotNull((Object)structHandle);
        memberHandle = structHandle.getMember("format");
        ReportItemParseTest.assertEquals((String)"pdf", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("valueExpr");
        ReportItemParseTest.assertNull((Object)memberHandle.getStringValue());
        bindings = dataHandle.paramBindingsIterator();
        structHandle = (StructureHandle)bindings.next();
        ReportItemParseTest.assertNotNull((Object)structHandle);
        memberHandle = structHandle.getMember("paramName");
        ReportItemParseTest.assertEquals((Object)"param1", (Object)memberHandle.getValue());
        memberHandle = structHandle.getMember("expression");
        ReportItemParseTest.assertEquals((String)"value1", (String)memberHandle.getStringValue());
        structHandle = (StructureHandle)bindings.next();
        ReportItemParseTest.assertNotNull((Object)structHandle);
        memberHandle = structHandle.getMember("paramName");
        ReportItemParseTest.assertEquals((Object)"param2", (Object)memberHandle.getValue());
        memberHandle = structHandle.getMember("expression");
        ReportItemParseTest.assertEquals((String)"value2", (String)memberHandle.getStringValue());
        structHandle = (StructureHandle)bindings.next();
        ReportItemParseTest.assertNull((Object)structHandle);
        ReportItemParseTest.assertEquals((String)"2005 Statistics", (String)dataHandle.getTocExpression());
        FreeFormHandle form = (FreeFormHandle)this.designHandle.findElement("free form");
        ReportItemParseTest.assertEquals((String)"\"This Section\"", (String)form.getTocExpression());
        TOCHandle tocHandle = dataHandle.getTOC();
        ReportItemParseTest.assertEquals((String)"2005 Statistics", (String)tocHandle.getExpression());
    }

    public void testWriteProperties() throws Exception {
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel");
        labelHandle.setCube(this.designHandle.findCube("testCube_one"));
        labelHandle.setBookmarkDisplayName("new display name");
        labelHandle.setZIndex(1);
        labelHandle.setOnCreate("my new label on create");
        labelHandle.setOnRender(null);
        labelHandle.setOnPrepare("my new label on prepare");
        labelHandle.setOnPageBreak("my new label on page break");
        Iterator rules = labelHandle.visibilityRulesIterator();
        StructureHandle structHandle = (StructureHandle)rules.next();
        ReportItemParseTest.assertNotNull((Object)structHandle);
        MemberHandle memberHandle = structHandle.getMember("format");
        memberHandle.setValue((Object)"reportlet");
        memberHandle.setValue((Object)"userDefinedformat");
        memberHandle = structHandle.getMember("valueExpr");
        memberHandle.setValue((Object)"10*20");
        labelHandle.setTocExpression("new 2005 statistics");
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.findElement("bodyData");
        dataHandle.setOnCreate("my new data on create");
        dataHandle.setOnRender("my new data on render");
        dataHandle.setOnPrepare(null);
        dataHandle.setEventHandlerClass("my new data handler class");
        dataHandle.setACLExpression("new acl expression test");
        dataHandle.setCascadeACL(true);
        rules = dataHandle.visibilityRulesIterator();
        structHandle = (StructureHandle)rules.next();
        structHandle = (StructureHandle)rules.next();
        ReportItemParseTest.assertNotNull((Object)structHandle);
        memberHandle = structHandle.getMember("format");
        memberHandle.setValue((Object)"reportlet");
        memberHandle = structHandle.getMember("valueExpr");
        memberHandle.setValue((Object)"bodyData 2nd rule.");
        structHandle = (StructureHandle)rules.next();
        ReportItemParseTest.assertNull((Object)structHandle);
        Iterator bindings = dataHandle.paramBindingsIterator();
        structHandle = (StructureHandle)bindings.next();
        ReportItemParseTest.assertNotNull((Object)structHandle);
        memberHandle = structHandle.getMember("paramName");
        memberHandle.setValue((Object)"no paramter 1");
        memberHandle = structHandle.getMember("expression");
        memberHandle.setValue((Object)"setting value 1");
        structHandle = (StructureHandle)bindings.next();
        ReportItemParseTest.assertNotNull((Object)structHandle);
        memberHandle = structHandle.getMember("paramName");
        memberHandle.setValue((Object)"no paramter 2");
        memberHandle = structHandle.getMember("expression");
        memberHandle.setValue((Object)"setting value 2");
        dataHandle.setTocExpression(null);
        this.save();
        ReportItemParseTest.assertTrue((boolean)this.compareFile("ReportItemParseTest_golden.xml"));
        dataHandle.addTOC("toc1");
        TOCHandle tocHandle = dataHandle.getTOC();
        ReportItemParseTest.assertNotNull((Object)tocHandle);
        dataHandle.addTOC(null);
        TOC toc = StructureFactory.createTOC((String)"toc2");
        dataHandle.addTOC(toc);
        this.save();
        ReportItemParseTest.assertTrue((boolean)this.compareFile("ReportItemParseTest_2_golden.xml"));
    }

    public void testOpenTOCStructure() throws Exception {
        this.openDesign("ReportItemParseTest_2.xml");
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.getBody().get(0);
        TOCHandle tocHandle = dataHandle.getTOC();
        ReportItemParseTest.assertNotNull((Object)tocHandle);
        ReportItemParseTest.assertEquals((String)"2005 Statistics", (String)tocHandle.getExpression());
        ReportItemParseTest.assertEquals((String)"NewStyle", (String)tocHandle.getStyleName());
        ReportItemParseTest.assertEquals((String)"double", (String)tocHandle.getBorderTopStyle());
        ReportItemParseTest.assertEquals((String)"thick", (String)tocHandle.getBorderTopWidth().getStringValue());
        ReportItemParseTest.assertEquals((String)"gray", (String)tocHandle.getBorderTopColor().getStringValue());
        ReportItemParseTest.assertEquals((String)"double", (String)tocHandle.getBorderLeftStyle());
        ReportItemParseTest.assertEquals((String)"thick", (String)tocHandle.getBorderLeftWidth().getStringValue());
        ReportItemParseTest.assertEquals((String)"blue", (String)tocHandle.getBorderLeftColor().getStringValue());
        ReportItemParseTest.assertEquals((String)"double", (String)tocHandle.getBorderBottomStyle());
        ReportItemParseTest.assertEquals((String)"thick", (String)tocHandle.getBorderBottomWidth().getStringValue());
        ReportItemParseTest.assertEquals((String)"red", (String)tocHandle.getBorderBottomColor().getStringValue());
        ReportItemParseTest.assertEquals((String)"double", (String)tocHandle.getBorderRightStyle());
        ReportItemParseTest.assertEquals((String)"thick", (String)tocHandle.getBorderRightWidth().getStringValue());
        ReportItemParseTest.assertEquals((String)"yellow", (String)tocHandle.getBorderRightColor().getStringValue());
        ReportItemParseTest.assertEquals((String)"center", (String)tocHandle.getNumberAlign());
        ReportItemParseTest.assertEquals((Object)"cursive", (Object)tocHandle.getFontFamily().getValue());
        ReportItemParseTest.assertEquals((String)"10pc", (String)tocHandle.getFontSize().getStringValue());
        ReportItemParseTest.assertEquals((String)"italic", (String)tocHandle.getFontStyle());
        ReportItemParseTest.assertEquals((String)"bold", (String)tocHandle.getFontWeight());
        ReportItemParseTest.assertEquals((String)"normal", (String)tocHandle.getFontVariant());
        ReportItemParseTest.assertEquals((String)"#000000", (String)tocHandle.getColor().getStringValue());
        ReportItemParseTest.assertEquals((String)"underline", (String)tocHandle.getTextUnderline());
        ReportItemParseTest.assertEquals((String)"overline", (String)tocHandle.getTextOverline());
        ReportItemParseTest.assertEquals((String)"line-through", (String)tocHandle.getTextLineThrough());
        ReportItemParseTest.assertEquals((String)"right", (String)tocHandle.getTextAlign());
        ReportItemParseTest.assertEquals((String)"4in", (String)tocHandle.getTextIndent().getStringValue());
        ReportItemParseTest.assertEquals((String)"lowercase", (String)tocHandle.getTextTransform());
        ReportItemParseTest.assertEquals((String)"yyyy/mm/dd", (String)tocHandle.getDateTimeFormat());
        ReportItemParseTest.assertEquals((String)"#.00", (String)tocHandle.getNumberFormat());
        ReportItemParseTest.assertEquals((String)"string-format", (String)tocHandle.getStringFormat());
        ReportItemParseTest.assertEquals((String)"Short Date", (String)tocHandle.getDateTimeFormatCategory());
        ReportItemParseTest.assertEquals((String)"Currency", (String)tocHandle.getNumberFormatCategory());
        ReportItemParseTest.assertEquals((String)"<", (String)tocHandle.getStringFormatCategory());
        StyleHandle styleHandle = (StyleHandle)this.designHandle.getStyles().get(0);
        styleHandle.setProperty("borderTopColor", (Object)"red");
        styleHandle.setProperty("borderLeftColor", (Object)"yellow");
        tocHandle.setProperty("borderLeftColor", null);
        tocHandle.setProperty("borderBottomWidth", null);
        tocHandle.setProperty("borderRightColor", (Object)"white");
        ReportItemParseTest.assertEquals((String)"gray", (String)tocHandle.getBorderTopColor().getStringValue());
        ReportItemParseTest.assertEquals((String)"medium", (String)tocHandle.getBorderBottomWidth().getStringValue());
        ReportItemParseTest.assertEquals((String)"white", (String)tocHandle.getBorderRightColor().getStringValue());
        ReportItemParseTest.assertEquals((String)"yellow", (String)tocHandle.getBorderLeftColor().getStringValue());
        this.save();
        ReportItemParseTest.assertTrue((boolean)this.compareFile("ReportItemParseTest_3_golden.xml"));
    }

    public void testWriteTOCStructure() throws Exception {
        this.createDesign();
        DataItemHandle dataHandle = this.designHandle.getElementFactory().newDataItem("bodyData");
        this.designHandle.getBody().add((DesignElementHandle)dataHandle);
        TOC toc = StructureFactory.createTOC((String)"2005 Statistics");
        TOCHandle tocHandle = dataHandle.addTOC(toc);
        ReportItemParseTest.assertNotNull((Object)tocHandle);
        ReportItemParseTest.assertEquals((String)"2005 Statistics", (String)tocHandle.getExpression());
        tocHandle.setStyleName("NewStyle");
        tocHandle.setProperty("borderTopStyle", (Object)"double");
        tocHandle.setProperty("borderTopColor", (Object)"gray");
        tocHandle.setProperty("borderTopWidth", (Object)"thick");
        tocHandle.setProperty("borderBottomStyle", (Object)"double");
        tocHandle.setProperty("borderBottomColor", (Object)"red");
        tocHandle.setProperty("borderBottomWidth", (Object)"thick");
        tocHandle.setProperty("borderLeftStyle", (Object)"double");
        tocHandle.setProperty("borderLeftColor", (Object)"blue");
        tocHandle.setProperty("borderLeftWidth", (Object)"thick");
        tocHandle.setProperty("borderRightStyle", (Object)"double");
        tocHandle.setProperty("borderRightColor", (Object)"yellow");
        tocHandle.setProperty("borderRightWidth", (Object)"thick");
        tocHandle.setProperty("backgroundColor", (Object)"#808080");
        tocHandle.setProperty("numberAlign", (Object)"center");
        tocHandle.setProperty("fontFamily", (Object)"cursive");
        tocHandle.setProperty("fontSize", (Object)"10pc");
        tocHandle.setProperty("fontStyle", (Object)"italic");
        tocHandle.setProperty("fontWeight", (Object)"bold");
        tocHandle.setProperty("fontVariant", (Object)"normal");
        tocHandle.setProperty("color", (Object)"#000000");
        tocHandle.setProperty("textUnderline", (Object)"underline");
        tocHandle.setProperty("textOverline", (Object)"overline");
        tocHandle.setProperty("textLineThrough", (Object)"line-through");
        tocHandle.setProperty("textAlign", (Object)"right");
        tocHandle.setProperty("textIndent", (Object)"4in");
        tocHandle.setProperty("textTransform", (Object)"lowercase");
        DateTimeFormatValue value = new DateTimeFormatValue();
        value.setPattern("yyyy/mm/dd");
        value.setCategory("Short Date");
        tocHandle.setProperty("dateTimeFormat", (Object)value);
        value = new StringFormatValue();
        value.setPattern("string-format");
        value.setCategory("<");
        tocHandle.setProperty("stringFormat", (Object)value);
        value = new NumberFormatValue();
        value.setPattern("#.00");
        value.setCategory("Currency");
        tocHandle.setProperty("numberFormat", (Object)value);
        this.save();
        ReportItemParseTest.assertTrue((boolean)this.compareFile("ReportItemParseTest_4_golden.xml"));
    }
}

