/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ListItem;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class SortingParserTest
extends BaseTestCase {
    private static final String FILE_NAME = "SortingParserTest.xml";
    private static final String SEMANTIC_CHECK_FILE_NAME = "SortingParserTest_1.xml";
    private static final String GOLDEN_FILE_NAME = "SortingParserTest_golden.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign(FILE_NAME);
    }

    public void testParser() {
        TableItem table = (TableItem)this.design.findElement("My table");
        SortingParserTest.assertNotNull((Object)table);
        ArrayList sorting = (ArrayList)table.getProperty((Module)this.design, "sort");
        SortingParserTest.assertEquals((int)2, (int)sorting.size());
        SortKey sortEntry = (SortKey)sorting.get(0);
        SortingParserTest.assertEquals((String)"age", (String)sortEntry.getKey());
        SortingParserTest.assertEquals((String)"asc", (String)sortEntry.getDirection());
        ListItem list = (ListItem)this.design.findElement("My list");
        SortingParserTest.assertNotNull((Object)table);
        sorting = (ArrayList)list.getProperty((Module)this.design, "sort");
        SortingParserTest.assertEquals((int)2, (int)sorting.size());
    }

    public void testSemanticCheck() throws DesignFileException {
        this.openDesign(SEMANTIC_CHECK_FILE_NAME);
        List errors = this.design.getErrorList();
        SortingParserTest.assertEquals((int)3, (int)errors.size());
        int i = 0;
        SortingParserTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)errors.get(i++)).getErrorCode());
        SortingParserTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)errors.get(i++)).getErrorCode());
        SortingParserTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)errors.get(i++)).getErrorCode());
    }

    public void testWriter() throws Exception {
        this.save();
        SortingParserTest.assertTrue((boolean)this.compareFile(GOLDEN_FILE_NAME));
    }
}

