/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.FontHandle;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.elements.structures.DateFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.TimeFormatValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.FreeForm;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StyleParseTest
extends BaseTestCase {
    String fileName = "StyleParseTest.xml";
    String goldenFileName = "StyleParseTest_golden.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        this.openDesign(this.fileName);
        StyleElement style = this.design.findStyle("My-Style");
        DateFormatValue dateFormatValue = (DateFormatValue)style.getProperty((Module)this.design, "dateFormat");
        StyleParseTest.assertEquals((String)"yyyy/mm/dd", (String)dateFormatValue.getPattern());
        StyleParseTest.assertEquals((String)"Short Date", (String)dateFormatValue.getCategory());
        TimeFormatValue timeFormatValue = (TimeFormatValue)style.getProperty((Module)this.design, "timeFormat");
        StyleParseTest.assertEquals((String)"hh/mm", (String)timeFormatValue.getPattern());
        StyleParseTest.assertEquals((String)"Short Time", (String)timeFormatValue.getCategory());
        StyleParseTest.assertEquals((String)"fantasy", (String)style.getStringProperty((Module)this.design, "fontFamily"));
        StyleParseTest.assertEquals((String)"red", (String)style.getStringProperty((Module)this.design, "color"));
        StyleParseTest.assertEquals((String)"larger", (String)style.getStringProperty((Module)this.design, "fontSize"));
        StyleParseTest.assertEquals((String)"italic", (String)style.getStringProperty((Module)this.design, "fontStyle"));
        StyleParseTest.assertEquals((String)"normal", (String)style.getStringProperty((Module)this.design, "fontVariant"));
        StyleParseTest.assertEquals((String)"bold", (String)style.getStringProperty((Module)this.design, "fontWeight"));
        StyleParseTest.assertEquals((String)"line-through", (String)style.getStringProperty((Module)this.design, "textLineThrough"));
        StyleParseTest.assertEquals((String)"overline", (String)style.getStringProperty((Module)this.design, "textOverline"));
        StyleParseTest.assertEquals((String)"underline", (String)style.getStringProperty((Module)this.design, "textUnderline"));
        StyleParseTest.assertEquals((String)"dotted", (String)style.getStringProperty((Module)this.design, "borderTopStyle"));
        StyleParseTest.assertEquals((String)"thin", (String)style.getStringProperty((Module)this.design, "borderTopWidth"));
        StyleParseTest.assertEquals((String)"blue", (String)style.getStringProperty((Module)this.design, "borderTopColor"));
        StyleParseTest.assertEquals((String)"dashed", (String)style.getStringProperty((Module)this.design, "borderLeftStyle"));
        StyleParseTest.assertEquals((String)"thin", (String)style.getStringProperty((Module)this.design, "borderLeftWidth"));
        StyleParseTest.assertEquals((String)"green", (String)style.getStringProperty((Module)this.design, "borderLeftColor"));
        StyleParseTest.assertEquals((String)"solid", (String)style.getStringProperty((Module)this.design, "borderBottomStyle"));
        StyleParseTest.assertEquals((String)"thin", (String)style.getStringProperty((Module)this.design, "borderBottomWidth"));
        StyleParseTest.assertEquals((String)"red", (String)style.getStringProperty((Module)this.design, "borderBottomColor"));
        StyleParseTest.assertEquals((String)"double", (String)style.getStringProperty((Module)this.design, "borderRightStyle"));
        StyleParseTest.assertEquals((String)"thin", (String)style.getStringProperty((Module)this.design, "borderRightWidth"));
        StyleParseTest.assertEquals((String)"maroon", (String)style.getStringProperty((Module)this.design, "borderRightColor"));
        StyleParseTest.assertEquals((String)"1mm", (String)style.getStringProperty((Module)this.design, "paddingTop"));
        StyleParseTest.assertEquals((String)"2mm", (String)style.getStringProperty((Module)this.design, "paddingLeft"));
        StyleParseTest.assertEquals((String)"3mm", (String)style.getStringProperty((Module)this.design, "paddingRight"));
        StyleParseTest.assertEquals((String)"4mm", (String)style.getStringProperty((Module)this.design, "paddingBottom"));
        StyleParseTest.assertEquals((String)"scroll", (String)style.getStringProperty((Module)this.design, "backgroundAttachment"));
        StyleParseTest.assertEquals((String)"red", (String)style.getStringProperty((Module)this.design, "backgroundColor"));
        StyleParseTest.assertEquals((String)"file", (String)style.getStringProperty((Module)this.design, "backgroundImage"));
        StyleParseTest.assertEquals((String)"embed", (String)style.getStringProperty((Module)this.design, "backgroundImageType"));
        StyleParseTest.assertEquals((String)"center", (String)style.getStringProperty((Module)this.design, "backgroundPositionX"));
        StyleParseTest.assertEquals((String)"top", (String)style.getStringProperty((Module)this.design, "backgroundPositionY"));
        StyleParseTest.assertEquals((String)"repeat", (String)style.getStringProperty((Module)this.design, "backgroundRepeat"));
        StyleParseTest.assertEquals((String)"right", (String)style.getStringProperty((Module)this.design, "textAlign"));
        StyleParseTest.assertEquals((String)"5mm", (String)style.getStringProperty((Module)this.design, "textIndent"));
        StyleParseTest.assertEquals((String)"normal", (String)style.getStringProperty((Module)this.design, "letterSpacing"));
        StyleParseTest.assertEquals((String)"normal", (String)style.getStringProperty((Module)this.design, "lineHeight"));
        StyleParseTest.assertEquals((String)"19", (String)style.getStringProperty((Module)this.design, "orphans"));
        StyleParseTest.assertEquals((String)"uppercase", (String)style.getStringProperty((Module)this.design, "textTransform"));
        StyleParseTest.assertEquals((String)"middle", (String)style.getStringProperty((Module)this.design, "verticalAlign"));
        StyleParseTest.assertEquals((String)"nowrap", (String)style.getStringProperty((Module)this.design, "whiteSpace"));
        StyleParseTest.assertEquals((String)"12", (String)style.getStringProperty((Module)this.design, "widows"));
        StyleParseTest.assertEquals((String)"normal", (String)style.getStringProperty((Module)this.design, "wordSpacing"));
        StyleParseTest.assertEquals((String)"inline", (String)style.getStringProperty((Module)this.design, "display"));
        StyleParseTest.assertEquals((String)"My Page", (String)style.getStringProperty((Module)this.design, "masterPage"));
        StyleParseTest.assertEquals((String)"auto", (String)style.getStringProperty((Module)this.design, "pageBreakAfter"));
        StyleParseTest.assertEquals((String)"auto", (String)style.getStringProperty((Module)this.design, "pageBreakBefore"));
        StyleParseTest.assertEquals((String)"auto", (String)style.getStringProperty((Module)this.design, "pageBreakInside"));
        StyleParseTest.assertEquals((String)"true", (String)style.getStringProperty((Module)this.design, "showIfBlank"));
        StyleParseTest.assertEquals((String)"true", (String)style.getStringProperty((Module)this.design, "canShrink"));
        StyleParseTest.assertEquals((String)"right", (String)style.getStringProperty((Module)this.design, "numberAlign"));
        StyleParseTest.assertEquals((String)"auto", (String)style.getStringProperty((Module)this.design, "marginTop"));
        StyleParseTest.assertEquals((String)"auto", (String)style.getStringProperty((Module)this.design, "marginLeft"));
        StyleParseTest.assertEquals((String)"auto", (String)style.getStringProperty((Module)this.design, "marginRight"));
        StyleParseTest.assertEquals((String)"auto", (String)style.getStringProperty((Module)this.design, "marginBottom"));
        StyleParseTest.assertEquals((String)"rtl", (String)style.getStringProperty((Module)this.design, "bidiTextDirection"));
        List mapRules = (List)style.getProperty((Module)this.design, "mapRules");
        StyleParseTest.assertEquals((int)5, (int)mapRules.size());
        StyleParseTest.assertEquals((String)"eq", (String)((MapRule)mapRules.get(0)).getOperator());
        StyleParseTest.assertEquals((String)"[somefield]", (String)((MapRule)mapRules.get(0)).getTestExpression());
        StyleParseTest.assertEquals((String)"Closed", (String)((MapRule)mapRules.get(0)).getDisplay());
        StyleParseTest.assertEquals((String)"\"X\"", (String)((MapRule)mapRules.get(0)).getValue1());
        StyleParseTest.assertEquals((String)"is-true", (String)((MapRule)mapRules.get(1)).getOperator());
        StyleParseTest.assertEquals((String)"Open", (String)((MapRule)mapRules.get(1)).getDisplay());
        StyleParseTest.assertEquals((String)"like", (String)((MapRule)mapRules.get(2)).getOperator());
        StyleParseTest.assertEquals((String)"Unknown", (String)((MapRule)mapRules.get(2)).getDisplay());
        NameSpace ns = this.design.getNameHelper().getNameSpace(0);
        StyleParseTest.assertEquals((int)19, (int)ns.getCount());
        StyleParseTest.assertEquals((String)"scroll", (String)style.getStringProperty((Module)this.design, "overflow"));
        StyleElement predefinedStyle = this.design.findStyle("table-detail");
        StyleParseTest.assertEquals((String)"table-detail", (String)predefinedStyle.getName());
        StyleParseTest.assertEquals((String)"large", (String)predefinedStyle.getStringProperty((Module)this.design, "fontSize"));
        StyleHandle sh = (StyleHandle)style.getHandle((Module)this.design);
        Iterator iter = sh.mapRulesIterator();
        StyleParseTest.assertNotNull(iter.next());
        StyleParseTest.assertNotNull(iter.next());
        StyleParseTest.assertNotNull(iter.next());
        DimensionHandle handle = sh.getBackgroundSizeWidth();
        StyleParseTest.assertEquals((String)"contain", (String)handle.getStringValue());
        handle = sh.getBackgroundSizeHeight();
        StyleParseTest.assertEquals((String)"cover", (String)handle.getStringValue());
        style = this.design.findStyle("test");
        StyleHandle styleHandle = (StyleHandle)style.getHandle((Module)this.design);
        StyleParseTest.assertEquals((Object)ULocale.ENGLISH, (Object)this.getLocale(styleHandle, "dateTimeFormat"));
        StyleParseTest.assertEquals((Object)ULocale.CANADA, (Object)this.getLocale(styleHandle, "dateFormat"));
        StyleParseTest.assertEquals((Object)ULocale.US, (Object)this.getLocale(styleHandle, "timeFormat"));
        StyleParseTest.assertEquals((Object)ULocale.FRANCE, (Object)this.getLocale(styleHandle, "numberFormat"));
        StyleParseTest.assertEquals((Object)ULocale.JAPANESE, (Object)this.getLocale(styleHandle, "stringFormat"));
    }

    private ULocale getLocale(StyleHandle handle, String propName) {
        PropertyHandle propHandle = handle.getPropertyHandle(propName);
        FormatValue formatValueToSet = (FormatValue)handle.getProperty(propName);
        FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
        return formatHandle.getLocale();
    }

    public void testSearchingProperty() throws Exception {
        this.openDesign(this.fileName);
        FreeForm form = (FreeForm)this.design.findElement("My First Form");
        Label label = (Label)form.getSlot(0).getContent(0);
        StyleParseTest.assertEquals((String)"4mm", (String)label.getStringProperty((Module)this.design, "width"));
        StyleParseTest.assertEquals((String)"4mm", (String)label.getFactoryProperty((Module)this.design, "width").toString());
        form = (FreeForm)this.design.findElement("My Second Form");
        label = (Label)form.getSlot(0).getContent(0);
        StyleParseTest.assertEquals((String)"My-Style", (String)label.getStyleName());
        StyleParseTest.assertEquals((String)"bold", (String)label.getStringProperty((Module)this.design, "fontWeight"));
        StyleParseTest.assertEquals((String)"bold", (String)label.getFactoryProperty((Module)this.design, "fontWeight").toString());
        form = (FreeForm)this.design.findElement("My Third Form");
        label = (Label)form.getSlot(0).getContent(0);
        StyleParseTest.assertEquals(null, (String)label.getStyleName());
        StyleParseTest.assertEquals((String)"bolder", (String)label.getStringProperty((Module)this.design, "fontWeight"));
        StyleParseTest.assertEquals((String)"bolder", (String)label.getFactoryProperty((Module)this.design, "fontWeight").toString());
        form = (FreeForm)this.design.findElement("My Fourth Form");
        label = (Label)form.getSlot(0).getContent(0);
        StyleParseTest.assertEquals((String)"My-Style", (String)label.getStyleName());
        StyleParseTest.assertEquals((String)"lighter", (String)label.getStringProperty((Module)this.design, "fontWeight"));
        StyleParseTest.assertEquals((String)"lighter", (String)label.getFactoryProperty((Module)this.design, "fontWeight").toString());
        form = (FreeForm)this.design.findElement("My Fifth Form");
        label = (Label)form.getSlot(0).getContent(0);
        StyleParseTest.assertEquals(null, (String)label.getStyleName());
        StyleParseTest.assertEquals((String)"100", (String)label.getStringProperty((Module)this.design, "fontWeight"));
        StyleParseTest.assertEquals((String)"100", (String)label.getFactoryProperty((Module)this.design, "fontWeight").toString());
        StyleParseTest.assertEquals(null, (String)this.design.getStringProperty((Module)this.design, "author"));
        StyleParseTest.assertEquals(null, (Object)this.design.getFactoryProperty((Module)this.design, "author"));
        MasterPage page = (MasterPage)this.design.getSlot(4).getContent(0);
        StyleParseTest.assertEquals((String)"8.5in", (String)page.getStringProperty((Module)this.design, "width"));
        StyleParseTest.assertEquals(null, (Object)page.getFactoryProperty((Module)this.design, "width"));
        StyleParseTest.assertEquals((String)"1", (String)page.getStringProperty((Module)this.design, "columns"));
        StyleParseTest.assertEquals((String)"1", (String)page.getFactoryProperty((Module)this.design, "columns").toString());
        form = (FreeForm)this.design.findElement("My Fifth Form");
        StyleParseTest.assertEquals(null, (String)form.getStringProperty((Module)this.design, "backgroundColor"));
        StyleParseTest.assertEquals((String)"repeat", (String)form.getStringProperty((Module)this.design, "backgroundRepeat"));
        StyleParseTest.assertEquals(null, (Object)form.getFactoryProperty((Module)this.design, "backgroundColor"));
        StyleParseTest.assertEquals(null, (Object)form.getFactoryProperty((Module)this.design, "backgroundRepeat"));
        form = (FreeForm)this.design.findElement("My Fifth Form");
        StyleParseTest.assertEquals((String)"serif", (String)form.getStringProperty((Module)this.design, "fontFamily"));
        StyleParseTest.assertEquals((String)"normal", (String)form.getStringProperty((Module)this.design, "fontStyle"));
        StyleParseTest.assertEquals(null, (Object)form.getFactoryProperty((Module)this.design, "fontFamily"));
        StyleParseTest.assertEquals(null, (Object)form.getFactoryProperty((Module)this.design, "fontStyle"));
        FreeForm childForm = (FreeForm)this.design.findElement("Child Form");
        StyleParseTest.assertEquals(null, (String)childForm.getStyleName());
        StyleParseTest.assertEquals((String)"999mm", (String)childForm.getStringProperty((Module)this.design, "x"));
        StyleParseTest.assertEquals((String)"999mm", (String)childForm.getFactoryProperty((Module)this.design, "x").toString());
        childForm = (FreeForm)this.design.findElement("Child Form");
        StyleParseTest.assertEquals(null, (String)childForm.getStyleName());
        StyleParseTest.assertEquals((String)"x-small", (String)childForm.getStringProperty((Module)this.design, "fontSize"));
        StyleParseTest.assertEquals((String)"small-caps", (String)childForm.getStringProperty((Module)this.design, "fontVariant"));
        StyleParseTest.assertEquals((Object)"x-small", (Object)childForm.getFactoryProperty((Module)this.design, "fontSize"));
        StyleParseTest.assertEquals((String)"small-caps", (String)childForm.getFactoryProperty((Module)this.design, "fontVariant").toString());
        StyleParseTest.assertEquals((String)"red", (String)childForm.getStringProperty((Module)this.design, "color"));
        StyleParseTest.assertEquals((Object)"red", (Object)childForm.getFactoryProperty((Module)this.design, "color"));
        TableItem table = (TableItem)this.design.findElement("My Fourth Table");
        StyleParseTest.assertNotNull((Object)table);
        TableRow row = (TableRow)table.getSlot(2).getContent(0);
        StyleParseTest.assertEquals((String)"large", (String)row.getStringProperty((Module)this.design, "fontSize"));
        StyleParseTest.assertEquals((Object)"large", (Object)row.getFactoryProperty((Module)this.design, "fontSize"));
        TableRow row1 = (TableRow)table.getSlot(0).getContent(0);
        StyleParseTest.assertEquals((Object)"red", (Object)row1.getFactoryProperty((Module)this.design, "color"));
        table = (TableItem)this.design.findElement("My Sixth Table");
        StyleParseTest.assertNotNull((Object)table);
        row = (TableRow)table.getSlot(0).getContent(0);
        StyleParseTest.assertEquals((String)"xx-large", (String)row.getStringProperty((Module)this.design, "fontSize"));
        StyleParseTest.assertEquals(null, (Object)row.getFactoryProperty((Module)this.design, "fontSize"));
        table = (TableItem)this.design.findElement("My Seventh Table");
        StyleParseTest.assertNotNull((Object)table);
        row = (TableRow)table.getSlot(0).getContent(0);
        StyleParseTest.assertEquals((String)"100", (String)row.getStringProperty((Module)this.design, "fontWeight"));
        StyleParseTest.assertEquals(null, (Object)row.getFactoryProperty((Module)this.design, "fontWeight"));
        table = (TableItem)this.design.findElement("My Eighth Inner Table");
        StyleParseTest.assertNotNull((Object)table);
        StyleParseTest.assertEquals(null, (String)table.getStringProperty((Module)this.design, "x"));
        StyleParseTest.assertEquals(null, (Object)table.getFactoryProperty((Module)this.design, "x"));
        table = (TableItem)this.design.findElement("My Tenth Table");
        StyleParseTest.assertNotNull((Object)table);
        row = (TableRow)table.getSlot(0).getContent(0);
        StyleParseTest.assertEquals((String)"xx-large", (String)row.getStringProperty((Module)this.design, "fontSize"));
        StyleParseTest.assertEquals(null, (Object)row.getFactoryProperty((Module)this.design, "fontSize"));
    }

    public void testWriter() throws Exception {
        this.openDesign(this.fileName);
        SharedStyleHandle style = this.designHandle.findStyle("My-Style");
        style.setNumberFormat("Scientific");
        style.setTextDirection("ltr");
        style.setBackgroundImageType("url");
        DimensionHandle handle = style.getBackgroundSizeHeight();
        handle.setStringValue("19pt");
        handle = style.getBackgroundSizeWidth();
        handle.setStringValue("0.5in");
        style.setOverflow("auto");
        DataItemHandle label = (DataItemHandle)this.designHandle.findElement("my data 2");
        style = label.getPrivateStyle();
        style.setNumberFormat("###.**");
        style.setNumberFormatCategory("Currency");
        style = this.designHandle.findStyle("test");
        this.setLocale((StyleHandle)style, "dateTimeFormat", ULocale.CANADA);
        this.setLocale((StyleHandle)style, "dateFormat", ULocale.US);
        this.setLocale((StyleHandle)style, "timeFormat", ULocale.FRANCE);
        this.setLocale((StyleHandle)style, "numberFormat", ULocale.JAPANESE);
        this.setLocale((StyleHandle)style, "stringFormat", ULocale.ENGLISH);
        this.save();
        StyleParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    private void setLocale(StyleHandle handle, String propName, ULocale locale) throws Exception {
        PropertyHandle propHandle = handle.getPropertyHandle(propName);
        FormatValue formatValueToSet = (FormatValue)handle.getProperty(propName);
        FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
        formatHandle.setLocale(locale);
    }

    public void testWriteHighlightRules() throws Exception {
        this.openDesign("StyleParseTest_1.xml");
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        StyleParseTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        StyleParseTest.assertEquals((String)"[this]", (String)highlightHandle.getTestExpression());
        highlightHandle.setDesignTime(true);
        ColorHandle colorHandle = highlightHandle.getColor();
        colorHandle.setRGB(0xFF0088);
        colorHandle = highlightHandle.getBackgroundColor();
        StyleParseTest.assertNotNull((Object)colorHandle);
        colorHandle.setStringValue("red");
        colorHandle = highlightHandle.getBorderBottomColor();
        try {
            colorHandle.setStringValue("nocolor");
            StyleParseTest.fail();
        }
        catch (PropertyValueException e) {
            StyleParseTest.assertEquals((String)e.getErrorCode(), (String)"Error.PropertyValueException.INVALID_VALUE");
        }
        colorHandle = highlightHandle.getBorderLeftColor();
        colorHandle.setRGB(1193046);
        colorHandle = highlightHandle.getBorderRightColor();
        colorHandle.setRGB(6636321);
        colorHandle = highlightHandle.getBorderTopColor();
        colorHandle.setStringValue("yellow");
        highlightHandle.setBorderLeftStyle("dotted");
        highlightHandle.setBorderRightStyle("none");
        highlightHandle.setBorderTopStyle("ridge");
        highlightHandle.setBorderBottomStyle("groove");
        highlightHandle.setOperator("eq");
        highlightHandle.setOperator("ne");
        highlightHandle.setOperator("lt");
        highlightHandle.setOperator("le");
        highlightHandle.setOperator("ge");
        highlightHandle.setOperator("between");
        highlightHandle.setOperator("not-between");
        highlightHandle.setOperator("is-not-null");
        highlightHandle.setOperator("is-true");
        highlightHandle.setOperator("is-false");
        highlightHandle.setOperator("like");
        highlightHandle.setOperator("gt");
        highlightHandle.setValue1("dataSet.name");
        highlightHandle.setValue2("table.column");
        try {
            highlightHandle.setTextAlign("nochoice");
            StyleParseTest.fail();
        }
        catch (PropertyValueException e) {
            StyleParseTest.assertEquals((String)e.getErrorCode(), (String)"Error.PropertyValueException.CHOICE_NOT_FOUND");
        }
        highlightHandle.setTextAlign("justify");
        highlightHandle.setTextLineThrough("none");
        highlightHandle.setTextOverline("none");
        highlightHandle.setTextUnderline("none");
        highlightHandle.setTextTransform("capitalize");
        highlightHandle.setNumberFormatCategory("Currency");
        highlightHandle.setNumberFormat("$000,000");
        highlightHandle.setDateTimeFormatCategory("Medium Date");
        highlightHandle.setDateTimeFormat("mm dd, yyyy");
        try {
            highlightHandle.setStringFormatCategory("no format");
            StyleParseTest.fail();
        }
        catch (PropertyValueException e) {
            StyleParseTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        DimensionHandle dimensionHandle = highlightHandle.getBorderBottomWidth();
        dimensionHandle.setStringValue("medium");
        dimensionHandle = highlightHandle.getBorderTopWidth();
        dimensionHandle.setStringValue("12pt");
        dimensionHandle = highlightHandle.getBorderLeftWidth();
        dimensionHandle.setStringValue("12mm");
        dimensionHandle = highlightHandle.getBorderRightWidth();
        dimensionHandle.setStringValue("thick");
        dimensionHandle = highlightHandle.getTextIndent();
        dimensionHandle.setStringValue("2pc");
        FontHandle fontHandle = highlightHandle.getFontFamilyHandle();
        fontHandle.setStringValue("song");
        dimensionHandle = highlightHandle.getFontSize();
        dimensionHandle.setStringValue("18pc");
        highlightHandle.setFontStyle("oblique");
        highlightHandle.setFontVariant("small-caps");
        highlightHandle.setFontWeight("900");
        highlightHandle.setTextDirection("ltr");
        highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        StyleParseTest.assertNotNull((Object)highlightHandle);
        StyleParseTest.assertEquals((String)"[this]", (String)highlightHandle.getTestExpression());
        dimensionHandle = highlightHandle.getFontSize();
        dimensionHandle.setStringValue("18pt");
        highlightHandle.setStyleName("Empty Style");
        highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        StyleParseTest.assertNull((Object)highlightHandle);
        this.save();
        StyleParseTest.assertTrue((boolean)this.compareFile("StyleParseTest_golden_1.xml"));
    }

    public void testPredefinedStyle() throws Exception {
        this.openDesign(this.fileName);
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        ElementDefn elementDefn = (ElementDefn)dd.getElement("ReportDesign");
        StyleParseTest.assertEquals((String)"report", (String)elementDefn.getSelector());
        elementDefn = (ElementDefn)dd.getElement("GraphicMasterPage");
        StyleParseTest.assertEquals((String)"page", (String)elementDefn.getSelector());
        elementDefn = (ElementDefn)dd.getElement("Label");
        StyleParseTest.assertEquals((String)"label", (String)elementDefn.getSelector());
        elementDefn = (ElementDefn)dd.getElement("Text");
        StyleParseTest.assertEquals((String)"text", (String)elementDefn.getSelector());
        elementDefn = (ElementDefn)dd.getElement("Grid");
        StyleParseTest.assertEquals((String)"grid", (String)elementDefn.getSelector());
        elementDefn = (ElementDefn)dd.getElement("FreeForm");
        StyleParseTest.assertEquals((String)"free-form", (String)elementDefn.getSelector());
        elementDefn = (ElementDefn)dd.getElement("Line");
        StyleParseTest.assertEquals((String)"line", (String)elementDefn.getSelector());
        elementDefn = (ElementDefn)dd.getElement("Rectangle");
        StyleParseTest.assertEquals((String)"rectangle", (String)elementDefn.getSelector());
        elementDefn = (ElementDefn)dd.getElement("List");
        StyleParseTest.assertEquals((String)"list", (String)elementDefn.getSelector());
        StyleParseTest.assertEquals((String)"list-header", (String)((SlotDefn)elementDefn.getSlot(0)).getSelector());
        StyleParseTest.assertEquals((String)"list-footer", (String)((SlotDefn)elementDefn.getSlot(3)).getSelector());
        StyleParseTest.assertEquals((String)"list-detail", (String)((SlotDefn)elementDefn.getSlot(2)).getSelector());
        elementDefn = (ElementDefn)dd.getElement("ListGroup");
        StyleParseTest.assertEquals(null, (String)elementDefn.getSelector());
        StyleParseTest.assertEquals((String)"list-group-header", (String)((SlotDefn)elementDefn.getSlot(0)).getSelector());
        StyleParseTest.assertEquals((String)"list-group-footer", (String)((SlotDefn)elementDefn.getSlot(1)).getSelector());
        elementDefn = (ElementDefn)dd.getElement("Table");
        StyleParseTest.assertEquals((String)"table", (String)elementDefn.getSelector());
        StyleParseTest.assertEquals((String)"table-header", (String)((SlotDefn)elementDefn.getSlot(0)).getSelector());
        StyleParseTest.assertEquals((String)"table-footer", (String)((SlotDefn)elementDefn.getSlot(3)).getSelector());
        StyleParseTest.assertEquals((String)"table-detail", (String)((SlotDefn)elementDefn.getSlot(2)).getSelector());
        elementDefn = (ElementDefn)dd.getElement("TableGroup");
        StyleParseTest.assertEquals(null, (String)elementDefn.getSelector());
        StyleParseTest.assertEquals((String)"table-group-header", (String)((SlotDefn)elementDefn.getSlot(0)).getSelector());
        StyleParseTest.assertEquals((String)"table-group-footer", (String)((SlotDefn)elementDefn.getSlot(1)).getSelector());
    }

    public void testPropertySearchWithLevel() throws Exception {
        this.openDesign(this.fileName);
        TableItem table = (TableItem)this.design.findElement("My Ninth Table");
        StyleParseTest.assertNotNull((Object)table);
        TableGroup group = (TableGroup)table.getSlot(1).getContent(0);
        TableRow row = (TableRow)group.getSlot(0).getContent(0);
        StyleParseTest.assertEquals((String)"center", (String)row.getStringProperty((Module)this.design, "textAlign"));
        StyleParseTest.assertEquals((Object)"center", (Object)row.getFactoryProperty((Module)this.design, "textAlign"));
        group = (TableGroup)table.getSlot(1).getContent(1);
        row = (TableRow)group.getSlot(0).getContent(0);
        StyleParseTest.assertEquals((String)"right", (String)row.getStringProperty((Module)this.design, "textAlign"));
        StyleParseTest.assertEquals((Object)"right", (Object)row.getFactoryProperty((Module)this.design, "textAlign"));
        group = (TableGroup)table.getSlot(1).getContent(8);
        row = (TableRow)group.getSlot(0).getContent(0);
        StyleParseTest.assertEquals((String)"center", (String)row.getStringProperty((Module)this.design, "textAlign"));
        StyleParseTest.assertEquals((Object)"center", (Object)row.getFactoryProperty((Module)this.design, "textAlign"));
        group = (TableGroup)table.getSlot(1).getContent(9);
        row = (TableRow)group.getSlot(0).getContent(0);
        StyleParseTest.assertEquals((String)"center", (String)row.getStringProperty((Module)this.design, "textAlign"));
        StyleParseTest.assertEquals((Object)"center", (Object)row.getFactoryProperty((Module)this.design, "textAlign"));
    }

    public void testReadHighlightRules() throws Exception {
        this.openDesign("StyleParseTest_1.xml");
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        StyleParseTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        StyleParseTest.assertNotNull((Object)highlightHandle);
        StyleParseTest.assertFalse((boolean)highlightHandle.isDesignTime());
        StyleParseTest.assertEquals((String)"[this]", (String)highlightHandle.getTestExpression());
        ColorHandle colorHandle = highlightHandle.getColor();
        StyleParseTest.assertEquals((String)"blue", (String)colorHandle.getCssValue());
        colorHandle = highlightHandle.getBackgroundColor();
        StyleParseTest.assertNotNull((Object)colorHandle);
        StyleParseTest.assertEquals((String)"white", (String)colorHandle.getCssValue());
        colorHandle = highlightHandle.getColor();
        StyleParseTest.assertEquals((String)"blue", (String)colorHandle.getCssValue());
        colorHandle = highlightHandle.getBorderBottomColor();
        StyleParseTest.assertEquals((String)"black", (String)colorHandle.getCssValue());
        colorHandle = highlightHandle.getBorderLeftColor();
        StyleParseTest.assertEquals((String)"black", (String)colorHandle.getCssValue());
        colorHandle = highlightHandle.getBorderRightColor();
        StyleParseTest.assertEquals((String)"black", (String)colorHandle.getCssValue());
        colorHandle = highlightHandle.getBorderTopColor();
        StyleParseTest.assertEquals((String)"black", (String)colorHandle.getCssValue());
        String borderStyle = highlightHandle.getBorderBottomStyle();
        StyleParseTest.assertEquals((String)"solid", (String)borderStyle);
        borderStyle = highlightHandle.getBorderLeftStyle();
        StyleParseTest.assertEquals((String)"solid", (String)borderStyle);
        borderStyle = highlightHandle.getBorderRightStyle();
        StyleParseTest.assertEquals((String)"solid", (String)borderStyle);
        borderStyle = highlightHandle.getBorderTopStyle();
        StyleParseTest.assertEquals((String)"solid", (String)borderStyle);
        String operator = highlightHandle.getOperator();
        StyleParseTest.assertEquals((String)"eq", (String)operator);
        String value1 = highlightHandle.getValue1();
        StyleParseTest.assertEquals((String)"\"10\"", (String)value1);
        String value2 = highlightHandle.getValue2();
        StyleParseTest.assertEquals((String)"\"20\"", (String)value2);
        String textValue = highlightHandle.getTextAlign();
        StyleParseTest.assertEquals((String)"right", (String)textValue);
        textValue = highlightHandle.getTextLineThrough();
        StyleParseTest.assertEquals((String)"line-through", (String)textValue);
        textValue = highlightHandle.getTextOverline();
        StyleParseTest.assertEquals((String)"overline", (String)textValue);
        textValue = highlightHandle.getTextUnderline();
        StyleParseTest.assertEquals((String)"underline", (String)textValue);
        textValue = highlightHandle.getTextTransform();
        StyleParseTest.assertEquals((String)"lowercase", (String)textValue);
        StyleParseTest.assertEquals((String)"#.00", (String)highlightHandle.getNumberFormat());
        StyleParseTest.assertEquals((String)"yyyy/mm/dd", (String)highlightHandle.getDateTimeFormat());
        StyleParseTest.assertEquals((String)"string-format", (String)highlightHandle.getStringFormat());
        DimensionHandle dimensionHandle = highlightHandle.getBorderBottomWidth();
        StyleParseTest.assertEquals((String)"thin", (String)dimensionHandle.getStringValue());
        dimensionHandle = highlightHandle.getBorderLeftWidth();
        StyleParseTest.assertEquals((String)"thin", (String)dimensionHandle.getStringValue());
        dimensionHandle = highlightHandle.getBorderTopWidth();
        StyleParseTest.assertEquals((String)"thin", (String)dimensionHandle.getStringValue());
        dimensionHandle = highlightHandle.getBorderRightWidth();
        StyleParseTest.assertEquals((String)"thin", (String)dimensionHandle.getStringValue());
        FontHandle fontHandle = highlightHandle.getFontFamilyHandle();
        StyleParseTest.assertEquals((String)"\"Arial\"", (String)fontHandle.getStringValue());
        String fontValue = highlightHandle.getFontStyle();
        StyleParseTest.assertEquals((String)"normal", (String)fontValue);
        fontValue = highlightHandle.getFontVariant();
        StyleParseTest.assertEquals((String)"normal", (String)fontValue);
        fontValue = highlightHandle.getFontWeight();
        StyleParseTest.assertEquals((String)"bold", (String)fontValue);
        dimensionHandle = highlightHandle.getFontSize();
        StyleParseTest.assertEquals((String)"9pt", (String)dimensionHandle.getStringValue());
        dimensionHandle = highlightHandle.getTextIndent();
        StyleParseTest.assertEquals((String)"1pc", (String)dimensionHandle.getStringValue());
        StyleParseTest.assertEquals((String)"rtl", (String)highlightHandle.getTextDirection());
        highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        StyleParseTest.assertNotNull((Object)highlightHandle);
        StyleParseTest.assertEquals((String)"[this]", (String)highlightHandle.getTestExpression());
        colorHandle = highlightHandle.getColor();
        StyleParseTest.assertEquals((String)"blue", (String)colorHandle.getCssValue());
        dimensionHandle = highlightHandle.getFontSize();
        StyleParseTest.assertEquals((String)"5pc", (String)dimensionHandle.getStringValue());
        dimensionHandle = highlightHandle.getTextIndent();
        StyleParseTest.assertNull((Object)dimensionHandle.getStringValue());
        StyleParseTest.assertNull((Object)highlightHandle.getStyle());
        StyleParseTest.assertEquals((Object)"nonExistedStyle", (Object)highlightHandle.getProperty("style"));
        highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        StyleParseTest.assertNull((Object)highlightHandle);
    }

    public void testSessionDefault() throws DesignFileException, PropertyValueException {
        this.openDesign(this.fileName);
        FreeForm form = (FreeForm)this.design.findElement("My Sixth Form");
        StyleParseTest.assertNotNull((Object)form);
        this.design.getSession().setDefaultValue("borderBottomColor", (Object)"#0000ff");
        StyleParseTest.assertEquals((String)"#0000FF", (String)form.getStringProperty((Module)this.design, "borderBottomColor").toString());
        StyleParseTest.assertEquals((String)"black", (String)form.getStringProperty((Module)this.design, "borderTopColor").toString());
        this.design.getSession().setDefaultValue("borderBottomColor", null);
        StyleParseTest.assertEquals((String)"black", (String)form.getStringProperty((Module)this.design, "borderBottomColor").toString());
    }

    public void testPropertyFromSelector() throws Exception {
        this.openDesign(this.fileName);
        LabelHandle label = (LabelHandle)this.designHandle.findElement("label1");
        String bkColor = label.getStringProperty("backgroundColor");
        StyleParseTest.assertEquals((String)"gray", (String)bkColor);
    }

    public void testOpenSaveObsoleteFile() throws Exception {
        this.openDesign("StyleParseTest_obsolete.xml");
        this.save();
        StyleParseTest.assertTrue((boolean)this.compareFile("StyleParseTest_obsolete_golden.xml"));
    }

    public void testFontFamily() throws Exception {
        this.openDesign(this.fileName);
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle(null);
        this.designHandle.getStyles().add((DesignElementHandle)style);
        String value = "cursive";
        style.getFontFamilyHandle().setValue((Object)value);
        StyleParseTest.assertEquals((String)"cursive", (String)style.getStringProperty("fontFamily"));
        value = "a b";
        style.getFontFamilyHandle().setValue((Object)value);
        StyleParseTest.assertEquals((String)"\"a b\"", (String)style.getStringProperty("fontFamily"));
        value = " a b, \"cd\" ,fantasy";
        style.getFontFamilyHandle().setValue((Object)value);
        StyleParseTest.assertEquals((String)"\"a b\", \"cd\", fantasy", (String)style.getStringProperty("fontFamily"));
    }

    public void testTOC() throws Exception {
        this.openDesign(this.fileName);
        LabelHandle label = this.designHandle.getElementFactory().newLabel(null);
        this.designHandle.getBody().add((DesignElementHandle)label);
        label.setTocExpression("label toc expression");
        TOCHandle tocHandle = label.getTOC();
        CommandStack stack = this.designHandle.getCommandStack();
        stack.startTrans(null);
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("newTocStyle");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        tocHandle.setStyleName(style.getName());
        stack.commit();
        StyleParseTest.assertEquals((String)style.getName(), (String)tocHandle.getStyleName());
        stack.undo();
        StyleParseTest.assertNull((Object)tocHandle.getStyleName());
        this.designHandle.getStyles().add((DesignElementHandle)style);
        tocHandle.setStyleName(style.getName());
        StyleParseTest.assertEquals((int)1, (int)((Style)style.getElement()).getClientList().size());
        stack.undo();
        StyleParseTest.assertEquals((int)0, (int)((Style)style.getElement()).getClientList().size());
    }
}

