/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class TextDataItemParseTest
extends BaseTestCase {
    String fileName = "TextDataItemParseTest.xml";
    String goldenFileName = "TextDataItemParseTest_golden.xml";
    String checkFileName = "TextDataItemParseTest_1.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        this.openDesign(this.fileName);
        TextDataHandle dataHandle = (TextDataHandle)this.designHandle.findElement("Text Data");
        TextDataItemParseTest.assertNotNull((Object)dataHandle.getElement());
        TextDataItemParseTest.assertEquals((String)"value expr", (String)dataHandle.getValueExpr());
        TextDataItemParseTest.assertEquals((String)"auto", (String)dataHandle.getContentType());
        TextDataItemParseTest.assertTrue((boolean)dataHandle.hasExpression());
    }

    public void testWriter() throws Exception {
        this.openDesign(this.fileName);
        TextDataHandle dataHandle = (TextDataHandle)this.designHandle.findElement("Text Data");
        TextDataItemParseTest.assertNotNull((Object)dataHandle.getElement());
        dataHandle.setValueExpr("new value expr");
        dataHandle.setContentType("rtf");
        dataHandle.setHasExpression(false);
        this.save();
        TextDataItemParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testSemanticError() throws Exception {
        this.openDesign(this.checkFileName);
        List errors = this.design.getErrorList();
        TextDataItemParseTest.assertEquals((int)1, (int)errors.size());
        int i = 0;
        TextDataItemParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)errors.get(i++)).getErrorCode());
    }
}

