/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.MultiRowItem;
import org.eclipse.birt.report.model.api.extension.SimpleRowItem;
import org.eclipse.birt.report.model.api.simpleapi.ILabel;
import org.eclipse.birt.report.model.api.simpleapi.IMultiRowItem;
import org.eclipse.birt.report.model.api.simpleapi.IReportDesign;
import org.eclipse.birt.report.model.api.simpleapi.IReportItem;
import org.eclipse.birt.report.model.api.simpleapi.ISortCondition;
import org.eclipse.birt.report.model.api.simpleapi.ITable;
import org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class SimpleApiTest
extends BaseTestCase {
    private static final String FILENAME = "DesignFileTest.xml";
    private static final String OUT_FILENAME = "DesignFileTest_out.xml";
    private static final String GOLDEN_FILENAME = "DesignFileTest_golden.xml";
    private IReportDesign simpleDesign;

    protected void setUp() throws Exception {
        DesignEngine engine = new DesignEngine(null);
        InputStream ins = this.getResource("input/DesignFileTest.xml").openStream();
        this.simpleDesign = engine.openDesign("input/DesignFileTest.xml", ins, null);
    }

    public void testSimpleElement() throws Exception {
        ITable table = (ITable)this.simpleDesign.getReportElement("my table");
        SimpleApiTest.assertNotNull((Object)table);
        ILabel label = (ILabel)this.simpleDesign.getReportElement("my label");
        SimpleApiTest.assertNotNull((Object)label);
        IReportItem matrix = (IReportItem)this.simpleDesign.getReportElement("testMatrix");
        SimpleApiTest.assertNotNull((Object)matrix);
        SimpleApiTest.assertTrue((boolean)(matrix instanceof IMultiRowItem));
        SimpleApiTest.assertTrue((boolean)(matrix instanceof MultiRowItem));
        SimpleApiTest.assertEquals((String)"org.eclipse.birt.report.model.tests.matrix.Matrix", (String)matrix.getClass().getName());
        IReportItem box = (IReportItem)this.simpleDesign.getReportElement("testBox");
        SimpleApiTest.assertNotNull((Object)box);
        SimpleApiTest.assertFalse((boolean)(box instanceof IMultiRowItem));
        SimpleApiTest.assertTrue((boolean)(box instanceof SimpleRowItem));
        SimpleApiTest.assertEquals((String)"org.eclipse.birt.report.model.tests.box.Box", (String)box.getClass().getName());
    }

    protected URL getResource(String name) {
        return ((Object)((Object)this)).getClass().getResource(name);
    }

    public void testSaveDesign() throws Exception {
        ITable table = (ITable)this.simpleDesign.getReportElement("my table");
        SimpleApiTest.assertNotNull((Object)table);
        table.setName("my new table");
        this.simpleDesign.saveAs(this.getOutputFolder(OUT_FILENAME));
        SimpleApiTest.assertTrue((boolean)this.compareFile(GOLDEN_FILENAME, OUT_FILENAME));
    }

    private String getOutputFolder(String outputFile) throws IOException {
        String folder = String.valueOf(this.getTempFolder()) + "/output/";
        File tmpFolder = new File(folder);
        if (!tmpFolder.exists()) {
            tmpFolder.mkdirs();
        }
        return String.valueOf(folder) + outputFile;
    }

    public void testStructureHandle() throws Exception {
        ITable table = (ITable)this.simpleDesign.getReportElement("my table");
        SimpleApiTest.assertNotNull((Object)table);
        ISortCondition[] sorts = table.getSortConditions();
        ISortCondition sort = sorts[0];
        try {
            sort.setDirection("invalidValue");
            SimpleApiTest.fail();
        }
        catch (SemanticException e) {
            SimpleApiTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testUndoRedo() throws Exception {
        this.openDesign(FILENAME);
        this.simpleDesign = (IReportDesign)SimpleElementFactory.getInstance().getElement((DesignElementHandle)this.designHandle);
        ITable table = (ITable)this.simpleDesign.getReportElement("my table");
        SimpleApiTest.assertNotNull((Object)table);
        table.setCaption("new caption");
        SimpleApiTest.assertFalse((boolean)this.designHandle.getCommandStack().canUndo());
        this.simpleDesign.setTheme(null);
        SimpleApiTest.assertFalse((boolean)this.designHandle.getCommandStack().canUndo());
        SimpleApiTest.assertNull((Object)this.designHandle.getProperty("theme"));
    }
}

