/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class URIUtilTest
extends BaseTestCase {
    public void testFileProtocol() throws IOException {
        URIUtilTest.assertEquals((String)"//C:/disk/test/data.file", (String)URIUtil.getLocalPath((String)"file://C:/disk/test/data.file"));
        URIUtilTest.assertEquals((String)"/C:/disk/test/data.file", (String)URIUtil.getLocalPath((String)"/C:/disk/test/data.file"));
        URIUtilTest.assertEquals((String)"/usr/local/disk/test/data.file", (String)URIUtil.getLocalPath((String)"/usr/local/disk/test/data.file"));
        URIUtilTest.assertEquals((String)"C:\\disk\\test/data.file", (String)URIUtil.getLocalPath((String)"C:\\disk\\test/data.file"));
        URIUtilTest.assertEquals((String)"C:/disk/test/data.file", (String)URIUtil.getLocalPath((String)"C:/disk/test/data.file"));
        URIUtilTest.assertEquals((String)"./test/data.file", (String)URIUtil.getLocalPath((String)"./test/data.file"));
        URIUtilTest.assertNull((Object)URIUtil.getLocalPath((String)"http://hello/test/test.html"));
        URIUtilTest.assertNull((Object)URIUtil.getLocalPath((String)"ftp://hello/test/test.html"));
        URIUtilTest.assertNull((Object)URIUtil.getLocalPath((String)"http://hp.msn.com/2I/_XM9~_`9ZW5I]T9{Q29,@+.jpg"));
        URIUtilTest.assertEquals((String)"hp.msn.com/2I/_XM9~_`9ZW5I]T9{Q29,@+.jpg", (String)URIUtil.getLocalPath((String)"file://hp.msn.com/2I/_XM9~_`9ZW5I]T9{Q29,@+.jpg"));
        URIUtilTest.assertEquals((String)"C:\\hp.msn.com/2I/_XM9~_`9ZW5I]T9{Q29,@+.jpg", (String)URIUtil.getLocalPath((String)"C:\\hp.msn.com/2I/_XM9~_`9ZW5I]T9{Q29,@+.jpg"));
        URIUtilTest.assertEquals((String)"/C:/hp.msn.com/2I/_XM9~_`9ZW5I]T9{Q29,@+.jpg", (String)URIUtil.getLocalPath((String)"file:///C:/hp.msn.com/2I/_XM9~_`9ZW5I]T9{Q29,@+.jpg"));
    }

    public void testGetRelativePath() {
        if (this.isWindowsPlatform()) {
            this.getRelativePathOnWindows();
        } else {
            this.getRelativePathOnUnix();
        }
        URIUtilTest.assertEquals((String)"../lib/lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"./birt/sampleReports/reportdesigns/", (String)"./birt/sampleReports/lib/lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"./reportdesigns", (String)"./reportdesigns/lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"../lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"./reportdesigns/hello.rptdesign", (String)"./reportdesigns/lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"", (String)URIUtil.getRelativePath((String)"./reportdesigns/lib1", (String)"./reportdesigns/lib1"));
        URIUtilTest.assertNull((Object)URIUtil.getRelativePath(null, null));
        URIUtilTest.assertEquals((String)"", (String)URIUtil.getRelativePath((String)"", (String)""));
        URIUtilTest.assertEquals((String)"./birt/lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"", (String)"./birt/lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"fragments/new_library.rptlibrary", (String)URIUtil.getRelativePath((String)"bundleentry://385", (String)"bundleentry://385/fragments/new_library.rptlibrary"));
        URIUtilTest.assertEquals((String)"../../test.rptdesign", (String)URIUtil.getRelativePath((String)"../test/report", (String)"../test.rptdesign"));
    }

    private void getRelativePathOnUnix() {
        URIUtilTest.assertEquals((String)"../lib/lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"/birt/sampleReports/Reportdesigns/", (String)"/birt/sampleReports/lib/lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"../../../birt/sampleReports/lib/lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"/usr/sampleReports/reportdesigns/", (String)"/birt/sampleReports/lib/lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"lib/lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"/sampleReports//reportdesigns//", (String)"/sampleReports//reportdesigns//lib//lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"/sampleReports//reportdesigns//", (String)"/sampleReports//reportdesigns//lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"..", (String)URIUtil.getRelativePath((String)"//sampleReports//reportdesigns//lib1.rptlibrary", (String)"//sampleReports//reportdesigns//"));
    }

    private void getRelativePathOnWindows() {
        URIUtilTest.assertEquals((String)"../lib/lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"E://birt//sampleReports//Reportdesigns//", (String)"E://birt//sampleReports//lib//lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"../lib/lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"/E:/birt/sampleReports/reportdesigns/", (String)"/E:/birt/sampleReports/lib/lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"../lib/lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"E:/birt/sampleReports/reportdesigns/", (String)"/E:/birt/sampleReports/lib/lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"E:/birt/sampleReports/lib/lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"D:/birt/sampleReports/reportdesigns/", (String)"E:/birt/sampleReports/lib/lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"lib/lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"E://birt//sampleReports//reportdesigns//", (String)"E://birt//sampleReports//reportdesigns//lib//lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"lib1.rptlibrary", (String)URIUtil.getRelativePath((String)"E://birt//sampleReports//reportdesigns//", (String)"E://birt//sampleReports//reportdesigns//lib1.rptlibrary"));
        URIUtilTest.assertEquals((String)"..", (String)URIUtil.getRelativePath((String)"E://birt//sampleReports//reportdesigns//lib1.rptlibrary", (String)"E://birt//sampleReports//reportdesigns//"));
        URIUtilTest.assertEquals((String)"spaced directory name/aa/lib.xml", (String)URIUtil.getRelativePath((String)"D://", (String)"D://spaced directory name//aa//lib.xml"));
        URIUtilTest.assertEquals((String)"D:/spaced directory name/lib.xml", (String)URIUtil.getRelativePath((String)"C://", (String)"D://spaced directory name//lib.xml"));
        URIUtilTest.assertEquals((String)"test.library", (String)URIUtil.getRelativePath((String)"c:\\", (String)"c:\\test.library"));
    }

    public void testResolveAbsolutePath() {
        if (this.isWindowsPlatform()) {
            this.resolveAbsolutePathOnWindows();
        } else {
            this.resolveAbsolutePathOnUnix();
        }
        URIUtilTest.assertEquals((String)"bundleentry://385/fragments/new_library.rptlibrary", (String)URIUtil.resolveAbsolutePath((String)"bundleentry://385", (String)"/fragments/new_library.rptlibrary"));
        URIUtilTest.assertEquals((String)"bundleentry://385/fragments/new_library.rptlibrary", (String)URIUtil.resolveAbsolutePath((String)"bundleentry://385/", (String)"fragments/new_library.rptlibrary"));
        URIUtilTest.assertEquals((String)"bundleentry://385/fragments/new_library.rptlibrary", (String)URIUtil.resolveAbsolutePath((String)"bundleentry://385", (String)"fragments/new_library.rptlibrary"));
        URIUtilTest.assertEquals((String)"http://localhost:8080/c.rptdesign", (String)URIUtil.resolveAbsolutePath((String)"http://localhost:8080/rp/", (String)"../c.rptdesign"));
        URIUtilTest.assertEquals((String)"http://localhost:8080/../c.rptdesign", (String)URIUtil.resolveAbsolutePath((String)"http://localhost:8080", (String)"../c.rptdesign"));
        URIUtilTest.assertEquals((String)"http://sub", (String)URIUtil.resolveAbsolutePath((String)"http://server/path", (String)"http://sub"));
        URIUtilTest.assertEquals((String)"jndi://abc/../sub", (String)URIUtil.resolveAbsolutePath((String)"jndi://abc", (String)"../sub"));
        URIUtilTest.assertEquals((String)"jndi://abc/sub", (String)URIUtil.resolveAbsolutePath((String)"jndi://abc/test", (String)"../sub"));
        URIUtilTest.assertEquals((String)"jndi://sub", (String)URIUtil.resolveAbsolutePath((String)"jndi://abc", (String)"jndi://sub"));
    }

    private void resolveAbsolutePathOnUnix() {
        URIUtilTest.assertEquals((String)(String.valueOf(File.separator) + "birt" + File.separator + "sampleReports" + File.separator + "lib" + File.separator + "lib1.rptlibrary"), (String)URIUtil.resolveAbsolutePath((String)"/birt//sampleReports//reportdesigns//", (String)"../lib/lib1.rptlibrary"));
        String tmpAbsolutePath = URIUtil.resolveAbsolutePath((String)"./reportdesigns", (String)"./lib/lib1.rptlibrary");
        String tmpPath = String.valueOf(File.separator) + "reportdesigns" + File.separator + "lib" + File.separator + "lib1.rptlibrary";
        URIUtilTest.assertTrue((boolean)tmpAbsolutePath.endsWith(tmpPath));
    }

    private void resolveAbsolutePathOnWindows() {
        URIUtilTest.assertEquals((String)("C:" + File.separator + "birt" + File.separator + "sampleReports" + File.separator + "lib" + File.separator + "lib1.rptlibrary").toLowerCase(), (String)URIUtil.resolveAbsolutePath((String)"C://birt//sampleReports//reportdesigns//", (String)"..\\lib\\lib1.rptlibrary").toLowerCase());
        String filePath = "reportdesigns" + File.separator + "lib" + File.separator + "lib1.rptlibrary";
        URIUtilTest.assertEquals((String)new File(filePath).getAbsolutePath().toLowerCase(), (String)URIUtil.resolveAbsolutePath((String)".\\reportdesigns", (String)".\\lib\\lib1.rptlibrary").toLowerCase());
        URIUtilTest.assertEquals((String)("C:" + File.separator + "new_report_3.rptdocument").toLowerCase(), (String)URIUtil.resolveAbsolutePath((String)"./reportdesigns", (String)("C:" + File.separator + "new_report_3.rptdocument")).toLowerCase());
    }
}

