/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import junit.framework.TestCase;
import org.eclipse.birt.data.aggregation.impl.BuildInAggregationFactory;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;

public class FinanceTest
extends TestCase {
    private BuildInAggregationFactory buildInAggrFactory = new BuildInAggregationFactory();

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIrr() throws Exception {
        double[] b = new double[]{-70000.0, 12000.0, 15000.0, 18000.0, 21000.0, 26000.0};
        double[] a = new double[]{-70000.0, 12000.0, 15000.0};
        double[] c = new double[]{-70000.0, 12000.0, 15000.0, 18000.0, 21000.0};
        double[] d = new double[]{-70000.0, 22000.0, 25000.0, 30000.0, 31000.0};
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("irr");
        Accumulator ac = ag.newAccumulator();
        FinanceTest.assertEquals((String)"IRR", (String)ag.getName());
        FinanceTest.assertEquals((int)0, (int)ag.getType());
        FinanceTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        FinanceTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        FinanceTest.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < b.length) {
            ac.onRow(new Object[]{new Double(b[i]), new Double(0.1)});
            ++i;
        }
        ac.finish();
        FinanceTest.assertEquals((double)0.0866, (double)((Double)ac.getValue()), (double)1.0E-4);
        ac.start();
        i = 0;
        while (i < a.length) {
            ac.onRow(new Object[]{new Double(a[i]), new Double(-0.6)});
            ++i;
        }
        ac.finish();
        FinanceTest.assertEquals((double)-0.44, (double)((Double)ac.getValue()), (double)0.01);
        ac.start();
        i = 0;
        while (i < a.length) {
            ac.onRow(new Object[]{new Double(a[i]), new Double(2.3)});
            ++i;
        }
        ac.finish();
        FinanceTest.assertEquals((Object)Double.NaN, (Object)((Double)ac.getValue()));
        ac.start();
        i = 0;
        while (i < c.length) {
            ac.onRow(new Object[]{new Double(c[i]), new Double(-0.1)});
            ++i;
        }
        ac.finish();
        FinanceTest.assertEquals((double)-0.021244, (double)((Double)ac.getValue()), (double)1.0E-6);
        ac.start();
        i = 0;
        while (i < d.length) {
            ac.onRow(new Object[]{new Double(d[i]), new Double(0.05)});
            ++i;
        }
        ac.finish();
        FinanceTest.assertEquals((double)0.19, (double)((Double)ac.getValue()), (double)0.01);
        ac.start();
        ac.finish();
        FinanceTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            FinanceTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            FinanceTest.assertTrue((boolean)true);
        }
    }

    public void testMirr() throws Exception {
        double[] a = new double[]{-120000.0, 39000.0, 30000.0, 21000.0, 37000.0, 46000.0};
        double[] b = new double[]{-120000.0, 39000.0, 30000.0, 21000.0};
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("mirr");
        Accumulator ac = ag.newAccumulator();
        FinanceTest.assertEquals((String)"MIRR", (String)ag.getName());
        FinanceTest.assertEquals((int)0, (int)ag.getType());
        FinanceTest.assertEquals((int)3, (int)ag.getParameterDefn().length);
        FinanceTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        FinanceTest.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        FinanceTest.assertTrue((!ag.getParameterDefn()[2].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < a.length) {
            ac.onRow(new Object[]{new Double(a[i]), new Double(0.1), new Double(0.14)});
            ++i;
        }
        ac.finish();
        FinanceTest.assertEquals((double)0.13475911082831482, (double)((Double)ac.getValue()), (double)Double.MIN_VALUE);
        ac.start();
        i = 0;
        while (i < b.length) {
            ac.onRow(new Object[]{new Double(b[i]), new Double(0.1), new Double(0.12)});
            ++i;
        }
        ac.finish();
        FinanceTest.assertEquals((double)-0.048044655249980806, (double)((Double)ac.getValue()), (double)Double.MIN_VALUE);
        ac.start();
        ac.finish();
        FinanceTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            FinanceTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            FinanceTest.assertTrue((boolean)true);
        }
    }

    public void testNpv() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("npv");
        Accumulator ac = ag.newAccumulator();
        FinanceTest.assertEquals((String)"NPV", (String)ag.getName());
        FinanceTest.assertEquals((int)0, (int)ag.getType());
        FinanceTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        FinanceTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        FinanceTest.assertFalse((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        double[] a = new double[]{-10000.0, 3000.0, 4200.0, 6800.0};
        ac.start();
        int i = 0;
        while (i < a.length) {
            ac.onRow(new Object[]{new Double(a[i]), new Double(0.1)});
            ++i;
        }
        ac.finish();
        FinanceTest.assertEquals((double)1188.4434123352207, (double)((Double)ac.getValue()), (double)Double.MIN_VALUE);
        ac.start();
        ac.finish();
        FinanceTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            FinanceTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            FinanceTest.assertTrue((boolean)true);
        }
    }

    public void testRunningNpv() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("runningnpv");
        Accumulator ac = ag.newAccumulator();
        FinanceTest.assertEquals((String)"RUNNINGNPV", (String)ag.getName());
        FinanceTest.assertEquals((int)1, (int)ag.getType());
        FinanceTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        FinanceTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        FinanceTest.assertFalse((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        double[] a = new double[]{-10000.0, 3000.0, 4200.0, 6800.0};
        double[] b = new double[]{-9090.90909090909, -6611.570247933883, -3456.0480841472577, 1188.4434123352207};
        ac.start();
        int i = 0;
        while (i < a.length) {
            ac.onRow(new Object[]{new Double(a[i]), new Double(0.1), new Double(0.14)});
            FinanceTest.assertEquals((double)b[i], (double)((Double)ac.getValue()), (double)Double.MIN_VALUE);
            ++i;
        }
        ac.finish();
        ac.start();
        ac.finish();
        FinanceTest.assertEquals(null, (Object)ac.getValue());
    }
}

