/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashSet;
import junit.framework.TestCase;
import org.eclipse.birt.data.aggregation.impl.BuildInAggregationFactory;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalTest
extends TestCase {
    private double[] weight = new double[]{1.2, 1.4, 2.0, 0.5, 1.4, 2.4, 1.5, 2.5, 3.7, 1.4, 1.03, 0.5, 0.2, 0.6, 1.3, 1.5, 12.4};
    private double[] doubleArray1 = new double[]{1.0, 3.0, 5.0, 4.0, 6.0, 8.0, 3.0, 4.0, 5.0, 7.0, 9.0, 10.0, 4.0, 6.0, 7.0};
    private boolean[] doubleArray1TopBottom;
    private double[] doubleArray2;
    private Double[] doubleArray3;
    private boolean[] doubleArray3TopBottom;
    private int[] doubleArray3RankDec;
    private int[] doubleArray3RankAsc;
    private int[] doubleArray3PercentRank;
    private Object[] doubleArray3PercentSum;
    private String[] str1;
    private String[] str3;
    private double[] doubleArray4;
    private double[] doubleArray5;
    private double[] doubleArray6;
    private Object[] anyObjectArray;
    private Object[] anyObjectArray2;
    private Date[] dates;
    private Date[] dates2;
    private String[] str2;
    private String[] str4;
    private BigDecimal[] bigDecimalArray;
    private int[] bigDecimalRankAsc;
    private int[] bigDecimalPercentRank;
    private int[] bigDecimalPercentSum;
    private BuildInAggregationFactory buildInAggrFactory;

    public TotalTest() {
        boolean[] blArray = new boolean[15];
        blArray[5] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[14] = true;
        this.doubleArray1TopBottom = blArray;
        this.doubleArray2 = new double[]{4.0, -43.0, 4.0, 23.0, -15.0, -6.0, 4.0, -6.0, 3.0, 63.0, 33.0, -6.0, -23.0, 34.0};
        Double[] doubleArray = new Double[8];
        doubleArray[0] = Double.valueOf("100");
        doubleArray[1] = Double.valueOf("20");
        doubleArray[3] = Double.valueOf("300");
        doubleArray[5] = Double.valueOf("40");
        doubleArray[6] = Double.valueOf("10");
        doubleArray[7] = Double.valueOf("10");
        this.doubleArray3 = doubleArray;
        boolean[] blArray2 = new boolean[8];
        blArray2[0] = true;
        blArray2[3] = true;
        this.doubleArray3TopBottom = blArray2;
        this.doubleArray3RankDec = new int[]{2, 4, 7, 1, 7, 3, 5, 5};
        this.doubleArray3RankAsc = new int[]{7, 5, 1, 8, 1, 6, 3, 3};
        int[] nArray = new int[8];
        nArray[0] = 857;
        nArray[1] = 571;
        nArray[3] = 1000;
        nArray[5] = 714;
        nArray[6] = 285;
        nArray[7] = 285;
        this.doubleArray3PercentRank = nArray;
        Object[] objectArray = new Object[8];
        objectArray[0] = new Integer(208);
        objectArray[1] = new Integer(41);
        objectArray[3] = new Integer(625);
        objectArray[5] = new Integer(83);
        objectArray[6] = new Integer(20);
        objectArray[7] = new Integer(20);
        this.doubleArray3PercentSum = objectArray;
        this.str1 = new String[]{"4", "-43", "4", "23", "-15", "-6", "4", "-6", "3", "63", "33", "-6", "-23", "34"};
        this.str3 = new String[]{"4", "-43", "4o", "23", "-15", "-6", "4", "-6", "3", "63", "33", "-6", "-23", "34"};
        this.doubleArray4 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        this.doubleArray5 = new double[]{1.0, 2.0, 2.0, 3.0, 1.0, 3.0, 4.0, 1.0, 2.0};
        this.doubleArray6 = new double[]{1.0, 2.0, 2.0, 3.0, 1.0, 3.0, 4.0, 2.0, 1.0};
        Object[] objectArray2 = new Object[8];
        objectArray2[0] = "aa";
        objectArray2[1] = "bb";
        objectArray2[3] = new Integer(0);
        objectArray2[5] = new Double(1.0);
        objectArray2[6] = new Float(0.0f);
        this.anyObjectArray = objectArray2;
        Object[] objectArray3 = new Object[10];
        objectArray3[0] = "aa";
        objectArray3[1] = "bb";
        objectArray3[3] = new Integer(0);
        objectArray3[5] = new Double(1.0);
        objectArray3[6] = new Float(0.0f);
        objectArray3[8] = false;
        objectArray3[9] = new Date(1000000L);
        this.anyObjectArray2 = objectArray3;
        this.dates = new Date[]{new Date(1000000L), new Date(2000000L), new Date(3000000L), new Date(4000000L)};
        this.dates2 = new Date[]{new Date(1000000L), new Date(2000000L), new Date(2000000L), new Date(3000000L), new Date(4000000L)};
        this.str2 = new String[]{"test", "string", "array", "for", "aggregation"};
        this.str4 = new String[]{"test", "string", "array", "for", "aggregation", "test", "string", "array", "for", "aggregation"};
        this.bigDecimalArray = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("3"), new BigDecimal("5"), new BigDecimal("4"), new BigDecimal("6"), new BigDecimal("8"), new BigDecimal("3"), new BigDecimal("4"), new BigDecimal("5"), new BigDecimal("7"), new BigDecimal("9"), new BigDecimal("10"), new BigDecimal("4"), new BigDecimal("6"), new BigDecimal("7")};
        this.bigDecimalRankAsc = new int[]{1, 2, 7, 4, 9, 13, 2, 4, 7, 11, 14, 15, 4, 9, 11};
        int[] nArray2 = new int[15];
        nArray2[1] = 71;
        nArray2[2] = 428;
        nArray2[3] = 214;
        nArray2[4] = 571;
        nArray2[5] = 857;
        nArray2[6] = 71;
        nArray2[7] = 214;
        nArray2[8] = 428;
        nArray2[9] = 714;
        nArray2[10] = 928;
        nArray2[11] = 1000;
        nArray2[12] = 214;
        nArray2[13] = 571;
        nArray2[14] = 714;
        this.bigDecimalPercentRank = nArray2;
        this.bigDecimalPercentSum = new int[]{12, 36, 60, 48, 73, 97, 36, 48, 60, 85, 109, 121, 48, 73, 85};
        this.buildInAggrFactory = new BuildInAggregationFactory();
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testTotalConcatenate() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("concatenate");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"CONCATENATE", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)4, (int)ag.getParameterDefn().length);
        String separator = "-";
        String result = "";
        ac.start();
        int i = 0;
        while (i < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i];
            objectArray[1] = separator;
            ac.onRow(objectArray);
            result = String.valueOf(result) + this.str2[i];
            result = String.valueOf(result) + separator;
            ++i;
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - separator.length());
        }
        ac.finish();
        TotalTest.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str4.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str4[i];
            objectArray[1] = separator;
            ac.onRow(objectArray);
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        boolean exceedsMaxLength = false;
        int i2 = 0;
        while (i2 < this.str4.length) {
            ac.onRow(new Object[]{this.str4[i2], separator, 50, true});
            if (exceedsMaxLength || result.getBytes().length > 50 - this.str4[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = String.valueOf(result) + this.str4[i2];
                result = String.valueOf(result) + separator;
            }
            ++i2;
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - separator.length());
        }
        ac.finish();
        TotalTest.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || result.getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = String.valueOf(result) + this.str2[i2];
                result = String.valueOf(result) + separator;
            }
            ++i2;
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - separator.length());
        }
        ac.finish();
        TotalTest.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = ";  ";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || result.getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = String.valueOf(result) + this.str2[i2];
                result = String.valueOf(result) + separator;
            }
            ++i2;
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - separator.length());
        }
        ac.finish();
        TotalTest.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = "\n";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || result.getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = String.valueOf(result) + this.str2[i2];
                result = String.valueOf(result) + separator;
            }
            ++i2;
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - separator.length());
        }
        ac.finish();
        TotalTest.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = "\t";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || result.getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = String.valueOf(result) + this.str2[i2];
                result = String.valueOf(result) + separator;
            }
            ++i2;
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - separator.length());
        }
        ac.finish();
        TotalTest.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = "   ";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || result.getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = String.valueOf(result) + this.str2[i2];
                result = String.valueOf(result) + separator;
            }
            ++i2;
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - separator.length());
        }
        ac.finish();
        TotalTest.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = ",,, ";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || result.getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = String.valueOf(result) + this.str2[i2];
                result = String.valueOf(result) + separator;
            }
            ++i2;
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - separator.length());
        }
        ac.finish();
        TotalTest.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = "#";
        exceedsMaxLength = false;
        LinkedHashSet<String> objects = new LinkedHashSet<String>();
        int i3 = 0;
        while (i3 < this.anyObjectArray2.length) {
            if (this.anyObjectArray2[i3] != null) {
                objects.add(this.anyObjectArray2[i3].toString());
            }
            ++i3;
        }
        for (String value : objects) {
            ac.onRow(new Object[]{value, separator, 30, false});
            if (value == null) continue;
            if (exceedsMaxLength || result.getBytes().length > 30 - value.length()) {
                exceedsMaxLength = true;
                continue;
            }
            result = String.valueOf(result) + value;
            result = String.valueOf(result) + separator;
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - separator.length());
        }
        ac.finish();
        TotalTest.assertEquals((Object)result, (Object)ac.getValue());
    }

    public void testTotalCount() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("count");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"COUNT", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        ac.start();
        int i = 0;
        while (i < this.anyObjectArray.length) {
            ac.onRow(new Object[]{this.anyObjectArray[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Integer(5), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.anyObjectArray.length) {
            ac.onRow(null);
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Integer(8), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow(new Object[0]);
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Integer(15), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow(new Object[0]);
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Integer(14), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[0]);
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Integer(14), (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals((Object)new Integer(0), (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
    }

    public void testTotalSum() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("sum");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"SUM", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(82.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(69.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(69.0), (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.start();
        try {
            i = 0;
            while (i < this.str2.length) {
                ac.onRow(new Object[]{this.str2[i]});
                ++i;
            }
            TotalTest.fail();
        }
        catch (DataException dataException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new BigDecimal("82.0"), (Object)ac.getValue());
    }

    public void testTotalRunningSum() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("RUNNINGSUM");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"RUNNINGSUM", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        double sum = 0.0;
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i])});
            TotalTest.assertEquals((Object)new Double(sum += this.doubleArray1[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        sum = 0.0;
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i])});
            TotalTest.assertEquals((Object)new Double(sum += this.doubleArray2[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        sum = 0.0;
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            TotalTest.assertEquals((Object)new Double(sum += new Double(this.str1[i]).doubleValue()), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        sum = 0.0;
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        BigDecimal bigSum = BigDecimal.ZERO;
        ac.start();
        int i2 = 0;
        while (i2 < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i2]});
            bigSum = bigSum.add(this.bigDecimalArray[i2]);
            Object ret = ac.getValue();
            TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
            TotalTest.assertTrue((bigSum.compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
            ++i2;
        }
        ac.finish();
    }

    public void testTotalAve() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("ave");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"AVE", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(5.466666666666667), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(4.928571428571429), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(4.928571428571429), (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal("5.466666666666666666666666666666667").compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalFirst() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("first");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"FIRST", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(1.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(4.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)"4", (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal(1).compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalLast() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("last");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"LAST", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(7.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(34.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)"34", (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal(7).compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalMax() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("max");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"MAX", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(10.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(63.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)"63", (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal(10).compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalMin() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("min");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"MIN", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(1.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(-43.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)"-15", (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal(1).compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalMedian() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("median");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"MEDIAN", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(5.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(3.5), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(3.5), (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.dates.length) {
            ac.onRow(new Object[]{this.dates[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)ac.getValue(), (Object)new Date(2500000L));
        ac.start();
        i = 0;
        while (i < this.dates2.length) {
            ac.onRow(new Object[]{this.dates2[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)ac.getValue(), (Object)new Date(2000000L));
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal(5).compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalMode() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("mode");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"MODE", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(4.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(4.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray4.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray4[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray5.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray5[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(1.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray6.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray6[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(1.0), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(4.0), (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.start();
        ac.onRow((Object[])new Double[]{new Double(4.0)});
        ac.onRow((Object[])new Double[]{new Double(4.0)});
        ac.onRow((Object[])new Double[]{new Double(3.0)});
        ac.finish();
        TotalTest.assertEquals((Object)ac.getValue(), (Object)new Double(4.0));
        ac.start();
        i = 0;
        while (i < this.dates.length) {
            ac.onRow(new Object[]{this.dates[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)ac.getValue(), null);
        ac.start();
        i = 0;
        while (i < this.dates2.length) {
            ac.onRow(new Object[]{this.dates2[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)ac.getValue(), (Object)new Date(2000000L));
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal(4).compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalStdDev() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("stddev");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"STDDEV", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(2.445598573141631), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(26.560422510872147), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(26.560422510872147), (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal("2.445598573141631").compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalVariance() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("variance");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"VARIANCE", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(5.980952380952381), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(705.4560439560439), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(705.4560439560439), (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal("5.980952380952380952380952380952381").compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalWeightedAva() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("weightedAve");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"WEIGHTEDAVE", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i]), new Double(this.weight[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(5.343042071197409), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray2[i]), new Double(this.weight[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(3.236104279390063), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i], new Double(this.weight[i])});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Double(3.236104279390063), (Object)ac.getValue());
        ac.start();
        ac.onRow(new Object[]{new Double(1.0), new Double(1.0)});
        ac.onRow(new Object[]{new Double(2.0), new Double(2.0)});
        ac.finish();
        TotalTest.assertEquals((Object)new Double(1.6666666666666667), (Object)ac.getValue());
        ac.start();
        Object[] objectArray = new Object[2];
        objectArray[1] = new Double(3.0);
        ac.onRow(objectArray);
        ac.onRow(new Object[]{new Double(2.0), new Double(2.0)});
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = new Double(2.0);
        ac.onRow(objectArray2);
        ac.finish();
        TotalTest.assertEquals((Object)new Double(2.0), (Object)ac.getValue());
        ac.start();
        ac.onRow(new Object[]{new Double(1.0), new Double(3.0)});
        ac.onRow(new Object[]{new Double(1.0), new Double(-3.0)});
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        ac.onRow(new Object[]{new Double(1.0), new Double(2.0)});
        ac.onRow(new Object[]{new Double(2.0), new Double(-4.0)});
        ac.finish();
        TotalTest.assertEquals((Object)new Double(3.0), (Object)ac.getValue());
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            TotalTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {
            TotalTest.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], new Double(this.weight[i])});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal("5.343042071197411003236245954692557").compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalMovingAve() throws Exception {
        double[] values1 = new double[]{1.0, 2.0, 3.0, 3.25, 3.8, 4.5, 4.285714285714286, 4.25, 4.75, 5.25, 5.75, 6.5, 6.25, 6.0, 6.5};
        double[] values2 = new double[]{4.0, -19.5, -11.666666666666666, -3.0, -5.4, -5.5, -5.5, 0.6666666666666666, 0.5, 7.166666666666667, 15.166666666666666, 15.166666666666666, 10.666666666666666, 17.333333333333332};
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("movingAve");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"MOVINGAVE", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow(new Object[]{new Double(this.doubleArray1[i]), new Integer(8)});
            TotalTest.assertEquals((Object)new Double(values1[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow(new Object[]{new Double(this.doubleArray2[i]), new Integer(6)});
            TotalTest.assertEquals((Object)new Double(values2[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i], new Integer(6)});
            TotalTest.assertEquals((Object)new Double(values2[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac.start();
        ac.finish();
        TotalTest.assertEquals(null, (Object)ac.getValue());
        BigDecimal[] expectResults = new BigDecimal[]{new BigDecimal("1.0"), new BigDecimal("2.0"), new BigDecimal("3.0"), new BigDecimal("3.25"), new BigDecimal("3.8"), new BigDecimal("4.5"), new BigDecimal("4.285714285714285714285714285714286"), new BigDecimal("4.25"), new BigDecimal("4.75"), new BigDecimal("5.25"), new BigDecimal("5.75"), new BigDecimal("6.5"), new BigDecimal("6.25"), new BigDecimal("6.0"), new BigDecimal("6.5")};
        ac.start();
        int i2 = 0;
        while (i2 < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i2], 8});
            Object ret = ac.getValue();
            TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
            TotalTest.assertTrue((expectResults[i2].compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
            ++i2;
        }
        ac.finish();
    }

    public void testTotalAveDate() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("ave");
        Accumulator ac = ag.newAccumulator();
        ac.start();
        int i = 0;
        while (i < this.dates.length) {
            ac.onRow(new Object[]{this.dates[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Date(2500000L), (Object)ac.getValue());
    }

    public void testTotalMaxDate() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("max");
        Accumulator ac = ag.newAccumulator();
        ac.start();
        int i = 0;
        while (i < this.dates.length) {
            ac.onRow(new Object[]{this.dates[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Date(4000000L), (Object)ac.getValue());
    }

    public void testTotalMinDate() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("min");
        Accumulator ac = ag.newAccumulator();
        ac.start();
        int i = 0;
        while (i < this.dates.length) {
            ac.onRow(new Object[]{this.dates[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Date(1000000L), (Object)ac.getValue());
    }

    public void testTotalMaxString() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("max");
        Accumulator ac = ag.newAccumulator();
        ac.start();
        int i = 0;
        while (i < this.str2.length) {
            ac.onRow(new Object[]{this.str2[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)"test", (Object)ac.getValue());
    }

    public void testTotalMinString() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("min");
        Accumulator ac = ag.newAccumulator();
        ac.start();
        int i = 0;
        while (i < this.str2.length) {
            ac.onRow(new Object[]{this.str2[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)"aggregation", (Object)ac.getValue());
    }

    public void testTotalTop() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("isTopN");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"ISTOPN", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i]), new Double(5.0)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i]), new Double(5.0)});
            TotalTest.assertEquals((Object)new Boolean(this.doubleArray1TopBottom[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ag = this.buildInAggrFactory.getAggregation("isTopN");
        ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"ISTOPN", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        ac.onRow((Object[])new Double[]{new Double(6.0), new Double(5.0)});
        ac.finish();
        ac.start();
        ac.onRow((Object[])new Double[]{new Double(6.0), new Double(5.0)});
        ac.finish();
        TotalTest.assertEquals((Object)new Boolean(true), (Object)ac.getValue());
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], new Double(5.0)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], new Double(5.0)});
            TotalTest.assertEquals((Object)new Boolean(this.doubleArray1TopBottom[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ag = this.buildInAggrFactory.getAggregation("isTopNPercent");
        ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"ISTOPNPERCENT", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i]), new Double(33.0)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i]), new Double(33.0)});
            TotalTest.assertEquals((Object)new Boolean(this.doubleArray1TopBottom[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], new Double(33.0)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], new Double(33.0)});
            TotalTest.assertEquals((Object)new Boolean(this.doubleArray1TopBottom[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ag = this.buildInAggrFactory.getAggregation("isTopNPercent");
        ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"ISTOPNPERCENT", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        ac.onRow((Object[])new Double[]{new Double(6.0), new Double(100.0)});
        ac.finish();
        ac.start();
        ac.onRow((Object[])new Double[]{new Double(6.0), new Double(100.0)});
        ac.finish();
        TotalTest.assertEquals((Object)new Boolean(true), (Object)ac.getValue());
    }

    public void testTotalTop2() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("isTopN");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"ISTOPN", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray3[i], new Double(2.0)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray3[i], new Double(2.0)});
            TotalTest.assertEquals((Object)new Boolean(this.doubleArray3TopBottom[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
    }

    public void testTotalBottom() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("isBottomN");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"ISBOTTOMN", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i]), new Double(10.0)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i]), new Double(10.0)});
            TotalTest.assertEquals((Object)new Boolean(!this.doubleArray1TopBottom[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], new Double(10.0)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], new Double(10.0)});
            TotalTest.assertEquals((Object)new Boolean(!this.doubleArray1TopBottom[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ag = this.buildInAggrFactory.getAggregation("isBottomNPercent");
        ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"ISBOTTOMNPERCENT", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i]), new Double(66.0)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i]), new Double(66.0)});
            TotalTest.assertEquals((Object)new Boolean(!this.doubleArray1TopBottom[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], new Double(66.0)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], new Double(66.0)});
            TotalTest.assertEquals((Object)new Boolean(!this.doubleArray1TopBottom[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
    }

    public void testTotalRank() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("rank");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"RANK", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertFalse((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], new Boolean(false)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], new Integer(0)});
            TotalTest.assertEquals((Object)new Integer(this.doubleArray3RankDec[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ag = this.buildInAggrFactory.getAggregation("rank");
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], new Boolean(true)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], new Integer(1)});
            TotalTest.assertEquals((Object)new Integer(this.doubleArray3RankAsc[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], new Boolean(true)});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], new Double(0.0)});
            TotalTest.assertEquals((Object)new Integer(this.bigDecimalRankAsc[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
    }

    public void testTotalPercentRank() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("percentrank");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"PERCENTRANK", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i]});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i]});
            TotalTest.assertEquals((int)this.doubleArray3PercentRank[i], (int)new Double((Double)ac.getValue() * 1000.0).intValue());
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            TotalTest.assertEquals((int)this.bigDecimalPercentRank[i], (int)new Double((Double)ac.getValue() * 1000.0).intValue());
            ++i;
        }
        ac.finish();
    }

    public void testTotalPercentSum() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("percentsum");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"PERCENTSUM", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i]});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i]});
            TotalTest.assertEquals((Object)(this.doubleArray3PercentSum[i] == null ? new Integer(0) : this.doubleArray3PercentSum[i]), (Object)new Integer((int)(new Double(ac.getValue().toString()) * 1000.0)));
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.str2.length) {
            try {
                ac.onRow(new Object[]{this.str2[i]});
                TotalTest.fail();
            }
            catch (DataException dataException) {}
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            Object ret = ac.getValue();
            TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
            TotalTest.assertEquals((int)this.bigDecimalPercentSum[i], (int)new Double(((Number)ret).doubleValue() * 1000.0).intValue());
            ++i;
        }
        ac.finish();
    }

    public void testTotalPercentile() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("percentile");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"PERCENTILE", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertFalse((boolean)ag.getParameterDefn()[1].isOptional());
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], new Double(0.1)});
            ++i;
        }
        ac.finish();
        Object value = ac.getValue();
        TotalTest.assertEquals((Object)value, (Object)new Double(10.0));
        ac.start();
        int i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], new Double(0.0)});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        TotalTest.assertEquals((Object)value, (Object)new Double(10.0));
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], new Double(1.0)});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        TotalTest.assertEquals((Object)value, (Object)new Double(300.0));
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], new Double(0.7)});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        TotalTest.assertEquals((Object)value, (Object)new Double(70.0));
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], new Double(0.35)});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        TotalTest.assertEquals((Object)value, (Object)new Double(17.5));
        try {
            ac.start();
            i2 = 0;
            while (i2 < this.doubleArray3.length) {
                ac.onRow(new Object[]{this.doubleArray3[i2], new Double(-1.0)});
                ++i2;
            }
            ac.finish();
            TotalTest.fail((String)"should not arrive here");
        }
        catch (DataException dataException) {}
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            try {
                ac.onRow(new Object[]{this.doubleArray3[i2], new Double(-0.9)});
                TotalTest.fail();
            }
            catch (DataException dataException) {}
            try {
                ac.onRow(new Object[]{this.doubleArray3[i2], new Double(4.1)});
                TotalTest.fail();
            }
            catch (DataException dataException) {}
            ++i2;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i2 = 0;
        while (i2 < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i2], new Double(0.1)});
            ++i2;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal("3.0").compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalQuartile() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("quartile");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"QUARTILE", (String)ag.getName());
        TotalTest.assertEquals((int)0, (int)ag.getType());
        TotalTest.assertEquals((int)2, (int)ag.getParameterDefn().length);
        TotalTest.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        TotalTest.assertFalse((boolean)ag.getParameterDefn()[1].isOptional());
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], new Double(0.0)});
            ++i;
        }
        ac.finish();
        Object value = ac.getValue();
        TotalTest.assertEquals((Object)value, (Object)new Double(10.0));
        ac.start();
        int i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], new Double(1.0)});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        TotalTest.assertEquals((Object)value, (Object)new Double(12.5));
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], new Double(2.0)});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        TotalTest.assertEquals((Object)value, (Object)new Double(30.0));
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], new Double(3.0)});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        TotalTest.assertEquals((Object)value, (Object)new Double(85.0));
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], new Double(4.0)});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        TotalTest.assertEquals((Object)value, (Object)new Double(300.0));
        try {
            ac.start();
            i2 = 0;
            while (i2 < this.doubleArray3.length) {
                ac.onRow(new Object[]{this.doubleArray3[i2], new Double(5.0)});
                ++i2;
            }
            ac.finish();
            TotalTest.fail((String)"should not arrive here");
        }
        catch (DataException dataException) {}
        ac = ag.newAccumulator();
        ac.start();
        i2 = 0;
        while (i2 < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i2], new Double(1.0)});
            ++i2;
        }
        ac.finish();
        Object ret = ac.getValue();
        TotalTest.assertTrue((boolean)(ret instanceof BigDecimal));
        TotalTest.assertTrue((new BigDecimal("4.0").compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    public void testTotalRunningCount() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("runningcount");
        Accumulator ac = ag.newAccumulator();
        TotalTest.assertEquals((String)"RUNNINGCOUNT", (String)ag.getName());
        TotalTest.assertEquals((int)1, (int)ag.getType());
        TotalTest.assertEquals((int)1, (int)ag.getParameterDefn().length);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{new Double(this.doubleArray1[i]), new Double(5.0)});
            TotalTest.assertEquals((Object)new Integer(i + 1), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.anyObjectArray.length) {
            ac.onRow(new Object[]{this.anyObjectArray[i]});
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Integer(5), (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.anyObjectArray.length) {
            ac.onRow(null);
            ++i;
        }
        ac.finish();
        TotalTest.assertEquals((Object)new Integer(8), (Object)ac.getValue());
    }
}

