/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.binding.APITestCase;
import testutil.ConfigText;

public class ColumnHintTest
extends APITestCase {
    private String tableCalls;
    private String tableCustomer;

    protected void setUp() throws Exception {
        super.setUp();
        this.prepareDataSet(new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestDataCalls.TableName"), ConfigText.getString("Api.TestDataCalls.TableSQL"), ConfigText.getString("Api.TestDataCalls.TestDataFileName")));
        this.tableCalls = ConfigText.getString("Api.TestDataCalls.TableName");
        this.tableCustomer = ConfigText.getString("Api.TestDataCustomer.TableName");
    }

    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestDataCustomer.TableName"), ConfigText.getString("Api.TestDataCustomer.TableSQL"), ConfigText.getString("Api.TestDataCustomer.TestDataFileName"));
    }

    public void testDuplicateColName() throws Exception {
        String testSQL = "select " + this.tableCalls + ".CustomerID, " + this.tableCustomer + ".CustomerID, Charge from " + this.tableCalls + ", " + this.tableCustomer;
        ((OdaDataSetDesign)this.dataSet).setQueryText(testSQL);
        ColumnDefinition colDef = new ColumnDefinition("CUSTOMERID_2");
        colDef.setAlias("a");
        colDef.setDataType(0);
        colDef.setExportHint(2);
        colDef.setColumnPosition(2);
        colDef.setSearchHint(1);
        this.dataSet.addResultSetHint((IColumnDefinition)colDef);
        String[] bindingNameRow = new String[]{"ROW_CUSTOMERID", "ROW_CUSTOMERID_2", "ROW_A", "ROW_CHARGE"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.CUSTOMERID", 0), new ScriptExpression("dataSetRow.CUSTOMERID_2", 0), new ScriptExpression("dataSetRow.a", 0), new ScriptExpression("dataSetRow.CHARGE", 0)};
        QueryDefinition queryDefn = this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        this.outputQueryResult(this.executeQuery((IQueryDefinition)queryDefn), bindingNameRow);
        this.checkOutputFile();
    }
}

