/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import testutil.ConfigText;

public class DistinctValueTest
extends APITestCase {
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Binding.TestData.TableName"), ConfigText.getString("Binding.TestData.TableSQL"), "testData3.txt");
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void testBasic() throws Exception {
        this.dataSet.setDistinctValue(true);
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1", "testColumn2", "testColumn3", "testColumn4", "testColumn5", "testColumn6"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        se[1] = new ScriptExpression("dataSetRow.CITY");
        se[2] = new ScriptExpression("dataSetRow.SALE_DATE");
        se[3] = new ScriptExpression("dataSetRow.AMOUNT");
        se[4] = new ScriptExpression("dataSetRow.ORDERED");
        se[5] = new ScriptExpression("dataSetRow.NULL_COLUMN");
        int i = 0;
        while (i < name.length) {
            queryDefn.addResultSetExpression(name[i], (IBaseExpression)se[i]);
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testQueryDistinct() throws Exception {
        this.dataSet.setDistinctValue(false);
        QueryDefinition queryDefn = this.newReportQuery();
        queryDefn.setDistinctValue(true);
        String[] name = new String[]{"testColumn1", "testColumn2", "testColumn3", "testColumn4", "testColumn5", "testColumn6"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        se[1] = new ScriptExpression("dataSetRow.CITY");
        se[2] = new ScriptExpression("dataSetRow.SALE_DATE");
        se[3] = new ScriptExpression("dataSetRow.AMOUNT");
        se[4] = new ScriptExpression("dataSetRow.ORDERED");
        se[5] = new ScriptExpression("dataSetRow.NULL_COLUMN");
        int i = 0;
        while (i < name.length) {
            queryDefn.addResultSetExpression(name[i], (IBaseExpression)se[i]);
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }
}

