/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.binding.APITestCase;
import testutil.ConfigText;

public class InputParameterTest
extends APITestCase {
    private static final String TEST_TABLE_NAME = ConfigText.getString("Api.TestData.TableName");

    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(TEST_TABLE_NAME, ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    protected String getTestTableName() {
        return TEST_TABLE_NAME;
    }

    public void test1() throws Exception {
        OdaDataSetDesign baseDataset = this.newDataSet("newDataSet", "select * from " + TEST_TABLE_NAME + " where AMOUNT > ?");
        ArrayList<ParameterDefinition> inputParamDefns = new ArrayList<ParameterDefinition>();
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 2);
        inputParamDefn.setInputMode(true);
        inputParamDefn.setPosition(1);
        inputParamDefn.setDefaultInputValue("0");
        inputParamDefns.add(inputParamDefn);
        ArrayList<InputParameterBinding> inputParamBindings = new ArrayList<InputParameterBinding>();
        InputParameterBinding paramBinding = new InputParameterBinding(1, (IBaseExpression)new ScriptExpression("100"));
        inputParamBindings.add(paramBinding);
        this.runQuery((IBaseDataSetDesign)baseDataset, inputParamDefns, inputParamBindings);
    }

    public void test2() throws Exception {
        OdaDataSetDesign baseDataset = this.newDataSet("newDataSet", "select * from " + TEST_TABLE_NAME + " where AMOUNT > ? and AMOUNT < ?");
        ArrayList<ParameterDefinition> inputParamDefns = new ArrayList<ParameterDefinition>();
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 2, true, false);
        inputParamDefn.setPosition(1);
        inputParamDefn.setDefaultInputValue("0");
        inputParamDefns.add(inputParamDefn);
        inputParamDefn = new ParameterDefinition("param2", 2, true, false);
        inputParamDefn.setPosition(2);
        inputParamDefn.setDefaultInputValue("0");
        inputParamDefns.add(inputParamDefn);
        ArrayList<InputParameterBinding> inputParamBindings = new ArrayList<InputParameterBinding>();
        InputParameterBinding paramBinding = new InputParameterBinding(1, (IBaseExpression)new ScriptExpression("'100'"));
        inputParamBindings.add(paramBinding);
        paramBinding = new InputParameterBinding("param2", (IBaseExpression)new ScriptExpression("100*70"));
        inputParamBindings.add(paramBinding);
        this.runQuery((IBaseDataSetDesign)baseDataset, inputParamDefns, inputParamBindings);
    }

    public void test3() throws Exception {
        OdaDataSetDesign baseDataset = this.newDataSet("newDataSet", "select * from " + TEST_TABLE_NAME + " where CITY<>? ");
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 5, true, false);
        inputParamDefn.setPosition(1);
        inputParamDefn.setDefaultInputValue("0");
        ArrayList<ParameterDefinition> inputParamDefns = new ArrayList<ParameterDefinition>();
        inputParamDefns.add(inputParamDefn);
        ArrayList<InputParameterBinding> inputParamBindings = new ArrayList<InputParameterBinding>();
        InputParameterBinding paramBinding = new InputParameterBinding(1, (IBaseExpression)new ScriptExpression("'Shanghai'"));
        inputParamBindings.add(paramBinding);
        this.runQuery((IBaseDataSetDesign)baseDataset, inputParamDefns, inputParamBindings);
    }

    public void test5() throws Exception {
        OdaDataSetDesign baseDataset = this.newDataSet("newDataSet", "select * from " + TEST_TABLE_NAME + " where AMOUNT > ?");
        ArrayList<ParameterDefinition> inputParamDefns = new ArrayList<ParameterDefinition>();
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 2);
        inputParamDefn.setInputMode(true);
        inputParamDefn.setPosition(1);
        inputParamDefns.add(inputParamDefn);
        ArrayList<InputParameterBinding> inputParamBindings = new ArrayList<InputParameterBinding>();
        InputParameterBinding paramBinding = new InputParameterBinding(1, (IBaseExpression)new ScriptExpression("100"));
        inputParamBindings.add(paramBinding);
        this.runQuery((IBaseDataSetDesign)baseDataset, inputParamDefns, inputParamBindings);
    }

    public void test6() throws Exception {
        OdaDataSetDesign baseDataset = this.newDataSet("newDataSet", "select * from " + TEST_TABLE_NAME + " where AMOUNT > ?");
        ArrayList<ParameterDefinition> inputParamDefns = new ArrayList<ParameterDefinition>();
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 2);
        inputParamDefn.setInputMode(true);
        inputParamDefn.setPosition(1);
        inputParamDefns.add(inputParamDefn);
        ArrayList<InputParameterBinding> inputParamBindingsOfDS = new ArrayList<InputParameterBinding>();
        InputParameterBinding paramBinding = new InputParameterBinding(1, (IBaseExpression)new ScriptExpression("400"));
        inputParamBindingsOfDS.add(paramBinding);
        this.runQuery((IBaseDataSetDesign)baseDataset, inputParamDefns, inputParamBindingsOfDS, null);
    }

    public void test7() throws Exception {
        OdaDataSetDesign baseDataset = this.newDataSet("newDataSet", "select * from " + TEST_TABLE_NAME + " where AMOUNT > ?");
        ArrayList<ParameterDefinition> inputParamDefns = new ArrayList<ParameterDefinition>();
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 2);
        inputParamDefn.setInputMode(true);
        inputParamDefn.setPosition(1);
        inputParamDefns.add(inputParamDefn);
        ArrayList<InputParameterBinding> inputParamBindingsOfQuery = new ArrayList<InputParameterBinding>();
        InputParameterBinding paramBinding = new InputParameterBinding(1, (IBaseExpression)new ScriptExpression("400"));
        inputParamBindingsOfQuery.add(paramBinding);
        ArrayList<InputParameterBinding> inputParamBindingsOfDS = new ArrayList<InputParameterBinding>();
        paramBinding = new InputParameterBinding(1, (IBaseExpression)new ScriptExpression("300"));
        inputParamBindingsOfDS.add(paramBinding);
        this.runQuery((IBaseDataSetDesign)baseDataset, inputParamDefns, inputParamBindingsOfDS, inputParamBindingsOfQuery);
    }

    public void test10() throws Exception {
        OdaDataSetDesign baseDataset = this.newDataSet("newDataSet", "select * from " + TEST_TABLE_NAME + " where AMOUNT > ?");
        ArrayList<ParameterDefinition> inputParamDefns = new ArrayList<ParameterDefinition>();
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 2);
        inputParamDefn.setInputMode(true);
        inputParamDefn.setPosition(1);
        inputParamDefn.setDefaultInputValue("400");
        inputParamDefns.add(inputParamDefn);
        this.runQuery((IBaseDataSetDesign)baseDataset, inputParamDefns, null);
    }

    public void testRegression103982() throws Exception {
        OdaDataSetDesign baseDataset = this.newDataSet("newDataSet", "select * from " + TEST_TABLE_NAME + " where SALE_DATE > ?");
        ArrayList<ParameterDefinition> inputParamDefns = new ArrayList<ParameterDefinition>();
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 6);
        inputParamDefn.setInputMode(true);
        inputParamDefn.setPosition(1);
        inputParamDefn.setDefaultInputValue("6/1/00 2:00 AM");
        inputParamDefns.add(inputParamDefn);
        this.runQuery((IBaseDataSetDesign)baseDataset, inputParamDefns, null);
    }

    private void runQuery(IBaseDataSetDesign dataSet, Collection inputParamDefns, Collection inputParamBindingsOfQuery) throws Exception {
        this.runQuery(dataSet, inputParamDefns, null, inputParamBindingsOfQuery);
    }

    private void runQuery(IBaseDataSetDesign dataSet, Collection inputParamDefns, Collection inputParamBindingsOfDS, Collection inputParamBindingsOfQuery) throws Exception {
        if (inputParamDefns != null) {
            for (ParameterDefinition paramDefn : inputParamDefns) {
                if (!paramDefn.isInputMode()) continue;
                ((OdaDataSetDesign)dataSet).addParameter((IParameterDefinition)paramDefn);
            }
        }
        if (inputParamBindingsOfDS != null) {
            for (IInputParameterBinding paramBinds : inputParamBindingsOfDS) {
                ((OdaDataSetDesign)dataSet).addInputParamBinding(paramBinds);
            }
        }
        this.createAndRunQuery(dataSet, inputParamBindingsOfQuery);
        this.checkOutputFile();
    }

    private void createAndRunQuery(IBaseDataSetDesign dataSet, Collection inputParamBindings) throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameSort = new String[]{"SORT_SALE_DATE"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.SALE_DATE")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setColumn("SORT_SALE_DATE");
        sortDefn[0].setSortDirection(1);
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUT"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0), new ScriptExpression("dataSetRow.AMOUNT", 0)};
        QueryDefinition queryDefn = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, bindingNameSort, bindingExprSort, sortDefn, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow);
        if (inputParamBindings != null) {
            for (InputParameterBinding inputParamBinding : inputParamBindings) {
                queryDefn.addInputParamBinding(inputParamBinding);
            }
        }
        queryDefn.setDataSetName(dataSet.getName());
        this.outputQueryResult(this.executeQuery((IQueryDefinition)queryDefn), bindingNameRow);
    }
}

