/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import testutil.ConfigText;

public class QueryCacheTest
extends APITestCase {
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Binding.TestData.TableName"), ConfigText.getString("Binding.TestData.TableSQL"), ConfigText.getString("Binding.TestData.TestDataFileName"));
    }

    public void testBasicCache() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        query.setAutoBinding(true);
        query.setCacheQueryResults(true);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        this.outputQueryResult(it, new String[]{"CITY", "AMOUNT"});
        this.checkOutputFile();
    }

    public void testBasicCache1() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        query.setAutoBinding(true);
        query.setCacheQueryResults(true);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        QueryCacheTest.assertEquals((Object)it.getValue("CITY"), (Object)"Beijing");
        QueryCacheTest.assertEquals((Object)it.getValue("AMOUNT"), (Object)7000);
        it.next();
        QueryCacheTest.assertEquals((Object)it.getValue("CITY"), (Object)"Beijing");
        QueryCacheTest.assertEquals((Object)it.getValue("AMOUNT"), (Object)7000);
        it.next();
        QueryCacheTest.assertEquals((Object)it.getValue("CITY"), (Object)"New York");
        QueryCacheTest.assertEquals((Object)it.getValue("AMOUNT"), (Object)100);
    }

    public void testCacheEmptyResultSet() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        query.setAutoBinding(true);
        query.setCacheQueryResults(true);
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("false")));
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        queryResults.getResultIterator().close();
    }

    public void testCacheEmptyResultSet1() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        query.setAutoBinding(true);
        query.setCacheQueryResults(true);
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("false")));
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        QueryCacheTest.assertEquals((Object)it.getValue("CITY"), null);
        QueryCacheTest.assertEquals((Object)it.getValue("AMOUNT"), null);
        QueryCacheTest.assertEquals((boolean)it.next(), (boolean)false);
    }

    public void testSubqueryCache() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        query.setAutoBinding(true);
        query.setCacheQueryResults(true);
        SubqueryDefinition sub = new SubqueryDefinition("test", (IBaseQueryDefinition)query);
        sub.setApplyOnGroupFlag(false);
        query.addSubquery(sub);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        IResultIterator it = queryResults.getResultIterator();
        while (it.next()) {
            it.getSecondaryIterator(new ScriptContext(), "test").close();
        }
        it.close();
        String id = queryResults.getID();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        newQuery.addSubquery(sub);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        while (it.next()) {
            IResultIterator subIt = it.getSecondaryIterator(new ScriptContext(), "test");
            while (subIt.next()) {
            }
            subIt.close();
        }
        it.close();
    }

    public void testUseDetailsCache() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        query.setAutoBinding(true);
        query.setCacheQueryResults(true);
        query.setUsesDetails(false);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        this.outputQueryResult(result.getResultIterator(), new String[]{"CITY", "AMOUNT"});
        this.checkOutputFile();
    }

    public void testSerializableJavaObjectCache() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        ScriptExpression se = new ScriptExpression("new java.lang.StringBuffer(\"ss\")");
        se.setDataType(11);
        Binding b = new Binding("serializable", (IBaseExpression)se);
        b.setDataType(11);
        query.addBinding((IBinding)b);
        query.setCacheQueryResults(true);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        it.getResultMetaData();
        int count = 0;
        while (it.next()) {
            Object value = it.getValue("serializable");
            QueryCacheTest.assertTrue((boolean)(value instanceof StringBuffer));
            QueryCacheTest.assertEquals((String)"ss", (String)value.toString());
            ++count;
        }
        QueryCacheTest.assertTrue((count > 0 ? 1 : 0) != 0);
        it.close();
    }

    public void testUnserializableJavaObjectCache() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        ScriptExpression se = new ScriptExpression("new java.lang.ThreadGroup(\"ss\")");
        se.setDataType(11);
        Binding b = new Binding("unserializable", (IBaseExpression)se);
        b.setDataType(11);
        query.addBinding((IBinding)b);
        query.setCacheQueryResults(true);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = null;
        try {
            it = queryResults.getResultIterator();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        QueryCacheTest.assertTrue((boolean)false);
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        it.getResultMetaData();
        int count = 0;
        while (it.next()) {
            it.getValue("unserializable");
            ++count;
        }
        QueryCacheTest.assertTrue((count > 0 ? 1 : 0) != 0);
        it.close();
    }
}

