/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding.newbinding;

import com.ibm.icu.util.TimeZone;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import testutil.ConfigText;

public class ColumnBindingTest
extends APITestCase {
    private TimeZone currentTimeZone = TimeZone.getDefault();
    private FileArchiveWriter archiveWriter;
    private FileArchiveReader archiveReader;
    private String[] rowExprName;
    private String[] totalExprName;
    private String queryResultID;
    private List expectedValue;
    private DataEngine myGenDataEngine;
    private DataEngine myPreDataEngine;
    private String subName = "subName";

    public void setUp() throws Exception {
        super.setUp();
        TimeZone.setDefault((TimeZone)TimeZone.getTimeZone((String)"GMT+0"));
    }

    public void tearDown() throws Exception {
        super.tearDown();
        TimeZone.setDefault((TimeZone)this.currentTimeZone);
    }

    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Binding.TestData.TableName"), ConfigText.getString("Binding.TestData.TableSQL"), ConfigText.getString("Binding.TestData.TestDataFileName"));
    }

    public void testBasic() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1", "testColumn2", "AMOUNT1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        se[1] = new ScriptExpression("dataSetRow.CITY");
        se[2] = new ScriptExpression("dataSetRow.AMOUNT");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testBasic1() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"AMOUNT1", "AMOUNT2"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.AMOUNT");
        se[0].setDataType(5);
        se[1] = new ScriptExpression("row.AMOUNT1");
        se[1].setDataType(-1);
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            ColumnBindingTest.assertTrue((boolean)(ri.getValue("AMOUNT2") instanceof String));
        }
    }

    public void testBasic2() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1", "testColumn2", "AMOUNT1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        se[1] = new ScriptExpression("row." + name[0]);
        se[2] = new ScriptExpression("dataSetRow.AMOUNT");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testBindingNameWithDoubleQuote() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"test\"Column1", "test\"Column2", "AMOUNT1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        se[1] = new ScriptExpression("row[\"test\\\"Column1\"]");
        se[2] = new ScriptExpression("dataSetRow.AMOUNT");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testFilterOnDataSet() throws Exception {
        ScriptExpression baseExpr = new ScriptExpression("row.AMOUNT > 100");
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)baseExpr);
        this.dataSet.addFilter((IFilterDefinition)filterDefn);
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1", "testColumn2", "AMOUNT1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        se[1] = new ScriptExpression("dataSetRow.CITY");
        se[2] = new ScriptExpression("dataSetRow.AMOUNT");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testFilterOnDateType() throws Exception {
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("row.SALE_DATE", 7, "'2004-05-01 00:00:00'", "'2004-06-05 00:00:00'"));
        this.dataSet.addFilter((IFilterDefinition)filterDefn);
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1", "testColumn2", "SALE_DATE"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        se[1] = new ScriptExpression("dataSetRow.CITY");
        se[2] = new ScriptExpression("dataSetRow.SALE_DATE");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testFilterOnDataSet2() throws Exception {
    }

    public void testComputedOnDataSet() throws Exception {
        ComputedColumn cc = new ComputedColumn("AMOUNT2", "row.AMOUNT*2");
        this.dataSet.addComputedColumn((IComputedColumn)cc);
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1", "testColumn2", "AMOUNT1", "AMOUNT2"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        se[1] = new ScriptExpression("dataSetRow.CITY");
        se[2] = new ScriptExpression("dataSetRow.AMOUNT");
        se[3] = new ScriptExpression("dataSetRow.AMOUNT2");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testComputedOnDataSet2() throws Exception {
    }

    public void testFilterOnTable() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1", "testColumn2", "AMOUNT1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        se[1] = new ScriptExpression("dataSetRow.CITY");
        se[2] = new ScriptExpression("dataSetRow.AMOUNT");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT1>100");
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)filterExpr);
        queryDefn.addFilter((IFilterDefinition)filterDefn);
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
    }

    public void testNoDataSet() throws Exception {
        String[] name = new String[]{"testColumn1", "testColumn2"};
        int[] dataType = new int[]{2, 3};
        ScriptExpression[] se = new ScriptExpression[]{new ScriptExpression("i=10", dataType[0]), new ScriptExpression("i=20", dataType[1])};
        this.basicTestNoDataSet(name, dataType, se);
        this.checkOutputFile();
    }

    public void testNoDataSet2() throws Exception {
        String[] name = new String[]{"testColumn1", "testColumn2"};
        int[] dataType = new int[2];
        ScriptExpression[] se = new ScriptExpression[]{new ScriptExpression("new Date()", dataType[0]), new ScriptExpression("row[\"testColumn1\"].getFullYear( )", dataType[1])};
        this.basicTestNoDataSet(name, dataType, se);
    }

    public void testNoDataSet3() throws Exception {
        String[] name = new String[]{"testColumn1"};
        int[] dataType = new int[]{6};
        ScriptExpression[] se = new ScriptExpression[]{new ScriptExpression("new Date()", dataType[0])};
        this.basicTestNoDataSet(name, dataType, se);
    }

    private void basicTestNoDataSet(String[] name, int[] dataType, ScriptExpression[] se) throws BirtException {
        DataEngineImpl dataEngine = new DataEngineImpl(DataEngineContext.newInstance((int)3, null, null, null));
        QueryDefinition queryDefn = new QueryDefinition();
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = dataEngine.prepare((IQueryDefinition)queryDefn).execute(null).getResultIterator();
        if (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                Object value = ri.getValue(name[i2]);
                str = String.valueOf(str) + value;
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                if (dataType[i2] == 2) {
                    ColumnBindingTest.assertTrue((boolean)value.getClass().equals(Integer.class));
                } else if (dataType[i2] == 3) {
                    ColumnBindingTest.assertTrue((boolean)value.getClass().equals(Double.class));
                } else if (dataType[i2] == 6) {
                    ColumnBindingTest.assertTrue((boolean)value.getClass().equals(Date.class));
                }
                ++i2;
            }
            this.testPrintln(str);
        }
    }

    public void testNoDataSetWithNestedQuery() throws Exception {
        String[] name = new String[]{"testColumn1"};
        IQueryResults queryResult = null;
        int[] dataType = new int[]{6};
        ScriptExpression[] se = new ScriptExpression[]{new ScriptExpression("new Date()", dataType[0])};
        DataEngineImpl myDataEngine = new DataEngineImpl(DataEngineContext.newInstance((int)3, null, null, null));
        QueryDefinition queryDefn = new QueryDefinition();
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = myDataEngine.prepare((IQueryDefinition)queryDefn).execute(null).getResultIterator();
        queryResult = ri.getQueryResults();
        QueryDefinition queryDefn2 = this.newReportQuery();
        int i2 = 0;
        while (i2 < name.length) {
            queryDefn2.addBinding((IBinding)new Binding(name[i2], (IBaseExpression)new ScriptExpression("row._outer." + name[i2])));
            ++i2;
        }
        IResultIterator ri2 = this.dataEngine.prepare((IQueryDefinition)queryDefn2).execute(queryResult, null).getResultIterator();
        if (ri2.next()) {
            String str = "";
            int i3 = 0;
            while (i3 < name.length) {
                Object value = ri2.getValue(name[i3]);
                str = String.valueOf(str) + value;
                if (i3 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i3;
            }
            this.testPrintln(str);
        }
        ri2.close();
    }

    public void testNoDataSetWithSubQuery() throws Exception {
        int[] dataType = new int[]{6};
        String[] name = new String[]{"testColumn1"};
        IResultIterator ri2 = null;
        ScriptExpression[] se = new ScriptExpression[]{new ScriptExpression("new Date()", dataType[0])};
        QueryDefinition queryDefn = new QueryDefinition();
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        String subQueryName = "TEST";
        SubqueryDefinition subQueryDefn = new SubqueryDefinition(subQueryName, (IBaseQueryDefinition)queryDefn);
        int i2 = 0;
        while (i2 < name.length) {
            subQueryDefn.addBinding((IBinding)new Binding(name[i2], (IBaseExpression)new ScriptExpression("row._outer." + name[i2], dataType[i2])));
            ++i2;
        }
        queryDefn.addSubquery(subQueryDefn);
        DataEngineImpl myDataEngine = new DataEngineImpl(DataEngineContext.newInstance((int)3, null, null, null));
        IResultIterator ri = myDataEngine.prepare((IQueryDefinition)queryDefn).execute(null).getResultIterator();
        ri.next();
        ri2 = ri.getSecondaryIterator(subQueryName, null);
        if (ri2.next()) {
            String str = "";
            int i3 = 0;
            while (i3 < name.length) {
                Object value = ri2.getValue(name[i3]);
                str = String.valueOf(str) + value;
                if (i3 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                if (dataType[0] == 6) {
                    ColumnBindingTest.assertTrue((boolean)value.getClass().equals(Date.class));
                }
                ++i3;
            }
            this.testPrintln(str);
        }
        ri2.close();
    }

    public void testAutoBinding() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        this.dataSet.addComputedColumn((IComputedColumn)new ComputedColumn("COUN\"TRY", "row[\"COUNTRY\"]"));
        queryDefn.setAutoBinding(true);
        String[] name = new String[]{"COUN\"TRY", "CITY", "AMOUNT"};
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i = 0;
            while (i < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i]);
                if (i < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i;
            }
            this.testPrintln(str);
        }
        ri.close();
        this.checkOutputFile();
    }

    public void testAccessGroupColumn() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1", "testColumn2", "AMOUNT1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        se[1] = new ScriptExpression("dataSetRow.CITY");
        se[2] = new ScriptExpression("dataSetRow.AMOUNT");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        GroupDefinition groupDefn = new GroupDefinition("group1");
        groupDefn.setKeyColumn("testColumn1");
        String name2 = "testColumn3";
        ScriptExpression se2 = new ScriptExpression("Total.sum(dataSetRow.AMOUNT)");
        se2.setGroupName("group1");
        queryDefn.addBinding((IBinding)new Binding(name2, (IBaseExpression)se2));
        queryDefn.addGroup(groupDefn);
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                str = String.valueOf(str) + ", ";
                ++i2;
            }
            str = String.valueOf(str) + ri.getValue(name2);
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testSpecialExpression() throws Exception {
        ComputedColumn cc = new ComputedColumn("AMOUNT2", "row.AMOUNT*2");
        this.dataSet.addComputedColumn((IComputedColumn)cc);
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("if ( 2<1 ){ true;  }else{ false;}");
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setExpression("row.testColumn1");
        sortDefn[0].setSortDirection(1);
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        i = 0;
        while (i < sortDefn.length) {
            queryDefn.addSort(sortDefn[i]);
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testSpecialExpression2() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"AMOUNT", "testColumn1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.AMOUNT");
        se[1] = new ScriptExpression("if ( row.AMOUNT >200 ){ Total.runningSum(row.AMOUNT);  }else{ row.AMOUNT;}");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testSpecialExpression3() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"AMOUNT", "testColumn1", "testColumn2"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.AMOUNT");
        se[1] = new ScriptExpression("var p=dataSetRow.AMOUNT+1;if( p >200 ){\"A large amount!\";  } else{ \"A small amount!\";}");
        se[2] = new ScriptExpression("row[\"testColumn1\"]+dataSetRow.AMOUNT");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                if (i2 < name.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i2;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testInvalidSort() throws Exception {
        int i = 0;
        while (i < 4) {
            this.testInvalidSort(i);
            ++i;
        }
    }

    private void testInvalidSort(int sortIndex) throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"rownum1", "rownum2", "rownum3"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("row.__rownum");
        se[1] = new ScriptExpression("row.rownum1");
        se[2] = new ScriptExpression("row[\"rownum2\"]");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        SortDefinition[] sort = new SortDefinition[name.length + 1];
        sort[0] = new SortDefinition();
        sort[0].setExpression("row.rownum1");
        sort[1] = new SortDefinition();
        sort[1].setExpression("row.rownum2");
        sort[2] = new SortDefinition();
        sort[2].setExpression("row.rownum3");
        sort[3] = new SortDefinition();
        sort[3].setExpression("row.__rownum");
        queryDefn.addSort(sort[sortIndex]);
        try {
            this.executeQuery((IQueryDefinition)queryDefn);
            ColumnBindingTest.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {}
    }

    public void testInvalidFilter() throws Exception {
        int i = 0;
        while (i < 4) {
            this.testInvalidFilter(i);
            ++i;
        }
    }

    private void testInvalidFilter(int filterIndex) throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"rownum1", "rownum2", "rownum3"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("row.__rownum");
        se[1] = new ScriptExpression("row.rownum1");
        se[2] = new ScriptExpression("row[\"rownum2\"]");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        FilterDefinition[] filter = new FilterDefinition[name.length + 1];
        filter[0] = new FilterDefinition((IBaseExpression)new ScriptExpression("row.rownum1 == 1"));
        filter[1] = new FilterDefinition((IBaseExpression)new ScriptExpression("row.rownum2 == 1"));
        filter[2] = new FilterDefinition((IBaseExpression)new ScriptExpression("row.rownum3 == 1"));
        filter[3] = new FilterDefinition((IBaseExpression)new ScriptExpression("row.__rownum == 1"));
        queryDefn.addFilter((IFilterDefinition)filter[filterIndex]);
        try {
            this.executeQuery((IQueryDefinition)queryDefn);
            ColumnBindingTest.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {}
    }

    public void testGroup() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1", "testColumn2", "AMOUNT1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        se[1] = new ScriptExpression("dataSetRow.CITY");
        se[2] = new ScriptExpression("dataSetRow.AMOUNT");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        GroupDefinition groupDefn = new GroupDefinition("group1");
        groupDefn.setKeyColumn("testColumn1");
        String name2 = "testColumn3";
        ScriptExpression se2 = new ScriptExpression("Total.sum(dataSetRow.AMOUNT)");
        se2.setGroupName("group1");
        queryDefn.addBinding((IBinding)new Binding(name2, (IBaseExpression)se2));
        queryDefn.addGroup(groupDefn);
        String name3 = "testColumn4";
        ScriptExpression se3 = new ScriptExpression("row[\"testColumn1\"]");
        GroupDefinition groupDefn1 = new GroupDefinition("group2");
        groupDefn1.setKeyColumn("testColumn4");
        se3.setGroupName("group2");
        queryDefn.addBinding((IBinding)new Binding(name3, (IBaseExpression)se3));
        queryDefn.addGroup(groupDefn1);
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        while (ri.next()) {
            String str = "";
            int i2 = 0;
            while (i2 < name.length) {
                str = String.valueOf(str) + ri.getValue(name[i2]);
                str = String.valueOf(str) + ", ";
                ++i2;
            }
            str = String.valueOf(str) + ri.getValue(name2);
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    public void testInvalidBinding() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        if (ri.next()) {
            try {
                ri.getValue(name[0]);
            }
            catch (BirtException e) {
                ColumnBindingTest.assertTrue((e.getErrorCode() == "data.engine.InvalidJSExpr" ? 1 : 0) != 0);
            }
        }
        ri.close();
    }

    public void testBlankExpression() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"testColumn1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression(null);
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        try {
            if (ri.next()) {
                ri.getValue(name[0]);
            }
            ColumnBindingTest.fail((String)"Should not arrive here");
        }
        catch (BirtException birtException) {
            ri.close();
        }
    }

    public void testBasicReportDocument() throws Exception {
        String fileName = ColumnBindingTest.getOutputFolder() + "testData";
        DataEngineContext deContext1 = this.newContext(1, fileName);
        this.myGenDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext1);
        this.myGenDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.genBasic();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasic();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genBasic() throws Exception {
        this.expectedValue = new ArrayList();
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        Context.exit();
        QueryDefinition qd = this.newReportQuery();
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBinding[] totalBeArray = this.getAggrBinding();
        this.prepareExprNameAndQuery(rowBeArray, totalBeArray, (BaseQueryDefinition)qd);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i = 0;
            while (i < rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i]));
                ++i;
            }
            i = 0;
            while (i < totalBeArray.length) {
                this.expectedValue.add(ri.getValue(this.totalExprName[i]));
                ++i;
            }
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void genSerializable() throws Exception {
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        Context.exit();
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"serializable"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("new java.lang.StringBuffer(\"ss\")");
        se[0].setDataType(11);
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)queryDefn).execute((Scriptable)scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        ColumnBindingTest.assertEquals((int)11, (int)ri.getResultMetaData().getColumnType(1));
        while (ri.next()) {
            ColumnBindingTest.assertTrue((boolean)(ri.getValue("serializable") instanceof StringBuffer));
            ColumnBindingTest.assertEquals((String)"ss", (String)ri.getValue("serializable").toString());
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void genUnserializable() throws Exception {
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        Context.exit();
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"unserializable"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("new java.lang.ThreadGroup(\"ss\")");
        se[0].setDataType(11);
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)queryDefn).execute((Scriptable)scope);
        this.queryResultID = qr.getID();
        try {
            try {
                IResultIterator ri = qr.getResultIterator();
                ColumnBindingTest.assertEquals((int)11, (int)ri.getResultMetaData().getColumnType(1));
                while (ri.next()) {
                    ColumnBindingTest.assertTrue((boolean)(ri.getValue("unserializable") instanceof ThreadGroup));
                }
                ri.close();
                ColumnBindingTest.assertTrue((boolean)false);
            }
            catch (Exception e) {
                e.printStackTrace();
                qr.close();
                this.myGenDataEngine.shutdown();
            }
        }
        finally {
            qr.close();
            this.myGenDataEngine.shutdown();
        }
    }

    private void preSerializable() throws Exception {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        IResultIterator ri = qr.getResultIterator();
        int rowCount = 0;
        while (ri.next()) {
            ColumnBindingTest.assertTrue((boolean)(ri.getValue("serializable") instanceof StringBuffer));
            ColumnBindingTest.assertEquals((String)"ss", (String)ri.getValue("serializable").toString());
            ++rowCount;
        }
        ColumnBindingTest.assertTrue((rowCount > 0 ? 1 : 0) != 0);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    private void preBasic() throws Exception {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult1(ri);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    public void testDummy1Document() throws Exception {
        String fileName = ColumnBindingTest.getOutputFolder() + "testData";
        DataEngineContext deContext1 = this.newContext(1, fileName);
        this.myGenDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext1);
        this.myGenDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.genDummy1();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preDummy1();
        this.closeArchiveReader();
    }

    public void testObjectTypeBasic() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] name = new String[]{"ObjectType"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("new java.lang.StringBuffer(\"ss\")");
        se[0].setDataType(11);
        int i = 0;
        while (i < name.length) {
            queryDefn.addBinding((IBinding)new Binding(name[i], (IBaseExpression)se[i]));
            ++i;
        }
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        ColumnBindingTest.assertEquals((int)11, (int)ri.getResultMetaData().getColumnType(1));
        while (ri.next()) {
            ColumnBindingTest.assertTrue((boolean)(ri.getValue("ObjectType") instanceof StringBuffer));
            ColumnBindingTest.assertEquals((String)"ss", (String)ri.getValue("ObjectType").toString());
        }
    }

    public void testSerializableObjectTypeInReportDocument() throws Exception {
        String fileName = ColumnBindingTest.getOutputFolder() + "testData";
        DataEngineContext deContext1 = this.newContext(1, fileName);
        this.myGenDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext1);
        this.myGenDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.genSerializable();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preSerializable();
        this.closeArchiveReader();
    }

    public void testUnserializableObjectTypeInReportDocument() throws Exception {
        String fileName = ColumnBindingTest.getOutputFolder() + "testData";
        DataEngineContext deContext1 = this.newContext(1, fileName);
        this.myGenDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext1);
        this.myGenDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.genUnserializable();
    }

    private void genDummy1() throws Exception {
        this.expectedValue = new ArrayList();
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        Context.exit();
        QueryDefinition qd = new QueryDefinition();
        IBaseExpression[] rowBeArray = this.getDummyRowExpr();
        this.prepareExprNameAndQuery(rowBeArray, null, (BaseQueryDefinition)qd);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i = 0;
            while (i < rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i]));
                ++i;
            }
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preDummy1() throws Exception {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult1(ri);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    private IBaseExpression[] getDummyRowExpr() {
        int num = 1;
        IBaseExpression[] rowBeArray = new IBaseExpression[num];
        rowBeArray[0] = new ScriptExpression("new Date()", 6);
        this.rowExprName = new String[rowBeArray.length];
        this.rowExprName[0] = "Date";
        return rowBeArray;
    }

    public void testDummy2Document() throws Exception {
        String fileName = ColumnBindingTest.getOutputFolder() + "testData";
        DataEngineContext deContext1 = this.newContext(1, fileName);
        this.myGenDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext1);
        this.myGenDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.genDummy2();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preDummy2();
        this.closeArchiveReader();
    }

    private void genDummy2() throws Exception {
        this.expectedValue = new ArrayList();
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        Context.exit();
        QueryDefinition qd = new QueryDefinition();
        IBaseExpression[] rowBeArray = this.getDummyRowExpr();
        this.prepareExprNameAndQuery(rowBeArray, null, (BaseQueryDefinition)qd);
        SubqueryDefinition subQueryDefn = new SubqueryDefinition(this.subName, (IBaseQueryDefinition)qd);
        qd.addSubquery(subQueryDefn);
        IBaseExpression[] rowBeArray2 = this.getDummyRowExpr();
        this.prepareExprNameAndQuery(rowBeArray2, null, (BaseQueryDefinition)subQueryDefn);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i = 0;
            while (i < rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i]));
                ++i;
            }
            IResultIterator ri2 = ri.getSecondaryIterator(this.subName, (Scriptable)scope);
            while (ri2.next()) {
                int i2 = 0;
                while (i2 < rowBeArray2.length) {
                    this.expectedValue.add(ri2.getValue(this.rowExprName[i2]));
                    ++i2;
                }
            }
            ri2.close();
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preDummy2() throws Exception {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult2(ri);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    private DataEngineContext newContext(int type, String fileName) throws BirtException {
        switch (type) {
            case 1: {
                try {
                    this.archiveWriter = new FileArchiveWriter(fileName);
                    this.archiveWriter.initialize();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                return DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)this.archiveWriter);
            }
            case 2: {
                try {
                    this.archiveReader = new FileArchiveReader(fileName);
                    this.archiveReader.open();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                return DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)this.archiveReader, null);
            }
        }
        throw new IllegalArgumentException("" + type);
    }

    private IBaseExpression[] getRowExpr() {
        int num = 4;
        IBaseExpression[] rowBeArray = new IBaseExpression[num];
        rowBeArray[0] = new ScriptExpression("dataSetRow.COUNTRY");
        rowBeArray[1] = new ScriptExpression("dataSetRow.CITY");
        rowBeArray[2] = new ScriptExpression("dataSetRow.SALE_DATE");
        rowBeArray[3] = new ScriptExpression("dataSetRow.AMOUNT");
        this.rowExprName = new String[rowBeArray.length];
        this.rowExprName[0] = "COUNTRY_1";
        this.rowExprName[1] = "CITY_1";
        this.rowExprName[2] = "SALE_NAME_1";
        this.rowExprName[3] = "AMOUNT_1";
        return rowBeArray;
    }

    private IBinding[] getAggrBinding() throws DataException {
        int num2 = 2;
        this.totalExprName = new String[num2];
        this.totalExprName[0] = "TOTAL_COUNT_1";
        this.totalExprName[1] = "TOTAL_AMOUNT_1";
        IBinding[] totalBeArray = new IBinding[num2];
        totalBeArray[0] = new Binding(this.totalExprName[0]);
        totalBeArray[0].setAggrFunction("COUNT");
        totalBeArray[1] = new Binding(this.totalExprName[1], (IBaseExpression)new ScriptExpression("row.AMOUNT_1"));
        totalBeArray[1].setAggrFunction("SUM");
        return totalBeArray;
    }

    private void prepareExprNameAndQuery(IBaseExpression[] rowBeArray, IBinding[] totalBeArray, BaseQueryDefinition qd) throws DataException {
        int num = rowBeArray.length;
        int i = 0;
        while (i < num) {
            qd.addBinding((IBinding)new Binding(this.rowExprName[i], rowBeArray[i]));
            ++i;
        }
        if (totalBeArray != null) {
            int num2 = totalBeArray.length;
            int i2 = 0;
            while (i2 < num2) {
                qd.addBinding(totalBeArray[i2]);
                ++i2;
            }
        }
    }

    private void checkResult1(IResultIterator ri) throws BirtException {
        Iterator it = this.expectedValue.iterator();
        while (ri.next()) {
            Object ob2;
            Object ob1;
            String str = "";
            int i = 0;
            while (i < this.rowExprName.length) {
                ob1 = it.next();
                ob2 = ri.getValue(this.rowExprName[i]);
                ColumnBindingTest.assertEquals(ob1, (Object)ob2);
                str = String.valueOf(str) + " " + ob2.toString();
                ++i;
            }
            if (this.totalExprName != null) {
                i = 0;
                while (i < this.totalExprName.length) {
                    ob1 = it.next();
                    ob2 = ri.getValue(this.totalExprName[i]);
                    ColumnBindingTest.assertEquals(ob1, (Object)ob2);
                    str = String.valueOf(str) + " " + ob2.toString();
                    ++i;
                }
            }
            this.testPrintln("row result set: " + str);
        }
    }

    private void checkResult2(IResultIterator ri) throws BirtException {
        Iterator it = this.expectedValue.iterator();
        while (ri.next()) {
            Object ob2;
            Object ob1;
            String str = "";
            int i = 0;
            while (i < this.rowExprName.length) {
                Object ob12 = it.next();
                Object ob22 = ri.getValue(this.rowExprName[i]);
                ColumnBindingTest.assertEquals(ob12, (Object)ob22);
                str = String.valueOf(str) + " " + ob22.toString();
                ++i;
            }
            IResultIterator ri2 = ri.getSecondaryIterator(this.subName, null);
            while (ri2.next()) {
                int i2 = 0;
                while (i2 < this.rowExprName.length) {
                    ob1 = it.next();
                    ob2 = ri2.getValue(this.rowExprName[i2]);
                    ColumnBindingTest.assertEquals(ob1, (Object)ob2);
                    str = String.valueOf(str) + " " + ob2.toString();
                    ++i2;
                }
            }
            if (this.totalExprName != null) {
                int i3 = 0;
                while (i3 < this.totalExprName.length) {
                    ob1 = it.next();
                    ob2 = ri.getValue(this.totalExprName[i3]);
                    ColumnBindingTest.assertEquals(ob1, (Object)ob2);
                    str = String.valueOf(str) + " " + ob2.toString();
                    ++i3;
                }
            }
            this.testPrintln("row result set: " + str);
        }
    }

    private void closeArchiveWriter() throws DataException {
        if (this.archiveWriter != null) {
            try {
                this.archiveWriter.finish();
            }
            catch (IOException e) {
                throw new DataException("error", (Throwable)e);
            }
        }
    }

    private void closeArchiveReader() throws DataException {
        if (this.archiveReader != null) {
            try {
                this.archiveReader.close();
            }
            catch (IOException e) {
                throw new DataException("error", (Throwable)e);
            }
        }
    }
}

