/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.MemoryCache;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class MemoryCacheTest
extends TestCase {
    private IResultObject[] resultObjects;

    public void setUp() throws DataException {
        ArrayList<ResultFieldMetadata> columnsList = new ArrayList<ResultFieldMetadata>();
        ResultFieldMetadata columnMetaData = new ResultFieldMetadata(1, "col1", "col1", DataType.getClass((int)5), "String", true);
        columnsList.add(columnMetaData);
        this.resultObjects = new ResultObject[]{new ResultObject((IResultClass)new ResultClass(columnsList), new Object[]{"abc"}), new ResultObject((IResultClass)new ResultClass(columnsList), new Object[]{"def"})};
    }

    public void testNext() throws DataException {
        MemoryCache memoryCache = new MemoryCache(this.resultObjects, this.resultObjects[0].getResultClass(), null);
        int i = 0;
        MemoryCacheTest.assertEquals((int)memoryCache.getCurrentIndex(), (int)-1);
        while (memoryCache.next()) {
            if (i == 0) {
                MemoryCacheTest.assertEquals((int)memoryCache.getCurrentIndex(), (int)0);
                MemoryCacheTest.assertEquals((String)memoryCache.getCurrentResult().getFieldValue(1).toString(), (String)"abc");
            } else if (i == 1) {
                MemoryCacheTest.assertEquals((int)memoryCache.getCurrentIndex(), (int)1);
                MemoryCacheTest.assertEquals((String)memoryCache.getCurrentResult().getFieldValue(1).toString(), (String)"def");
            }
            ++i;
        }
        i = 0;
        while (i < 5) {
            MemoryCacheTest.assertEquals((boolean)memoryCache.next(), (boolean)false);
            MemoryCacheTest.assertEquals((int)memoryCache.getCurrentIndex(), (int)2);
            MemoryCacheTest.assertEquals((Object)memoryCache.getCurrentResult(), null);
            ++i;
        }
    }

    public void testFetch() throws DataException {
        MemoryCache memoryCache = new MemoryCache(this.resultObjects, this.resultObjects[0].getResultClass(), null);
        int i = 0;
        while (memoryCache.fetch() != null) {
            if (i == 0) {
                MemoryCacheTest.assertEquals((String)memoryCache.getCurrentResult().getFieldValue(1).toString(), (String)"abc");
            } else if (i == 1) {
                MemoryCacheTest.assertEquals((String)memoryCache.getCurrentResult().getFieldValue(1).toString(), (String)"def");
            }
            ++i;
        }
        MemoryCacheTest.assertEquals((int)i, (int)2);
    }
}

