/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.impl.Util;

public class CachedResultSetTest
extends Util.CachedResultSetTestHelper {
    private CachedResultSet rs;

    protected void setUp() throws Exception {
        super.setUp();
        this.rs = this.getDefaultCachedResultSet();
    }

    protected void tearDown() throws Exception {
        this.rs.close();
        super.tearDown();
    }

    public void testFirst() throws DataException {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    int l = 0;
                    while (l < 3) {
                        int id = this.rs.getCurrentResultIndex();
                        this.rs.first(3);
                        CachedResultSetTest.assertEquals((int)(id - l), (int)this.rs.getCurrentResultIndex());
                        int m = 0;
                        while (m < l) {
                            this.rs.next();
                            ++m;
                        }
                        this.rs.first(2);
                        CachedResultSetTest.assertEquals((int)(id - 3 * k - l), (int)this.rs.getCurrentResultIndex());
                        m = 0;
                        while (m < 3 * k + l) {
                            this.rs.next();
                            ++m;
                        }
                        this.rs.first(1);
                        CachedResultSetTest.assertEquals((int)(id - 3 * k - 9 * j - l), (int)this.rs.getCurrentResultIndex());
                        m = 0;
                        while (m < 9 * j + 3 * k + l) {
                            this.rs.next();
                            ++m;
                        }
                        this.rs.first(0);
                        CachedResultSetTest.assertEquals((int)0, (int)this.rs.getCurrentResultIndex());
                        m = 0;
                        while (m < 27 * i + 9 * j + 3 * k + l) {
                            this.rs.next();
                            ++m;
                        }
                        this.rs.next();
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        try {
            this.rs.first(-1);
        }
        catch (DataException e) {
            CachedResultSetTest.assertEquals((String)e.getErrorCode(), (String)"data.engine.InvalidGroupLevel");
        }
        try {
            this.rs.first(5);
        }
        catch (DataException e) {
            CachedResultSetTest.assertEquals((String)e.getErrorCode(), (String)"data.engine.InvalidGroupLevel");
        }
    }

    public void testLast() throws DataException {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    int l = 0;
                    while (l < 3) {
                        this.rs.last(3);
                        CachedResultSetTest.assertEquals((int)(27 * i + 9 * j + 3 * k + 2), (int)this.rs.getCurrentResultIndex());
                        this.rs.first(3);
                        int m = 0;
                        while (m < l) {
                            this.rs.next();
                            ++m;
                        }
                        this.rs.last(2);
                        CachedResultSetTest.assertEquals((int)(27 * i + 9 * j + 8), (int)this.rs.getCurrentResultIndex());
                        this.rs.first(2);
                        m = 0;
                        while (m < 3 * k + l) {
                            this.rs.next();
                            ++m;
                        }
                        this.rs.last(1);
                        CachedResultSetTest.assertEquals((int)(27 * i + 26), (int)this.rs.getCurrentResultIndex());
                        this.rs.first(1);
                        m = 0;
                        while (m < 9 * j + 3 * k + l) {
                            this.rs.next();
                            ++m;
                        }
                        this.rs.last(0);
                        CachedResultSetTest.assertEquals((int)80, (int)this.rs.getCurrentResultIndex());
                        this.rs.first(0);
                        m = 0;
                        while (m < 27 * i + 9 * j + 3 * k + l) {
                            this.rs.next();
                            ++m;
                        }
                        this.rs.next();
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        try {
            this.rs.last(-1);
        }
        catch (DataException e) {
            CachedResultSetTest.assertEquals((String)e.getErrorCode(), (String)"data.engine.InvalidGroupLevel");
        }
        try {
            this.rs.last(5);
        }
        catch (DataException e) {
            CachedResultSetTest.assertEquals((String)e.getErrorCode(), (String)"data.engine.InvalidGroupLevel");
        }
    }

    public void testGetCurrentResult() throws Exception {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    int l = 0;
                    while (l < 3) {
                        CachedResultSetTest.assertEquals((int)DataTypeUtil.toInteger((Object)this.rs.getCurrentResult().getFieldValue("COL0")), (int)i);
                        CachedResultSetTest.assertEquals((int)DataTypeUtil.toInteger((Object)this.rs.getCurrentResult().getFieldValue("COL1")), (int)j);
                        CachedResultSetTest.assertEquals((int)DataTypeUtil.toInteger((Object)this.rs.getCurrentResult().getFieldValue("COL2")), (int)k);
                        CachedResultSetTest.assertEquals((int)DataTypeUtil.toInteger((Object)this.rs.getCurrentResult().getFieldValue("COL3")), (int)l);
                        this.rs.next();
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void testGetCurrentResultIndex() throws Exception {
        int i = 0;
        while (this.rs.next()) {
            CachedResultSetTest.assertEquals((int)this.rs.getCurrentResultIndex(), (int)(++i));
        }
    }

    public void testGetStartingGroupLevel() throws DataException {
        int[] expectedResult = this.prepareTestDataForGetStartingGroupLevel();
        int counter = 0;
        CachedResultSetTest.assertEquals((int)this.rs.getStartingGroupLevel(), (int)expectedResult[counter]);
        while (this.rs.next()) {
            CachedResultSetTest.assertEquals((int)this.rs.getStartingGroupLevel(), (int)expectedResult[++counter]);
        }
        try {
            this.rs.getStartingGroupLevel();
        }
        catch (DataException e) {
            CachedResultSetTest.assertEquals((String)e.getMessage(), (String)DataResourceHandle.getInstance().getMessage("data.engine.NoCurrentRow"));
        }
    }

    public void testGetEndingGroupLevel() throws DataException {
        int[] expectedResult = this.prepareTestDataForGetEndingGroupLevel();
        int counter = 0;
        CachedResultSetTest.assertEquals((int)this.rs.getEndingGroupLevel(), (int)expectedResult[counter]);
        while (this.rs.next()) {
            CachedResultSetTest.assertEquals((int)this.rs.getEndingGroupLevel(), (int)expectedResult[++counter]);
        }
        try {
            this.rs.getEndingGroupLevel();
        }
        catch (DataException e) {
            CachedResultSetTest.assertEquals((String)e.getMessage(), (String)DataResourceHandle.getInstance().getMessage("data.engine.NoCurrentRow"));
        }
    }

    public void testGetGroupData() throws Exception {
        CachedResultSet rs2 = this.getDefaultSubQueryCachedResultSet();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                CachedResultSetTest.assertEquals((int)DataTypeUtil.toInteger((Object)rs2.getCurrentResult().getFieldValue("COL0")), (int)0);
                CachedResultSetTest.assertEquals((int)DataTypeUtil.toInteger((Object)rs2.getCurrentResult().getFieldValue("COL1")), (int)0);
                CachedResultSetTest.assertEquals((int)DataTypeUtil.toInteger((Object)rs2.getCurrentResult().getFieldValue("COL2")), (int)i);
                CachedResultSetTest.assertEquals((int)DataTypeUtil.toInteger((Object)rs2.getCurrentResult().getFieldValue("COL3")), (int)j);
                rs2.next();
                ++j;
            }
            ++i;
        }
    }

    private int[] prepareTestDataForGetEndingGroupLevel() {
        int[] expectedResult = new int[81];
        int i = 0;
        while (i < 81) {
            expectedResult[i] = 4;
            ++i;
        }
        int counter = -1;
        int i2 = 0;
        while (i2 < 3) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    int l = 0;
                    while (l < 3) {
                        ++counter;
                        ++l;
                    }
                    expectedResult[counter] = 3;
                    ++k;
                }
                expectedResult[counter] = 2;
                ++j;
            }
            expectedResult[counter] = 1;
            ++i2;
        }
        expectedResult[expectedResult.length - 1] = 0;
        return expectedResult;
    }

    private int[] prepareTestDataForGetStartingGroupLevel() {
        int[] expectedResult = new int[81];
        int i = 0;
        while (i < 81) {
            expectedResult[i] = 4;
            ++i;
        }
        int counter = 0;
        int i2 = 0;
        while (i2 < 3) {
            expectedResult[counter] = 1;
            int j = 0;
            while (j < 3) {
                if (expectedResult[counter] == 4) {
                    expectedResult[counter] = 2;
                }
                int k = 0;
                while (k < 3) {
                    if (expectedResult[counter] == 4) {
                        expectedResult[counter] = 3;
                    }
                    int l = 0;
                    while (l < 3) {
                        ++counter;
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        expectedResult[0] = 0;
        return expectedResult;
    }
}

