/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ComplexExpression;
import org.eclipse.birt.data.engine.expression.ConstantExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ComplexExpressionCompilerTest
extends TestCase {
    private ScriptableObject m_scope;
    private ExpressionCompiler m_compiler;
    private AggregateRegistry m_registry;
    private ScriptContext context;

    protected void setUp() throws Exception {
        this.context = new ScriptContext();
        this.m_scope = Context.getCurrentContext().initStandardObjects();
        ScriptableObject.defineClass((Scriptable)this.m_scope, Row.class);
        ScriptableObject.defineClass((Scriptable)this.m_scope, AggrValue.class);
        Scriptable row = Context.getCurrentContext().newObject((Scriptable)this.m_scope, "Row");
        this.m_scope.put("row", (Scriptable)this.m_scope, (Object)row);
        Scriptable aggr = Context.getCurrentContext().newObject((Scriptable)this.m_scope, "AggrValue");
        this.m_scope.put("_aggr_value", (Scriptable)this.m_scope, (Object)aggr);
        this.m_compiler = new ExpressionCompiler();
        this.m_registry = new AggregateRegistry(){
            private int m_index = 1;

            public int register(AggregateExpression aggregationExpr) {
                return this.m_index++;
            }
        };
    }

    protected void tearDown() throws Exception {
        this.context.close();
    }

    public void testDirectReference1() throws Exception {
        CompiledExpression expr = this.m_compiler.compile("row.col1", this.m_registry, this.context);
        this.checkDirectRef1(expr);
    }

    public void testDirectReference2() throws Exception {
        CompiledExpression expr = this.m_compiler.compile("row[\"col1\"]", this.m_registry, this.context);
        this.checkDirectRef1(expr);
    }

    public void testDirectReference3() throws Exception {
        CompiledExpression expr = this.m_compiler.compile("row[ 1 ]", this.m_registry, this.context);
        ComplexExpressionCompilerTest.assertTrue((boolean)(expr instanceof ColumnReferenceExpression));
        ComplexExpressionCompilerTest.assertNull((Object)((ColumnReferenceExpression)expr).getColumnName());
        ComplexExpressionCompilerTest.assertEquals((int)1, (int)((ColumnReferenceExpression)expr).getColumnindex());
    }

    private void checkDirectRef1(CompiledExpression expr) {
        ComplexExpressionCompilerTest.assertNotNull((Object)expr);
        ComplexExpressionCompilerTest.assertTrue((boolean)(expr instanceof ColumnReferenceExpression));
        ComplexExpressionCompilerTest.assertEquals((String)"col1", (String)((ColumnReferenceExpression)expr).getColumnName());
        ComplexExpressionCompilerTest.assertEquals((int)-1, (int)((ColumnReferenceExpression)expr).getColumnindex());
    }

    public void testNonDirectRefOnRow1() throws Exception {
        ComplexExpression expr = this.isComplexExpression("row[col1]");
        this.checkSubExpressionSize(expr, 0);
        this.checkSubConstantsSize(expr, 0);
    }

    public void testNonDirectRefOnRow2() throws Exception {
        ComplexExpression expr = this.isComplexExpression("row[getColumnId()]");
        this.checkSubExpressionSize(expr, 0);
        this.checkSubConstantsSize(expr, 0);
    }

    public void testNonDirectRefOnRow3() throws Exception {
        ComplexExpression expr = this.isComplexExpression("row[SomeObject.getColumnId()]");
        this.checkSubExpressionSize(expr, 0);
        this.checkSubConstantsSize(expr, 1);
    }

    public void testMisc1() throws Exception {
        ComplexExpression expr = this.isComplexExpression("obj1.prop1 + obj2.prop2 + 100");
        this.checkSubExpressionSize(expr, 0);
        this.checkSubConstantsSize(expr, 3);
    }

    public void testComplexExpr1() throws Exception {
        ComplexExpression expr = this.isComplexExpression("row.col1 + row[\"col2\"]");
        this.checkComplexExpr1(expr);
        this.checkSubConstantsSize(expr, 0);
        Object o = expr.evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertTrue((boolean)(o instanceof Double));
        ComplexExpressionCompilerTest.assertEquals((Object)new Double(100.0), (Object)o);
    }

    public void testComplexExpr2() throws Exception {
        ComplexExpression expr = this.isComplexExpression("row[1] * row[\"col2\"]");
        this.checkSubConstantsSize(expr, 0);
        Object o = expr.evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertTrue((boolean)(o instanceof Double));
        ComplexExpressionCompilerTest.assertEquals((Object)new Double(0.0), (Object)o);
        Collection subExpressions = this.checkSubExpressionSize(expr, 2);
        Iterator iter = subExpressions.iterator();
        int count = 1;
        while (iter.hasNext()) {
            CompiledExpression ex = (CompiledExpression)iter.next();
            ComplexExpressionCompilerTest.assertTrue((boolean)(ex instanceof ColumnReferenceExpression));
            if (count++ == 1) {
                ComplexExpressionCompilerTest.assertEquals((int)1, (int)((ColumnReferenceExpression)ex).getColumnindex());
                continue;
            }
            ComplexExpressionCompilerTest.assertEquals((String)"col2", (String)((ColumnReferenceExpression)ex).getColumnName());
        }
    }

    public void testComplexExpr3() throws Exception {
        ComplexExpression expr = this.isComplexExpression("CustomFunction( row.col1 )");
        this.checkSubConstantsSize(expr, 0);
        this.hasOneSubExprAsDirectRef1(expr);
    }

    public void testComplexExpr4() throws Exception {
        ComplexExpression expr = this.isComplexExpression("CustomObject.CustomFunction( row.col1 )");
        this.checkSubConstantsSize(expr, 1);
        this.hasOneSubExprAsDirectRef1(expr);
    }

    public void testComplexExpr5() throws Exception {
        ComplexExpression expr = this.isComplexExpression("CustomObject[1]( row.col1 )");
        this.checkSubConstantsSize(expr, 1);
        this.hasOneSubExprAsDirectRef1(expr);
    }

    public void testComplexExpr6() throws Exception {
        ComplexExpression expr = this.isComplexExpression("CustomObject[1].CustomFunction( row.col1 )");
        this.checkSubConstantsSize(expr, 2);
        this.hasOneSubExprAsDirectRef1(expr);
    }

    private ComplexExpression isComplexExpression(String exprStr) throws DataException {
        CompiledExpression expr = this.m_compiler.compile(exprStr, this.m_registry, this.context);
        ComplexExpressionCompilerTest.assertTrue((boolean)(expr instanceof ComplexExpression));
        return (ComplexExpression)expr;
    }

    private void hasOneSubExprAsDirectRef1(ComplexExpression expr) {
        Collection subExpressions = this.checkSubExpressionSize(expr, 1);
        Iterator iter = subExpressions.iterator();
        CompiledExpression ex = (CompiledExpression)iter.next();
        this.checkDirectRef1(ex);
    }

    public void testAggregate1() throws Exception {
        AggregateExpression expr = this.checkTopLevelNonNestedAggregate("Total.sum( row.col1 )");
        this.checkAggregate1(expr);
    }

    public void testAggregate2() throws Exception {
        AggregateExpression expr = this.checkTopLevelNonNestedAggregate("Total.sum( row[\"col1\"] )");
        this.checkAggregate1(expr);
    }

    public void testAggregate3() throws Exception {
        AggregateExpression expr = this.checkTopLevelNonNestedAggregate("Total.sum( row[2] )");
        this.checkAggregate2(expr);
    }

    public void testAggregate4() throws Exception {
        AggregateExpression expr = this.checkTopLevelNonNestedAggregate("Total.sum( row.col1 + row.col2 )");
        List args = expr.getArguments();
        ComplexExpressionCompilerTest.assertEquals((int)1, (int)args.size());
        CompiledExpression arg1 = (CompiledExpression)args.get(0);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg1 instanceof ComplexExpression));
        this.checkComplexExpr1((ComplexExpression)arg1);
    }

    public void testAggregate5() throws Exception {
        AggregateExpression expr = this.checkTopLevelNonNestedAggregate("Total.sum( row.col1 + row.col2, true, null )");
        List args = expr.getArguments();
        ComplexExpressionCompilerTest.assertEquals((int)3, (int)args.size());
        CompiledExpression arg1 = (CompiledExpression)args.get(0);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg1 instanceof ComplexExpression));
        this.checkComplexExpr1((ComplexExpression)arg1);
        CompiledExpression arg2 = (CompiledExpression)args.get(1);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg2 instanceof ConstantExpression));
        ComplexExpressionCompilerTest.assertEquals((Object)Boolean.TRUE, (Object)((ConstantExpression)arg2).getValue());
        CompiledExpression arg3 = (CompiledExpression)args.get(2);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg3 instanceof ConstantExpression));
        ComplexExpressionCompilerTest.assertNull((Object)((ConstantExpression)arg3).getValue());
    }

    public void testAggregate6() throws Exception {
        AggregateExpression expr = this.checkTopLevelNonNestedAggregate("Total.sum( row.col1 + row.col2, row.col1 == 100, \"MyGroup\" )");
        List args = expr.getArguments();
        ComplexExpressionCompilerTest.assertEquals((int)3, (int)args.size());
        CompiledExpression arg1 = (CompiledExpression)args.get(0);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg1 instanceof ComplexExpression));
        this.checkComplexExpr1((ComplexExpression)arg1);
        this.checkSubConstantsSize((ComplexExpression)arg1, 0);
        CompiledExpression arg2 = (CompiledExpression)args.get(1);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg2 instanceof ComplexExpression));
        this.checkComplexExpr2((ComplexExpression)arg2);
        this.checkSubConstantsSize((ComplexExpression)arg2, 1);
        CompiledExpression arg3 = (CompiledExpression)args.get(2);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg3 instanceof ConstantExpression));
        ComplexExpressionCompilerTest.assertEquals((Object)"MyGroup", (Object)((ConstantExpression)arg3).getValue());
    }

    public void testAggregate7() throws Exception {
        AggregateExpression expr = this.checkTopLevelNonNestedAggregate("Total.sum( row.col1 + row.col2, row.col1 == 100, 12 )");
        this.checkAggregate3(expr);
    }

    public void testAggregate8() throws Exception {
        AggregateExpression expr = this.checkTopLevelNonNestedAggregate("Total.sum( row.col1 + row.col2, row.col1 == 100, GetGroupName() )");
        List args = expr.getArguments();
        ComplexExpressionCompilerTest.assertEquals((int)3, (int)args.size());
        CompiledExpression arg1 = (CompiledExpression)args.get(0);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg1 instanceof ComplexExpression));
        this.checkComplexExpr1((ComplexExpression)arg1);
        CompiledExpression arg2 = (CompiledExpression)args.get(1);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg2 instanceof ComplexExpression));
        this.checkComplexExpr2((ComplexExpression)arg2);
        CompiledExpression arg3 = (CompiledExpression)args.get(2);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg3 instanceof ComplexExpression));
    }

    public void testAggregate9() throws Exception {
        AggregateExpression expr = this.checkTopLevelNonNestedAggregate("Total.sum(row[\"repID\"],null,Total.OVERALL)");
        List args = expr.getArguments();
        ComplexExpressionCompilerTest.assertEquals((int)3, (int)args.size());
        CompiledExpression arg1 = (CompiledExpression)args.get(0);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg1 instanceof ColumnReferenceExpression));
        ComplexExpressionCompilerTest.assertEquals((String)"repID", (String)((ColumnReferenceExpression)arg1).getColumnName());
        ComplexExpressionCompilerTest.assertEquals((int)-1, (int)((ColumnReferenceExpression)arg1).getColumnindex());
        CompiledExpression arg2 = (CompiledExpression)args.get(1);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg2 instanceof ConstantExpression));
        ComplexExpressionCompilerTest.assertEquals(null, (Object)((ConstantExpression)arg2).getValue());
        CompiledExpression arg3 = (CompiledExpression)args.get(2);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg3 instanceof ConstantExpression));
        ComplexExpressionCompilerTest.assertEquals((Object)"OVERALL", (Object)((ConstantExpression)arg3).getValue());
    }

    private void checkAggregate1(AggregateExpression expr) {
        List args = expr.getArguments();
        ComplexExpressionCompilerTest.assertEquals((int)1, (int)args.size());
        this.checkDirectRef1((CompiledExpression)args.get(0));
    }

    private void checkAggregate2(AggregateExpression expr) {
        List args = expr.getArguments();
        ComplexExpressionCompilerTest.assertEquals((int)1, (int)args.size());
        ComplexExpressionCompilerTest.assertNotNull(args.get(0));
        ComplexExpressionCompilerTest.assertTrue((boolean)(args.get(0) instanceof ColumnReferenceExpression));
        ComplexExpressionCompilerTest.assertEquals((int)2, (int)((ColumnReferenceExpression)args.get(0)).getColumnindex());
    }

    private void checkAggregate3(AggregateExpression expr) throws DataException {
        List args = expr.getArguments();
        ComplexExpressionCompilerTest.assertEquals((int)3, (int)args.size());
        CompiledExpression arg1 = (CompiledExpression)args.get(0);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg1 instanceof ComplexExpression));
        this.checkComplexExpr1((ComplexExpression)arg1);
        CompiledExpression arg2 = (CompiledExpression)args.get(1);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg2 instanceof ComplexExpression));
        this.checkComplexExpr2((ComplexExpression)arg2);
        CompiledExpression arg3 = (CompiledExpression)args.get(2);
        ComplexExpressionCompilerTest.assertTrue((boolean)(arg3 instanceof ConstantExpression));
        ComplexExpressionCompilerTest.assertEquals((Object)new Double(12.0), (Object)((ConstantExpression)arg3).getValue());
    }

    private AggregateExpression checkTopLevelNonNestedAggregate(String exprStr) throws DataException {
        CompiledExpression expr = this.m_compiler.compile(exprStr, this.m_registry, this.context);
        ComplexExpressionCompilerTest.assertTrue((boolean)(expr instanceof AggregateExpression));
        Object o = ((AggregateExpression)expr).evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertTrue((boolean)(o instanceof Integer));
        ComplexExpressionCompilerTest.assertEquals((int)21, (int)((Integer)o));
        return (AggregateExpression)expr;
    }

    private void checkComplexExpr1(ComplexExpression arg1) throws DataException {
        ComplexExpressionCompilerTest.assertNotNull((Object)arg1);
        Collection subExpressions = this.checkSubExpressionSize(arg1, 2);
        Iterator i = subExpressions.iterator();
        int j = 1;
        while (i.hasNext()) {
            CompiledExpression e = (CompiledExpression)i.next();
            ComplexExpressionCompilerTest.assertEquals(e.getClass(), ColumnReferenceExpression.class);
            ComplexExpressionCompilerTest.assertEquals((String)(j++ == 1 ? "col1" : "col2"), (String)((ColumnReferenceExpression)e).getColumnName());
        }
        Object o = arg1.evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertTrue((boolean)(o instanceof Double));
        ComplexExpressionCompilerTest.assertEquals((int)100, (int)((Double)o).intValue());
    }

    private void checkComplexExpr2(ComplexExpression arg2) throws DataException {
        this.hasOneSubExprAsDirectRef1(arg2);
        Object o = arg2.evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testNestedAggregate1() throws Exception {
        CompiledExpression expr = this.m_compiler.compile("Total.sum( Total.sum( row.col1 ) )", this.m_registry, this.context);
        ComplexExpressionCompilerTest.assertTrue((boolean)(expr instanceof AggregateExpression));
        Object o = ((AggregateExpression)expr).evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertTrue((boolean)(o instanceof Integer));
        ComplexExpressionCompilerTest.assertEquals((int)42, (int)((Integer)o));
        List args = ((AggregateExpression)expr).getArguments();
        ComplexExpressionCompilerTest.assertEquals((int)1, (int)args.size());
        AggregateExpression expr1 = (AggregateExpression)args.get(0);
        this.checkAggregate1(expr1);
    }

    public void testNestedAggregate2() throws Exception {
        CompiledExpression expr = this.m_compiler.compile("Total.sum( Total.sum( row.col1 ), Total.sum( row[\"col1\"] ) )", this.m_registry, this.context);
        ComplexExpressionCompilerTest.assertTrue((boolean)(expr instanceof AggregateExpression));
        Object o = ((AggregateExpression)expr).evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertTrue((boolean)(o instanceof Integer));
        ComplexExpressionCompilerTest.assertEquals((int)63, (int)((Integer)o));
        List args = ((AggregateExpression)expr).getArguments();
        ComplexExpressionCompilerTest.assertEquals((int)2, (int)args.size());
        AggregateExpression arg1 = (AggregateExpression)args.get(0);
        this.checkAggregate1(arg1);
        AggregateExpression arg2 = (AggregateExpression)args.get(1);
        this.checkAggregate1(arg2);
    }

    public void testComplexAggregates1() throws Exception {
        ComplexExpression expr = this.isComplexExpression("Total.sum( row[\"col1\"] ) + Total.sum( row[2] )");
        Object o = expr.evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertTrue((boolean)(o instanceof Double));
        ComplexExpressionCompilerTest.assertEquals((int)63, (int)((Double)o).intValue());
        Collection subExpressions = this.checkSubExpressionSize(expr, 2);
        Iterator iter = subExpressions.iterator();
        CompiledExpression subExpr1 = (CompiledExpression)iter.next();
        ComplexExpressionCompilerTest.assertTrue((boolean)(subExpr1 instanceof AggregateExpression));
        this.checkAggregate1((AggregateExpression)subExpr1);
        CompiledExpression subExpr2 = (CompiledExpression)iter.next();
        ComplexExpressionCompilerTest.assertTrue((boolean)(subExpr2 instanceof AggregateExpression));
        this.checkAggregate2((AggregateExpression)subExpr2);
    }

    public void testComplexAggregates2() throws Exception {
        ComplexExpression expr = this.isComplexExpression("CustomFunction( Total.sum( row.col1 ) )");
        Collection subExpressions = this.checkSubExpressionSize(expr, 1);
        Iterator iter = subExpressions.iterator();
        AggregateExpression aggregate = (AggregateExpression)iter.next();
        this.checkAggregate1(aggregate);
    }

    public void testComplexAggregates3() throws Exception {
        ComplexExpression expr = this.isComplexExpression("Total.sum( row.col1 + row.col2, row.col1 == 100, 12 ) + row.col1 + 300");
        Collection subExpressions = this.checkSubExpressionSize(expr, 2);
        Iterator iter = subExpressions.iterator();
        CompiledExpression subExpr1 = (CompiledExpression)iter.next();
        ComplexExpressionCompilerTest.assertTrue((boolean)(subExpr1 instanceof AggregateExpression));
        this.checkAggregate3((AggregateExpression)subExpr1);
        CompiledExpression subExpr2 = (CompiledExpression)iter.next();
        ComplexExpressionCompilerTest.assertTrue((boolean)(subExpr2 instanceof ColumnReferenceExpression));
        this.checkDirectRef1(subExpr2);
        Object o = expr.evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertEquals((Object)new Double(421.0), (Object)o);
    }

    public void testComplexAggregates4() throws Exception {
        ComplexExpression expr = this.isComplexExpression("CustomFunc1( CustomFunc2( Total.sum( row.col1 ) + row[2] ) )");
        Collection subExpressions = this.checkSubExpressionSize(expr, 2);
        Iterator iter = subExpressions.iterator();
        CompiledExpression subExpr1 = (CompiledExpression)iter.next();
        ComplexExpressionCompilerTest.assertTrue((boolean)(subExpr1 instanceof AggregateExpression));
        this.checkAggregate1((AggregateExpression)subExpr1);
        CompiledExpression subExpr2 = (CompiledExpression)iter.next();
        ComplexExpressionCompilerTest.assertTrue((boolean)(subExpr2 instanceof ColumnReferenceExpression));
        ComplexExpressionCompilerTest.assertEquals((int)2, (int)((ColumnReferenceExpression)subExpr2).getColumnindex());
    }

    public void testComplexConstants1() throws Exception {
        this.doTestComplexConstants("100 + 200 + Total.sum( row.col1 )");
    }

    public void testComplexConstants2() throws Exception {
        this.doTestComplexConstants("100 + Total.sum( row.col1 ) + 200");
    }

    private void doTestComplexConstants(String exprStr) throws Exception {
        ComplexExpression expr = this.isComplexExpression(exprStr);
        Collection subExpressions = this.checkSubExpressionSize(expr, 1);
        Iterator iter = subExpressions.iterator();
        CompiledExpression subExpr = (CompiledExpression)iter.next();
        ComplexExpressionCompilerTest.assertTrue((boolean)(subExpr instanceof AggregateExpression));
        this.checkAggregate1((AggregateExpression)subExpr);
        Object o = expr.evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertEquals((int)321, (int)((Double)o).intValue());
    }

    public void testComplexConstants3() throws Exception {
        ComplexExpression expr = this.isComplexExpression("100 + Total.sum( row.col1 ) + 200 + Total.sum( row[2] )");
        Collection subExpressions = this.checkSubExpressionSize(expr, 2);
        Iterator iter = subExpressions.iterator();
        CompiledExpression subExpr1 = (CompiledExpression)iter.next();
        ComplexExpressionCompilerTest.assertTrue((boolean)(subExpr1 instanceof AggregateExpression));
        this.checkAggregate1((AggregateExpression)subExpr1);
        CompiledExpression subExpr2 = (CompiledExpression)iter.next();
        ComplexExpressionCompilerTest.assertTrue((boolean)(subExpr2 instanceof AggregateExpression));
        this.checkAggregate2((AggregateExpression)subExpr2);
        Object o = expr.evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertEquals((int)363, (int)((Double)o).intValue());
    }

    public void testConstants1() throws Exception {
        Object o = this.checkConstantExpression("null");
        ComplexExpressionCompilerTest.assertNull((Object)o);
    }

    public void testConstants2() throws Exception {
        Object o = this.checkConstantExpression("100");
        ComplexExpressionCompilerTest.assertEquals((Object)new Double(100.0), (Object)o);
    }

    public void testConstants3() throws Exception {
        Object o = this.checkConstantExpression("\"null\"");
        ComplexExpressionCompilerTest.assertEquals((Object)"null", (Object)o);
    }

    public void testConstants4() throws Exception {
        Object o = this.checkConstantExpression("100 + 200 + 300");
        ComplexExpressionCompilerTest.assertEquals((int)600, (int)((Double)o).intValue());
    }

    public void testConstants5() throws Exception {
        Object o = this.checkConstantExpression("true");
        ComplexExpressionCompilerTest.assertTrue((boolean)((Boolean)o));
    }

    public void testConstants6() throws Exception {
        Object o = this.checkConstantExpression("false");
        ComplexExpressionCompilerTest.assertFalse((boolean)((Boolean)o));
    }

    public void testConstants7() throws Exception {
        Object o = this.checkConstantExpression("\"hello\" + \" world\"");
        ComplexExpressionCompilerTest.assertEquals((Object)"hello world", (Object)o);
    }

    public void testConstants8() throws Exception {
        Object o = this.checkConstantExpression("\"hello \" + 21");
        ComplexExpressionCompilerTest.assertEquals((Object)"hello 21", (Object)o);
    }

    private Object checkConstantExpression(String exprStr) throws DataException {
        CompiledExpression expr = this.m_compiler.compile(exprStr, this.m_registry, this.context);
        ComplexExpressionCompilerTest.assertTrue((boolean)(expr instanceof ConstantExpression));
        return ((ConstantExpression)expr).getValue();
    }

    private Collection checkSubExpressionSize(ComplexExpression expr, int expected) {
        Collection subExpressions = expr.getSubExpressions();
        ComplexExpressionCompilerTest.assertEquals((int)expected, (int)subExpressions.size());
        return subExpressions;
    }

    private Collection checkSubConstantsSize(ComplexExpression expr, int expected) {
        Collection constantExpressions = expr.getConstantExpressions();
        ComplexExpressionCompilerTest.assertEquals((int)expected, (int)constantExpressions.size());
        return constantExpressions;
    }

    public void testBlock() throws Exception {
        ComplexExpression expr = this.isComplexExpression("if( row.col1 == 100 ) row.col1 + row[\"col2\"]; else 100;");
        Object o = expr.evaluate(this.context, (Scriptable)this.m_scope);
        ComplexExpressionCompilerTest.assertTrue((boolean)(o instanceof Double));
        ComplexExpressionCompilerTest.assertEquals((Object)new Double(100.0), (Object)o);
    }

    public static class AggrValue
    extends ScriptableObject {
        private static final long serialVersionUID = 244365478768L;

        public String getClassName() {
            return "AggrValue";
        }

        public Object get(int index, Scriptable start) {
            return new Integer(21 * index);
        }
    }

    public static class Row
    extends ScriptableObject {
        private static final long serialVersionUID = 1756453855L;
        private int col1 = 100;
        private int col2 = 0;

        public int jsGet_col1() {
            return this.col1;
        }

        public int jsGet_col2() {
            return this.col2;
        }

        public Object get(int index, Scriptable start) {
            switch (index) {
                case 0: {
                    return new Integer(0);
                }
                case 1: {
                    return new Integer(this.col1);
                }
                case 2: {
                    return new Integer(this.col2);
                }
            }
            return null;
        }

        public String getClassName() {
            return "Row";
        }
    }
}

