/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.ConfigFileParser;
import testutil.BaseTestCase;

public class ConfigFileParserTest
extends BaseTestCase {
    private ConfigFileParser.Node node;
    private ConfigFileParser parser;

    public void testParseXML2DOM() throws IOException {
        this.parser = new ConfigFileParser(this.getInputFolder("testDomTree.txt"));
        this.node = this.parser.getNode();
        ConfigFileParserTest.assertFalse((String)"parseXML2DOM() failed !!! ", (this.node == null ? 1 : 0) != 0);
        ConfigFileParserTest.assertTrue((String)"parseXML2DOM() failed !!! ", (boolean)this.parser.containDataSet("dset1"));
        ConfigFileParserTest.assertFalse((String)"parseXML2DOM() failed !!! ", (boolean)this.parser.containDataSet("dataSet1"));
        ConfigFileParserTest.assertEquals((String)"parseXML2DOM() occurrs errors !!!", (int)4, (int)this.node.getChildren().size());
        ConfigFileParserTest.assertEquals((String)"parseXML2DOM() occurrs errors !!!", (String)"report", (String)this.node.getName());
        ConfigFileParserTest.assertEquals((String)"parseXML2DOM() occurrs errors !!!", (String)"dset2", (String)((ConfigFileParser.Node)this.node.getChildren().get(1)).getAttrValue("id"));
        ConfigFileParserTest.assertEquals((String)"parseXML2DOM() occurrs errors !!!", (String)"query-text", (String)((ConfigFileParser.Node)((ConfigFileParser.Node)this.node.getChildren().get(0)).getChildren().get(1)).getName());
        ConfigFileParserTest.assertEquals((String)"parseXML2DOM() occurrs errors !!!", (String)"value1", (String)((ConfigFileParser.Node)((ConfigFileParser.Node)((ConfigFileParser.Node)this.node.getChildren().get(2)).getChildren().get(2)).getChildren().get(0)).getValue());
        this.openOutputFile();
        this.print(this.node, "");
        this.closeOutputFile();
        this.checkOutputFile();
    }

    private void initConfigFileParser() throws IOException {
        this.parser = new ConfigFileParser(this.getInputFolder("testDomTree.txt"));
    }

    public void testGetQueryTextByID() throws IOException, DataException {
        this.initConfigFileParser();
        ConfigFileParserTest.assertEquals((String)"getQueryTextByID() failed!!!", (String)"select * from BBHEGDCGHEBEA where ${timestamp-column}$ >=date('${date}$')", (String)this.parser.getQueryTextByID("dset1"));
    }

    public void testGetModeByID() throws IOException, DataException {
        this.initConfigFileParser();
        ConfigFileParserTest.assertEquals((String)"getModeByID() failed!!!", (String)"expire", (String)this.parser.getModeByID("dset1"));
        ConfigFileParserTest.assertEquals((String)"getModeByID() failed!!!", (String)"persistent", (String)this.parser.getModeByID("dset2"));
    }

    public void testGetTimeStampColumnByID() throws IOException, DataException {
        this.initConfigFileParser();
        ConfigFileParserTest.assertEquals((String)"getTimeStampColumnByID() failed!!!", (String)"timestamp1", (String)this.parser.getTimeStampColumnByID("dset3"));
        ConfigFileParserTest.assertEquals((String)"getTimeStampColumnByID() failed!!!", (String)"timestamp2", (String)this.parser.getTimeStampColumnByID("dset4"));
    }

    public void testGetParametersByID() throws IOException {
        this.initConfigFileParser();
        ConfigFileParserTest.assertEquals((String)"getParametersByID() failed!!!", (Object)"value1", this.parser.getParametersByID("dset3").get("param1"));
        ConfigFileParserTest.assertEquals((String)"getParametersByID() failed!!!", (Object)"value2", this.parser.getParametersByID("dset3").get("param2"));
    }

    public void testGetTSFormatByID() throws IOException, DataException {
        this.initConfigFileParser();
        ConfigFileParserTest.assertEquals((String)"getTSFormatByID() failed!!!", (String)"yy-MM-dd hh:mm:ss", (String)this.parser.getTSFormatByID("dset1"));
        ConfigFileParserTest.assertEquals((String)"getTSFormatByID() failed!!!", (String)"yy-MM-dd", (String)this.parser.getTSFormatByID("dset3"));
    }

    private void print(ConfigFileParser.Node n, String padding) {
        this.testPrintln(String.valueOf(padding) + "{" + n.getName() + "}");
        this.testPrintln(String.valueOf(padding) + "\t" + "value:" + n.getValue());
        Iterator it = n.getAttributes().keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            String value = n.getAttrValue(key);
            this.testPrintln(String.valueOf(padding) + "\t" + "[" + key + "]:" + value);
        }
        if (n.getChildren() != null) {
            int i = 0;
            while (i < n.getChildren().size()) {
                this.print((ConfigFileParser.Node)n.getChildren().get(i), String.valueOf(padding) + "\t");
                ++i;
            }
        }
    }
}

