/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;
import org.eclipse.birt.data.engine.impl.document.GroupInfoUtil;

public class GroupInfoUtilTest
extends TestCase {
    static final int SOURCE = 1;
    static final int TARGET = 2;

    public void testGetGroup() {
        List[] source = this.getTest1(1);
        List[] target = this.getTest1(2);
        GroupInfoUtilTest.assertTrue((boolean)this.twoGroupListArrayEqual(source, target));
        List[] result = GroupInfoUtil.cleanUnUsedGroupInstance((List[])source);
        GroupInfoUtilTest.assertTrue((boolean)this.twoGroupListArrayEqual(result, target));
        source = this.getTest2(1);
        target = this.getTest2(2);
        GroupInfoUtilTest.assertFalse((boolean)this.twoGroupListArrayEqual(source, target));
        result = GroupInfoUtil.cleanUnUsedGroupInstance((List[])source);
        GroupInfoUtilTest.assertTrue((boolean)this.twoGroupListArrayEqual(result, target));
        source = this.getTest3(1);
        target = this.getTest3(2);
        result = GroupInfoUtil.cleanUnUsedGroupInstance((List[])source);
        GroupInfoUtilTest.assertTrue((boolean)this.twoGroupListArrayEqual(result, target));
        source = this.getTest4(1);
        target = this.getTest4(2);
        result = GroupInfoUtil.cleanUnUsedGroupInstance((List[])source);
        GroupInfoUtilTest.assertTrue((boolean)this.twoGroupListArrayEqual(result, target));
        source = this.getTest5(1);
        target = this.getTest5(2);
        result = GroupInfoUtil.cleanUnUsedGroupInstance((List[])source);
        GroupInfoUtilTest.assertTrue((boolean)this.twoGroupListArrayEqual(result, target));
        source = this.getTest6(1);
        target = this.getTest6(2);
        result = GroupInfoUtil.cleanUnUsedGroupInstance((List[])source);
        GroupInfoUtilTest.assertTrue((boolean)this.twoGroupListArrayEqual(result, target));
        source = this.getTest7(1);
        target = this.getTest7(2);
        result = GroupInfoUtil.cleanUnUsedGroupInstance((List[])source);
        GroupInfoUtilTest.assertTrue((boolean)this.twoGroupListArrayEqual(result, target));
        source = this.getTest8(1);
        target = this.getTest8(2);
        result = GroupInfoUtil.cleanUnUsedGroupInstance((List[])source);
        GroupInfoUtilTest.assertTrue((boolean)this.twoGroupListArrayEqual(result, target));
        source = this.getTest9(1);
        target = this.getTest9(2);
        result = GroupInfoUtil.cleanUnUsedGroupInstance((List[])source);
        GroupInfoUtilTest.assertTrue((boolean)this.twoGroupListArrayEqual(result, target));
    }

    private List[] getTest0(int type) {
        if (type == 1) {
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            List[] lists = new List[]{level0};
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 4));
            return lists;
        }
        if (type == 2) {
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            List[] lists = new List[]{level0};
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            return lists;
        }
        return null;
    }

    private List[] getTest1(int type) {
        if (type == 1) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level1.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, 3));
            level2.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(2, 6));
            level2.add(this.getGroupInfo(3, 7));
            return lists;
        }
        if (type == 2) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level1.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, 3));
            level2.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(2, 6));
            level2.add(this.getGroupInfo(3, 7));
            return lists;
        }
        return null;
    }

    private List[] getTest2(int type) {
        if (type == 1) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level1.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, -2));
            level2.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(2, 6));
            level2.add(this.getGroupInfo(3, 7));
            return lists;
        }
        if (type == 2) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 3));
            level1.add(this.getGroupInfo(1, 4));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(2, 6));
            level2.add(this.getGroupInfo(3, 7));
            return lists;
        }
        return null;
    }

    private List[] getTest3(int type) {
        if (type == 1) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level1.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, 3));
            level2.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(2, -2));
            level2.add(this.getGroupInfo(3, 7));
            return lists;
        }
        if (type == 2) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, 3));
            level2.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(2, 7));
            return lists;
        }
        return null;
    }

    private List[] getTest4(int type) {
        if (type == 1) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level1.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, -2));
            level2.add(this.getGroupInfo(1, -2));
            level2.add(this.getGroupInfo(2, 6));
            level2.add(this.getGroupInfo(3, 7));
            return lists;
        }
        if (type == 2) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 1));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(1, 2));
            level1.add(this.getGroupInfo(1, 3));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, 6));
            level2.add(this.getGroupInfo(2, 7));
            return lists;
        }
        return null;
    }

    private List[] getTest5(int type) {
        if (type == 1) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level1.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(0, -2));
            level2.add(this.getGroupInfo(0, -2));
            level2.add(this.getGroupInfo(1, -2));
            level2.add(this.getGroupInfo(1, -2));
            level2.add(this.getGroupInfo(2, -2));
            level2.add(this.getGroupInfo(3, -2));
            return lists;
        }
        if (type == 2) {
            List[] lists = new List[3];
            ArrayList level0 = new ArrayList();
            ArrayList level1 = new ArrayList();
            ArrayList level2 = new ArrayList();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            return lists;
        }
        return null;
    }

    private List[] getTest6(int type) {
        if (type == 1) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level1.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(0, -2));
            level2.add(this.getGroupInfo(0, 1));
            level2.add(this.getGroupInfo(1, -2));
            level2.add(this.getGroupInfo(1, -2));
            level2.add(this.getGroupInfo(2, -2));
            level2.add(this.getGroupInfo(3, -2));
            return lists;
        }
        if (type == 2) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level1.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 1));
            return lists;
        }
        return null;
    }

    private List[] getTest7(int type) {
        if (type == 1) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level1.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, 3));
            level2.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(2, 6));
            level2.add(this.getGroupInfo(3, -2));
            return lists;
        }
        if (type == 2) {
            List[] lists = new List[3];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, 3));
            level2.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(2, 6));
            return lists;
        }
        return null;
    }

    private List[] getTest8(int type) {
        if (type == 1) {
            List[] lists = new List[4];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level3 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            lists[3] = level3;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level0.add(this.getGroupInfo(-1, 3));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level1.add(this.getGroupInfo(2, 5));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, 4));
            level2.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(2, 6));
            level2.add(this.getGroupInfo(3, 8));
            level3.add(this.getGroupInfo(0, 0));
            level3.add(this.getGroupInfo(0, 2));
            level3.add(this.getGroupInfo(1, 3));
            level3.add(this.getGroupInfo(1, 5));
            level3.add(this.getGroupInfo(2, 6));
            level3.add(this.getGroupInfo(3, 7));
            level3.add(this.getGroupInfo(4, -2));
            level3.add(this.getGroupInfo(4, -2));
            level3.add(this.getGroupInfo(5, 10));
            return lists;
        }
        if (type == 2) {
            List[] lists = new List[4];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level3 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            lists[3] = level3;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, 4));
            level2.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(2, 6));
            level3.add(this.getGroupInfo(0, 0));
            level3.add(this.getGroupInfo(0, 2));
            level3.add(this.getGroupInfo(1, 3));
            level3.add(this.getGroupInfo(1, 5));
            level3.add(this.getGroupInfo(2, 6));
            level3.add(this.getGroupInfo(3, 7));
            level3.add(this.getGroupInfo(4, 10));
            return lists;
        }
        return null;
    }

    private List[] getTest9(int type) {
        if (type == 1) {
            List[] lists = new List[4];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level3 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            lists[3] = level3;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level0.add(this.getGroupInfo(-1, 3));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level1.add(this.getGroupInfo(2, 5));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 2));
            level2.add(this.getGroupInfo(1, 4));
            level2.add(this.getGroupInfo(1, 5));
            level2.add(this.getGroupInfo(2, 6));
            level2.add(this.getGroupInfo(3, 8));
            level3.add(this.getGroupInfo(0, 0));
            level3.add(this.getGroupInfo(0, -2));
            level3.add(this.getGroupInfo(1, 3));
            level3.add(this.getGroupInfo(1, 5));
            level3.add(this.getGroupInfo(2, 6));
            level3.add(this.getGroupInfo(3, 7));
            level3.add(this.getGroupInfo(4, -2));
            level3.add(this.getGroupInfo(4, -2));
            level3.add(this.getGroupInfo(5, 10));
            return lists;
        }
        if (type == 2) {
            List[] lists = new List[4];
            ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
            ArrayList<GroupInfo> level3 = new ArrayList<GroupInfo>();
            lists[0] = level0;
            lists[1] = level1;
            lists[2] = level2;
            lists[3] = level3;
            level0.add(this.getGroupInfo(-1, 0));
            level0.add(this.getGroupInfo(-1, 2));
            level1.add(this.getGroupInfo(0, 0));
            level1.add(this.getGroupInfo(0, 2));
            level1.add(this.getGroupInfo(1, 4));
            level2.add(this.getGroupInfo(0, 0));
            level2.add(this.getGroupInfo(0, 1));
            level2.add(this.getGroupInfo(1, 3));
            level2.add(this.getGroupInfo(1, 4));
            level2.add(this.getGroupInfo(2, 5));
            level3.add(this.getGroupInfo(0, 0));
            level3.add(this.getGroupInfo(1, 3));
            level3.add(this.getGroupInfo(1, 5));
            level3.add(this.getGroupInfo(2, 6));
            level3.add(this.getGroupInfo(3, 7));
            level3.add(this.getGroupInfo(4, 10));
            return lists;
        }
        return null;
    }

    private boolean twoGroupListArrayEqual(List[] g1, List[] g2) {
        if (g1.length != g2.length) {
            return false;
        }
        int i = 0;
        while (i < g1.length) {
            if (!this.twoListEqual(g1[i], g2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean twoListEqual(List g1, List g2) {
        if (g1.size() != g2.size()) {
            return false;
        }
        int i = 0;
        while (i < g1.size()) {
            GroupInfo info1 = (GroupInfo)g1.get(i);
            GroupInfo info2 = (GroupInfo)g2.get(i);
            if (info1.parent != info2.parent || info1.firstChild != info2.firstChild) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private GroupInfo getGroupInfo(int parent, int child) {
        GroupInfo info = new GroupInfo();
        info.parent = parent;
        info.firstChild = child;
        return info;
    }

    public void testInvalidGroupIndex() throws Exception {
        List[] groups = this.getExampleGroupList();
        int[] nArray = new int[6];
        nArray[1] = 5;
        nArray[2] = 4;
        nArray[3] = 3;
        nArray[4] = 6;
        nArray[5] = 8;
        int[] indexArray = nArray;
        try {
            GroupInfoUtil.getGroupInfo((List[])groups, (int[])indexArray);
            GroupInfoUtilTest.fail((String)"should not get there");
        }
        catch (DataException dataException) {}
    }

    public void testRemoveOneGroupItem() throws Exception {
        List[] groups = this.getExampleGroupList();
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 8;
        int[] indexArray = nArray;
        List[] returnGroups = GroupInfoUtil.getGroupInfo((List[])groups, (int[])indexArray);
        List refactorList = returnGroups[returnGroups.length - 1];
        ArrayList<GroupInfo> expectedList = new ArrayList<GroupInfo>();
        expectedList.add(this.getGroupInfo(0, 0));
        expectedList.add(this.getGroupInfo(0, 1));
        expectedList.add(this.getGroupInfo(1, 2));
        expectedList.add(this.getGroupInfo(1, 3));
        expectedList.add(this.getGroupInfo(2, 4));
        expectedList.add(this.getGroupInfo(3, 5));
        GroupInfoUtilTest.assertTrue((boolean)this.twoListEqual(expectedList, refactorList));
    }

    public void testEntireGroup() throws Exception {
        List[] groups = this.getExampleGroupList();
        int[] nArray = new int[6];
        nArray[1] = 3;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 8;
        int[] indexArray = nArray;
        List[] returnGroups = GroupInfoUtil.getGroupInfo((List[])groups, (int[])indexArray);
        List refactorList = returnGroups[returnGroups.length - 1];
        ArrayList<GroupInfo> expectedList = new ArrayList<GroupInfo>();
        expectedList.add(this.getGroupInfo(0, 0));
        expectedList.add(this.getGroupInfo(0, 1));
        expectedList.add(this.getGroupInfo(1, 3));
        expectedList.add(this.getGroupInfo(2, 4));
        expectedList.add(this.getGroupInfo(3, 5));
        GroupInfoUtilTest.assertTrue((boolean)this.twoListEqual(expectedList, refactorList));
    }

    public void testMultipleEntireGroup() throws Exception {
        List[] groups = this.getExampleGroupList();
        int[] nArray = new int[4];
        nArray[1] = 5;
        nArray[2] = 6;
        nArray[3] = 8;
        int[] indexArray = nArray;
        List[] returnGroups = GroupInfoUtil.getGroupInfo((List[])groups, (int[])indexArray);
        List refactorList = returnGroups[returnGroups.length - 1];
        ArrayList<GroupInfo> expectedList = new ArrayList<GroupInfo>();
        expectedList.add(this.getGroupInfo(0, 0));
        expectedList.add(this.getGroupInfo(0, 1));
        expectedList.add(this.getGroupInfo(1, 2));
        expectedList.add(this.getGroupInfo(2, 3));
        GroupInfoUtilTest.assertTrue((boolean)this.twoListEqual(expectedList, refactorList));
    }

    public void testGetGroupInfo() throws DataException {
        List[] groups = this.getTest0(1);
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 5;
        int[] indexArray = nArray;
        List[] result = GroupInfoUtil.getGroupInfo((List[])groups, (int[])indexArray);
        GroupInfoUtilTest.assertTrue((boolean)this.twoGroupListArrayEqual(result, this.getTest0(2)));
    }

    private List[] getExampleGroupList() {
        ArrayList<GroupInfo> level0 = new ArrayList<GroupInfo>();
        ArrayList<GroupInfo> level1 = new ArrayList<GroupInfo>();
        ArrayList<GroupInfo> level2 = new ArrayList<GroupInfo>();
        level0.add(this.getGroupInfo(-1, 0));
        level0.add(this.getGroupInfo(-1, 2));
        level1.add(this.getGroupInfo(0, 0));
        level1.add(this.getGroupInfo(0, 2));
        level1.add(this.getGroupInfo(1, 4));
        level1.add(this.getGroupInfo(1, 5));
        level2.add(this.getGroupInfo(0, 0));
        level2.add(this.getGroupInfo(0, 2));
        level2.add(this.getGroupInfo(1, 3));
        level2.add(this.getGroupInfo(1, 5));
        level2.add(this.getGroupInfo(2, 6));
        level2.add(this.getGroupInfo(3, 7));
        List[] groups = new List[]{level0, level1, level2};
        return groups;
    }
}

