/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.rd;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public abstract class RDTestCase
extends APITestCase {
    protected DataEngine myGenDataEngine;
    protected DataEngine myPreDataEngine;
    protected DataEngine myPreDataEngine2;
    protected IDocArchiveWriter archiveWriter;
    protected IDocArchiveReader archiveReader;
    protected ScriptableObject scope;
    protected String fileName;
    protected String fileName2;
    private static int index = 0;

    public void setUp() throws Exception {
        super.setUp();
        this.fileName = String.valueOf(this.getOutputPath()) + ((Object)((Object)this)).getClass().getSimpleName() + File.separator + this.getName() + File.separator + "RptDocumentTemp" + File.separator + "testData_" + ++index;
        this.fileName2 = String.valueOf(this.getOutputPath()) + ((Object)((Object)this)).getClass().getSimpleName() + File.separator + this.getName() + File.separator + "RptDocumentTemp" + File.separator + "testData_" + ++index;
        RDTestCase.deleteFile(new File(this.fileName));
        RDTestCase.deleteFile(new File(this.fileName2));
        DataEngineContext deContext1 = this.newContext(1, this.fileName, this.fileName2);
        deContext1.setTmpdir(RDTestCase.getTempDir());
        this.myGenDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext1);
        this.myGenDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        Context context = Context.enter();
        this.scope = context.initStandardObjects();
        Context.exit();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.archiveWriter != null) {
            try {
                this.archiveWriter.finish();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.archiveReader != null) {
            try {
                this.archiveReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.myGenDataEngine != null) {
            this.myGenDataEngine.shutdown();
            this.myGenDataEngine = null;
        }
        if (this.myPreDataEngine != null) {
            this.myPreDataEngine.shutdown();
            this.myPreDataEngine = null;
        }
        if (this.myPreDataEngine2 != null) {
            this.myPreDataEngine2.shutdown();
            this.myPreDataEngine2 = null;
        }
        if (this.fileName != null) {
            RDTestCase.deleteFile(new File(this.fileName));
        }
        if (this.fileName2 != null) {
            RDTestCase.deleteFile(new File(this.fileName));
        }
    }

    protected boolean useFolderArchive() {
        return false;
    }

    private String getOutputPath() {
        return String.valueOf(RDTestCase.getOutputFolder().getAbsolutePath()) + File.separator;
    }

    protected DataEngineContext newContext(int type, String fileName) throws BirtException {
        return this.newContext(type, fileName, null);
    }

    protected DataEngineContext newContext(int type, String fileName, String fileName2) throws BirtException {
        boolean useFolder = this.useFolderArchive();
        switch (type) {
            case 1: {
                try {
                    this.archiveWriter = useFolder ? new FolderArchiveWriter(fileName) : new FileArchiveWriter(fileName);
                    this.archiveWriter.initialize();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                DataEngineContext context = DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)this.archiveWriter);
                context.setTmpdir(RDTestCase.getTempDir());
                return context;
            }
            case 2: {
                try {
                    this.archiveReader = useFolder ? new FolderArchiveReader(fileName) : new FileArchiveReader(fileName);
                    this.archiveReader.open();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                DataEngineContext context = DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)this.archiveReader, null);
                context.setTmpdir(RDTestCase.getTempDir());
                return context;
            }
            case 4: {
                try {
                    this.archiveReader = useFolder ? new FolderArchiveReader(fileName) : new FileArchiveReader(fileName);
                    this.archiveReader.open();
                    this.archiveWriter = useFolder ? new FolderArchiveWriter(fileName2) : new FileArchiveWriter(fileName2);
                    this.archiveWriter.initialize();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                DataEngineContext context = DataEngineContext.newInstance((int)4, null, (IDocArchiveReader)this.archiveReader, (IDocArchiveWriter)this.archiveWriter);
                context.setTmpdir(RDTestCase.getTempDir());
                return context;
            }
        }
        throw new IllegalArgumentException("" + type);
    }

    protected void closeArchiveWriter() throws DataException {
        if (this.archiveWriter != null) {
            try {
                this.archiveWriter.finish();
                this.archiveWriter = null;
            }
            catch (IOException e) {
                throw new DataException("error", (Throwable)e);
            }
        }
    }

    protected void closeArchiveReader() throws DataException {
        if (this.archiveReader != null) {
            try {
                this.archiveReader.close();
                this.archiveReader = null;
            }
            catch (Exception e) {
                throw new DataException("error", (Throwable)e);
            }
        }
    }
}

