/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.rd;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.rd.RDTestCase;
import org.mozilla.javascript.Scriptable;
import testutil.ConfigText;

public class SummaryIVTest
extends RDTestCase {
    private String[] bindingName;
    private String GEN_queryResultID;
    private String UPDATE_queryResultID;

    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBasicFilter() throws Exception {
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasicIV();
        this.closeArchiveReader();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName2);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.updateBasicIVOnFilter();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        this.checkOutputFile();
    }

    public void testBasicSort() throws Exception {
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasicIV();
        this.closeArchiveReader();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName2);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.updateBasicIVOnSort();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        this.checkOutputFile();
    }

    public void testBasicAggregation() throws Exception {
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasicIV();
        this.closeArchiveReader();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName2);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.updateBasicIVOnAggregation();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        this.checkOutputFile();
    }

    private void updateBasicIVOnFilter() throws BirtException {
        IQueryResults qr = null;
        QueryDefinition qd = this.newSummaryQuery();
        qd.setQueryResultsID(this.GEN_queryResultID);
        ConditionalExpression condition = new ConditionalExpression("row[\"SALES\"]", 6, "1000");
        FilterDefinition filter = new FilterDefinition((IBaseExpression)condition);
        ((GroupDefinition)qd.getGroups().get(1)).addFilter((IFilterDefinition)filter);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            int i = 0;
            while (i < this.bindingName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.bindingName[i]) + "  ";
                ++i;
            }
            this.testPrintln(abc);
        }
        this.testPrintln("\n");
        ri.close();
        qr.close();
        this.myPreDataEngine.shutdown();
        this.myPreDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        this.myPreDataEngine = null;
    }

    private void updateBasicIVOnAggregation() throws BirtException {
        IQueryResults qr = null;
        QueryDefinition qd = this.newSummaryQuery();
        qd.setQueryResultsID(this.GEN_queryResultID);
        Binding binding = new Binding("SUM_ON_COUNTRY");
        binding.setExpression((IBaseExpression)new ScriptExpression("row[\"SALES\"]"));
        binding.setAggrFunction("SUM");
        binding.addAggregateOn("countryGroup");
        qd.addBinding((IBinding)binding);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            int i = 0;
            while (i < this.bindingName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.bindingName[i]) + "  ";
                ++i;
            }
            abc = String.valueOf(abc) + ri.getValue("SUM_ON_COUNTRY") + "  ";
            this.testPrintln(abc);
        }
        this.testPrintln("\n");
        ri.close();
        qr.close();
        this.myPreDataEngine.shutdown();
        this.myPreDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        this.myPreDataEngine = null;
    }

    private void updateBasicIVOnSort() throws BirtException {
        IQueryResults qr = null;
        QueryDefinition qd = this.newSummaryQuery();
        qd.setQueryResultsID(this.GEN_queryResultID);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"SALES\"]");
        sort.setSortDirection(0);
        ((GroupDefinition)qd.getGroups().get(1)).addSort(sort);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            int i = 0;
            while (i < this.bindingName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.bindingName[i]) + "  ";
                ++i;
            }
            this.testPrintln(abc);
        }
        this.testPrintln("\n");
        ri.close();
        qr.close();
        this.myPreDataEngine.shutdown();
        this.myPreDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        this.myPreDataEngine = null;
    }

    private void preBasicIV() throws BirtException {
        IQueryResults qr = null;
        QueryDefinition qd = this.newSummaryQuery();
        qd.setQueryResultsID(this.GEN_queryResultID);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        qr = this.myPreDataEngine.getQueryResults(this.UPDATE_queryResultID);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            int i = 0;
            while (i < this.bindingName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.bindingName[i]) + "  ";
                ++i;
            }
            this.testPrintln(abc);
        }
        this.testPrintln("\n");
        ri.close();
        qr.close();
        this.myPreDataEngine.shutdown();
        this.myPreDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        this.myPreDataEngine = null;
    }

    private void genBasicIV() throws BirtException {
        QueryDefinition qd = this.newSummaryQuery();
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.GEN_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            int i = 0;
            while (i < this.bindingName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.bindingName[i]) + "  ";
                ++i;
            }
            this.testPrintln(abc);
        }
        this.testPrintln("\n");
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
        this.myGenDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
    }

    private QueryDefinition newSummaryQuery() throws DataException {
        QueryDefinition qd = this.newReportQuery();
        qd.setIsSummaryQuery(true);
        qd.setUsesDetails(false);
        GroupDefinition gd = new GroupDefinition("countryGroup");
        gd.setKeyColumn("COUNTRY");
        qd.addGroup(gd);
        GroupDefinition gd2 = new GroupDefinition("cityGroup");
        gd2.setKeyColumn("CITY");
        qd.addGroup(gd2);
        this.bindingName = new String[3];
        this.bindingName[0] = "COUNTRY";
        this.bindingName[1] = "CITY";
        this.bindingName[2] = "SALES";
        Binding[] binding = new Binding[]{new Binding(this.bindingName[0], (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY")), new Binding(this.bindingName[1], (IBaseExpression)new ScriptExpression("dataSetRow.CITY")), new Binding(this.bindingName[2])};
        binding[2].setAggrFunction("SUM");
        binding[2].setExpression((IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        binding[2].addAggregateOn("cityGroup");
        qd.addBinding((IBinding)binding[0]);
        qd.addBinding((IBinding)binding[1]);
        qd.addBinding((IBinding)binding[2]);
        return qd;
    }
}

