/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Random;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionTest;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.impl.Blob;
import org.eclipse.datatools.connectivity.oda.impl.Clob;
import org.eclipse.datatools.connectivity.oda.impl.SimpleResultSet;
import org.osgi.framework.Bundle;

public class LargeObjectTest
extends ConnectionTest {
    private static final String DTP_FLATFILE_DATASET_ID = "org.eclipse.datatools.connectivity.oda.flatfile.dataSet";
    private static final String DTP_FLATFILE_DATASOURCE_ID = "org.eclipse.datatools.connectivity.oda.flatfile";
    private static final String BIRT_FLATFILE_DATASOURCE_ID = "org.eclipse.birt.report.data.oda.flatfile";
    private Connection m_flatFileConnection = null;
    private static String sm_pluginFile = null;
    private static String sm_manifestsDir = null;
    private static String sm_pluginFileName = "plugin.xml";
    private static String sm_dtpFlatfileId = "org.eclipse.datatools.connectivity.oda.flatfile";
    private static String sm_birtFlatfileId = "org.eclipse.birt.report.data.oda.flatfile";
    private static boolean sm_pluginTest = Platform.isRunning();

    protected void setUp() throws Exception {
        super.setUp();
        this.setupDirectories();
        TestUtil.createTestFile();
        Properties prop = new Properties();
        prop.setProperty("HOME", "testdatabase");
        prop.setProperty("CHARSET", "UTF-16BE");
        this.m_flatFileConnection = ConnectionManager.getInstance().openConnection(DTP_FLATFILE_DATASOURCE_ID, prop);
    }

    protected void tearDown() throws Exception {
        this.m_flatFileConnection.close();
        super.tearDown();
    }

    public void testJdbc() throws Exception {
        String command = "select * from \"testtable_lob\"";
        PreparedStatement stmt = this.getConnection().prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        LargeObjectTest.assertTrue((boolean)stmt.execute());
        ResultSet resultSet = stmt.getResultSet();
        LargeObjectTest.assertNotNull((Object)resultSet);
        IResultObject resultObject = resultSet.fetch();
        IResultClass resultClass = resultObject.getResultClass();
        LargeObjectTest.assertEquals((int)2, (int)resultClass.getFieldCount());
        String[] names = resultClass.getFieldNames();
        LargeObjectTest.assertEquals((String)"blob1", (String)names[0]);
        LargeObjectTest.assertEquals((String)"clob1", (String)names[1]);
        LargeObjectTest.assertEquals((String)"BLOB", (String)resultClass.getFieldNativeTypeName(1));
        LargeObjectTest.assertEquals((String)"CLOB", (String)resultClass.getFieldNativeTypeName(2));
        LargeObjectTest.assertEquals(IBlob.class, (Object)resultClass.getFieldValueClass(1));
        LargeObjectTest.assertEquals(IClob.class, (Object)resultClass.getFieldValueClass(2));
        Object obj = resultObject.getFieldValue(1);
        LargeObjectTest.assertNull((Object)obj);
        obj = resultObject.getFieldValue(2);
        LargeObjectTest.assertTrue((boolean)(obj instanceof String));
        LargeObjectTest.assertEquals((String)"abcdefg", (String)obj.toString());
        LargeObjectTest.assertEquals((String)"bcd", (String)obj.toString().substring(1, 4));
        stmt.close();
    }

    public void testFlatfileBlob() throws Exception {
        String command = "select blob_col from table1";
        PreparedStatement stmt = this.m_flatFileConnection.prepareStatement(command, DTP_FLATFILE_DATASET_ID);
        LargeObjectTest.assertTrue((boolean)stmt.execute());
        ResultSet resultSet = stmt.getResultSet();
        LargeObjectTest.assertNotNull((Object)resultSet);
        IResultClass resultClass = resultSet.getMetaData();
        LargeObjectTest.assertEquals((int)1, (int)resultClass.getFieldCount());
        String[] names = resultClass.getFieldNames();
        LargeObjectTest.assertEquals((String)"blob_col", (String)names[0]);
        LargeObjectTest.assertEquals((String)"BLOB", (String)resultClass.getFieldNativeTypeName(1));
        LargeObjectTest.assertEquals(String.class, (Object)resultClass.getFieldValueClass(1));
        IResultObject resultObject = resultSet.fetch();
        Object obj = resultObject.getFieldValue(1);
        LargeObjectTest.assertTrue((boolean)(obj instanceof String));
        LargeObjectTest.assertEquals((String)"0123456789", (String)obj.toString());
        stmt.close();
    }

    public void testFlatfileClob() throws Exception {
        String command = "select clob_col from table1";
        PreparedStatement stmt = this.m_flatFileConnection.prepareStatement(command, DTP_FLATFILE_DATASET_ID);
        LargeObjectTest.assertTrue((boolean)stmt.execute());
        ResultSet resultSet = stmt.getResultSet();
        LargeObjectTest.assertNotNull((Object)resultSet);
        IResultObject resultObject = resultSet.fetch();
        IResultClass resultClass = resultObject.getResultClass();
        LargeObjectTest.assertEquals((int)1, (int)resultClass.getFieldCount());
        String[] names = resultClass.getFieldNames();
        LargeObjectTest.assertEquals((String)"clob_col", (String)names[0]);
        LargeObjectTest.assertEquals((String)"CLOB", (String)resultClass.getFieldNativeTypeName(1));
        LargeObjectTest.assertEquals(String.class, (Object)resultClass.getFieldValueClass(1));
        Object obj = resultObject.getFieldValue(1);
        LargeObjectTest.assertTrue((boolean)(obj instanceof String));
        LargeObjectTest.assertEquals((String)"abcdefghijklmnopqrstuvwxyz", (String)obj.toString());
        stmt.close();
    }

    public void testFlatfileGetBlob() throws Exception {
    }

    public void testFlatfileGetClob() throws Exception {
    }

    private void setupDirectories() throws IOException {
        String dataDir;
        if (sm_pluginFile != null && sm_manifestsDir != null) {
            return;
        }
        if (sm_pluginTest) {
            Bundle dataBundle = Platform.getBundle((String)"org.eclipse.birt.data");
            URL url = dataBundle.getEntry("/");
            dataDir = Platform.asLocalURL((URL)url).getPath();
            Bundle driverBundle = Platform.getBundle((String)sm_dtpFlatfileId);
            URL jdbcUrl = driverBundle.getEntry("/");
            sm_pluginFile = String.valueOf(Platform.asLocalURL((URL)jdbcUrl).getPath()) + sm_pluginFileName;
        } else {
            dataDir = ".";
            sm_pluginFile = String.valueOf(dataDir) + "/test/plugins/" + sm_dtpFlatfileId + "/" + sm_pluginFileName;
            System.setProperty("BIRT_HOME", String.valueOf(dataDir) + "/test");
        }
        sm_manifestsDir = String.valueOf(dataDir) + "/test/plugins/" + sm_birtFlatfileId + "/manifests/";
    }

    private class ResultSetLob
    extends ResultSet {
        private IResultClass m_resultClass;

        public ResultSetLob(IResultClass resultClass) {
            super((IResultSet)new SimpleResultSet(), resultClass);
            this.m_resultClass = null;
            this.m_resultClass = resultClass;
        }

        public IResultObject fetch() throws DataException {
            int columnCount = this.m_resultClass.getFieldCount();
            int[] driverPositions = ((ResultClass)this.m_resultClass).getFieldDriverPositions();
            assert (columnCount == driverPositions.length);
            Object[] fields = new Object[columnCount];
            int i = 1;
            while (i <= columnCount) {
                if (!this.m_resultClass.isCustomField(i)) {
                    Class dataType = this.m_resultClass.getFieldValueClass(i);
                    Object colValue = null;
                    if (dataType == IClob.class) {
                        colValue = this.getClob();
                    } else if (dataType == IBlob.class) {
                        colValue = this.getBlob();
                    } else assert (false);
                    fields[i - 1] = colValue;
                }
                ++i;
            }
            ResultObject ret = new ResultObject(this.m_resultClass, fields);
            return ret;
        }

        private Object getBlob() {
            byte[] byArray = new byte[10];
            byArray[1] = 1;
            byArray[2] = 2;
            byArray[3] = 3;
            byArray[4] = 4;
            byArray[5] = 5;
            byArray[6] = 6;
            byArray[7] = 7;
            byArray[8] = 8;
            byArray[9] = 9;
            byte[] bytes = byArray;
            return new Blob(bytes);
        }

        private Object getClob() {
            return new Clob("abcdefghijklmnopqrstuvwxyz");
        }
    }

    private static class TestUtil {
        public static final String CHARSET = "UTF-16BE";
        public static final String CONN_HOME_DIR_PROP = "HOME";
        public static final String CONN_CHARSET = "CHARSET";
        public static final String CONN_INCLTYPELINE = "INCLTYPELINE";

        private TestUtil() {
        }

        public static void createTestFile() throws OdaException {
            TestUtil.createTestFileDirectory();
            TestUtil.createTestFile_test1();
        }

        private static void createTestFileDirectory() throws OdaException {
            File file = new File("testdatabase");
            if (file.exists()) {
                return;
            }
            try {
                file.mkdirs();
            }
            catch (SecurityException e) {
                throw new OdaException(e.getMessage());
            }
        }

        private static void createTestFile_test1() throws OdaException {
            File file = new File("testdatabase" + File.separator + "table1");
            if (file.exists()) {
                return;
            }
            try {
                FileOutputStream fos = new FileOutputStream(file);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CHARSET);
                Random r = new Random();
                String comma = new String(",");
                String endOfLine = new String("\n");
                osw.flush();
                String header = "INT0_COL,DOUBLE0_COL,CLOB_COL,DATE_COL,TIME_COL,TIMESTAMP_COL,BLOB_COL,INT1_COL,DOUBLE1_COL,BIGDECIMAL_COL\n";
                String types = "INT, DOUBLE, CLOB, DATE, TIME, TIMESTAMP, BLOB, INT, DOUBLE, BIGDECIMAL\n";
                osw.write(header);
                osw.write(types);
                int i = 0;
                while (i < 1234) {
                    int j = 0;
                    while (j < 10) {
                        if (j == 0) {
                            osw.write(Integer.toString(i));
                        }
                        if (j == 1 || j == 8) {
                            osw.write(Double.toString(r.nextDouble()));
                        }
                        if (j == 2) {
                            osw.write("abcdefghijklmnopqrstuvwxyz");
                        }
                        if (j == 3) {
                            int year = 1000 + i;
                            int month = i % 12 + 1;
                            int day = i % 28 + 1;
                            String s = String.valueOf(Integer.toString(year)) + "-" + Integer.toString(month) + "-" + Integer.toString(day);
                            osw.write(s);
                        }
                        if (j == 4) {
                            osw.write(Time.valueOf(String.valueOf(i % 24) + ":" + j + ":00").toString());
                        }
                        if (j == 5) {
                            osw.write(Integer.toString(new Timestamp(System.currentTimeMillis()).getNanos()));
                        }
                        if (j == 6) {
                            osw.write(new String("0123456789"));
                        }
                        if (j == 7) {
                            osw.write(Integer.toString(r.nextInt()));
                        }
                        if (j == 9) {
                            osw.write(Double.toString(r.nextDouble()));
                        }
                        if (j < 9) {
                            osw.write(comma);
                        }
                        ++j;
                    }
                    osw.write(endOfLine);
                    ++i;
                }
                osw.close();
            }
            catch (Exception e) {
                throw new OdaException(e.getMessage());
            }
        }
    }
}

