/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Date;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.testutil.OdaTestDriverCase;

public class OutputParametersTest
extends OdaTestDriverCase {
    public void testOutputParamDataTypeMapping() {
        PreparedStatement hostStmt = null;
        Object outParam2Value = null;
        Object outParam3Value = null;
        try {
            hostStmt = this.getOpenedConnection().prepareStatement(null, "1");
            OutputParametersTest.assertTrue((hostStmt != null ? 1 : 0) != 0);
            boolean execStatus = hostStmt.execute();
            OutputParametersTest.assertTrue((boolean)execStatus);
            outParam2Value = hostStmt.getParameterValue(2);
            outParam3Value = hostStmt.getParameterValue(3);
        }
        catch (DataException e1) {
            OutputParametersTest.fail((String)("testOutputParamDataTypeMapping failed: " + e1.toString()));
        }
        OutputParametersTest.assertTrue((outParam2Value != null ? 1 : 0) != 0);
        OutputParametersTest.assertTrue((boolean)(outParam2Value instanceof Date));
        OutputParametersTest.assertTrue((outParam3Value != null ? 1 : 0) != 0);
        OutputParametersTest.assertTrue((boolean)(outParam3Value instanceof String));
    }

    public void testGetParameterByNativeName() throws Exception {
        PreparedStatement hostStmt = null;
        Object outParam1Value = null;
        Object outParam2Value = null;
        Object outParam3Value = null;
        try {
            hostStmt = this.getOpenedConnection().prepareStatement(null, "1");
            OutputParametersTest.assertTrue((hostStmt != null ? 1 : 0) != 0);
            boolean execStatus = hostStmt.execute();
            OutputParametersTest.assertTrue((boolean)execStatus);
            outParam1Value = hostStmt.getParameterValue("myParamNativeName1");
            outParam2Value = hostStmt.getParameterValue("myParamNativeName2");
            outParam3Value = hostStmt.getParameterValue("myParamNativeName3");
        }
        catch (DataException e1) {
            OutputParametersTest.fail((String)("testGetParameterByNativeName failed: " + e1.toString()));
        }
        OutputParametersTest.assertTrue((outParam1Value != null ? 1 : 0) != 0);
        OutputParametersTest.assertTrue((boolean)(outParam1Value instanceof String));
        OutputParametersTest.assertTrue((boolean)((String)outParam1Value).startsWith("myParamNativeName"));
        OutputParametersTest.assertTrue((outParam2Value != null ? 1 : 0) != 0);
        OutputParametersTest.assertTrue((boolean)(outParam2Value instanceof Date));
        OutputParametersTest.assertTrue((outParam3Value != null ? 1 : 0) != 0);
        OutputParametersTest.assertTrue((boolean)(outParam3Value instanceof String));
        OutputParametersTest.assertTrue((boolean)((String)outParam3Value).startsWith("myParamNativeName"));
    }

    public void testGetParameterWithNativeNameInHints() throws Exception {
        PreparedStatement hostStmt = null;
        Object outParam1Value = null;
        Object outParam2Value = null;
        Object outParam3Value = null;
        try {
            hostStmt = this.getOpenedConnection().prepareStatement(null, "1");
            OutputParametersTest.assertTrue((hostStmt != null ? 1 : 0) != 0);
            ParameterHint hint = new ParameterHint("ParamName1", true, false);
            hint.setNativeName("myParamNativeName1");
            hostStmt.addParameterHint(hint);
            hint = new ParameterHint("ParamName2", true, false);
            hint.setNativeName("myParamNativeName2");
            hostStmt.addParameterHint(hint);
            hint = new ParameterHint("ParamName3", true, false);
            hint.setNativeName("myParamNativeName3");
            hostStmt.addParameterHint(hint);
            boolean execStatus = hostStmt.execute();
            OutputParametersTest.assertTrue((boolean)execStatus);
            outParam1Value = hostStmt.getParameterValue("ParamName1");
            outParam2Value = hostStmt.getParameterValue("ParamName2");
            outParam3Value = hostStmt.getParameterValue("ParamName3");
        }
        catch (DataException e1) {
            OutputParametersTest.fail((String)("testGetParameterByNativeName failed: " + e1.toString()));
        }
        OutputParametersTest.assertTrue((outParam1Value != null ? 1 : 0) != 0);
        OutputParametersTest.assertTrue((boolean)(outParam1Value instanceof String));
        OutputParametersTest.assertTrue((boolean)((String)outParam1Value).startsWith("myParamNativeName"));
        OutputParametersTest.assertTrue((outParam2Value != null ? 1 : 0) != 0);
        OutputParametersTest.assertTrue((boolean)(outParam2Value instanceof Date));
        OutputParametersTest.assertTrue((outParam3Value != null ? 1 : 0) != 0);
        OutputParametersTest.assertTrue((boolean)(outParam3Value instanceof String));
        OutputParametersTest.assertTrue((boolean)((String)outParam3Value).startsWith("myParamNativeName"));
    }

    public void testGetParameterWithPositionInHints() throws Exception {
        PreparedStatement hostStmt = null;
        Object outParam3Value = null;
        try {
            hostStmt = this.getOpenedConnection().prepareStatement(null, "1");
            OutputParametersTest.assertTrue((hostStmt != null ? 1 : 0) != 0);
            ParameterHint hint = new ParameterHint("ParamName3", true, false);
            hint.setPosition(3);
            hostStmt.addParameterHint(hint);
            boolean execStatus = hostStmt.execute();
            OutputParametersTest.assertTrue((boolean)execStatus);
            outParam3Value = hostStmt.getParameterValue("ParamName3");
        }
        catch (DataException e1) {
            OutputParametersTest.fail((String)("testGetParameterByNativeName failed: " + e1.toString()));
        }
        OutputParametersTest.assertTrue((outParam3Value != null ? 1 : 0) != 0);
        OutputParametersTest.assertTrue((boolean)(outParam3Value instanceof String));
        OutputParametersTest.assertTrue((boolean)((String)outParam3Value).startsWith("myParamNativeName"));
    }
}

