/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionTest;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odaconsumer.ParameterMetaData;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;

public class ParameterHintTest
extends ConnectionTest {
    private DataResourceHandle resourceHandle = DataResourceHandle.getInstance();

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testNameToPositionInSingleParameterHint() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        ParameterHint hint = new ParameterHint("ParamName", true, false);
        hint.setPosition(1);
        statement.addParameterHint(hint);
        statement.setParameterValue("ParamName", (Object)new Integer(4));
        ParameterHintTest.assertTrue((boolean)statement.execute());
        ResultSet resultset = statement.getResultSet();
        int count = 0;
        while (resultset.fetch() != null) {
            ++count;
        }
        ParameterHintTest.assertEquals((int)1, (int)count);
    }

    public void testNameToPositionInParameterHints() throws Exception {
        String command = "select \"intColumn\" from \"testtable\" where \"intColumn\" = ? OR \"stringColumn\" = ?";
        PreparedStatement statement = this.getConnection().prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        statement.addParameterHint(hint);
        hint = new ParameterHint("ParamName2", true, false);
        hint.setPosition(2);
        statement.addParameterHint(hint);
        statement.setParameterValue("ParamName1", (Object)new Integer(0));
        statement.setParameterValue("ParamName2", (Object)"blah blah blah");
        ParameterHintTest.assertTrue((boolean)statement.execute());
        ResultSet resultset = statement.getResultSet();
        int count = 0;
        while (resultset.fetch() != null) {
            ++count;
        }
        ParameterHintTest.assertEquals((int)2, (int)count);
    }

    public void testValidateParameterHints1() throws Exception {
        try {
            PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
            ParameterHintTest.assertNotNull((Object)statement);
            ParameterHint hint = new ParameterHint("ParamName1", true, false);
            hint.setPosition(1);
            statement.addParameterHint(hint);
            hint = new ParameterHint("ParamName1", true, false);
            hint.setPosition(2);
            statement.addParameterHint(hint);
            ParameterHintTest.fail();
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.SameParamNameForDifferentHints", new Object[]{"ParamName1"});
            ParameterHintTest.assertEquals((String)msg, (String)ex.getMessage());
        }
    }

    public void testValidateInputParameterHints2() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        statement.addParameterHint(hint);
        hint = new ParameterHint("PName1", true, false);
        hint.setPosition(1);
        try {
            statement.addParameterHint(hint);
            ParameterHintTest.fail();
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.DifferentParamNameForSamePosition", new Object[]{"ParamName1", new Integer(1)});
            ParameterHintTest.assertEquals((String)msg, (String)ex.getMessage());
        }
    }

    public void testValidateOutputParameterHints() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        ParameterHint outputHint = new ParameterHint("ParamName1", false, true);
        outputHint.setPosition(2);
        statement.addParameterHint(outputHint);
        ParameterHint hint = new ParameterHint("PName1", true, false);
        hint.setPosition(2);
        try {
            statement.addParameterHint(hint);
            ParameterHintTest.fail();
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.DifferentParamNameForSamePosition", new Object[]{"ParamName1", new Integer(2)});
            ParameterHintTest.assertEquals((String)msg, (String)ex.getMessage());
        }
    }

    public void testValidateInputParameterHintsSucceed() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setNativeName("sameNativeName");
        statement.addParameterHint(hint);
        hint = new ParameterHint("ParamName2", true, false);
        hint.setPosition(2);
        hint.setNativeName("sameNativeName");
        try {
            statement.addParameterHint(hint);
            ParameterHintTest.assertTrue((boolean)true);
        }
        catch (DataException dataException) {
            ParameterHintTest.fail();
        }
    }

    public void testGetParameterMetaData1() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData);
        ParameterHintTest.assertEquals((int)1, (int)parameterMetaData.size());
        for (ParameterMetaData metadata : parameterMetaData) {
            this.checkDefaultMetaData(metadata, 1);
        }
    }

    public void testGetParameterMetaData2() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" < ? AND \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData);
        ParameterHintTest.assertEquals((int)2, (int)parameterMetaData.size());
        Iterator iter = parameterMetaData.iterator();
        int count = 1;
        while (iter.hasNext()) {
            ParameterMetaData metadata = (ParameterMetaData)iter.next();
            this.checkDefaultMetaData(metadata, count++);
        }
    }

    private void checkDefaultMetaData(ParameterMetaData metadata, int index) {
        ParameterHintTest.assertEquals((int)index, (int)metadata.getPosition());
        ParameterHintTest.assertEquals((int)4, (int)metadata.getDataType());
        ParameterHintTest.assertEquals(null, (String)metadata.getName());
        ParameterHintTest.assertEquals(null, (Object)metadata.getDefaultValue());
        ParameterHintTest.assertEquals((String)"INTEGER", (String)metadata.getNativeTypeName());
        ParameterHintTest.assertEquals((int)0, (int)metadata.getScale());
        ParameterHintTest.assertEquals((int)10, (int)metadata.getPrecision());
        ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
        ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
        ParameterHintTest.assertEquals(null, (Object)metadata.isOptional());
        ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
    }

    public void testGetParameterMetaData3() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setNativeName("paramNativeName");
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData1);
        ParameterHintTest.assertNotSame((Object)parameterMetaData, (Object)parameterMetaData1);
        for (ParameterMetaData metadata : parameterMetaData1) {
            ParameterHintTest.assertEquals((int)1, (int)metadata.getPosition());
            ParameterHintTest.assertEquals((int)4, (int)metadata.getDataType());
            ParameterHintTest.assertEquals((String)"ParamName1", (String)metadata.getName());
            ParameterHintTest.assertEquals((String)"paramNativeName", (String)metadata.getNativeName());
            ParameterHintTest.assertEquals(null, (Object)metadata.getDefaultValue());
            ParameterHintTest.assertEquals((String)"INTEGER", (String)metadata.getNativeTypeName());
            ParameterHintTest.assertEquals((int)0, (int)metadata.getScale());
            ParameterHintTest.assertEquals((int)10, (int)metadata.getPrecision());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOptional());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    public void testUnsupportedRuntimeParameterMetaData() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        Collection parameterMetaData = null;
        try {
            parameterMetaData = statement.getParameterMetaData();
        }
        catch (DataException dataException) {}
        ParameterHintTest.assertNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        ParameterHint hint2 = new ParameterHint("ParamName2", true, false);
        hint2.setDataType(Double.class);
        statement.addParameterHint(hint2);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData1);
        Iterator iter = parameterMetaData1.iterator();
        int paramNumInCollection = 1;
        while (iter.hasNext()) {
            ParameterMetaData metadata = (ParameterMetaData)iter.next();
            if (paramNumInCollection++ == 1) {
                ParameterHintTest.assertEquals((int)1, (int)metadata.getPosition());
                ParameterHintTest.assertEquals((int)4, (int)metadata.getDataType());
                ParameterHintTest.assertEquals((String)"ParamName1", (String)metadata.getName());
                ParameterHintTest.assertEquals(null, (Object)metadata.getDefaultValue());
                ParameterHintTest.assertEquals(null, (String)metadata.getNativeTypeName());
                ParameterHintTest.assertEquals((int)-1, (int)metadata.getScale());
                ParameterHintTest.assertEquals((int)-1, (int)metadata.getPrecision());
                ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
                ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
                ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOptional());
                ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
                continue;
            }
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getPosition());
            ParameterHintTest.assertEquals((int)8, (int)metadata.getDataType());
            ParameterHintTest.assertEquals((String)"ParamName2", (String)metadata.getName());
            ParameterHintTest.assertEquals(null, (Object)metadata.getDefaultValue());
            ParameterHintTest.assertEquals(null, (String)metadata.getNativeTypeName());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getScale());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getPrecision());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    public void testMultipleHintsOnSameParameterName() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        Collection parameterMetaData = null;
        try {
            parameterMetaData = statement.getParameterMetaData();
        }
        catch (DataException dataException) {}
        ParameterHintTest.assertNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setNativeName("paramNativeName1");
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        ParameterHint hint2 = new ParameterHint("ParamName2", false, true);
        hint2.setDataType(Double.class);
        statement.addParameterHint(hint2);
        ParameterHint hint3 = new ParameterHint("ParamName1", false, true);
        hint3.setNativeName("paramNativeName3");
        statement.addParameterHint(hint3);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData1);
        Iterator iter = parameterMetaData1.iterator();
        int paramNumInCollection = 1;
        while (iter.hasNext()) {
            ParameterMetaData metadata = (ParameterMetaData)iter.next();
            if (paramNumInCollection++ == 1) {
                ParameterHintTest.assertEquals((int)1, (int)metadata.getPosition());
                ParameterHintTest.assertEquals((int)4, (int)metadata.getDataType());
                ParameterHintTest.assertEquals((String)"ParamName1", (String)metadata.getName());
                ParameterHintTest.assertEquals((String)"paramNativeName3", (String)metadata.getNativeName());
                ParameterHintTest.assertEquals(null, (Object)metadata.getDefaultValue());
                ParameterHintTest.assertEquals(null, (String)metadata.getNativeTypeName());
                ParameterHintTest.assertEquals((int)-1, (int)metadata.getScale());
                ParameterHintTest.assertEquals((int)-1, (int)metadata.getPrecision());
                ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isInputMode());
                ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOutputMode());
                ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
                ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
                continue;
            }
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getPosition());
            ParameterHintTest.assertEquals((int)8, (int)metadata.getDataType());
            ParameterHintTest.assertEquals((String)"ParamName2", (String)metadata.getName());
            ParameterHintTest.assertEquals(null, (Object)metadata.getDefaultValue());
            ParameterHintTest.assertEquals(null, (String)metadata.getNativeTypeName());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getScale());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getPrecision());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isInputMode());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOutputMode());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    public void testUnsupportedRuntimeParameterMetaData2() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        Collection parameterMetaData = null;
        try {
            parameterMetaData = statement.getParameterMetaData();
        }
        catch (DataException dataException) {}
        ParameterHintTest.assertNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        hint.setDefaultInputValue((Object)"123");
        statement.addParameterHint(hint);
        ParameterHint hint2 = new ParameterHint("ParamName2", true, false);
        hint2.setDataType(Double.class);
        hint2.setDefaultInputValue((Object)"456");
        statement.addParameterHint(hint2);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData1);
        Iterator iter = parameterMetaData1.iterator();
        int paramNumInCollection = 1;
        while (iter.hasNext()) {
            ParameterMetaData metadata = (ParameterMetaData)iter.next();
            if (paramNumInCollection++ == 1) {
                ParameterHintTest.assertEquals((int)1, (int)metadata.getPosition());
                ParameterHintTest.assertEquals((int)4, (int)metadata.getDataType());
                ParameterHintTest.assertEquals((String)"ParamName1", (String)metadata.getName());
                ParameterHintTest.assertEquals((Object)"123", (Object)metadata.getDefaultValue());
                ParameterHintTest.assertEquals(null, (String)metadata.getNativeTypeName());
                ParameterHintTest.assertEquals((int)-1, (int)metadata.getScale());
                ParameterHintTest.assertEquals((int)-1, (int)metadata.getPrecision());
                ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
                ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
                ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOptional());
                ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
                continue;
            }
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getPosition());
            ParameterHintTest.assertEquals((int)8, (int)metadata.getDataType());
            ParameterHintTest.assertEquals((String)"ParamName2", (String)metadata.getName());
            ParameterHintTest.assertEquals((Object)"456", (Object)metadata.getDefaultValue());
            ParameterHintTest.assertEquals(null, (String)metadata.getNativeTypeName());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getScale());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getPrecision());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    public void testUnsupportedParameterDataTypes() throws Exception {
        ParameterHint inputHint = new ParameterHint("InputParameter", true, true);
        boolean isErrorCaught = false;
        try {
            inputHint.setDataType(IBlob.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            isErrorCaught = true;
        }
        ParameterHintTest.assertTrue((boolean)isErrorCaught);
        isErrorCaught = false;
        try {
            inputHint.setDataType(IClob.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            isErrorCaught = true;
        }
        ParameterHintTest.assertTrue((boolean)isErrorCaught);
    }

    public void testMergeParamHints() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        ParameterHint outputHint = new ParameterHint("ParamName1", false, true);
        outputHint.setPosition(1);
        outputHint.setDataType(Integer.class);
        statement.addParameterHint(outputHint);
        Collection parameterMetaData = statement.getParameterMetaData();
        ParameterHintTest.assertTrue((parameterMetaData != null && parameterMetaData.size() == 1 ? 1 : 0) != 0);
        for (ParameterMetaData metadata : parameterMetaData) {
            ParameterHintTest.assertEquals((int)1, (int)metadata.getPosition());
            ParameterHintTest.assertEquals((int)4, (int)metadata.getDataType());
            ParameterHintTest.assertEquals((String)"ParamName1", (String)metadata.getName());
            ParameterHintTest.assertEquals(null, (Object)metadata.getDefaultValue());
            ParameterHintTest.assertEquals(null, (String)metadata.getNativeTypeName());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getScale());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getPrecision());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isInputMode());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOutputMode());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    public void testMergeParamHints1() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setNativeName("paramNativeName");
        hint.setDataType(Integer.class);
        statement.addParameterHint(hint);
        Collection parameterMetaData = statement.getParameterMetaData();
        ParameterHintTest.assertTrue((parameterMetaData != null && parameterMetaData.size() == 1 ? 1 : 0) != 0);
        for (ParameterMetaData metadata : parameterMetaData) {
            ParameterHintTest.assertEquals((int)1, (int)metadata.getPosition());
            ParameterHintTest.assertEquals((int)4, (int)metadata.getDataType());
            ParameterHintTest.assertEquals((String)"ParamName1", (String)metadata.getName());
            ParameterHintTest.assertEquals((String)"paramNativeName", (String)metadata.getNativeName());
            ParameterHintTest.assertEquals(null, (Object)metadata.getDefaultValue());
            ParameterHintTest.assertEquals(null, (String)metadata.getNativeTypeName());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getScale());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getPrecision());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    public void testConflictingParamHints() throws Exception {
        try {
            Connection connection = this.getMySqlConnection();
            PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
            ParameterHint hint = new ParameterHint("ParamName1", true, false);
            hint.setPosition(1);
            hint.setDataType(Integer.class);
            hint.setIsInputOptional(false);
            statement.addParameterHint(hint);
            ParameterHint outputHint = new ParameterHint("ParamName1", false, true);
            outputHint.setPosition(2);
            outputHint.setDataType(Integer.class);
            statement.addParameterHint(outputHint);
            ParameterHintTest.fail();
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.SameParamNameForDifferentHints", new Object[]{"ParamName1"});
            ParameterHintTest.assertEquals((String)msg, (String)ex.getMessage());
        }
    }

    public void testMergeParamHints3() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        ParameterHint outputHint = new ParameterHint("ParamName1", false, true);
        outputHint.setDataType(Double.class);
        statement.addParameterHint(outputHint);
        Collection parameterMetaData = statement.getParameterMetaData();
        ParameterHintTest.assertTrue((parameterMetaData != null && parameterMetaData.size() == 1 ? 1 : 0) != 0);
        for (ParameterMetaData metadata : parameterMetaData) {
            ParameterHintTest.assertEquals((int)1, (int)metadata.getPosition());
            ParameterHintTest.assertEquals((int)8, (int)metadata.getDataType());
            ParameterHintTest.assertEquals((String)"ParamName1", (String)metadata.getName());
            ParameterHintTest.assertEquals(null, (Object)metadata.getDefaultValue());
            ParameterHintTest.assertEquals(null, (String)metadata.getNativeTypeName());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getScale());
            ParameterHintTest.assertEquals((int)-1, (int)metadata.getPrecision());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isInputMode());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOutputMode());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    public void testMergeParamHintsWithRuntimeMd() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setNativeName("myParam1");
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData1);
        ParameterHintTest.assertNotSame((Object)parameterMetaData, (Object)parameterMetaData1);
        for (ParameterMetaData metadata : parameterMetaData1) {
            ParameterHintTest.assertEquals((int)1, (int)metadata.getPosition());
            ParameterHintTest.assertEquals((int)4, (int)metadata.getDataType());
            ParameterHintTest.assertEquals((String)"ParamName1", (String)metadata.getName());
            ParameterHintTest.assertEquals((String)"myParam1", (String)metadata.getNativeName());
            ParameterHintTest.assertEquals(null, (Object)metadata.getDefaultValue());
            ParameterHintTest.assertEquals((String)"INTEGER", (String)metadata.getNativeTypeName());
            ParameterHintTest.assertEquals((int)0, (int)metadata.getScale());
            ParameterHintTest.assertEquals((int)10, (int)metadata.getPrecision());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOptional());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    public void testMergeParamHintsWithDefaultValue() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        hint.setDefaultInputValue((Object)"123");
        statement.addParameterHint(hint);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData1);
        ParameterHintTest.assertNotSame((Object)parameterMetaData, (Object)parameterMetaData1);
        for (ParameterMetaData metadata : parameterMetaData1) {
            ParameterHintTest.assertEquals((int)1, (int)metadata.getPosition());
            ParameterHintTest.assertEquals((int)4, (int)metadata.getDataType());
            ParameterHintTest.assertEquals((String)"ParamName1", (String)metadata.getName());
            ParameterHintTest.assertEquals((Object)"123", (Object)metadata.getDefaultValue());
            ParameterHintTest.assertEquals((String)"INTEGER", (String)metadata.getNativeTypeName());
            ParameterHintTest.assertEquals((int)0, (int)metadata.getScale());
            ParameterHintTest.assertEquals((int)10, (int)metadata.getPrecision());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            ParameterHintTest.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOptional());
            ParameterHintTest.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    public void testMergeParamHintOnLOB() throws Exception {
        String queryText = "select * from \"testtable_lob\" where \"clob1\" like ? ";
        PreparedStatement statement = this.getConnection().prepareStatement(queryText, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHintTest.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("OutParam", false, true);
        hint.setPosition(1);
        hint.setDataType(IClob.class);
        statement.addParameterHint(hint);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        ParameterHintTest.assertNotNull((Object)parameterMetaData1);
        ParameterHintTest.assertNotSame((Object)parameterMetaData, (Object)parameterMetaData1);
        for (ParameterMetaData metadata : parameterMetaData1) {
            ParameterHintTest.assertEquals((int)1, (int)metadata.getPosition());
            ParameterHintTest.assertEquals((String)"OutParam", (String)metadata.getName());
            ParameterHintTest.assertEquals((int)2005, (int)metadata.getDataType());
        }
        statement.close();
    }
}

