/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer.testdriver;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.data.engine.odaconsumer.testdriver.TestParamMetaDataImpl;
import org.eclipse.birt.data.engine.odaconsumer.testdriver.TestResultSetImpl;
import org.eclipse.birt.data.engine.odaconsumer.testdriver.TestResultSetMetaDataImpl;
import org.eclipse.datatools.connectivity.oda.IAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IParameterRowSet;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class TestAdvQueryImpl
implements IAdvancedQuery {
    public static final String TEST_CASE_OUTPUTPARAM = "1";
    public static final String TEST_CASE_IN_PARAM_NAME = "2";
    public static final String TEST_CASE_SEQ_RESULT_SETS = "3";
    public static final String TEST_CASE_NAMED_RESULT_SETS = "4";
    public static final int MAX_RESULT_SETS = 3;
    private Object m_appContext;
    private boolean m_isPrepareCalled = false;
    private IParameterMetaData m_paramMetaData;
    private int m_currentTestCase = 0;
    private int m_currentResultSet = 1;
    private boolean m_hasExecuted = false;

    public TestAdvQueryImpl(int testCaseId) {
        this.m_currentTestCase = testCaseId;
    }

    public void prepare(String queryText) throws OdaException {
        this.m_isPrepareCalled = true;
    }

    public void setAppContext(Object context) throws OdaException {
        if (this.m_isPrepareCalled) {
            throw new OdaException("Error: setAppContext should have been called *before* IQuery.prepare.");
        }
        this.m_appContext = context;
    }

    public Object getAppContext() {
        return this.m_appContext;
    }

    public void setProperty(String name, String value) throws OdaException {
    }

    public void close() throws OdaException {
    }

    public void setMaxRows(int max) throws OdaException {
    }

    public int getMaxRows() throws OdaException {
        return 0;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return new TestResultSetMetaDataImpl();
    }

    public IResultSet executeQuery() throws OdaException {
        this.m_hasExecuted = true;
        return this.getResultSet();
    }

    public void clearInParameters() throws OdaException {
    }

    public void setInt(String parameterName, int value) throws OdaException {
    }

    public void setInt(int parameterId, int value) throws OdaException {
    }

    public void setDouble(String parameterName, double value) throws OdaException {
    }

    public void setDouble(int parameterId, double value) throws OdaException {
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
    }

    public void setString(String parameterName, String value) throws OdaException {
        if (this.m_currentTestCase == 2 && (parameterName.endsWith(TEST_CASE_OUTPUTPARAM) ? !value.equals("stringValue") : parameterName.endsWith(TEST_CASE_SEQ_RESULT_SETS) && !value.equals("true"))) {
            throw new OdaException("Error in setString by name with value: " + value);
        }
    }

    public void setString(int parameterId, String value) throws OdaException {
        if (this.m_currentTestCase == 2) {
            throw new UnsupportedOperationException("Unable to setString by index");
        }
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        if (this.m_currentTestCase == 2 && parameterName.endsWith(TEST_CASE_IN_PARAM_NAME) && !value.equals(Date.valueOf("2005-11-13"))) {
            throw new OdaException("Error in setDate by name");
        }
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        if (this.m_currentTestCase == 2) {
            throw new UnsupportedOperationException("Unable to setDate by index");
        }
    }

    public void setTime(String parameterName, Time value) throws OdaException {
    }

    public void setTime(int parameterId, Time value) throws OdaException {
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        if (this.m_currentTestCase == 2) {
            throw new UnsupportedOperationException("Unable to setBoolean by name");
        }
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        if (this.m_currentTestCase == 2) {
            throw new OdaException("Unable to setBoolean by index");
        }
    }

    public void setNull(String parameterName) throws OdaException {
    }

    public void setNull(int parameterId) throws OdaException {
    }

    public int findInParameter(String parameterName) throws OdaException {
        if (this.m_currentTestCase == 1) {
            throw new UnsupportedOperationException();
        }
        throw new OdaException("Bad test case");
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        if (this.m_paramMetaData == null) {
            this.m_paramMetaData = new TestParamMetaDataImpl(this.m_currentTestCase);
        }
        return this.m_paramMetaData;
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public boolean execute() throws OdaException {
        this.m_hasExecuted = true;
        return this.m_hasExecuted;
    }

    public int findOutParameter(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int parameterId) throws OdaException {
        this.validateOutputParamId(parameterId);
        if (this.m_currentTestCase == 1 && parameterId == 2) {
            return Date.valueOf("2005-11-13");
        }
        return null;
    }

    public Date getDate(String parameterName) throws OdaException {
        if (this.m_currentTestCase == 1 && parameterName.endsWith(TEST_CASE_IN_PARAM_NAME)) {
            return Date.valueOf("2005-11-13");
        }
        throw new UnsupportedOperationException();
    }

    public double getDouble(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int getInt(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int getInt(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IResultSetMetaData getMetaDataOf(String resultSetName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getMoreResults() throws OdaException {
        if (this.m_currentTestCase == 3) {
            if (!this.m_hasExecuted) {
                throw new OdaException("Illegal sequence; cannot getMoreResults before having executed.");
            }
            if (this.m_currentResultSet + 1 <= 3) {
                ++this.m_currentResultSet;
                return true;
            }
        }
        return false;
    }

    public IResultSet getResultSet() throws OdaException {
        if (this.m_hasExecuted) {
            return new TestResultSetImpl(true, new TestResultSetMetaDataImpl());
        }
        throw new OdaException("Illegal sequence; cannot getResultSet before having executed.");
    }

    public IResultSet getResultSet(String resultSetName) throws OdaException {
        if (this.m_hasExecuted) {
            return new TestResultSetImpl(true, new TestResultSetMetaDataImpl());
        }
        throw new OdaException("Illegal sequence; cannot getResultSet(String) before having executed.");
    }

    public String[] getResultSetNames() throws OdaException {
        return new String[]{"set1", "set2"};
    }

    public IParameterRowSet getRow(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IParameterRowSet getRow(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec(String resultSetName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public String getString(int parameterId) throws OdaException {
        this.validateOutputParamId(parameterId);
        if (this.m_currentTestCase == 1) {
            if (parameterId == 1 && this.getAppContext() != null) {
                return this.getAppContext().toString();
            }
            if (parameterId == 3) {
                return "parameter 3 value as a String";
            }
        }
        return null;
    }

    private IParameterMetaData validateParamId(int parameterId) throws OdaException {
        IParameterMetaData paramMD = this.getParameterMetaData();
        if (paramMD == null) {
            throw new OdaException("Problem with getting query's paramter meta-data.");
        }
        if (parameterId > paramMD.getParameterCount()) {
            throw new OdaException("Given paramter id does not match parameter meta-data.");
        }
        return paramMD;
    }

    private void validateOutputParamId(int parameterId) throws OdaException {
        IParameterMetaData paramMD = this.validateParamId(parameterId);
        if (paramMD.getParameterMode(parameterId) == 1) {
            throw new OdaException("Given paramter id is not an output parameter.");
        }
    }

    public String getString(String parameterName) throws OdaException {
        if (this.m_currentTestCase == 1) {
            return String.valueOf(parameterName) + " value as a String";
        }
        throw new UnsupportedOperationException();
    }

    public Time getTime(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IParameterRowSet setNewRow(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IParameterRowSet setNewRow(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IParameterRowSet setNewRowSet(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IParameterRowSet setNewRowSet(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setSortSpec(String resultSetName, SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean wasNull() throws OdaException {
        return false;
    }

    public Object getObject(String parameterName) throws OdaException {
        return null;
    }

    public Object getObject(int parameterId) throws OdaException {
        return null;
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
    }

    public String getEffectiveQueryText() {
        return null;
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public void setObject(String parameterName, Object value) throws OdaException {
    }

    public void setObject(int parameterId, Object value) throws OdaException {
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
    }
}

