/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer.testdriver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class TestData {
    private static final double BIG_DECIMAL_DATA = 1.23456789012E9;
    private static final String CLOB_DATA = "abcdefghijklmnopqrstuvwxyz";
    private static final String STRING_DATA = "String data";
    private static final double DOUBLE_DATA = 123.4567890123;
    private static final int INT_DATA = Integer.MAX_VALUE;
    private static final long TIME_DATA = 1162377030L;
    private static final long TIMESTAMP_DATA = 1162463430L;
    private static final long DATE_DATA = 1162512000L;

    public static final boolean createBooleanTrueData() {
        return true;
    }

    public static final boolean createBooleanFalseData() {
        return false;
    }

    public static final BigDecimal createBigDecimalData() {
        return new BigDecimal(1.23456789012E9);
    }

    public static final String createClobDataString() {
        return CLOB_DATA;
    }

    public static final String createStringData() {
        return STRING_DATA;
    }

    public static final double createDoubleData() {
        return 123.4567890123;
    }

    public static final int createIntData() {
        return Integer.MAX_VALUE;
    }

    public static final Time createTimeData() {
        return new Time(1162377030L);
    }

    public static final Timestamp createTimestampData() {
        return new Timestamp(1162463430L);
    }

    public static final Date createDateData() {
        return new Date(1162512000L);
    }

    public static boolean checkBlobData(IBlob val1, IBlob val2) throws OdaException {
        if (val1 == val2) {
            return true;
        }
        try {
            InputStream is1 = val1.getBinaryStream();
            is1.reset();
            InputStream is2 = val2.getBinaryStream();
            is2.reset();
            return TestData.streamsContentEqual(is1, is2);
        }
        catch (IOException e) {
            throw new OdaException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean streamsContentEqual(InputStream is1, InputStream is2) throws OdaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [28[DOLOOP]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean checkClobData(IClob val, String clobData) throws OdaException {
        String valStr = TestData.getClobDataAsString(val);
        if (valStr == null) {
            return clobData == null;
        }
        return valStr.equals(clobData);
    }

    public static boolean checkClobData(IClob val1, IClob val2) throws OdaException {
        String val2Str = TestData.getClobDataAsString(val2);
        return TestData.checkClobData(val1, val2Str);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getClobDataAsString(IClob val) throws OdaException {
        if (val == null) {
            return null;
        }
        Reader is = val.getCharacterStream();
        if (is == null) {
            return null;
        }
        try {
            String outStr = "";
            int index = 0;
            while (true) {
                int c;
                if ((c = is.read()) == -1) {
                    String string = outStr;
                    return string;
                }
                outStr = String.valueOf(outStr) + (char)c;
                ++index;
                continue;
                break;
            }
        }
        catch (IOException ex) {
            throw new OdaException((Throwable)ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new OdaException((Throwable)e);
            }
        }
    }
}

