/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.api;

import java.util.ArrayList;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.olap.api.DrilledCube;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;
import testutil.BaseTestCase;

public class CubeDrillFeatureTest
extends BaseTestCase {
    private static final String cubeName = "DrilledCube";

    public void testBasicDrillUpOperation() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = rowEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("COUNTRY");
        hier1.createLevel("STATE");
        hier1.createLevel("CITY");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("YEAR");
        hier2.createLevel("QUARTER");
        hier2.createLevel("MONTH");
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition dim3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension3");
        hier3.createLevel("PRODUCTLINE");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("binding1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"COUNTRY\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("binding2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"STATE\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("binding3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"CITY\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("binding4");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"YEAR\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("binding5");
        binding5.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"QUARTER\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("binding6");
        binding6.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"MONTH\"]"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("binding7");
        binding7.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension3\"][\"PRODUCTLINE\"]"));
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("measure1");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding8);
        IEdgeDrillFilter filter = rowEdge.createDrillFilter("drill1");
        filter.setTargetHierarchy(hier1);
        filter.setTargetLevelName("COUNTRY");
        ArrayList<Object[]> memberList = new ArrayList<Object[]>();
        memberList.add(new Object[]{"CHINA"});
        memberList.add(null);
        memberList.add(null);
        filter.setTuple(memberList);
        IEdgeDrillFilter filter2 = rowEdge.createDrillFilter("drill2");
        filter2.setTargetHierarchy(hier1);
        filter2.setTargetLevelName("STATE");
        memberList = new ArrayList();
        memberList.add(new Object[]{"USA"});
        memberList.add(new Object[]{"STATE5", "STATE7", "STATE6"});
        filter2.setTuple(memberList);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        DrilledCube cube = new DrilledCube();
        cube.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("binding1");
        rowEdgeBindingNames.add("binding2");
        rowEdgeBindingNames.add("binding3");
        rowEdgeBindingNames.add("binding4");
        rowEdgeBindingNames.add("binding5");
        rowEdgeBindingNames.add("binding6");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("binding7");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", null, null, null, null);
        engine.shutdown();
    }

    public void testBasicDrillOperation2() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = rowEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("COUNTRY");
        hier1.createLevel("STATE");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("YEAR");
        hier2.createLevel("QUARTER");
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition dim3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension3");
        hier3.createLevel("PRODUCTLINE");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("binding1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"COUNTRY\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("binding2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"STATE\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("binding4");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"YEAR\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("binding5");
        binding5.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"QUARTER\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding7 = new Binding("binding7");
        binding7.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension3\"][\"PRODUCTLINE\"]"));
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("measure1");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding8);
        IEdgeDrillFilter filter = rowEdge.createDrillFilter("drill1");
        filter.setTargetHierarchy(hier1);
        filter.setTargetLevelName("COUNTRY");
        ArrayList<Object[]> memberList = new ArrayList<Object[]>();
        memberList.add(new Object[]{"USA", "CHINA", "FRANCE"});
        filter.setTuple(memberList);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        DrilledCube cube = new DrilledCube();
        cube.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("binding1");
        rowEdgeBindingNames.add("binding2");
        rowEdgeBindingNames.add("binding4");
        rowEdgeBindingNames.add("binding5");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("binding7");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", null, null, null, null);
        engine.shutdown();
    }

    public void testBasicDrillUpOperation3() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = rowEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("COUNTRY");
        hier1.createLevel("STATE");
        hier1.createLevel("CITY");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("YEAR");
        hier2.createLevel("QUARTER");
        hier2.createLevel("MONTH");
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition dim3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension3");
        hier3.createLevel("PRODUCTLINE");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("binding1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"COUNTRY\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("binding2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"STATE\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("binding3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"CITY\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("binding4");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"YEAR\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("binding5");
        binding5.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"QUARTER\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("binding6");
        binding6.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"MONTH\"]"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("binding7");
        binding7.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension3\"][\"PRODUCTLINE\"]"));
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("measure1");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding8);
        IEdgeDrillFilter filter = rowEdge.createDrillFilter("drill1");
        filter.setTargetHierarchy(hier2);
        filter.setTargetLevelName("YEAR");
        ArrayList<Object[]> memberList = new ArrayList<Object[]>();
        memberList.add(new Object[]{"2003"});
        memberList.add(null);
        memberList.add(null);
        filter.setTuple(memberList);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        DrilledCube cube = new DrilledCube();
        cube.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("binding1");
        rowEdgeBindingNames.add("binding2");
        rowEdgeBindingNames.add("binding3");
        rowEdgeBindingNames.add("binding4");
        rowEdgeBindingNames.add("binding5");
        rowEdgeBindingNames.add("binding6");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("binding7");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", null, null, null, null);
        engine.shutdown();
    }

    public void testBasicDrillUpOperation4() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = rowEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("COUNTRY");
        hier1.createLevel("STATE");
        hier1.createLevel("CITY");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("YEAR");
        hier2.createLevel("QUARTER");
        hier2.createLevel("MONTH");
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition dim3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension3");
        hier3.createLevel("PRODUCTLINE");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("binding1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"COUNTRY\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("binding2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"STATE\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("binding3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"CITY\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("binding4");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"YEAR\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("binding5");
        binding5.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"QUARTER\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("binding6");
        binding6.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"MONTH\"]"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("binding7");
        binding7.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension3\"][\"PRODUCTLINE\"]"));
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("measure1");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding8);
        IEdgeDrillFilter filter1 = rowEdge.createDrillFilter("drill2");
        filter1.setTargetHierarchy(hier1);
        filter1.setTargetLevelName("COUNTRY");
        ArrayList<Object[]> memberList = new ArrayList<Object[]>();
        memberList.add(new Object[]{"USA", "CHINA"});
        filter1.setTuple(memberList);
        IEdgeDrillFilter filter = rowEdge.createDrillFilter("drill1");
        filter.setTargetHierarchy(hier2);
        filter.setTargetLevelName("YEAR");
        memberList = new ArrayList();
        memberList.add(new Object[]{"2003"});
        memberList.add(null);
        memberList.add(null);
        filter.setTuple(memberList);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        DrilledCube cube = new DrilledCube();
        cube.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("binding1");
        rowEdgeBindingNames.add("binding2");
        rowEdgeBindingNames.add("binding3");
        rowEdgeBindingNames.add("binding4");
        rowEdgeBindingNames.add("binding5");
        rowEdgeBindingNames.add("binding6");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("binding7");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", null, null, null, null);
        engine.shutdown();
    }

    public void testBasicDrillOperation5() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = rowEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("COUNTRY");
        hier1.createLevel("STATE");
        hier1.createLevel("CITY");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("YEAR");
        hier2.createLevel("QUARTER");
        hier2.createLevel("MONTH");
        IDimensionDefinition dim3 = rowEdge.createDimension("dimension3");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension3");
        hier3.createLevel("PRODUCTLINE");
        hier3.createLevel("PRODUCTTYPE");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("binding1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"COUNTRY\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("binding2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"STATE\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("binding3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"CITY\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("binding4");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"YEAR\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("binding5");
        binding5.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"QUARTER\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("binding6");
        binding6.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"MONTH\"]"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("binding7");
        binding7.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension3\"][\"PRODUCTLINE\"]"));
        cqd.addBinding((IBinding)binding7);
        Binding binding9 = new Binding("binding8");
        binding9.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension3\"][\"PRODUCTTYPE\"]"));
        cqd.addBinding((IBinding)binding9);
        Binding binding8 = new Binding("measure1");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding8);
        IEdgeDrillFilter filter1 = rowEdge.createDrillFilter("drill2");
        filter1.setTargetHierarchy(hier1);
        filter1.setTargetLevelName("COUNTRY");
        ArrayList<Object[]> memberList = new ArrayList<Object[]>();
        memberList.add(new Object[]{"USA", "CHINA"});
        filter1.setTuple(memberList);
        IEdgeDrillFilter filter = rowEdge.createDrillFilter("drill1");
        filter.setTargetHierarchy(hier2);
        filter.setTargetLevelName("YEAR");
        memberList = new ArrayList();
        memberList.add(new Object[]{"2003"});
        memberList.add(null);
        memberList.add(null);
        filter.setTuple(memberList);
        IEdgeDrillFilter filter2 = rowEdge.createDrillFilter("drill13");
        filter2.setTargetHierarchy(hier3);
        filter2.setTargetLevelName("PRODUCTLINE");
        memberList = new ArrayList();
        memberList.add(new Object[]{"CAR", "PLANE"});
        memberList.add(null);
        memberList.add(null);
        filter2.setTuple(memberList);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        DrilledCube cube = new DrilledCube();
        cube.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("binding1");
        rowEdgeBindingNames.add("binding2");
        rowEdgeBindingNames.add("binding3");
        rowEdgeBindingNames.add("binding4");
        rowEdgeBindingNames.add("binding5");
        rowEdgeBindingNames.add("binding6");
        rowEdgeBindingNames.add("binding7");
        rowEdgeBindingNames.add("binding8");
        ArrayList columnEdgeBindingNames = new ArrayList();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", null, null, null, null);
        engine.shutdown();
    }

    public void testBasicDrillOperation6() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = rowEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("COUNTRY");
        hier1.createLevel("STATE");
        hier1.createLevel("CITY");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("YEAR");
        hier2.createLevel("QUARTER");
        hier2.createLevel("MONTH");
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition dim3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension3");
        hier3.createLevel("PRODUCTLINE");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("binding1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"COUNTRY\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("binding2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"STATE\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("binding3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"CITY\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("binding4");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"YEAR\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("binding5");
        binding5.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"QUARTER\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("binding6");
        binding6.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"MONTH\"]"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("binding7");
        binding7.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension3\"][\"PRODUCTLINE\"]"));
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("measure1");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding8);
        Binding binding9 = new Binding("total1");
        binding9.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding9.addAggregateOn("dimension[\"dimension1\"][\"COUNTRY\"]");
        binding9.addAggregateOn("dimension[\"dimension1\"][\"STATE\"]");
        binding9.addAggregateOn("dimension[\"dimension1\"][\"CITY\"]");
        binding9.addAggregateOn("dimension[\"dimension2\"][\"YEAR\"]");
        binding9.addAggregateOn("dimension[\"dimension2\"][\"QUARTER\"]");
        binding9.addAggregateOn("dimension[\"dimension2\"][\"MONTH\"]");
        binding9.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding9);
        Binding binding10 = new Binding("total2");
        binding10.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding10.addAggregateOn("dimension[\"dimension3\"][\"PRODUCTLINE\"]");
        binding10.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding10);
        Binding binding11 = new Binding("grandTotal1");
        binding11.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding11.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding11);
        IEdgeDrillFilter filter1 = rowEdge.createDrillFilter("drill2");
        filter1.setTargetHierarchy(hier1);
        filter1.setTargetLevelName("COUNTRY");
        ArrayList<Object[]> memberList = new ArrayList<Object[]>();
        memberList.add(new Object[]{"USA", "CHINA"});
        filter1.setTuple(memberList);
        IEdgeDrillFilter filter = rowEdge.createDrillFilter("drill1");
        filter.setTargetHierarchy(hier2);
        filter.setTargetLevelName("YEAR");
        memberList = new ArrayList();
        memberList.add(new Object[]{"2003"});
        memberList.add(null);
        memberList.add(null);
        filter.setTuple(memberList);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        DrilledCube cube = new DrilledCube();
        cube.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("binding1");
        rowEdgeBindingNames.add("binding2");
        rowEdgeBindingNames.add("binding3");
        rowEdgeBindingNames.add("binding4");
        rowEdgeBindingNames.add("binding5");
        rowEdgeBindingNames.add("binding6");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("binding7");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", "total2", "total1", "grandTotal1", null);
        engine.shutdown();
    }

    public void testDimensionExtend() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = rowEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("COUNTRY");
        hier1.createLevel("STATE");
        hier1.createLevel("CITY");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("YEAR");
        hier2.createLevel("QUARTER");
        hier2.createLevel("MONTH");
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition dim3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension3");
        hier3.createLevel("PRODUCTLINE");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("binding1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"COUNTRY\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("binding2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"STATE\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("binding3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"CITY\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("binding4");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"YEAR\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("binding5");
        binding5.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"QUARTER\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("binding6");
        binding6.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"MONTH\"]"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("binding7");
        binding7.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension3\"][\"PRODUCTLINE\"]"));
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("measure1");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding8);
        Binding binding9 = new Binding("total1");
        binding9.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding9.addAggregateOn("dimension[\"dimension1\"][\"COUNTRY\"]");
        binding9.addAggregateOn("dimension[\"dimension1\"][\"STATE\"]");
        binding9.addAggregateOn("dimension[\"dimension1\"][\"CITY\"]");
        binding9.addAggregateOn("dimension[\"dimension2\"][\"YEAR\"]");
        binding9.addAggregateOn("dimension[\"dimension2\"][\"QUARTER\"]");
        binding9.addAggregateOn("dimension[\"dimension2\"][\"MONTH\"]");
        binding9.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding9);
        Binding binding10 = new Binding("total2");
        binding10.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding10.addAggregateOn("dimension[\"dimension3\"][\"PRODUCTLINE\"]");
        binding10.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding10);
        Binding binding11 = new Binding("grandTotal1");
        binding11.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding11.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding11);
        IEdgeDrillFilter filter1 = rowEdge.createDrillFilter("drill2");
        filter1.setTargetHierarchy(hier1);
        filter1.setTargetLevelName("COUNTRY");
        ArrayList<Object[]> memberList = new ArrayList<Object[]>();
        memberList.add(new Object[]{"USA", "CHINA"});
        filter1.setTuple(memberList);
        IEdgeDrillFilter filter = rowEdge.createDrillFilter("drill1");
        filter.setTargetHierarchy(hier2);
        filter.setTargetLevelName("YEAR");
        memberList = new ArrayList();
        memberList.add(new Object[]{"2003"});
        memberList.add(null);
        memberList.add(null);
        filter.setTuple(memberList);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        DrilledCube cube = new DrilledCube();
        cube.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("binding1");
        rowEdgeBindingNames.add("binding2");
        rowEdgeBindingNames.add("binding3");
        rowEdgeBindingNames.add("binding4");
        rowEdgeBindingNames.add("binding5");
        rowEdgeBindingNames.add("binding6");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("binding7");
        List edgeCursors = cursor.getOrdinateEdge();
        StringBuffer strBuffer = new StringBuffer();
        int i = 0;
        while (i < edgeCursors.size()) {
            EdgeCursor eCursor = (EdgeCursor)edgeCursors.get(i);
            strBuffer.append("Edge Cursor " + i + "\n");
            List dCursor = eCursor.getDimensionCursor();
            while (eCursor.next()) {
                int k = 0;
                while (k < dCursor.size()) {
                    DimensionCursor dimCursor = (DimensionCursor)dCursor.get(k);
                    strBuffer.append(dimCursor.getExtent());
                    strBuffer.append("  ");
                    ++k;
                }
                strBuffer.append("\n");
            }
            strBuffer.append("\n");
            ++i;
        }
        this.testPrint(strBuffer.toString());
        this.checkOutputFile();
        this.close((CubeCursor)cursor);
        engine.shutdown();
    }

    private DataEngineContext createPresentationContext() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(CubeDrillFeatureTest.getTempDir());
        return context;
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingNames, String columnAggr, String rowAggr, String overallAggr, String subTotal) throws Exception {
        String output = this.getOutputFromCursor(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, columnAggr, rowAggr, overallAggr, subTotal);
        this.testPrint(output);
        this.checkOutputFile();
        this.close(cursor);
    }

    private void close(CubeCursor dataCursor) throws OLAPException {
        int i = 0;
        while (i < dataCursor.getOrdinateEdge().size()) {
            EdgeCursor edge = (EdgeCursor)dataCursor.getOrdinateEdge().get(i);
            edge.close();
            ++i;
        }
        dataCursor.close();
    }

    private String getOutputFromCursor(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingNames, String columnAggr, String rowAggr, String overallAggr, String subTotal) throws OLAPException {
        EdgeCursor edge1 = null;
        EdgeCursor edge2 = null;
        int index = 0;
        if (columnEdgeBindingNames != null && !columnEdgeBindingNames.isEmpty()) {
            edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(index);
            ++index;
        }
        if (rowEdgeBindingNames != null && !rowEdgeBindingNames.isEmpty()) {
            edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(index);
        }
        DimensionCursor columnCursor1 = null;
        if (edge1 != null) {
            columnCursor1 = (DimensionCursor)edge1.getDimensionCursor().get(0);
        }
        String[] lines = new String[columnEdgeBindingNames.size()];
        int i = 0;
        while (i < columnEdgeBindingNames.size()) {
            lines[i] = "\t\t                                                                           ";
            ++i;
        }
        if (edge1 != null) {
            while (edge1.next()) {
                i = 0;
                while (i < columnEdgeBindingNames.size()) {
                    int n = i;
                    lines[n] = String.valueOf(lines[n]) + cursor.getObject(columnEdgeBindingNames.get(i).toString()) + "\t\t";
                    ++i;
                }
            }
        }
        if (rowAggr != null) {
            int n = lines.length - 1;
            lines[n] = String.valueOf(lines[n]) + "Total";
        }
        String output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = String.valueOf(output) + "\n" + lines[i2];
            ++i2;
        }
        while (edge2.next()) {
            String line = "";
            int i3 = 0;
            while (i3 < rowEdgeBindingNames.size()) {
                line = String.valueOf(line) + cursor.getObject(rowEdgeBindingNames.get(i3).toString()) + "\t\t";
                ++i3;
            }
            if (edge1 != null) {
                edge1.beforeFirst();
            }
            if (edge1 != null) {
                while (edge1.next()) {
                    if (subTotal == null) {
                        line = String.valueOf(line) + cursor.getObject(measureBindingNames) + "\t\t";
                        continue;
                    }
                    if (columnCursor1 != null && edge1.getPosition() == columnCursor1.getEdgeEnd()) {
                        line = String.valueOf(line) + cursor.getObject(measureBindingNames);
                        line = String.valueOf(line) + "|" + cursor.getObject(subTotal) + "  ";
                        continue;
                    }
                    line = String.valueOf(line) + cursor.getObject(measureBindingNames) + "\t\t";
                }
            } else if (subTotal == null) {
                line = String.valueOf(line) + cursor.getObject(measureBindingNames) + "\t\t";
            }
            if (rowAggr != null) {
                line = String.valueOf(line) + cursor.getObject(rowAggr);
            }
            output = String.valueOf(output) + "\n" + line;
        }
        if (columnAggr != null) {
            String line = "                     Total\t\t";
            edge1.beforeFirst();
            while (edge1.next()) {
                line = String.valueOf(line) + cursor.getObject(columnAggr) + "\t\t";
            }
            if (overallAggr != null) {
                line = String.valueOf(line) + cursor.getObject(overallAggr);
            }
            output = String.valueOf(output) + "\n" + line;
        }
        return output;
    }
}

