/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.TestFactTable;
import org.eclipse.birt.data.engine.olap.api.query.CubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.CubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeMaterializer;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionForTest;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.AddingNestAggregations;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinitionIOUtil;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.impl.query.IncrementExecutionHint;
import testutil.BaseTestCase;

public class CubeIVTest
extends BaseTestCase {
    private static String cubeName = "cube";
    private static String documentPath = System.getProperty("java.io.tmpdir");

    static {
        if (!documentPath.endsWith(File.separator)) {
            documentPath = String.valueOf(documentPath) + File.separator;
        }
    }

    public void testBasic() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        cqd.setCacheQueryResults(true);
        FileArchiveWriter writter = new FileArchiveWriter(String.valueOf(documentPath) + "testTemp");
        DataEngineContext context = DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)writter);
        context.setTmpdir(CubeIVTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube((IDocArchiveWriter)writter, engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        writter.finish();
        engine.shutdown();
        FileArchiveReader reader = new FileArchiveReader(String.valueOf(documentPath) + "testTemp");
        engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)reader, null));
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, "edge2level1", "measure1");
        engine.shutdown();
    }

    public void testQueryWithoutEdge() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        cqd.createMeasure("measure1");
        Binding binding = new Binding("grandTotal");
        binding.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding);
        cqd.setCacheQueryResults(true);
        FileArchiveWriter writter = new FileArchiveWriter(String.valueOf(documentPath) + "testTemp");
        DataEngineContext context = DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)writter);
        context.setTmpdir(CubeIVTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube((IDocArchiveWriter)writter, engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        Object o = cursor.getObject("grandTotal");
        CubeIVTest.assertEquals((String)"2146.0", (String)o.toString());
        cursor.close();
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        o = cursor.getObject("grandTotal");
        CubeIVTest.assertEquals((String)"2146.0", (String)o.toString());
        cursor.close();
        writter.finish();
        engine.shutdown();
        FileArchiveReader reader = new FileArchiveReader(String.valueOf(documentPath) + "testTemp");
        engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)reader, null));
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        o = cursor.getObject("grandTotal");
        CubeIVTest.assertEquals((String)"2146.0", (String)o.toString());
        cursor.close();
        engine.shutdown();
    }

    public void testIVWithAddingNestAggregations() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("total");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("sumTotal1");
        binding7.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        Binding binding8 = new Binding("sumTotal2");
        binding8.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding8.setAggrFunction("SUM");
        binding8.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        Binding binding9 = new Binding("sumSumTotal1");
        binding9.setExpression((IBaseExpression)new ScriptExpression("data[\"sumTotal1\"]"));
        binding9.setAggrFunction("SUM");
        binding9.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        Binding binding10 = new Binding("maxTotal1");
        binding10.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding10.setAggrFunction("MAX");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        Binding binding11 = new Binding("maxTotal2");
        binding11.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding11.setAggrFunction("MAX");
        AddingNestAggregations cubeOperation1 = new AddingNestAggregations(new IBinding[]{binding7, binding8, binding10, binding11});
        AddingNestAggregations cubeOperation2 = new AddingNestAggregations(new IBinding[]{binding9});
        cqd.addCubeOperation((ICubeOperation)cubeOperation1);
        cqd.addCubeOperation((ICubeOperation)cubeOperation2);
        cqd.setCacheQueryResults(true);
        FileArchiveWriter writter = new FileArchiveWriter(String.valueOf(documentPath) + "testTemp");
        DataEngineContext context = DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)writter);
        context.setTmpdir(CubeIVTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube((IDocArchiveWriter)writter, engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        writter.finish();
        engine.shutdown();
        FileArchiveReader reader = new FileArchiveReader(String.valueOf(documentPath) + "testTemp");
        engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)reader, null));
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", new String[0]);
        this.checkOutputFile();
        cursor.close();
        engine.shutdown();
    }

    public void testBasicIV() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        cqd.setCacheQueryResults(true);
        FileArchiveWriter writter = new FileArchiveWriter(String.valueOf(documentPath) + "testTemp1");
        DataEngineContext context = DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)writter);
        context.setTmpdir(CubeIVTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube((IDocArchiveWriter)writter, engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        writter.flush();
        writter.finish();
        engine.shutdown();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        FileArchiveReader reader = new FileArchiveReader(String.valueOf(documentPath) + "testTemp");
        ArchiveWriter writer = new ArchiveWriter((IArchiveFile)new ArchiveFile(String.valueOf(documentPath) + "testTemp", "rw+"));
        engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)4, null, (IDocArchiveReader)reader, (IDocArchiveWriter)writer));
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level11\"]", 1, "\"CN\""));
        cqd.addFilter((IFilterDefinition)filter);
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        reader.close();
        writer.finish();
        engine.shutdown();
        reader = new FileArchiveReader(String.valueOf(documentPath) + "testTemp");
        engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)reader, null));
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, "edge2level1", "measure1");
        reader.close();
        engine.shutdown();
    }

    public void testIVWithIncrementSorts() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        FileArchiveWriter writter = new FileArchiveWriter(String.valueOf(documentPath) + "testTemp");
        DataEngineContext context = DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)writter);
        context.setTmpdir(CubeIVTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube((IDocArchiveWriter)writter, engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        writter.flush();
        writter.finish();
        engine.shutdown();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        FileArchiveReader reader = new FileArchiveReader(String.valueOf(documentPath) + "testTemp");
        ArchiveWriter writer = new ArchiveWriter((IArchiveFile)new ArchiveFile(String.valueOf(documentPath) + "testTemp", "rw+"));
        ICubeQueryDefinition savedQuery = CubeQueryDefinitionIOUtil.load((String)queryResults.getID(), (IDocArchiveReader)reader);
        engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)4, null, (IDocArchiveReader)reader, (IDocArchiveWriter)writer));
        cqd.setQueryResultsID(queryResults.getID());
        CubeSortDefinition csd = new CubeSortDefinition();
        csd.setSortDirection(1);
        csd.setExpression((IScriptExpression)new ScriptExpression("data[\"edge2level1\"]"));
        csd.setTargetLevel((ILevelDefinition)((IHierarchyDefinition)dim2.getHierarchy().get(0)).getLevels().get(0));
        cqd.addSort((ISortDefinition)csd);
        IncrementExecutionHint ieh = CubeQueryDefinitionUtil.getIncrementExecutionHint((ICubeQueryDefinition)savedQuery, (ICubeQueryDefinition)cqd);
        CubeIVTest.assertTrue((ieh != null ? 1 : 0) != 0);
        CubeIVTest.assertEquals((int)0, (int)ieh.getBindings().length);
        CubeIVTest.assertEquals((int)0, (int)ieh.getFilters().length);
        CubeIVTest.assertEquals((int)1, (int)ieh.getSorts().length);
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        reader.close();
        writer.finish();
        engine.shutdown();
        reader = new FileArchiveReader(String.valueOf(documentPath) + "testTemp");
        engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)reader, null));
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, "edge2level1", "measure1");
        reader.close();
        engine.shutdown();
    }

    public void testBasic1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        cqd.setCacheQueryResults(true);
        FileArchiveWriter writter = new FileArchiveWriter(String.valueOf(documentPath) + "testTemp");
        DataEngineContext context = DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)writter);
        context.setTmpdir(CubeIVTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube((IDocArchiveWriter)writter, engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        writter.finish();
        engine.shutdown();
        FileArchiveReader reader = new FileArchiveReader(String.valueOf(documentPath) + "testTemp");
        engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)reader, null));
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, "edge2level1", "measure1");
        engine.shutdown();
    }

    public void testFilter1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level11\"]", 1, "\"CN\""));
        cqd.addFilter((IFilterDefinition)filter);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        cqd.setCacheQueryResults(true);
        FileArchiveWriter writter = new FileArchiveWriter(String.valueOf(documentPath) + "testTemp");
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)writter));
        this.createCube((IDocArchiveWriter)writter, engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        writter.finish();
        engine.shutdown();
        FileArchiveReader reader = new FileArchiveReader(String.valueOf(documentPath) + "testTemp");
        engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)reader, null));
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, "edge2level1", "measure1");
        engine.shutdown();
    }

    public void testAggrSort() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"rowGrandTotal\"]");
        sorter1.setAxisQualifierLevels(null);
        sorter1.setAxisQualifierValues(null);
        sorter1.setTargetLevel(level21);
        sorter1.setSortDirection(1);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("data[\"city_year_total\"]");
        sorter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter2.setAxisQualifierValues(new Object[]{"2002"});
        sorter2.setTargetLevel(level12);
        sorter2.setSortDirection(1);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("data[\"country_year_total\"]");
        sorter3.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter3.setAxisQualifierValues(new Object[]{"2002"});
        sorter3.setTargetLevel(level11);
        sorter3.setSortDirection(1);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("dimension[\"dimension1\"][\"level13\"]");
        sorter4.setAxisQualifierLevels(null);
        sorter4.setAxisQualifierValues(null);
        sorter4.setTargetLevel(level13);
        sorter4.setSortDirection(1);
        CubeSortDefinition sorter5 = new CubeSortDefinition();
        sorter5.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter5.setAxisQualifierLevels(null);
        sorter5.setAxisQualifierValues(null);
        sorter5.setTargetLevel(level11);
        sorter5.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        cqd.addSort((ISortDefinition)sorter4);
        cqd.addSort((ISortDefinition)sorter5);
        cqd.setCacheQueryResults(true);
        FileArchiveWriter writter = new FileArchiveWriter(String.valueOf(documentPath) + "testTemp");
        DataEngineContext context = DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)writter);
        context.setTmpdir(CubeIVTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube((IDocArchiveWriter)writter, engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        writter.finish();
        engine.shutdown();
        FileArchiveReader reader = new FileArchiveReader(String.valueOf(documentPath) + "testTemp");
        engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)reader, null));
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
    }

    public void testNestedCrossTab() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"rowGrandTotal\"] > 420"));
        filter1.setAxisQualifierLevels(null);
        filter1.setAxisQualifierValues(null);
        filter1.setTargetLevel(level21);
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"city_year_total\"] == data._outer[\"column1\"]"));
        filter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter2.setAxisQualifierValues(new Object[]{"2002"});
        filter2.setTargetLevel(level12);
        CubeFilterDefinition filter3 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"country_year_total\"] < 300"));
        filter3.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter3.setAxisQualifierValues(new Object[]{"2002"});
        filter3.setTargetLevel(level11);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("dimension[\"dimension1\"][\"level13\"]");
        sorter4.setAxisQualifierLevels(null);
        sorter4.setAxisQualifierValues(null);
        sorter4.setTargetLevel(level13);
        sorter4.setSortDirection(1);
        CubeSortDefinition sorter5 = new CubeSortDefinition();
        sorter5.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter5.setAxisQualifierLevels(null);
        sorter5.setAxisQualifierValues(null);
        sorter5.setTargetLevel(level11);
        sorter5.setSortDirection(1);
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        cqd.addFilter((IFilterDefinition)filter3);
        cqd.addSort((ISortDefinition)sorter4);
        cqd.addSort((ISortDefinition)sorter5);
        FileArchiveWriter writter = new FileArchiveWriter(String.valueOf(documentPath) + "testTemp");
        DataEngineContext context = DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)writter);
        context.setTmpdir(CubeIVTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube((IDocArchiveWriter)writter, engine);
        IQueryDefinition query = this.createScriptDataSetQuery();
        this.defineDataSourceDataSet((DataEngine)engine);
        HashMap<String, String> idMap = new HashMap<String, String>();
        IPreparedQuery pq = engine.prepare(query);
        IQueryResults queryResults = pq.execute(null);
        IResultIterator it = queryResults.getResultIterator();
        while (it.next()) {
            if (!"55".equals(it.getValue("column1").toString()) && !"34".equals(it.getValue("column1").toString())) continue;
            IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
            ICubeQueryResults cqResults = pcq.execute((IBaseQueryResults)queryResults, null);
            cqResults.getCubeCursor();
            idMap.put(it.getValue("column1").toString(), cqResults.getID());
        }
        it.close();
        writter.flush();
        writter.finish();
        engine.shutdown();
        FileArchiveReader reader = new FileArchiveReader(String.valueOf(documentPath) + "testTemp");
        engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)reader, null));
        ((QueryDefinition)query).setQueryResultsID(queryResults.getID());
        pq = engine.prepare(query, null);
        queryResults = pq.execute(null);
        it = queryResults.getResultIterator();
        while (it.next()) {
            if (((Number)it.getValue("column1")).intValue() != 55 && ((Number)it.getValue("column1")).intValue() != 34) continue;
            this.testPrintln("\nOUTER RESULT:" + it.getValue("column1").toString());
            cqd.setQueryResultsID(idMap.get(it.getValue("column1").toString()).toString());
            IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
            ICubeQueryResults cqResults = pcq.execute((IBaseQueryResults)queryResults, null);
            ICubeCursor cursor = cqResults.getCubeCursor();
            ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
            columnEdgeBindingNames.add("edge1level1");
            columnEdgeBindingNames.add("edge1level2");
            columnEdgeBindingNames.add("edge1level3");
            this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1", false);
        }
        it.close();
        this.checkOutputFile();
    }

    private void defineDataSourceDataSet(DataEngine engine) throws BirtException {
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        ColumnDefinition col = new ColumnDefinition("column1");
        col.setDataType(2);
        dataSet.addResultSetHint((IColumnDefinition)col);
        dataSet.setOpenScript("i = 57;");
        dataSet.setFetchScript(" i--; if ( i < 27 ) return false; row.column1 = i; return true;");
        engine.defineDataSource((IBaseDataSourceDesign)dataSource);
        engine.defineDataSet((IBaseDataSetDesign)dataSet);
    }

    private IQueryDefinition createScriptDataSetQuery() throws DataException {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName("test");
        query.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("dataSetRow.column1")));
        return query;
    }

    private void createSortTestBindings(ICubeQueryDefinition cqd) throws DataException {
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("rowGrandTotal");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("columnGrandTotal");
        binding7.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("grandTotal");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding8.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding8);
        Binding binding9 = new Binding("country_year_total");
        binding9.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding9.setAggrFunction("SUM");
        binding9.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding9.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding9);
        Binding binding10 = new Binding("city_year_total");
        binding10.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding10.setAggrFunction("SUM");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding10.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding10);
        Binding binding11 = new Binding("dist_total");
        binding11.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding11.setAggrFunction("SUM");
        binding11.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding11.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding11.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding11);
        Binding binding12 = new Binding("city_total");
        binding12.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding12.setAggrFunction("SUM");
        binding12.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding12.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding12);
        Binding binding13 = new Binding("country_total");
        binding13.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding13.setAggrFunction("SUM");
        binding13.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        cqd.addBinding((IBinding)binding13);
    }

    private void printCube(CubeCursor cursor, String country_year_total, String city_year_total, String dist_total, String city_total, String country_total, String year_total, String grand_total, String[] columns, String row, String measure) throws OLAPException, IOException {
        this.printCube(cursor, country_year_total, city_year_total, dist_total, city_total, country_total, year_total, grand_total, columns, row, measure, true);
    }

    private void printCube(CubeCursor cursor, String country_year_total, String city_year_total, String dist_total, String city_total, String country_total, String year_total, String grand_total, String[] columns, String row, String measure, boolean checkOutput) throws OLAPException, IOException {
        long cityEnd;
        long countryEnd;
        EdgeCursor edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(1);
        String[] lines = new String[edge1.getDimensionCursor().size()];
        int i = 0;
        while (i < lines.length) {
            lines[i] = "\t\t";
            ++i;
        }
        while (edge1.next()) {
            long countryEnd2 = ((DimensionCursor)edge1.getDimensionCursor().get(0)).getEdgeEnd();
            long cityEnd2 = ((DimensionCursor)edge1.getDimensionCursor().get(1)).getEdgeEnd();
            lines[0] = String.valueOf(lines[0]) + cursor.getObject(columns[0]) + "\t\t";
            lines[1] = String.valueOf(lines[1]) + cursor.getObject(columns[1]) + "\t\t";
            lines[2] = String.valueOf(lines[2]) + cursor.getObject(columns[2]) + "\t\t";
            if (cityEnd2 == edge1.getPosition()) {
                lines[0] = String.valueOf(lines[0]) + cursor.getObject(columns[0]) + "\t\t";
                lines[1] = String.valueOf(lines[1]) + cursor.getObject(columns[1]) + "\t\t";
                lines[2] = String.valueOf(lines[2]) + "[Total]\t\t";
            }
            if (countryEnd2 != edge1.getPosition()) continue;
            lines[0] = String.valueOf(lines[0]) + cursor.getObject(columns[0]) + "\t\t";
            lines[1] = String.valueOf(lines[1]) + "[Total]\t\t";
            lines[2] = String.valueOf(lines[2]) + "    \t\t";
        }
        lines[0] = String.valueOf(lines[0]) + "[Total]";
        String output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = String.valueOf(output) + "\n" + lines[i2];
            ++i2;
        }
        while (edge2.next()) {
            String line = String.valueOf(cursor.getObject(row).toString()) + "\t\t";
            edge1.beforeFirst();
            while (edge1.next()) {
                countryEnd = ((DimensionCursor)edge1.getDimensionCursor().get(0)).getEdgeEnd();
                cityEnd = ((DimensionCursor)edge1.getDimensionCursor().get(1)).getEdgeEnd();
                line = String.valueOf(line) + cursor.getObject(measure) + "\t\t";
                if (cityEnd == edge1.getPosition()) {
                    line = String.valueOf(line) + "[" + cursor.getObject(city_year_total) + "]" + "\t\t";
                }
                if (countryEnd != edge1.getPosition()) continue;
                line = String.valueOf(line) + "[" + cursor.getObject(country_year_total) + "]" + "\t\t";
            }
            line = String.valueOf(line) + "[" + cursor.getObject(year_total) + "]";
            output = String.valueOf(output) + "\n" + line;
        }
        String line = "[Total]\t\t";
        edge1.beforeFirst();
        while (edge1.next()) {
            countryEnd = ((DimensionCursor)edge1.getDimensionCursor().get(0)).getEdgeEnd();
            cityEnd = ((DimensionCursor)edge1.getDimensionCursor().get(1)).getEdgeEnd();
            line = String.valueOf(line) + cursor.getObject(dist_total) + "\t\t";
            if (cityEnd == edge1.getPosition()) {
                line = String.valueOf(line) + "[" + cursor.getObject(city_total) + "]" + "\t\t";
            }
            if (countryEnd != edge1.getPosition()) continue;
            line = String.valueOf(line) + "[" + cursor.getObject(country_total) + "]" + "\t\t";
        }
        line = String.valueOf(line) + "[" + cursor.getObject(grand_total) + "]" + "\t\t";
        output = String.valueOf(output) + "\n" + line;
        this.testPrint(output);
        if (checkOutput) {
            this.checkOutputFile();
        }
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, String rowEdgeBindingNames, String measureBindingNames) throws Exception {
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, null, null, null);
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, String rowEdgeBindingNames, String measureBindingNames, String columnAggr, String rowAggr, String overallAggr) throws Exception {
        EdgeCursor edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(1);
        String[] lines = new String[edge1.getDimensionCursor().size()];
        int i = 0;
        while (i < lines.length) {
            lines[i] = "\t\t";
            ++i;
        }
        while (edge1.next()) {
            i = 0;
            while (i < lines.length) {
                int n = i;
                lines[n] = String.valueOf(lines[n]) + cursor.getObject(columnEdgeBindingNames.get(i).toString()) + "\t\t";
                ++i;
            }
        }
        if (rowAggr != null) {
            int n = lines.length - 1;
            lines[n] = String.valueOf(lines[n]) + "Total";
        }
        String output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = String.valueOf(output) + "\n" + lines[i2];
            ++i2;
        }
        while (edge2.next()) {
            String line = String.valueOf(cursor.getObject(rowEdgeBindingNames).toString()) + "\t\t";
            edge1.beforeFirst();
            while (edge1.next()) {
                line = String.valueOf(line) + cursor.getObject(measureBindingNames) + "\t\t";
            }
            if (rowAggr != null) {
                line = String.valueOf(line) + cursor.getObject(rowAggr);
            }
            output = String.valueOf(output) + "\n" + line;
        }
        if (columnAggr != null) {
            String line = "Total\t\t";
            edge1.beforeFirst();
            while (edge1.next()) {
                line = String.valueOf(line) + cursor.getObject(columnAggr) + "\t\t";
            }
            if (overallAggr != null) {
                line = String.valueOf(line) + cursor.getObject(overallAggr);
            }
            output = String.valueOf(output) + "\n" + line;
        }
        this.testPrint(output);
        this.checkOutputFile();
    }

    private void createCube(IDocArchiveWriter writter, DataEngineImpl engine) throws BirtException, IOException {
        CubeMaterializer cubeMaterializer = new CubeMaterializer(engine, String.valueOf(engine.hashCode()));
        IDocumentManager documentManager = cubeMaterializer.getDocumentManager();
        Dimension[] dimensions = new Dimension[2];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable.DIM0_L1Col);
        iterator.setLevelMember(1, TestFactTable.DIM0_L2Col);
        iterator.setLevelMember(2, TestFactTable.DIM0_L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        CubeIVTest.assertEquals((String)hierarchy.getName(), (String)"dimension1");
        CubeIVTest.assertEquals((int)dimensions[0].length(), (int)13);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, this.distinct(TestFactTable.DIM1_L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        CubeIVTest.assertEquals((String)hierarchy.getName(), (String)"dimension2");
        CubeIVTest.assertEquals((int)dimensions[1].length(), (int)5);
        TestFactTable factTable2 = new TestFactTable();
        String[] measureColumnName = new String[]{"measure1"};
        Cube cube = new Cube(cubeName, documentManager);
        cube.create(CubeUtility.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        cube.close();
        documentManager.flush();
        cubeMaterializer.saveCubeToReportDocument("cube", writter, new StopSign());
        cubeMaterializer.close();
    }

    private String[] distinct(String[] values) {
        Object[] lValues = new String[values.length];
        System.arraycopy(values, 0, lValues, 0, values.length);
        Arrays.sort(lValues);
        ArrayList<Object> tempList = new ArrayList<Object>();
        tempList.add(lValues[0]);
        int i = 1;
        while (i < lValues.length) {
            if (!((String)lValues[i]).equals(lValues[i - 1])) {
                tempList.add(lValues[i]);
            }
            ++i;
        }
        String[] result = new String[tempList.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (String)tempList.get(i2);
            ++i2;
        }
        return result;
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingName, String[] columnAggrs) throws Exception {
        String output = this.getOutputFromCursor(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingName, columnAggrs);
        this.testPrint(output);
    }

    private String getOutputFromCursor(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingName, String[] columnAggrs) throws OLAPException {
        EdgeCursor edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(1);
        String[] lines = new String[columnEdgeBindingNames.size()];
        int i = 0;
        while (i < columnEdgeBindingNames.size()) {
            lines[i] = "\t\t";
            ++i;
        }
        while (edge1.next()) {
            i = 0;
            while (i < columnEdgeBindingNames.size()) {
                int n = i;
                lines[n] = String.valueOf(lines[n]) + cursor.getObject(columnEdgeBindingNames.get(i).toString()) + "\t\t";
                ++i;
            }
        }
        String output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = String.valueOf(output) + "\n" + lines[i2];
            ++i2;
        }
        while (edge2.next()) {
            String line = "";
            int i3 = 0;
            while (i3 < rowEdgeBindingNames.size()) {
                line = String.valueOf(line) + cursor.getObject(rowEdgeBindingNames.get(i3).toString()).toString() + "\t\t";
                ++i3;
            }
            edge1.beforeFirst();
            while (edge1.next()) {
                line = String.valueOf(line) + cursor.getObject(measureBindingName) + "\t\t";
            }
            output = String.valueOf(output) + "\n" + line;
        }
        String line = "total\t\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("total") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        line = "maxTotal1\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("maxTotal1") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        line = "maxTotal2\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("maxTotal2") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        line = "sumTotal1\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("sumTotal1") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        line = "sumTotal2\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("sumTotal2") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        line = "sumSumTotal1\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("sumSumTotal1") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        return output;
    }
}

