/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.api;

import java.io.IOException;
import javax.olap.OLAPException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.DateFactTable;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerMap;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerReleaser;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionForTest;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;

class DrilledCube {
    public static final String cubeName = "DrilledCube";

    DrilledCube() {
    }

    void createCube(DataEngineImpl engine) throws IOException, BirtException, OLAPException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager((String)engine.getSession().getTempDir(), (String)String.valueOf(engine.hashCode()));
        DocManagerMap.getDocManagerMap().set(String.valueOf(engine.hashCode()), String.valueOf(engine.getSession().getTempDir()) + engine.hashCode(), documentManager);
        engine.addShutdownListener((IShutdownListener)new DocManagerReleaser((DataEngine)engine));
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"COUNTRY", "STATE", "CITY"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, DateFactTable.DIM0_COUNTRY_COL);
        iterator.setLevelMember(1, DateFactTable.DIM0_STATE_COL);
        iterator.setLevelMember(2, DateFactTable.DIM0_CITY_COL);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("COUNTRY", new String[]{"COUNTRY"}, null), new LevelDefinition("STATE", new String[]{"STATE"}, null), new LevelDefinition("CITY", new String[]{"CITY"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        levelNames = new String[]{"YEAR", "QUARTER", "MONTH"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, (Object[])DateFactTable.DIM1_YEAR_COL);
        iterator.setLevelMember(1, (Object[])DateFactTable.DIM1_QUARTER_COL);
        iterator.setLevelMember(2, (Object[])DateFactTable.DIM1_MONTH_COL);
        levelDefs = new ILevelDefn[]{new LevelDefinition("YEAR", new String[]{"YEAR"}, null), new LevelDefinition("QUARTER", new String[]{"QUARTER"}, null), new LevelDefinition("MONTH", new String[]{"MONTH"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        levelNames = new String[]{"PRODUCTLINE", "PRODUCTTYPE"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, DateFactTable.DIM2_PRODUCTLINE_COL1);
        iterator.setLevelMember(1, DateFactTable.DIM2_PRODUCTLINE_COL2);
        levelDefs = new ILevelDefn[]{new LevelDefinition("PRODUCTLINE", new String[]{"PRODUCTLINE"}, null), new LevelDefinition("PRODUCTTYPE", new String[]{"PRODUCTTYPE"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        DateFactTable factTable2 = new DateFactTable();
        String[] measureColumnName = new String[]{"measure1"};
        Cube cube = new Cube(cubeName, documentManager);
        cube.create(DrilledCube.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        cube.close();
        documentManager.flush();
    }

    public static String[][] getKeyColNames(IDimension[] dimensions) {
        String[][] keyColumnName = new String[][]{{"COUNTRY", "STATE", "CITY"}, {"YEAR", "QUARTER", "MONTH"}, {"PRODUCTLINE"}};
        return keyColumnName;
    }
}

