/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import testutil.BaseTestCase;

public class CursorModelTest
extends BaseTestCase {
    private Scriptable scope;
    private DataEngineImpl de;
    private CubeUtility creator;
    private ICube cube;

    protected void setUp() throws Exception {
        super.setUp();
        this.scope = new ImporterTopLevel();
        DataEngineContext context = DataEngineContext.newInstance((int)3, (Scriptable)this.scope, null, null);
        context.setTmpdir(CursorModelTest.getTempDir());
        this.de = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.creator = new CubeUtility();
        this.creator.createCube(this.de);
        this.cube = this.creator.getCube(CubeUtility.cubeName, this.de);
    }

    protected void tearDown() throws Exception {
        this.cube.close();
        if (this.de != null) {
            this.de.shutdown();
            this.de = null;
        }
    }

    public void testCursorModel1() throws OLAPException, BirtException, IOException {
        ICubeQueryDefinition cqd = this.creator.createQueryDefinition();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("AVE");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        Binding totalGrandTotal = new Binding("totalGrandTotal");
        totalGrandTotal.setAggrFunction("SUM");
        totalGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        cqd.addBinding((IBinding)totalGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowGrandTotal");
        try {
            this.testOut.print(this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            CursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorModel2() throws OLAPException, BirtException {
        CubeQueryDefinition cqd = new CubeQueryDefinition(CubeUtility.cubeName);
        cqd.createMeasure("measure1");
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        IDimensionDefinition dim2 = columnEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level12");
        IDimensionDefinition dim3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension3");
        hier3.createLevel("level13");
        IDimensionDefinition dim4 = columnEdge.createDimension("dimension4");
        IHierarchyDefinition hier4 = dim4.createHierarchy("dimension4");
        hier4.createLevel("level14");
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        EdgeCursor columnCursor = cubeView.getColumnEdgeView().getEdgeCursor();
        DimensionCursor countryCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(0);
        DimensionCursor cityCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(1);
        DimensionCursor streetCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(2);
        DimensionCursor timeCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(3);
        this.testOut.print(this.creator.printCubeAlongDimension(dataCursor, countryCursor, cityCursor, streetCursor, timeCursor, null, null));
        try {
            this.checkOutputFile();
        }
        catch (Exception exception) {
            CursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorModel3() throws OLAPException, BirtException {
        CubeQueryDefinition cqd = new CubeQueryDefinition(CubeUtility.cubeName);
        cqd.createMeasure("measure1");
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = rowEdge.createDimension("dimension5");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension5");
        hier1.createLevel("level21");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension6");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension6");
        hier2.createLevel("level22");
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        EdgeCursor rowCursor = cubeView.getRowEdgeView().getEdgeCursor();
        DimensionCursor productCursor1 = (DimensionCursor)rowCursor.getDimensionCursor().get(0);
        DimensionCursor productCursor2 = (DimensionCursor)rowCursor.getDimensionCursor().get(1);
        this.testOut.print(this.creator.printCubeAlongDimension(dataCursor, null, null, null, null, productCursor1, productCursor2));
        try {
            this.checkOutputFile();
        }
        catch (Exception exception) {
            CursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorModel4() throws DataException, OLAPException {
        ICubeQueryDefinition cqd = this.creator.createQueryDefinition();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("SUM");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        List dimCursorOnColumn = cubeView.getColumnEdgeView().getEdgeCursor().getDimensionCursor();
        List dimCursorOnRow = cubeView.getRowEdgeView().getEdgeCursor().getDimensionCursor();
        this.testOut.print(this.creator.printCubeAlongDimension(dataCursor, (DimensionCursor)dimCursorOnColumn.get(0), (DimensionCursor)dimCursorOnColumn.get(1), (DimensionCursor)dimCursorOnColumn.get(2), (DimensionCursor)dimCursorOnColumn.get(3), (DimensionCursor)dimCursorOnRow.get(0), (DimensionCursor)dimCursorOnRow.get(1)));
        try {
            this.checkOutputFile();
        }
        catch (Exception exception) {
            CursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorModel5() throws OLAPException, BirtException {
        ICubeQueryDefinition cqd = this.creator.createQueryDefinition();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding rowGrandAvg = new Binding("rowGrandAvg");
        rowGrandAvg.setAggrFunction("AVE");
        rowGrandAvg.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandAvg.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandAvg.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)rowGrandAvg);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowGrandTotal");
        rowGrandTotalNames.add("rowGrandAvg");
        try {
            this.testOut.print(this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, null, null, null));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            CursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorModel7() throws OLAPException, BirtException {
        ICubeQueryDefinition cqd = this.creator.createQueryDefinition();
        Binding rowGrandAvg = new Binding("rowWightedave");
        rowGrandAvg.setAggrFunction("WEIGHTEDAVE");
        rowGrandAvg.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandAvg.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandAvg.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        rowGrandAvg.addArgument((IBaseExpression)new ScriptExpression("dimension[\"dimension6\"][\"level22\"][\"attributes220\"]"));
        cqd.addBinding((IBinding)rowGrandAvg);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowWightedave");
        try {
            this.testOut.print(this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, null, null, null));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            CursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorOnCountry() throws OLAPException, BirtException {
        ICubeQueryDefinition cqd = this.creator.createQueryDefinition();
        Binding rowGrandTotal = new Binding("countryGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        cqd.addBinding((IBinding)rowGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> grandBindingNames = new ArrayList<String>();
        grandBindingNames.add("countryGrandTotal");
        try {
            this.testOut.print(this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, null, null, null, grandBindingNames));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            CursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorWithoutMeasure() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(CubeUtility.cubeName);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition rowdim1 = rowEdge.createDimension("dimension5");
        IHierarchyDefinition rowhier1 = rowdim1.createHierarchy("dimension5");
        rowhier1.createLevel("level21");
        IDimensionDefinition rowdim2 = rowEdge.createDimension("dimension6");
        IHierarchyDefinition rowhier2 = rowdim2.createHierarchy("dimension6");
        rowhier2.createLevel("level22");
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        IDimensionDefinition dim2 = columnEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level12");
        IDimensionDefinition dim3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension3");
        hier3.createLevel("level13");
        IDimensionDefinition dim4 = columnEdge.createDimension("dimension4");
        IHierarchyDefinition hier4 = dim4.createHierarchy("dimension4");
        hier4.createLevel("level14");
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        this.testOut.print(this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, null, null, null, null, null));
        this.checkOutputFile();
        try {
            dataCursor.getObject("measure1");
        }
        catch (Exception e) {
            CursorModelTest.assertTrue((boolean)(e instanceof OLAPException));
        }
    }

    public void testCursorModel6() throws OLAPException, BirtException {
        CubeQueryDefinition cqd = new CubeQueryDefinition(CubeUtility.cubeName);
        cqd.createMeasure("measure1");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dim = columnEdge.createDimension("dimension5");
        IHierarchyDefinition dimHier = dim.createHierarchy("dimension5");
        dimHier.createLevel("level21");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition geographyDim = rowEdge.createDimension("dimension1");
        IHierarchyDefinition geographyHier = geographyDim.createHierarchy("dimension1");
        geographyHier.createLevel("level11");
        IDimensionDefinition geographyDim3 = rowEdge.createDimension("dimension3");
        IHierarchyDefinition geographyHier3 = geographyDim3.createHierarchy("dimension3");
        geographyHier3.createLevel("level13");
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("AVE");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        Binding totalGrandTotal = new Binding("totalGrandTotal");
        totalGrandTotal.setAggrFunction("COUNTDISTINCT");
        totalGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        cqd.addBinding((IBinding)totalGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level13");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowGrandTotal");
        try {
            this.testOut.print(this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            CursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorModel8() throws OLAPException, BirtException {
        ICubeQueryDefinition cqd = this.creator.createQueryDefinition();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        rowGrandTotal.setFilter((IBaseExpression)new ScriptExpression("measure[\"measure1\"]>10"));
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("AVE");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        columnGrandTotal.setFilter((IBaseExpression)new ScriptExpression("measure[\"measure1\"]>10"));
        Binding totalGrandTotal = new Binding("totalGrandTotal");
        totalGrandTotal.setAggrFunction("SUM");
        totalGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        cqd.addBinding((IBinding)totalGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowGrandTotal");
        try {
            this.testOut.print(this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            CursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorModel9WithFetchLimit() throws OLAPException, BirtException {
        ICubeQueryDefinition cqd = this.creator.createQueryDefinition();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("AVE");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        Binding totalGrandTotal = new Binding("totalGrandTotal");
        totalGrandTotal.setAggrFunction("SUM");
        totalGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        cqd.addBinding((IBinding)totalGrandTotal);
        HashMap<String, String> appContext = new HashMap<String, String>();
        appContext.put("org.eclipse.birt.data.engine.olap.cursor.onColumn", "10");
        appContext.put("org.eclipse.birt.data.engine.olap.cursor.onRow", "3");
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()), this.cube, appContext, null);
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowGrandTotal");
        try {
            this.testOut.print(this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            CursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorWithPageEdge1() throws Exception {
        ICubeQueryDefinition cqd = this.creator.createQueryDefintionWithPage1();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("AVE");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        Binding totalGrandTotal = new Binding("totalGrandTotal");
        totalGrandTotal.setAggrFunction("SUM");
        totalGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        totalGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        cqd.addBinding((IBinding)totalGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()), this.cube, null, null);
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> pageEdgeBindingNames = new ArrayList<String>();
        pageEdgeBindingNames.add("level14");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowGrandTotal");
        this.testOut.print(this.creator.printCubeAlongPageEdge(dataCursor, pageEdgeBindingNames, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null));
        this.checkOutputFile();
    }

    public void testCursorWithPageEdge2() throws Exception {
        ICubeQueryDefinition cqd = this.creator.createQueryDefintionWithPage2();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("AVE");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        Binding totalGrandTotal = new Binding("totalGrandTotal");
        totalGrandTotal.setAggrFunction("SUM");
        totalGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        totalGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        totalGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        cqd.addBinding((IBinding)totalGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()), this.cube, null, null);
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> pageEdgeBindingNames = new ArrayList<String>();
        pageEdgeBindingNames.add("level14");
        pageEdgeBindingNames.add("level11");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowGrandTotal");
        this.testOut.print(this.creator.printCubeAlongPageEdge(dataCursor, pageEdgeBindingNames, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null));
        this.checkOutputFile();
    }

    public void testCursorWithPageEdge3() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(CubeUtility.cubeName);
        cqd.createMeasure("measure1");
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = rowEdge.createDimension("dimension5");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension5");
        hier1.createLevel("level21");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension6");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension6");
        hier2.createLevel("level22");
        IEdgeDefinition pageEdge = cqd.createEdge(3);
        IDimensionDefinition dim3 = pageEdge.createDimension("dimension4");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension4");
        hier3.createLevel("level14");
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        ArrayList<String> pageEdgeBindingNames = new ArrayList<String>();
        pageEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        this.testOut.print(this.creator.printCubeAlongPageEdge(dataCursor, pageEdgeBindingNames, new ArrayList(), rowEdgeBindingNames, measureBindingNames, null, null, null, null));
        this.checkOutputFile();
    }
}

