/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import javax.olap.OLAPException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.cursor.DateFactTable;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerMap;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerReleaser;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionForTest;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;

class DateCube {
    public static final String cubeName = "DateCube";

    DateCube() {
    }

    void createCube(DataEngineImpl engine) throws IOException, BirtException, OLAPException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager((String)engine.getSession().getTempDir(), (String)cubeName);
        DocManagerMap.getDocManagerMap().set(String.valueOf(engine.hashCode()), String.valueOf(engine.getSession().getTempDir()) + cubeName, documentManager);
        engine.addShutdownListener((IShutdownListener)new DocManagerReleaser((DataEngine)engine));
        Dimension[] dimensions = new Dimension[2];
        String[] levelNames = new String[]{"level11", "level12", "year/DateTime", "level13", "quarter/DateTime", "level14", "month/DateTime"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, DateFactTable.DIM0_L1Col);
        iterator.setLevelMember(1, (Object[])DateFactTable.DIM1_YEAR_Col);
        iterator.setLevelMember(2, DateFactTable.ATTRIBUTE_Col);
        iterator.setLevelMember(3, (Object[])DateFactTable.DIM1_QUARTER_Col);
        iterator.setLevelMember(4, DateFactTable.ATTRIBUTE_Col);
        iterator.setLevelMember(5, (Object[])DateFactTable.DIM1_MONTH_Col);
        iterator.setLevelMember(6, DateFactTable.ATTRIBUTE_Col);
        ILevelDefn[] levelDefs = new ILevelDefn[4];
        levelDefs[0] = new LevelDefinition("level11", new String[]{"level11"}, null);
        levelDefs[1] = new LevelDefinition("level12", new String[]{"level12"}, new String[]{"year/DateTime"});
        levelDefs[1].setTimeType("year");
        levelDefs[2] = new LevelDefinition("level13", new String[]{"level13"}, new String[]{"quarter/DateTime"});
        levelDefs[2].setTimeType("quarter");
        levelDefs[3] = new LevelDefinition("level14", new String[]{"level14"}, new String[]{"month/DateTime"});
        levelDefs[3].setTimeType("month");
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[0].getHierarchy();
        dimensions[0].getAllRows(new StopSign());
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, DateFactTable.DIM2_L2Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[1].getHierarchy();
        dimensions[1].getAllRows(new StopSign());
        DateFactTable factTable2 = new DateFactTable();
        String[] measureColumnName = new String[]{"measure1"};
        Cube cube = new Cube(cubeName, documentManager);
        cube.create(DateCube.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        cube.close();
        documentManager.flush();
    }

    ICube getCube(String cubeName, DataEngineImpl engine) throws DataException, IOException {
        ICube cube = null;
        IDocumentManager documentManager = DocumentManagerFactory.loadFileDocumentManager((String)engine.getSession().getTempDir(), (String)cubeName);
        cube = CubeQueryExecutorHelper.loadCube((String)cubeName, (IDocumentManager)documentManager, (StopSign)engine.getSession().getStopSign());
        return cube;
    }

    public static String[][] getKeyColNames(IDimension[] dimensions) {
        String[][] keyColumnName = new String[][]{{"level11", "level12", "level13", "level14"}, {"level21"}};
        return keyColumnName;
    }
}

