/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.CubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeMaterializer;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.ComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.JSMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.data.impl.SelectionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.TestFactTable;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.LevelFilter;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionForTest;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeElementFactory;
import org.eclipse.birt.data.engine.olap.util.filter.BaseDimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.DimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFacttableFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import testutil.BaseTestCase;

public class CubeAggregationTest
extends BaseTestCase {
    String pathName;
    private ImporterTopLevel baseScope;
    private ICubeQueryDefinition cubeQuery;
    IDocumentManager documentManager;
    private ILevelDefinition level21;
    private ILevelDefinition level31;
    private DimLevel dimLevel21 = new DimLevel("dimension2", "level21");
    private DimLevel dimLevel31 = new DimLevel("dimension3", "level31");
    private DimLevel dimLevel11 = new DimLevel("dimension1", "level11");
    private DimLevel dimLevel12 = new DimLevel("dimension1", "level12");
    private CubeMaterializer materializer;
    private ScriptContext cx = null;
    private DataEngineImpl engine = null;

    public CubeAggregationTest() {
        this.pathName = System.getProperty("java.io.tmpdir");
        this.baseScope = new ImporterTopLevel();
    }

    public void setUp() throws Exception {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(CubeAggregationTest.getTempDir());
        this.engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.materializer = new CubeMaterializer(this.engine);
        this.documentManager = this.materializer.getDocumentManager();
        this.createCube1(this.documentManager);
        this.cx = new ScriptContext();
        this.createCube1QueryDefn();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.documentManager.close();
        this.engine.shutdown();
        super.tearDown();
    }

    protected void finalize() throws Throwable {
        this.documentManager.close();
        this.documentManager = null;
        super.finalize();
    }

    public void testRAAggregation1() throws IOException, BirtException {
        IDocArchiveWriter writer = this.createRAWriter();
        this.materializer.saveCubeToReportDocument("cube1", writer, new StopSign());
        writer.flush();
        writer.finish();
        this.documentManager = this.createRADocumentManager();
        this.testCube1Aggregation();
        this.documentManager.close();
    }

    private IDocumentManager createRADocumentManager() throws IOException, DataException {
        ArchiveFile archiveFile = new ArchiveFile(String.valueOf(this.pathName) + File.separator + "docForTest", "rw+");
        ArchiveReader reader = new ArchiveReader((IArchiveFile)archiveFile);
        IDocumentManager documentManager = DocumentManagerFactory.createRADocumentManager((IDocArchiveReader)reader);
        return documentManager;
    }

    private IDocArchiveWriter createRAWriter() throws IOException {
        ArchiveFile archiveFile = new ArchiveFile(String.valueOf(this.pathName) + File.separator + "docForTest", "rw+");
        ArchiveWriter writer = new ArchiveWriter((IArchiveFile)archiveFile);
        return writer;
    }

    private void createCube1QueryDefn() throws DataException {
        this.cubeQuery = new CubeElementFactory().createCubeQuery("cube1");
        IEdgeDefinition rowEdge = this.cubeQuery.createEdge(1);
        IEdgeDefinition columnEdge = this.cubeQuery.createEdge(2);
        IDimensionDefinition dimension1 = rowEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dimension1.createHierarchy("hier1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        Binding bindin11 = new Binding("edge1_level11");
        bindin11.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        this.cubeQuery.addBinding((IBinding)bindin11);
        Binding bindin12 = new Binding("edge1_level12");
        bindin11.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        this.cubeQuery.addBinding((IBinding)bindin12);
        Binding bindin13 = new Binding("edge1_level13");
        bindin11.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        this.cubeQuery.addBinding((IBinding)bindin13);
        IDimensionDefinition dimension2 = columnEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dimension2.createHierarchy("hier2");
        this.level21 = hier2.createLevel("level21");
        Binding bindin21 = new Binding("edge1_level21");
        bindin11.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        this.cubeQuery.addBinding((IBinding)bindin21);
        IDimensionDefinition dimension3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition hier3 = dimension3.createHierarchy("hier3");
        this.level31 = hier3.createLevel("level31");
        Binding bindin31 = new Binding("edge1_level31");
        bindin11.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension3\"][\"level31\"]"));
        this.cubeQuery.addBinding((IBinding)bindin31);
        Binding measure1 = new Binding("measure1");
        measure1.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        this.cubeQuery.addBinding((IBinding)measure1);
        Binding measure2 = new Binding("measure2");
        measure2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure2\"]"));
        this.cubeQuery.addBinding((IBinding)measure2);
    }

    private static String[] distinct(String[] iValues) {
        Arrays.sort(iValues);
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add(iValues[0]);
        int i = 1;
        while (i < iValues.length) {
            if (!iValues[i].equals(iValues[i - 1])) {
                tempList.add(iValues[i]);
            }
            ++i;
        }
        String[] result = new String[tempList.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (String)tempList.get(i2);
            ++i2;
        }
        return result;
    }

    private void createCube1(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Dimension[] dimensions = new Dimension[3];
        String[] colNames = new String[]{"col11", "col12", "col13"};
        DimensionForTest iterator = new DimensionForTest(colNames);
        iterator.setLevelMember(0, TestFactTable.L1Col);
        iterator.setLevelMember(1, TestFactTable.L2Col);
        iterator.setLevelMember(2, TestFactTable.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"col11"}, null), new LevelDefinition("level12", new String[]{"col12"}, null), new LevelDefinition("level13", new String[]{"col13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        CubeAggregationTest.assertEquals((String)hierarchy.getName(), (String)"dimension1");
        CubeAggregationTest.assertEquals((int)dimensions[0].length(), (int)TestFactTable.L1Col.length);
        colNames = new String[]{"level21"};
        iterator = new DimensionForTest(colNames);
        iterator.setLevelMember(0, CubeAggregationTest.distinct(TestFactTable.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        CubeAggregationTest.assertEquals((String)hierarchy.getName(), (String)"dimension2");
        CubeAggregationTest.assertEquals((int)dimensions[1].length(), (int)3);
        colNames = new String[]{"level31"};
        iterator = new DimensionForTest(colNames);
        iterator.setLevelMember(0, TestFactTable.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        CubeAggregationTest.assertEquals((String)hierarchy.getName(), (String)"dimension3");
        CubeAggregationTest.assertEquals((int)dimensions[2].length(), (int)12);
        TestFactTable factTable2 = new TestFactTable();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        Cube cube = new Cube("cube1", documentManager);
        cube.create(CubeUtility.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        documentManager.flush();
    }

    public void testCube1Aggregation() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()), (IComputedMeasureHelper)new ComputedMeasureHelper(), null);
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{"1"}, (Object[])new Object[]{"3"}, (boolean)true, (boolean)false);
        cubeQueryExcutorHelper.addFilter(new LevelFilter(this.dimLevel21, filter[0]));
        AggregationDefinition[] aggregations = new AggregationDefinition[4];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM"), new AggregationFunctionDefinition("C_Measure1", "SUM")};
        AggregationFunctionDefinition[] funcitonsWithParameterCol = new AggregationFunctionDefinition[3];
        funcitonsWithParameterCol[0] = new AggregationFunctionDefinition("measure1", "SUM");
        funcitonsWithParameterCol[1] = new AggregationFunctionDefinition(null, "measure1", new DimLevel("dimension1", "level12"), "col12", "WEIGHTEDAVE");
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        sortType = new int[]{0, 0};
        levelsForFilter = new DimLevel[]{this.dimLevel31};
        aggregations[1] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        aggregations[2] = new AggregationDefinition(null, null, funcitons);
        aggregations[3] = new AggregationDefinition(levelsForFilter, sortType, null);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeQueryExecutorHelper.saveAggregationResultSet((String)this.pathName, (String)"test2", (IAggregationResultSet[])resultSet);
        resultSet = CubeQueryExecutorHelper.loadAggregationResultSet((String)this.pathName, (String)"test2");
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)2);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        resultSet[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"1");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(1), (Object)new Double(10.0));
        resultSet[0].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"2");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(1), (Object)new Double(26.0));
        CubeAggregationTest.assertEquals((int)resultSet[1].length(), (int)8);
        CubeAggregationTest.assertEquals((int)resultSet[1].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[1].getLevelIndex(this.dimLevel31), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[1].getLevelKeyDataType(this.dimLevel31, "level31"), (int)2);
        resultSet[1].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(1));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(0.0));
        resultSet[1].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(2));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(1.0));
        resultSet[1].seek(2);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(3));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(2.0));
        resultSet[1].seek(3);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(4));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(3.0));
        resultSet[1].seek(4);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(5));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(4.0));
        resultSet[1].seek(5);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(6));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(5.0));
        resultSet[1].seek(6);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(7));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[1].seek(7);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(8));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(7.0));
        CubeAggregationTest.assertEquals((int)resultSet[2].length(), (int)1);
        CubeAggregationTest.assertEquals((int)resultSet[2].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[2].getLevelIndex(this.dimLevel31), (int)-1);
        resultSet[2].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[2].getLevelKeyValue(0), null);
        CubeAggregationTest.assertEquals((Object)resultSet[2].getAggregationValue(0), (Object)new Double(28.0));
        CubeAggregationTest.assertEquals((int)resultSet[3].length(), (int)8);
        CubeAggregationTest.assertEquals((int)resultSet[3].getAggregationDataType(0), (int)-1);
        CubeAggregationTest.assertEquals((int)resultSet[3].getLevelIndex(this.dimLevel31), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[3].getLevelKeyDataType(this.dimLevel31, "level31"), (int)2);
        resultSet[3].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[3].getLevelKeyValue(0)[0], (Object)new Integer(1));
        CubeAggregationTest.assertEquals((Object)resultSet[3].getAggregationValue(0), null);
        resultSet[3].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSet[3].getLevelKeyValue(0)[0], (Object)new Integer(2));
        resultSet[3].seek(2);
        CubeAggregationTest.assertEquals((Object)resultSet[3].getLevelKeyValue(0)[0], (Object)new Integer(3));
        CubeAggregationTest.assertEquals((Object)resultSet[3].getAggregationValue(0), null);
        resultSet[3].seek(3);
        CubeAggregationTest.assertEquals((Object)resultSet[3].getLevelKeyValue(0)[0], (Object)new Integer(4));
        resultSet[3].seek(4);
        CubeAggregationTest.assertEquals((Object)resultSet[3].getLevelKeyValue(0)[0], (Object)new Integer(5));
        CubeAggregationTest.assertEquals((Object)resultSet[3].getAggregationValue(0), null);
        resultSet[3].seek(5);
        CubeAggregationTest.assertEquals((Object)resultSet[3].getLevelKeyValue(0)[0], (Object)new Integer(6));
        resultSet[3].seek(6);
        CubeAggregationTest.assertEquals((Object)resultSet[3].getLevelKeyValue(0)[0], (Object)new Integer(7));
        resultSet[3].seek(7);
        CubeAggregationTest.assertEquals((Object)resultSet[3].getLevelKeyValue(0)[0], (Object)new Integer(8));
        int i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }

    public void testCube1AggregationWithFunctionFilter() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition(null, "measure1", null, null, "SUM", (IJSFacttableFilterEvalHelper)new JSMeasureFilterEvalHelper())};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeQueryExecutorHelper.saveAggregationResultSet((String)this.pathName, (String)"test2", (IAggregationResultSet[])resultSet);
        resultSet = CubeQueryExecutorHelper.loadAggregationResultSet((String)this.pathName, (String)"test2");
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        resultSet[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"1");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(4.0));
        resultSet[0].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"2");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(12.0));
        resultSet[0].seek(2);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"3");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(20.0));
    }

    public void testCube1AggregationWithMeasureFilter() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition(null, "measure1", null, null, "SUM", null)};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        JSMeasureFilterEvalHelper measureFilter = new JSMeasureFilterEvalHelper();
        ArrayList<JSMeasureFilterEvalHelper> helper = new ArrayList<JSMeasureFilterEvalHelper>();
        helper.add(measureFilter);
        cubeQueryExcutorHelper.addMeasureFilter(helper);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeQueryExecutorHelper.saveAggregationResultSet((String)this.pathName, (String)"test2", (IAggregationResultSet[])resultSet);
        resultSet = CubeQueryExecutorHelper.loadAggregationResultSet((String)this.pathName, (String)"test2");
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        resultSet[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"1");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(4.0));
        resultSet[0].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"2");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(12.0));
        resultSet[0].seek(2);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"3");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(20.0));
    }

    public void testEmptyAggregation() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{"3999"}, (Object[])new Object[]{"1"}, (boolean)true, (boolean)false);
        cubeQueryExcutorHelper.addFilter(new LevelFilter(this.dimLevel21, filter[0]));
        AggregationDefinition[] aggregations = new AggregationDefinition[4];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        AggregationFunctionDefinition[] funcitonsWithParameterCol = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM"), new AggregationFunctionDefinition(null, "measure1", new DimLevel("dimension1", "level12"), "col12", "WEIGHTEDAVE")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        sortType = new int[]{0, 0};
        levelsForFilter = new DimLevel[]{this.dimLevel31};
        aggregations[1] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        aggregations[2] = new AggregationDefinition(null, null, funcitons);
        aggregations[3] = new AggregationDefinition(levelsForFilter, sortType, null);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeQueryExecutorHelper.saveAggregationResultSet((String)this.pathName, (String)"test2", (IAggregationResultSet[])resultSet);
        resultSet = CubeQueryExecutorHelper.loadAggregationResultSet((String)this.pathName, (String)"test2");
        int i = 0;
        while (i < resultSet.length) {
            CubeAggregationTest.assertEquals((int)resultSet[i].length(), (int)0);
            resultSet[i].close();
            ++i;
        }
    }

    public void testCube1AggregationWithColPara() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{"1"}, (Object[])new Object[]{"3"}, (boolean)true, (boolean)false);
        cubeQueryExcutorHelper.addFilter(new LevelFilter(this.dimLevel21, filter[0]));
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[]{0};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        AggregationFunctionDefinition[] funcitonsWithParameterCol = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        funcitonsWithParameterCol[0] = new AggregationFunctionDefinition(null, "measure1", new DimLevel("dimension1", "level12"), "col12", "WEIGHTEDAVE");
        aggregations[0] = new AggregationDefinition(null, null, funcitonsWithParameterCol);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)1);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel31), (int)-1);
        resultSet[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0), null);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(3.8333333333333335));
        int i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }

    public void testCube1AggrFilter1() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        Binding level21_sum = new Binding("level21_sum");
        level21_sum.setAggrFunction("SUM");
        level21_sum.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        level21_sum.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        this.cubeQuery.addBinding((IBinding)level21_sum);
        ScriptExpression expr = new ScriptExpression("data[\"level21_sum\"]>30");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr);
        cubeFilter.setTargetLevel(this.level21);
        DimensionFilterEvalHelper filterHelper = new DimensionFilterEvalHelper(null, (Scriptable)this.baseScope, this.cx, this.cubeQuery, (IFilterDefinition)cubeFilter);
        cubeQueryExcutorHelper.addJSFilter((IJSFilterHelper)filterHelper);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("level21_sum", "measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)1);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        resultSet[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"3");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(38.0));
        int i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }

    public void testCube1AggrFilter2() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{"1"}, (Object[])new Object[]{"3"}, (boolean)true, (boolean)false);
        cubeQueryExcutorHelper.addFilter(new LevelFilter(this.dimLevel21, filter[0]));
        Binding level21_sum = new Binding("level21_sum");
        level21_sum.setAggrFunction("SUM");
        level21_sum.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        level21_sum.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        level21_sum.addAggregateOn("dimension[\"dimension3\"][\"level31\"]");
        this.cubeQuery.addBinding((IBinding)level21_sum);
        ScriptExpression expr = new ScriptExpression("data[\"level21_sum\"]>2");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr);
        cubeFilter.setTargetLevel(this.level21);
        DimensionFilterEvalHelper dimfilter = new DimensionFilterEvalHelper(null, (Scriptable)this.baseScope, this.cx, this.cubeQuery, (IFilterDefinition)cubeFilter);
        cubeQueryExcutorHelper.addJSFilter((IJSFilterHelper)dimfilter);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[2];
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21, this.dimLevel31};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("level21_sum", "measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)8);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel31), (int)1);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        int i = 0;
        while (i < 8) {
            resultSet[0].seek(i);
            CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)String.valueOf(i / 4 + 1));
            CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(1)[0], (Object)new Integer(i + 1));
            CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(i));
            ++i;
        }
        i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }

    public void testCube1AggrFilter3() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{"1"}, (Object[])new Object[]{"3"}, (boolean)true, (boolean)false);
        cubeQueryExcutorHelper.addFilter(new LevelFilter(this.dimLevel21, filter[0]));
        Binding level21_sum = new Binding("level21_sum");
        level21_sum.setAggrFunction("SUM");
        level21_sum.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        level21_sum.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        this.cubeQuery.addBinding((IBinding)level21_sum);
        ScriptExpression expr = new ScriptExpression("data[\"level21_sum\"]>40");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr);
        cubeFilter.setTargetLevel(this.level21);
        DimensionFilterEvalHelper dimfilter = new DimensionFilterEvalHelper(null, (Scriptable)this.baseScope, this.cx, this.cubeQuery, (IFilterDefinition)cubeFilter);
        cubeQueryExcutorHelper.addJSFilter((IJSFilterHelper)dimfilter);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[1];
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("level21_sum", "measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)0);
        int i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }

    public void testCube1AggrFilter4() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        Binding level21_sum = new Binding("level21_sum");
        level21_sum.setAggrFunction("SUM");
        level21_sum.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        level21_sum.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        this.cubeQuery.addBinding((IBinding)level21_sum);
        ScriptExpression expr = new ScriptExpression("data[\"level21_sum\"]>0");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr);
        cubeFilter.setTargetLevel(this.level21);
        cubeFilter.setAxisQualifierLevels(new ILevelDefinition[]{this.level21});
        cubeFilter.setAxisQualifierValues(new Object[]{"1"});
        DimensionFilterEvalHelper dimfilter = new DimensionFilterEvalHelper(null, (Scriptable)this.baseScope, this.cx, this.cubeQuery, (IFilterDefinition)cubeFilter);
        cubeQueryExcutorHelper.addJSFilter((IJSFilterHelper)dimfilter);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[1];
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("level21_sum", "measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)1);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        resultSet[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"1");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        int i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }

    public void testCube1AggrFilter5() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        Binding level21_sum = new Binding("level21_sum");
        level21_sum.setAggrFunction("SUM");
        level21_sum.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        level21_sum.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        level21_sum.addAggregateOn("dimension[\"dimension3\"][\"level31\"]");
        this.cubeQuery.addBinding((IBinding)level21_sum);
        ScriptExpression expr = new ScriptExpression("data[\"level21_sum\"]>0");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr);
        cubeFilter.setTargetLevel(this.level21);
        cubeFilter.setAxisQualifierLevels(new ILevelDefinition[]{this.level31});
        cubeFilter.setAxisQualifierValues(new Object[]{new Integer(4)});
        DimensionFilterEvalHelper dimfilter = new DimensionFilterEvalHelper(null, (Scriptable)this.baseScope, this.cx, this.cubeQuery, (IFilterDefinition)cubeFilter);
        cubeQueryExcutorHelper.addJSFilter((IJSFilterHelper)dimfilter);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[2];
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21, this.dimLevel31};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("level21_sum", "measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)4);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel31), (int)1);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel31, "level31"), (int)2);
        int index1 = resultSet[0].getLevelIndex(this.dimLevel21);
        int index2 = resultSet[0].getLevelIndex(this.dimLevel31);
        int i = 0;
        while (i < resultSet[0].length()) {
            resultSet[0].seek(i);
            CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(index1)[0], (Object)"1");
            CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(index2)[0], (Object)new Integer(i + 1));
            CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(i));
            ++i;
        }
        i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }

    public void testCube1AggrFilter6() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        Binding level21_sum = new Binding("level21_sum");
        level21_sum.setAggrFunction("SUM");
        level21_sum.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        level21_sum.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        this.cubeQuery.addBinding((IBinding)level21_sum);
        ConditionalExpression expr1 = new ConditionalExpression("data[\"level21_sum\"]", 14, "2");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr1);
        cubeFilter.setTargetLevel(this.level21);
        IJSFilterHelper filterHelper = BaseDimensionFilterEvalHelper.createFilterHelper(null, (Scriptable)this.baseScope, (ICubeQueryDefinition)this.cubeQuery, (IFilterDefinition)cubeFilter, (ScriptContext)this.cx);
        cubeQueryExcutorHelper.addJSFilter(filterHelper);
        ConditionalExpression expr2 = new ConditionalExpression("data[\"level21_sum\"]", 15, "2");
        CubeFilterDefinition cubeFilter2 = new CubeFilterDefinition((IBaseExpression)expr2);
        cubeFilter2.setTargetLevel(this.level21);
        IJSFilterHelper filterHelper2 = BaseDimensionFilterEvalHelper.createFilterHelper(null, (Scriptable)this.baseScope, (ICubeQueryDefinition)this.cubeQuery, (IFilterDefinition)cubeFilter2, (ScriptContext)this.cx);
        cubeQueryExcutorHelper.addJSFilter(filterHelper2);
        ConditionalExpression expr3 = new ConditionalExpression("data[\"level21_sum\"]", 15, "3");
        CubeFilterDefinition cubeFilter3 = new CubeFilterDefinition((IBaseExpression)expr3);
        cubeFilter3.setTargetLevel(this.level21);
        IJSFilterHelper filterHelper3 = BaseDimensionFilterEvalHelper.createFilterHelper(null, (Scriptable)this.baseScope, (ICubeQueryDefinition)this.cubeQuery, (IFilterDefinition)cubeFilter3, (ScriptContext)this.cx);
        cubeQueryExcutorHelper.addJSFilter(filterHelper3);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("level21_sum", "measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)1);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        resultSet[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"2");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        int i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }

    public void testCube1AggrFilter7() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        Binding level21_sum = new Binding("level21_sum");
        level21_sum.setAggrFunction("SUM");
        level21_sum.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        level21_sum.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        this.cubeQuery.addBinding((IBinding)level21_sum);
        ConditionalExpression expr1 = new ConditionalExpression("data[\"level21_sum\"]", 16, "70");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr1);
        cubeFilter.setTargetLevel(this.level21);
        IJSFilterHelper filterHelper = BaseDimensionFilterEvalHelper.createFilterHelper(null, (Scriptable)this.baseScope, (ICubeQueryDefinition)this.cubeQuery, (IFilterDefinition)cubeFilter, (ScriptContext)this.cx);
        cubeQueryExcutorHelper.addJSFilter(filterHelper);
        ConditionalExpression expr2 = new ConditionalExpression("data[\"level21_sum\"]", 17, "70");
        CubeFilterDefinition cubeFilter2 = new CubeFilterDefinition((IBaseExpression)expr2);
        cubeFilter2.setTargetLevel(this.level21);
        IJSFilterHelper filterHelper2 = BaseDimensionFilterEvalHelper.createFilterHelper(null, (Scriptable)this.baseScope, (ICubeQueryDefinition)this.cubeQuery, (IFilterDefinition)cubeFilter2, (ScriptContext)this.cx);
        cubeQueryExcutorHelper.addJSFilter(filterHelper2);
        ConditionalExpression expr3 = new ConditionalExpression("data[\"level21_sum\"]", 16, "90");
        CubeFilterDefinition cubeFilter3 = new CubeFilterDefinition((IBaseExpression)expr3);
        cubeFilter3.setTargetLevel(this.level21);
        IJSFilterHelper filterHelper3 = BaseDimensionFilterEvalHelper.createFilterHelper(null, (Scriptable)this.baseScope, (ICubeQueryDefinition)this.cubeQuery, (IFilterDefinition)cubeFilter3, (ScriptContext)this.cx);
        cubeQueryExcutorHelper.addJSFilter(filterHelper3);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("level21_sum", "measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)1);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        resultSet[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"2");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        int i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }

    public void testCube1AggrFilter8() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        Binding level21_sum = new Binding("level21_sum");
        level21_sum.setAggrFunction("SUM");
        level21_sum.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        level21_sum.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        this.cubeQuery.addBinding((IBinding)level21_sum);
        ConditionalExpression expr1 = new ConditionalExpression("dimension[\"dimension2\"][\"level21\"]", 14, "1");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr1);
        IJSFilterHelper filterHelper = BaseDimensionFilterEvalHelper.createFilterHelper(null, (Scriptable)this.baseScope, (ICubeQueryDefinition)this.cubeQuery, (IFilterDefinition)cubeFilter, (ScriptContext)this.cx);
        cubeQueryExcutorHelper.addJSFilter(filterHelper);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("level21_sum", "measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)1);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        resultSet[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"3");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(38.0));
        int i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }

    public void testCube1AggrFilter9() throws IOException, DataException, BirtException {
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube1", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        Binding level21_sum = new Binding("level21_sum");
        level21_sum.setAggrFunction("SUM");
        level21_sum.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        level21_sum.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        this.cubeQuery.addBinding((IBinding)level21_sum);
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add("1");
        valueList.add("2");
        ConditionalExpression expr1 = new ConditionalExpression("dimension[\"dimension2\"][\"level21\"]", 22, valueList);
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr1);
        IJSFilterHelper filterHelper = BaseDimensionFilterEvalHelper.createFilterHelper(null, (Scriptable)this.baseScope, (ICubeQueryDefinition)this.cubeQuery, (IFilterDefinition)cubeFilter, (ScriptContext)this.cx);
        cubeQueryExcutorHelper.addJSFilter(filterHelper);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("level21_sum", "measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)2);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        resultSet[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"1");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[0].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"2");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        int i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }

    private void createCube2() throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[2];
        String[] ColNames = new String[]{"col11", "col12", "col13"};
        DimensionForTest iterator = new DimensionForTest(ColNames);
        iterator.setLevelMember(0, TestFactTable.L1Col);
        iterator.setLevelMember(1, TestFactTable.L2Col);
        iterator.setLevelMember(2, TestFactTable.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"col11"}, null), new LevelDefinition("level12", new String[]{"col12"}, null), new LevelDefinition("level13", new String[]{"col13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)this.documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        CubeAggregationTest.assertEquals((String)hierarchy.getName(), (String)"dimension1");
        CubeAggregationTest.assertEquals((int)dimensions[0].length(), (int)TestFactTable.L1Col.length);
        ColNames = new String[]{"level21"};
        iterator = new DimensionForTest(ColNames);
        iterator.setLevelMember(0, CubeAggregationTest.distinct(TestFactTable.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)this.documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        CubeAggregationTest.assertEquals((String)hierarchy.getName(), (String)"dimension2");
        CubeAggregationTest.assertEquals((int)dimensions[1].length(), (int)3);
        TestFactTable factTable2 = new TestFactTable();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        Cube cube = new Cube("cube2", this.documentManager);
        cube.create(CubeUtility.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        this.documentManager.flush();
    }

    public void testCube2Aggregation() throws IOException, BirtException {
        this.createCube2();
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube2", (IDocumentManager)this.documentManager, (StopSign)new StopSign()));
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{"1"}, (Object[])new Object[]{"3"}, (boolean)true, (boolean)false);
        cubeQueryExcutorHelper.addFilter(new LevelFilter(this.dimLevel21, filter[0]));
        AggregationDefinition[] aggregations = new AggregationDefinition[4];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        sortType = new int[]{0, 0};
        levelsForFilter = new DimLevel[]{this.dimLevel11, this.dimLevel12};
        funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        aggregations[1] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        sortType = new int[]{0};
        levelsForFilter = new DimLevel[]{this.dimLevel21};
        funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        aggregations[2] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        sortType = new int[]{0};
        levelsForFilter = new DimLevel[]{this.dimLevel11};
        funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        aggregations[3] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        CubeQueryExecutorHelper.saveAggregationResultSet((String)this.pathName, (String)"test1", (IAggregationResultSet[])resultSet);
        resultSet = CubeQueryExecutorHelper.loadAggregationResultSet((String)this.pathName, (String)"test1");
        CubeAggregationTest.assertEquals((int)resultSet[0].length(), (int)2);
        CubeAggregationTest.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        resultSet[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"1");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[0].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)"2");
        CubeAggregationTest.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        CubeAggregationTest.assertEquals((int)resultSet[1].length(), (int)4);
        CubeAggregationTest.assertEquals((int)resultSet[1].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[1].getLevelIndex(this.dimLevel21), (int)-1);
        CubeAggregationTest.assertEquals((int)resultSet[1].getLevelIndex(this.dimLevel11), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[1].getLevelIndex(this.dimLevel12), (int)1);
        CubeAggregationTest.assertEquals((int)resultSet[1].getLevelKeyDataType(this.dimLevel11, "col11"), (int)5);
        CubeAggregationTest.assertEquals((int)resultSet[1].getLevelKeyDataType(this.dimLevel12, "col12"), (int)2);
        resultSet[1].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)"1");
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(1)[0], (Object)new Integer(1));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(1.0));
        resultSet[1].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)"1");
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(1)[0], (Object)new Integer(2));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(5.0));
        resultSet[1].seek(2);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)"2");
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(1)[0], (Object)new Integer(1));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(9.0));
        resultSet[1].seek(3);
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)"2");
        CubeAggregationTest.assertEquals((Object)resultSet[1].getLevelKeyValue(1)[0], (Object)new Integer(2));
        CubeAggregationTest.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(13.0));
        CubeAggregationTest.assertEquals((int)resultSet[2].length(), (int)2);
        CubeAggregationTest.assertEquals((int)resultSet[2].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[2].getLevelIndex(this.dimLevel21), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[2].getLevelKeyDataType(this.dimLevel21, "level21"), (int)5);
        resultSet[2].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[2].getLevelKeyValue(0)[0], (Object)"1");
        CubeAggregationTest.assertEquals((Object)resultSet[2].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[2].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSet[2].getLevelKeyValue(0)[0], (Object)"2");
        CubeAggregationTest.assertEquals((Object)resultSet[2].getAggregationValue(0), (Object)new Double(22.0));
        CubeAggregationTest.assertEquals((int)resultSet[3].length(), (int)2);
        CubeAggregationTest.assertEquals((int)resultSet[3].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSet[3].getLevelIndex(this.dimLevel11), (int)0);
        CubeAggregationTest.assertEquals((int)resultSet[3].getLevelKeyDataType(this.dimLevel11, "col11"), (int)5);
        resultSet[3].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSet[3].getLevelKeyValue(0)[0], (Object)"1");
        CubeAggregationTest.assertEquals((Object)resultSet[3].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[3].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSet[3].getLevelKeyValue(0)[0], (Object)"2");
        CubeAggregationTest.assertEquals((Object)resultSet[3].getAggregationValue(0), (Object)new Double(22.0));
        int i = 0;
        while (i < resultSet.length) {
            resultSet[i].close();
            ++i;
        }
    }
}

