/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.IOException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import testutil.BaseTestCase;

public class CubeAggregationTest
extends BaseTestCase {
    private DimLevel[] dimLevels = new DimLevel[]{new DimLevel("geography", "province"), new DimLevel("geography", "city"), new DimLevel("customer", "name"), new DimLevel("product", "productID")};
    AggregationResultSet aggregationResultSet = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.createAggregationResult();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSumAggregation1() throws IOException, DataException {
        AggregationDefinition[] aggregations = new AggregationDefinition[2];
        int[] sortTypes = new int[2];
        AggregationFunctionDefinition[] aggregationFunctions = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("pSale", "totalSale", "SUM"), new AggregationFunctionDefinition("pCount", "totalCost", "COUNT")};
        DimLevel[] dimLevels = new DimLevel[]{this.dimLevels[0], this.dimLevels[2]};
        aggregations[0] = new AggregationDefinition(dimLevels, sortTypes, aggregationFunctions);
        sortTypes = new int[1];
        dimLevels = new DimLevel[]{this.dimLevels[0]};
        aggregations[1] = new AggregationDefinition(dimLevels, sortTypes, aggregationFunctions);
        AggregationHelper.getInstance();
        IAggregationResultSet[] resultSets = AggregationHelper.execute((IAggregationResultSet)this.aggregationResultSet, (AggregationDefinition[])aggregations, (StopSign)new StopSign());
        CubeAggregationTest.assertEquals((int)resultSets[0].length(), (int)6);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAggregationCount(), (int)2);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAggregationDataType(1), (int)2);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAllLevels().length, (int)2);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(0), (Object)this.dimLevels[0]);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(1), (Object)this.dimLevels[2]);
        CubeAggregationTest.assertEquals((int)resultSets[0].getLevelKeyColCount(0), (int)1);
        CubeAggregationTest.assertEquals((int)resultSets[0].getLevelKeyColCount(1), (int)1);
        resultSets[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(0)[0], (Object)"AnHui");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(1)[0], (Object)"li");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)new Double(110.0));
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(1), (Object)new Integer(1));
        resultSets[0].seek(2);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(0)[0], (Object)"AnHui");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(1)[0], (Object)"zhao");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)new Double(750.0));
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(1), (Object)new Integer(5));
        resultSets[0].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(0)[0], (Object)"AnHui");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(1)[0], (Object)"wang");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)new Double(120.0));
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(1), (Object)new Integer(1));
        resultSets[0].seek(3);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(0)[0], (Object)"HeBei");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(1)[0], (Object)"li");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)new Double(250.0));
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(1), (Object)new Integer(2));
        resultSets[0].seek(4);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(0)[0], (Object)"HeBei");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(1)[0], (Object)"wang");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)new Double(780.0));
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(1), (Object)new Integer(5));
        resultSets[0].seek(5);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(0)[0], (Object)"ShanTong");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(1)[0], (Object)"wang");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)new Double(288.0));
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(1), (Object)new Integer(2));
        CubeAggregationTest.assertEquals((int)resultSets[1].length(), (int)3);
        CubeAggregationTest.assertEquals((int)resultSets[1].getAggregationCount(), (int)2);
        CubeAggregationTest.assertEquals((int)resultSets[1].getAllLevels().length, (int)1);
        CubeAggregationTest.assertEquals((Object)resultSets[1].getLevel(0), (Object)this.dimLevels[0]);
        CubeAggregationTest.assertEquals((int)resultSets[1].getLevelKeyColCount(0), (int)1);
        resultSets[1].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSets[1].getLevelKeyValue(0)[0], (Object)"AnHui");
        CubeAggregationTest.assertEquals((Object)resultSets[1].getAggregationValue(0), (Object)new Double(980.0));
        CubeAggregationTest.assertEquals((Object)resultSets[1].getAggregationValue(1), (Object)new Integer(7));
        resultSets[1].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSets[1].getLevelKeyValue(0)[0], (Object)"HeBei");
        CubeAggregationTest.assertEquals((Object)resultSets[1].getAggregationValue(0), (Object)new Double(1030.0));
        CubeAggregationTest.assertEquals((Object)resultSets[1].getAggregationValue(1), (Object)new Integer(7));
        resultSets[1].seek(2);
        CubeAggregationTest.assertEquals((Object)resultSets[1].getLevelKeyValue(0)[0], (Object)"ShanTong");
        CubeAggregationTest.assertEquals((Object)resultSets[1].getAggregationValue(0), (Object)new Double(288.0));
        CubeAggregationTest.assertEquals((Object)resultSets[1].getAggregationValue(1), (Object)new Integer(2));
    }

    public void testSumAggregation2() throws IOException, DataException {
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortTypes = new int[1];
        AggregationFunctionDefinition[] aggregationFunctions = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("saleWeightAvg", "totalSale", this.dimLevels[3], "productID", "WEIGHTEDAVE")};
        DimLevel[] dimLevels = new DimLevel[]{this.dimLevels[0], this.dimLevels[2]};
        dimLevels = new DimLevel[]{this.dimLevels[0]};
        aggregations[0] = new AggregationDefinition(dimLevels, sortTypes, aggregationFunctions);
        AggregationHelper.getInstance();
        IAggregationResultSet[] resultSets = AggregationHelper.execute((IAggregationResultSet)this.aggregationResultSet, (AggregationDefinition[])aggregations, (StopSign)new StopSign());
        resultSets[0].seek(0);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(0)[0], (Object)"AnHui");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)new Double(144.0909090909091));
        resultSets[0].seek(1);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(0)[0], (Object)"HeBei");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)new Double(159.16666666666666));
        resultSets[0].seek(2);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(0)[0], (Object)"ShanTong");
        CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)new Double(177.0));
    }

    public void testRunningAggregation1() throws IOException, DataException {
        AggregationDefinition[] aggregations = new AggregationDefinition[2];
        int[] sortTypes = new int[2];
        AggregationFunctionDefinition[] aggregationFunctions = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("pSale", "totalSale", "RUNNINGSUM"), new AggregationFunctionDefinition("pCount", "totalCost", "RUNNINGCOUNT")};
        DimLevel[] dimLevels = new DimLevel[]{this.dimLevels[0], this.dimLevels[2]};
        aggregations[0] = new AggregationDefinition(dimLevels, sortTypes, aggregationFunctions);
        dimLevels = new DimLevel[]{this.dimLevels[0], this.dimLevels[1]};
        aggregations[1] = new AggregationDefinition(dimLevels, sortTypes, aggregationFunctions);
        AggregationHelper.getInstance();
        IAggregationResultSet[] resultSets = AggregationHelper.execute((IAggregationResultSet)this.aggregationResultSet, (AggregationDefinition[])aggregations, (StopSign)new StopSign());
        CubeAggregationTest.assertEquals((int)resultSets[0].length(), (int)16);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAggregationCount(), (int)2);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAggregationDataType(1), (int)2);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAllLevels().length, (int)4);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(0), (Object)this.dimLevels[0]);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(1), (Object)this.dimLevels[1]);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(2), (Object)this.dimLevels[2]);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(3), (Object)this.dimLevels[3]);
        CubeAggregationTest.assertEquals((int)resultSets[0].getLevelKeyColCount(0), (int)1);
        CubeAggregationTest.assertEquals((int)resultSets[0].getLevelKeyColCount(1), (int)1);
        Object[][] fieldValues = new Object[][]{{"AnHui", "li", new Double(110.0), new Integer(1)}, {"AnHui", "wang", new Double(120.0), new Integer(1)}, {"AnHui", "zhao", new Double(60.0), new Integer(1)}, {"AnHui", "zhao", new Double(360.0), new Integer(2)}, {"AnHui", "zhao", new Double(510.0), new Integer(3)}, {"AnHui", "zhao", new Double(630.0), new Integer(4)}, {"AnHui", "zhao", new Double(750.0), new Integer(5)}, {"HeBei", "li", new Double(100.0), new Integer(1)}, {"HeBei", "li", new Double(250.0), new Integer(2)}, {"HeBei", "wang", new Double(110.0), new Integer(1)}, {"HeBei", "wang", new Double(170.0), new Integer(2)}, {"HeBei", "wang", new Double(470.0), new Integer(3)}, {"HeBei", "wang", new Double(570.0), new Integer(4)}, {"HeBei", "wang", new Double(780.0), new Integer(5)}, {"ShanTong", "wang", new Double(45.0), new Integer(1)}, {"ShanTong", "wang", new Double(288.0), new Integer(2)}};
        int i = 0;
        while (i < fieldValues.length) {
            resultSets[0].seek(i);
            CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(0)[0], (Object)fieldValues[i][0]);
            CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(2)[0], (Object)fieldValues[i][1]);
            CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)fieldValues[i][2]);
            CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(1), (Object)fieldValues[i][3]);
            ++i;
        }
        CubeAggregationTest.assertEquals((int)resultSets[1].length(), (int)16);
        CubeAggregationTest.assertEquals((int)resultSets[1].getAggregationCount(), (int)2);
        CubeAggregationTest.assertEquals((int)resultSets[1].getAggregationDataType(0), (int)3);
        CubeAggregationTest.assertEquals((int)resultSets[1].getAggregationDataType(1), (int)2);
        CubeAggregationTest.assertEquals((int)resultSets[1].getAllLevels().length, (int)4);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(0), (Object)this.dimLevels[0]);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(1), (Object)this.dimLevels[1]);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(2), (Object)this.dimLevels[2]);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(3), (Object)this.dimLevels[3]);
        CubeAggregationTest.assertEquals((int)resultSets[1].getLevelKeyColCount(0), (int)1);
        CubeAggregationTest.assertEquals((int)resultSets[1].getLevelKeyColCount(1), (int)1);
        fieldValues = new Object[][]{{"AnHui", "HeFei", new Double(110.0), new Integer(1)}, {"AnHui", "HeFei", new Double(230.0), new Integer(2)}, {"AnHui", "HeFei", new Double(290.0), new Integer(3)}, {"AnHui", "HuaiBei", new Double(300.0), new Integer(1)}, {"AnHui", "HuaiBei", new Double(450.0), new Integer(2)}, {"AnHui", "HuaiBei", new Double(570.0), new Integer(3)}, {"AnHui", "HuaiBei", new Double(690.0), new Integer(4)}, {"HeBei", "ShiJiaZhuang", new Double(100.0), new Integer(1)}, {"HeBei", "ShiJiaZhuang", new Double(250.0), new Integer(2)}, {"HeBei", "ShiJiaZhuang", new Double(360.0), new Integer(3)}, {"HeBei", "ShiJiaZhuang", new Double(420.0), new Integer(4)}, {"HeBei", "ShiJiaZhuang", new Double(720.0), new Integer(5)}, {"HeBei", "XingTai", new Double(100.0), new Integer(1)}, {"HeBei", "XingTai", new Double(310.0), new Integer(2)}, {"ShanTong", "WeiFang", new Double(45.0), new Integer(1)}, {"ShanTong", "WeiFang", new Double(288.0), new Integer(2)}};
        i = 0;
        while (i < fieldValues.length) {
            resultSets[1].seek(i);
            CubeAggregationTest.assertEquals((Object)resultSets[1].getLevelKeyValue(0)[0], (Object)fieldValues[i][0]);
            CubeAggregationTest.assertEquals((Object)resultSets[1].getLevelKeyValue(1)[0], (Object)fieldValues[i][1]);
            CubeAggregationTest.assertEquals((Object)resultSets[1].getAggregationValue(0), (Object)fieldValues[i][2]);
            CubeAggregationTest.assertEquals((Object)resultSets[1].getAggregationValue(1), (Object)fieldValues[i][3]);
            ++i;
        }
    }

    public void testMultipleAggregation1() throws IOException, DataException {
        int j;
        AggregationDefinition[] aggregations = new AggregationDefinition[2];
        int[] sortTypes = new int[2];
        AggregationFunctionDefinition[] aggregationFunctions = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("saleRank", "totalSale", "RANK")};
        DimLevel[] dimLevels = new DimLevel[]{this.dimLevels[0], this.dimLevels[2]};
        aggregations[0] = new AggregationDefinition(dimLevels, sortTypes, aggregationFunctions);
        dimLevels = new DimLevel[]{this.dimLevels[0], this.dimLevels[1]};
        aggregations[1] = new AggregationDefinition(dimLevels, sortTypes, aggregationFunctions);
        AggregationHelper.getInstance();
        IAggregationResultSet[] resultSets = AggregationHelper.execute((IAggregationResultSet)this.aggregationResultSet, (AggregationDefinition[])aggregations, (StopSign)new StopSign());
        CubeAggregationTest.assertEquals((int)resultSets[0].length(), (int)16);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAggregationCount(), (int)1);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAggregationDataType(0), (int)2);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAllLevels().length, (int)4);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(0), (Object)this.dimLevels[0]);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(1), (Object)this.dimLevels[1]);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(2), (Object)this.dimLevels[2]);
        CubeAggregationTest.assertEquals((Object)resultSets[0].getLevel(3), (Object)this.dimLevels[3]);
        CubeAggregationTest.assertEquals((int)resultSets[0].getLevelKeyColCount(0), (int)1);
        CubeAggregationTest.assertEquals((int)resultSets[0].getLevelKeyColCount(1), (int)1);
        Object[][] fieldValues = new Object[][]{{"AnHui", "HeFei", "li", new Integer(1), new Double(110.0), new Integer(1)}, {"AnHui", "HeFei", "wang", new Integer(1), new Double(120.0), new Integer(1)}, {"AnHui", "HeFei", "zhao", new Integer(2), new Double(60.0), new Integer(1)}, {"AnHui", "HuaiBei", "zhao", new Integer(3), new Double(300.0), new Integer(5)}, {"AnHui", "HuaiBei", "zhao", new Integer(4), new Double(150.0), new Integer(4)}, {"AnHui", "HuaiBei", "zhao", new Integer(5), new Double(120.0), new Integer(2)}, {"AnHui", "HuaiBei", "zhao", new Integer(6), new Double(120.0), new Integer(2)}, {"HeBei", "ShiJiaZhuang", "li", new Integer(1), new Double(100.0), new Integer(1)}, {"HeBei", "ShiJiaZhuang", "li", new Integer(2), new Double(150.0), new Integer(2)}, {"HeBei", "ShiJiaZhuang", "wang", new Integer(3), new Double(110.0), new Integer(3)}, {"HeBei", "ShiJiaZhuang", "wang", new Integer(1), new Double(60.0), new Integer(1)}, {"HeBei", "ShiJiaZhuang", "wang", new Integer(2), new Double(300.0), new Integer(5)}, {"HeBei", "XingTai", "wang", new Integer(1), new Double(100.0), new Integer(2)}, {"HeBei", "XingTai", "wang", new Integer(2), new Double(210.0), new Integer(4)}, {"ShanTong", "WeiFang", "wang", new Integer(1), new Double(45.0), new Integer(1)}, {"ShanTong", "WeiFang", "wang", new Integer(2), new Double(243.0), new Integer(2)}};
        int i = 0;
        while (i < fieldValues.length) {
            resultSets[0].seek(i);
            j = 0;
            while (j < 4) {
                CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(j)[0], (Object)fieldValues[i][j]);
                ++j;
            }
            CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)fieldValues[i][5]);
            ++i;
        }
        CubeAggregationTest.assertEquals((int)resultSets[1].length(), (int)16);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAggregationCount(), (int)1);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAggregationDataType(0), (int)2);
        CubeAggregationTest.assertEquals((int)resultSets[0].getAllLevels().length, (int)4);
        CubeAggregationTest.assertEquals((Object)resultSets[1].getLevel(0), (Object)this.dimLevels[0]);
        CubeAggregationTest.assertEquals((Object)resultSets[1].getLevel(1), (Object)this.dimLevels[1]);
        CubeAggregationTest.assertEquals((int)resultSets[1].getLevelKeyColCount(0), (int)1);
        CubeAggregationTest.assertEquals((int)resultSets[1].getLevelKeyColCount(1), (int)1);
        fieldValues = new Object[][]{{"AnHui", "HeFei", "li", new Integer(1), new Double(110.0), new Integer(1)}, {"AnHui", "HeFei", "wang", new Integer(1), new Double(120.0), new Integer(1)}, {"AnHui", "HeFei", "zhao", new Integer(2), new Double(60.0), new Integer(1)}, {"AnHui", "HuaiBei", "zhao", new Integer(3), new Double(300.0), new Integer(5)}, {"AnHui", "HuaiBei", "zhao", new Integer(4), new Double(150.0), new Integer(4)}, {"AnHui", "HuaiBei", "zhao", new Integer(5), new Double(120.0), new Integer(2)}, {"AnHui", "HuaiBei", "zhao", new Integer(6), new Double(120.0), new Integer(2)}, {"HeBei", "ShiJiaZhuang", "li", new Integer(1), new Double(100.0), new Integer(1)}, {"HeBei", "ShiJiaZhuang", "li", new Integer(2), new Double(150.0), new Integer(2)}, {"HeBei", "ShiJiaZhuang", "wang", new Integer(3), new Double(110.0), new Integer(3)}, {"HeBei", "ShiJiaZhuang", "wang", new Integer(1), new Double(60.0), new Integer(1)}, {"HeBei", "ShiJiaZhuang", "wang", new Integer(2), new Double(300.0), new Integer(5)}, {"HeBei", "XingTai", "wang", new Integer(1), new Double(100.0), new Integer(2)}, {"HeBei", "XingTai", "wang", new Integer(2), new Double(210.0), new Integer(4)}, {"ShanTong", "WeiFang", "wang", new Integer(1), new Double(45.0), new Integer(1)}, {"ShanTong", "WeiFang", "wang", new Integer(2), new Double(243.0), new Integer(2)}};
        i = 0;
        while (i < fieldValues.length) {
            resultSets[0].seek(i);
            j = 0;
            while (j < 4) {
                CubeAggregationTest.assertEquals((Object)resultSets[0].getLevelKeyValue(j)[0], (Object)fieldValues[i][j]);
                ++j;
            }
            CubeAggregationTest.assertEquals((Object)resultSets[0].getAggregationValue(0), (Object)fieldValues[i][5]);
            ++i;
        }
    }

    private void createAggregationResult() throws IOException, DataException {
        int[] sortTypes = new int[4];
        AggregationFunctionDefinition[] aggregationFunctions = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("totalSale", "sale", "SUM"), new AggregationFunctionDefinition("totalCost", "cost", "SUM")};
        AggregationDefinition aggregation = new AggregationDefinition(this.dimLevels, sortTypes, aggregationFunctions);
        String[][] keyNames = new String[][]{{"province"}, {"city"}, {"name"}, {"productID"}};
        String[][] attrNames = null;
        this.aggregationResultSet = new AggregationResultSet(aggregation, this.getAggregationResultRow(), keyNames, attrNames);
    }

    private IDiskArray getAggregationResultRow() throws DataException, IOException {
        int LIST_BUFFER_SIZE = 4000;
        BufferedStructureArray result = new BufferedStructureArray(AggregationResultRow.getCreator(), LIST_BUFFER_SIZE);
        Object[][] fieldValues = new Object[][]{{"AnHui", "HeFei", "li", new Integer(1), new Double(110.0), new Double(90.0)}, {"AnHui", "HeFei", "wang", new Integer(1), new Double(120.0), new Double(130.0)}, {"AnHui", "HeFei", "zhao", new Integer(2), new Double(60.0), new Double(80.0)}, {"AnHui", "HuaiBei", "zhao", new Integer(3), new Double(300.0), new Double(200.0)}, {"AnHui", "HuaiBei", "zhao", new Integer(4), new Double(150.0), new Double(100.0)}, {"AnHui", "HuaiBei", "zhao", new Integer(5), new Double(120.0), new Double(600.0)}, {"AnHui", "HuaiBei", "zhao", new Integer(6), new Double(120.0), new Double(70.0)}, {"HeBei", "ShiJiaZhuang", "li", new Integer(1), new Double(100.0), new Double(100.0)}, {"HeBei", "ShiJiaZhuang", "li", new Integer(2), new Double(150.0), new Double(50.0)}, {"HeBei", "ShiJiaZhuang", "wang", new Integer(3), new Double(110.0), new Double(120.0)}, {"HeBei", "ShiJiaZhuang", "wang", new Integer(1), new Double(60.0), new Double(80.0)}, {"HeBei", "ShiJiaZhuang", "wang", new Integer(2), new Double(300.0), new Double(200.0)}, {"HeBei", "XingTai", "wang", new Integer(1), new Double(100.0), new Double(100.0)}, {"HeBei", "XingTai", "wang", new Integer(2), new Double(210.0), new Double(170.0)}, {"ShanTong", "WeiFang", "wang", new Integer(1), new Double(45.0), new Double(45.0)}, {"ShanTong", "WeiFang", "wang", new Integer(2), new Double(243.0), new Double(45.0)}};
        int i = 0;
        while (i < fieldValues.length) {
            result.add((Object)this.newAggregationResultRow(fieldValues[i]));
            ++i;
        }
        return result;
    }

    protected AggregationResultRow newAggregationResultRow(Object[] fieldValues) throws DataException, IOException {
        AggregationResultRow resultObj = new AggregationResultRow();
        Member[] members = new Member[4];
        int i = 0;
        while (i < members.length) {
            members[i] = new Member();
            members[i].setKeyValues(new Object[]{fieldValues[i]});
            ++i;
        }
        resultObj.setLevelMembers(members);
        resultObj.setAggregationValues(new Object[]{fieldValues[4], fieldValues[5]});
        return resultObj;
    }
}

