/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeElementFactory;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeMaterializer;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.SelectionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationExecutor;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSetWithOneMoreDummyAggr;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.DataSetFromOriginalCube;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IDataSet4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.SimpleLevelFilter;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionForTest;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable1;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable2;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableAccessor;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import testutil.BaseTestCase;

public class FactTableHelperTest2
extends BaseTestCase {
    private DimLevel dimLevel31 = new DimLevel("dimension3", "level31");
    private DimLevel dimLevel21 = new DimLevel("dimension2", "level21");
    private DimLevel dimLevel11 = new DimLevel("dimension1", "level11");
    private DimLevel dimLevel12 = new DimLevel("dimension1", "level12");

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFactTableSaveAndLoad() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad(IDocumentManager documentManager) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable1.L1Col);
        iterator.setLevelMember(1, FactTable1.L2Col);
        iterator.setLevelMember(2, FactTable1.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension1");
        FactTableHelperTest2.assertEquals((int)dimensions[0].length(), (int)FactTable1.L1Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable1.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension2");
        FactTableHelperTest2.assertEquals((int)dimensions[1].length(), (int)3);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        int[] lL1Col = new int[]{1, 2, 3};
        iterator.setLevelMember(0, lL1Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension3");
        FactTableHelperTest2.assertEquals((int)dimensions[2].length(), (int)3);
        FactTable1 factTable1 = new FactTable1();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"bigThreeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTable1, dimensions, measureColumnName, new StopSign());
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"bigThreeDimensions"), new StopSign());
        FactTableHelperTest2.assertEquals((String)factTable.getDimensionInfo()[0].getDimensionName(), (String)"dimension1");
        FactTableHelperTest2.assertEquals((int)factTable.getDimensionInfo()[0].getDimensionLength(), (int)FactTable1.L1Col.length);
        FactTableHelperTest2.assertEquals((String)factTable.getDimensionInfo()[1].getDimensionName(), (String)"dimension2");
        FactTableHelperTest2.assertEquals((int)factTable.getDimensionInfo()[1].getDimensionLength(), (int)3);
        FactTableHelperTest2.assertEquals((String)factTable.getDimensionInfo()[2].getDimensionName(), (String)"dimension3");
        FactTableHelperTest2.assertEquals((int)factTable.getDimensionInfo()[2].getDimensionLength(), (int)3);
        FactTableHelperTest2.assertEquals((String)factTable.getMeasureInfo()[0].getMeasureName(), (String)"measure1");
        FactTableHelperTest2.assertEquals((int)factTable.getMeasureInfo()[0].getDataType(), (int)2);
        FactTableHelperTest2.assertEquals((String)factTable.getMeasureInfo()[1].getMeasureName(), (String)"measure2");
        FactTableHelperTest2.assertEquals((int)factTable.getMeasureInfo()[1].getDataType(), (int)3);
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        IDiskArray[] dimensionPosition = new IDiskArray[3];
        dimensionPosition[0] = new BufferedPrimitiveDiskArray();
        dimensionPosition[0].add((Object)new Integer(10));
        dimensionPosition[0].add((Object)new Integer(11));
        dimensionPosition[1] = new BufferedPrimitiveDiskArray();
        dimensionPosition[1].add((Object)new Integer(1));
        dimensionPosition[1].add((Object)new Integer(2));
        dimensionPosition[2] = new BufferedPrimitiveDiskArray();
        dimensionPosition[2].add((Object)new Integer(1));
        dimensionPosition[2].add((Object)new Integer(2));
        dimensionPosition[2].add((Object)new Integer(3));
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNames, dimensionPosition, new StopSign());
        FactTableHelperTest2.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        FactTableHelperTest2.assertTrue((boolean)facttableRowIterator.next());
        FactTableHelperTest2.assertEquals((int)10, (int)facttableRowIterator.getDimensionPosition(0));
        FactTableHelperTest2.assertEquals((int)2, (int)facttableRowIterator.getDimensionPosition(1));
        FactTableHelperTest2.assertEquals((int)2, (int)facttableRowIterator.getDimensionPosition(2));
        FactTableHelperTest2.assertEquals((Object)new Integer(10), (Object)facttableRowIterator.getMeasure(0));
        FactTableHelperTest2.assertEquals((Object)new Double(10.0), (Object)facttableRowIterator.getMeasure(1));
        FactTableHelperTest2.assertTrue((boolean)facttableRowIterator.next());
        FactTableHelperTest2.assertEquals((int)11, (int)facttableRowIterator.getDimensionPosition(0));
        FactTableHelperTest2.assertEquals((int)2, (int)facttableRowIterator.getDimensionPosition(1));
        FactTableHelperTest2.assertEquals((int)2, (int)facttableRowIterator.getDimensionPosition(2));
        FactTableHelperTest2.assertEquals((Object)new Integer(11), (Object)facttableRowIterator.getMeasure(0));
        FactTableHelperTest2.assertEquals((Object)new Double(11.0), (Object)facttableRowIterator.getMeasure(1));
        FactTableHelperTest2.assertFalse((boolean)facttableRowIterator.next());
    }

    private static int[] distinct(int[] iValues) {
        Arrays.sort(iValues);
        ArrayList<Integer> tempList = new ArrayList<Integer>();
        tempList.add(new Integer(iValues[0]));
        int i = 1;
        while (i < iValues.length) {
            if (iValues[i] != iValues[i - 1]) {
                tempList.add(new Integer(iValues[i]));
            }
            ++i;
        }
        int[] result = new int[tempList.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (Integer)tempList.get(i2);
            ++i2;
        }
        return result;
    }

    public void testFactTableSaveAndLoad2() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad2(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad2(IDocumentManager documentManager) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension1");
        FactTableHelperTest2.assertEquals((int)dimensions[0].length(), (int)FactTable2.L1Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension2");
        FactTableHelperTest2.assertEquals((int)dimensions[1].length(), (int)3);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension3");
        FactTableHelperTest2.assertEquals((int)dimensions[2].length(), (int)12);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"bigThreeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTable2, dimensions, measureColumnName, new StopSign());
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"bigThreeDimensions"), new StopSign());
        FactTableHelperTest2.assertEquals((String)factTable.getDimensionInfo()[0].getDimensionName(), (String)"dimension1");
        FactTableHelperTest2.assertEquals((int)factTable.getDimensionInfo()[0].getDimensionLength(), (int)FactTable2.L1Col.length);
        FactTableHelperTest2.assertEquals((String)factTable.getDimensionInfo()[1].getDimensionName(), (String)"dimension2");
        FactTableHelperTest2.assertEquals((int)factTable.getDimensionInfo()[1].getDimensionLength(), (int)3);
        FactTableHelperTest2.assertEquals((String)factTable.getDimensionInfo()[2].getDimensionName(), (String)"dimension3");
        FactTableHelperTest2.assertEquals((int)factTable.getDimensionInfo()[2].getDimensionLength(), (int)12);
        FactTableHelperTest2.assertEquals((String)factTable.getMeasureInfo()[0].getMeasureName(), (String)"measure1");
        FactTableHelperTest2.assertEquals((int)factTable.getMeasureInfo()[0].getDataType(), (int)2);
        FactTableHelperTest2.assertEquals((String)factTable.getMeasureInfo()[1].getMeasureName(), (String)"measure2");
        FactTableHelperTest2.assertEquals((int)factTable.getMeasureInfo()[1].getDataType(), (int)3);
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        IDiskArray[] dimensionPosition = new IDiskArray[3];
        dimensionPosition[0] = new BufferedPrimitiveDiskArray();
        dimensionPosition[0].add((Object)new Integer(10));
        dimensionPosition[0].add((Object)new Integer(11));
        dimensionPosition[1] = new BufferedPrimitiveDiskArray();
        dimensionPosition[1].add((Object)new Integer(1));
        dimensionPosition[1].add((Object)new Integer(2));
        dimensionPosition[2] = new BufferedPrimitiveDiskArray();
        dimensionPosition[2].add((Object)new Integer(3));
        dimensionPosition[2].add((Object)new Integer(4));
        dimensionPosition[2].add((Object)new Integer(5));
        dimensionPosition[2].add((Object)new Integer(10));
        dimensionPosition[2].add((Object)new Integer(11));
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNames, dimensionPosition, new StopSign());
        FactTableHelperTest2.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        FactTableHelperTest2.assertTrue((boolean)facttableRowIterator.next());
        FactTableHelperTest2.assertEquals((int)10, (int)facttableRowIterator.getDimensionPosition(0));
        FactTableHelperTest2.assertEquals((int)2, (int)facttableRowIterator.getDimensionPosition(1));
        FactTableHelperTest2.assertEquals((int)10, (int)facttableRowIterator.getDimensionPosition(2));
        FactTableHelperTest2.assertEquals((Object)new Integer(10), (Object)facttableRowIterator.getMeasure(0));
        FactTableHelperTest2.assertEquals((Object)new Double(10.0), (Object)facttableRowIterator.getMeasure(1));
        FactTableHelperTest2.assertTrue((boolean)facttableRowIterator.next());
        FactTableHelperTest2.assertEquals((int)11, (int)facttableRowIterator.getDimensionPosition(0));
        FactTableHelperTest2.assertEquals((int)2, (int)facttableRowIterator.getDimensionPosition(1));
        FactTableHelperTest2.assertEquals((int)11, (int)facttableRowIterator.getDimensionPosition(2));
        FactTableHelperTest2.assertEquals((Object)new Integer(11), (Object)facttableRowIterator.getMeasure(0));
        FactTableHelperTest2.assertEquals((Object)new Double(11.0), (Object)facttableRowIterator.getMeasure(1));
        FactTableHelperTest2.assertFalse((boolean)facttableRowIterator.next());
    }

    public void testFactTableSaveAndLoad3() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad3(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad3(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        IDiskArray positionArray;
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension1");
        FactTableHelperTest2.assertEquals((int)dimensions[0].length(), (int)FactTable2.L1Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension2");
        FactTableHelperTest2.assertEquals((int)dimensions[1].length(), (int)3);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension3");
        FactTableHelperTest2.assertEquals((int)dimensions[2].length(), (int)12);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"bigThreeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTable2, dimensions, measureColumnName, new StopSign());
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"bigThreeDimensions"), new StopSign());
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        ILevel[] level = dimensions[1].getHierarchy().getLevels();
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(1)}, (Object[])new Object[]{new Integer(3)}, (boolean)true, (boolean)false);
        Level[] findLevel = new Level[]{(Level)level[0]};
        IDiskArray[] positionForFilter = null;
        positionForFilter = new IDiskArray[2];
        positionForFilter[0] = positionArray = dimensions[1].find(findLevel, filter);
        FactTableHelperTest2.assertEquals((int)positionArray.size(), (int)2);
        DimensionResultIterator[] dimesionResultSets = new DimensionResultIterator[2];
        dimesionResultSets[0] = new DimensionResultIterator(dimensions[1], positionArray, new StopSign());
        positionArray = dimensions[2].findAll();
        dimesionResultSets[1] = new DimensionResultIterator(dimensions[2], positionArray, new StopSign());
        String[] dimensionNamesForFilter = new String[]{"dimension2", "dimension3"};
        positionForFilter[1] = positionArray;
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNamesForFilter, positionForFilter, new StopSign());
        FactTableHelperTest2.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        AggregationDefinition[] aggregations = new AggregationDefinition[2];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        sortType = new int[]{0};
        levelsForFilter = new DimLevel[]{this.dimLevel31};
        aggregations[1] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        DataSetFromOriginalCube dataSet4Aggregation = new DataSetFromOriginalCube((IFactTableRowIterator)facttableRowIterator, (IDimensionResultIterator[])dimesionResultSets, null);
        AggregationExecutor aggregationCalculatorExecutor = new AggregationExecutor(null, (IDataSet4Aggregation)dataSet4Aggregation, aggregations, 0xA00000L);
        IAggregationResultSet[] resultSet = aggregationCalculatorExecutor.execute(new StopSign());
        FactTableHelperTest2.assertEquals((int)resultSet[0].length(), (int)2);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)2);
        resultSet[0].seek(0);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[0].seek(1);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        FactTableHelperTest2.assertEquals((int)resultSet[1].length(), (int)8);
        FactTableHelperTest2.assertEquals((int)resultSet[1].getAggregationDataType(0), (int)3);
        FactTableHelperTest2.assertEquals((int)resultSet[1].getLevelIndex(this.dimLevel31), (int)0);
        FactTableHelperTest2.assertEquals((int)resultSet[1].getLevelKeyDataType(this.dimLevel31, "level31"), (int)2);
        resultSet[1].seek(0);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(1));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(0.0));
        resultSet[1].seek(1);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(2));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(1.0));
        resultSet[1].seek(2);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(3));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(2.0));
        resultSet[1].seek(3);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(4));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(3.0));
        resultSet[1].seek(4);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(5));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(4.0));
        resultSet[1].seek(5);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(6));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(5.0));
        resultSet[1].seek(6);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(7));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[1].seek(7);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(8));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(7.0));
        this.closeResultSets(resultSet);
    }

    public void testFactTableSaveAndLoad4() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad4(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad4(IDocumentManager documentManager) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension1");
        FactTableHelperTest2.assertEquals((int)dimensions[0].length(), (int)FactTable2.L1Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension2");
        FactTableHelperTest2.assertEquals((int)dimensions[1].length(), (int)3);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension3");
        FactTableHelperTest2.assertEquals((int)dimensions[2].length(), (int)12);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        Cube cube = new Cube("cube", documentManager);
        cube.create(CubeUtility.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper((ICube)cube);
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(1)}, (Object[])new Object[]{new Integer(3)}, (boolean)true, (boolean)false);
        cubeQueryExcutorHelper.addSimpleLevelFilter(new SimpleLevelFilter(this.dimLevel21, filter[0]));
        AggregationDefinition[] aggregations = new AggregationDefinition[2];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        sortType = new int[]{0};
        levelsForFilter = new DimLevel[]{this.dimLevel31};
        aggregations[1] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        FactTableHelperTest2.assertEquals((int)resultSet[0].length(), (int)2);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)2);
        resultSet[0].seek(0);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[0].seek(1);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        FactTableHelperTest2.assertEquals((int)resultSet[1].length(), (int)8);
        FactTableHelperTest2.assertEquals((int)resultSet[1].getAggregationDataType(0), (int)3);
        FactTableHelperTest2.assertEquals((int)resultSet[1].getLevelIndex(this.dimLevel31), (int)0);
        FactTableHelperTest2.assertEquals((int)resultSet[1].getLevelKeyDataType(this.dimLevel31, "level31"), (int)2);
        resultSet[1].seek(0);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(1));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(0.0));
        resultSet[1].seek(1);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(2));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(1.0));
        resultSet[1].seek(2);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(3));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(2.0));
        resultSet[1].seek(3);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(4));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(3.0));
        resultSet[1].seek(4);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(5));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(4.0));
        resultSet[1].seek(5);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(6));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(5.0));
        resultSet[1].seek(6);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(7));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[1].seek(7);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(8));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(7.0));
        this.closeResultSets(resultSet);
    }

    public void testFactTableSaveAndLoad5() throws IOException, BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(FactTableHelperTest2.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        CubeMaterializer cubeCreatorHelper = new CubeMaterializer(engine, "cub1");
        this.testFactTableSaveAndLoad5(cubeCreatorHelper);
        cubeCreatorHelper.close();
    }

    private void testFactTableSaveAndLoad5(CubeMaterializer cubeMaterializer) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{CubeElementFactory.createLevelDefinition((String)"level11", (String[])new String[]{"level11"}, null), CubeElementFactory.createLevelDefinition((String)"level12", (String[])new String[]{"level12"}, null), CubeElementFactory.createLevelDefinition((String)"level13", (String[])new String[]{"level13"}, null)};
        IHierarchy hierarchy = cubeMaterializer.createHierarchy("dimension1", "hir1", (IDatasetIterator)iterator, levelDefs, new StopSign());
        dimensions[0] = (Dimension)cubeMaterializer.createDimension("dimension1", hierarchy);
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"hir1");
        FactTableHelperTest2.assertEquals((int)dimensions[0].length(), (int)FactTable2.L1Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{CubeElementFactory.createLevelDefinition((String)"level21", (String[])new String[]{"level21"}, null)};
        hierarchy = cubeMaterializer.createHierarchy("dimension2", "hir2", (IDatasetIterator)iterator, levelDefs, new StopSign());
        dimensions[1] = (Dimension)cubeMaterializer.createDimension("dimension2", hierarchy);
        hierarchy = dimensions[1].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"hir2");
        FactTableHelperTest2.assertEquals((int)dimensions[1].length(), (int)3);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        hierarchy = cubeMaterializer.createHierarchy("dimension3", "hir3", (IDatasetIterator)iterator, levelDefs, new StopSign());
        dimensions[2] = (Dimension)cubeMaterializer.createDimension("dimension3", hierarchy);
        hierarchy = dimensions[2].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"hir3");
        FactTableHelperTest2.assertEquals((int)dimensions[2].length(), (int)12);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        cubeMaterializer.createCube("cube", CubeUtility.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube", (IDocumentManager)cubeMaterializer.getDocumentManager(), (StopSign)new StopSign()));
        ISelection[][] filter = new ISelection[1][2];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(1)}, (Object[])new Object[]{new Integer(2)}, (boolean)true, (boolean)false);
        filter[0][1] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(2)}, (Object[])new Object[]{new Integer(3)}, (boolean)true, (boolean)false);
        cubeQueryExcutorHelper.addSimpleLevelFilter(new SimpleLevelFilter(this.dimLevel21, filter[0]));
        AggregationDefinition[] aggregations = new AggregationDefinition[2];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        sortType = new int[]{0, 0};
        levelsForFilter = new DimLevel[]{this.dimLevel31};
        aggregations[1] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        FactTableHelperTest2.assertEquals((int)resultSet[0].length(), (int)2);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel21), (int)0);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (int)2);
        resultSet[0].seek(0);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[0].seek(1);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        FactTableHelperTest2.assertEquals((int)resultSet[1].length(), (int)8);
        FactTableHelperTest2.assertEquals((int)resultSet[1].getAggregationDataType(0), (int)3);
        FactTableHelperTest2.assertEquals((int)resultSet[1].getLevelIndex(this.dimLevel31), (int)0);
        FactTableHelperTest2.assertEquals((int)resultSet[1].getLevelKeyDataType(this.dimLevel31, "level31"), (int)2);
        resultSet[1].seek(0);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(1));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(0.0));
        resultSet[1].seek(1);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(2));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(1.0));
        resultSet[1].seek(2);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(3));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(2.0));
        resultSet[1].seek(3);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(4));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(3.0));
        resultSet[1].seek(4);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(5));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(4.0));
        resultSet[1].seek(5);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(6));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(5.0));
        resultSet[1].seek(6);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(7));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[1].seek(7);
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(8));
        FactTableHelperTest2.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(7.0));
        this.closeResultSets(resultSet);
    }

    public void testMaxAggregation() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testMaxAggregation(documentManager);
        documentManager.close();
    }

    private void testMaxAggregation(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension1");
        FactTableHelperTest2.assertEquals((int)dimensions[0].length(), (int)FactTable2.L3Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension2");
        FactTableHelperTest2.assertEquals((int)dimensions[1].length(), (int)3);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension3");
        FactTableHelperTest2.assertEquals((int)dimensions[2].length(), (int)12);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"bigThreeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTable2, dimensions, measureColumnName, new StopSign());
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"bigThreeDimensions"), new StopSign());
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        DimensionResultIterator[] dimesionResultSets = new DimensionResultIterator[1];
        IDiskArray positionArray = dimensions[0].findAll();
        dimesionResultSets[0] = new DimensionResultIterator(dimensions[0], positionArray, new StopSign());
        String[] dimensionNamesForFilter = new String[]{"dimension1"};
        IDiskArray[] positionsForFilter = new IDiskArray[]{positionArray};
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNamesForFilter, positionsForFilter, new StopSign());
        FactTableHelperTest2.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("max", "measure1", "MAX")};
        aggregations[0] = new AggregationDefinition(null, null, funcitons);
        DataSetFromOriginalCube dataSet4Aggregation = new DataSetFromOriginalCube((IFactTableRowIterator)facttableRowIterator, (IDimensionResultIterator[])dimesionResultSets, null);
        AggregationExecutor aggregationCalculatorExecutor = new AggregationExecutor(null, (IDataSet4Aggregation)dataSet4Aggregation, aggregations, 0xA00000L);
        IAggregationResultSet[] resultSet = aggregationCalculatorExecutor.execute(new StopSign());
        FactTableHelperTest2.assertEquals((int)resultSet[0].length(), (int)1);
        resultSet[0].seek(0);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)11);
        this.closeResultSets(resultSet);
    }

    public void testNestAggregation() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testNestAggregation(documentManager);
        documentManager.close();
    }

    private void closeResultSets(IAggregationResultSet[] resultSets) throws IOException {
        IAggregationResultSet[] iAggregationResultSetArray = resultSets;
        int n = resultSets.length;
        int n2 = 0;
        while (n2 < n) {
            IAggregationResultSet rs = iAggregationResultSetArray[n2];
            rs.close();
            ++n2;
        }
    }

    private void testNestAggregation(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension1");
        FactTableHelperTest2.assertEquals((int)dimensions[0].length(), (int)FactTable2.L3Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension2");
        FactTableHelperTest2.assertEquals((int)dimensions[1].length(), (int)3);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        FactTableHelperTest2.assertEquals((String)hierarchy.getName(), (String)"dimension3");
        FactTableHelperTest2.assertEquals((int)dimensions[2].length(), (int)12);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"bigThreeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTable2, dimensions, measureColumnName, new StopSign());
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"bigThreeDimensions"), new StopSign());
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        DimensionResultIterator[] dimesionResultSets = new DimensionResultIterator[1];
        IDiskArray positionArray = dimensions[0].findAll();
        dimesionResultSets[0] = new DimensionResultIterator(dimensions[0], positionArray, new StopSign());
        String[] dimensionNamesForFilter = new String[]{"dimension1"};
        IDiskArray[] positionsForFilter = new IDiskArray[]{positionArray};
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNamesForFilter, positionsForFilter, new StopSign());
        FactTableHelperTest2.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[]{0, 0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel11, this.dimLevel12};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("total", "measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        DataSetFromOriginalCube dataSet4Aggregation = new DataSetFromOriginalCube((IFactTableRowIterator)facttableRowIterator, (IDimensionResultIterator[])dimesionResultSets, null);
        AggregationExecutor aggregationCalculatorExecutor = new AggregationExecutor(null, (IDataSet4Aggregation)dataSet4Aggregation, aggregations, 0xA00000L);
        IAggregationResultSet[] resultSet = aggregationCalculatorExecutor.execute(new StopSign());
        FactTableHelperTest2.assertEquals((int)resultSet[0].length(), (int)6);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel11), (int)0);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel12), (int)1);
        resultSet[0].seek(0);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(1.0));
        resultSet[0].seek(1);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(5.0));
        resultSet[0].seek(2);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(9.0));
        resultSet[0].seek(3);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(13.0));
        resultSet[0].seek(4);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(3));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(17.0));
        resultSet[0].seek(5);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(3));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(21.0));
        IAggregationResultSet sourceAggrResultSet = resultSet[0];
        aggregations = new AggregationDefinition[1];
        funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("max_total", "total", "MAX")};
        aggregations[0] = new AggregationDefinition(null, null, funcitons);
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        ScriptContext cx = new ScriptContext();
        AggregationResultSetWithOneMoreDummyAggr ars = new AggregationResultSetWithOneMoreDummyAggr(sourceAggrResultSet, "max_total", (IBaseExpression)new ScriptExpression("data[\"total\"]"), (Scriptable)scope, cx);
        resultSet = AggregationHelper.execute((IAggregationResultSet)ars, (AggregationDefinition[])aggregations, (StopSign)new StopSign());
        FactTableHelperTest2.assertEquals((int)resultSet[0].length(), (int)1);
        resultSet[0].seek(0);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(21.0));
        aggregations = new AggregationDefinition[1];
        sortType = new int[]{0};
        levelsForFilter = new DimLevel[]{this.dimLevel11};
        funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("sum_total", "total", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        ars = new AggregationResultSetWithOneMoreDummyAggr(sourceAggrResultSet, "sum_total", (IBaseExpression)new ScriptExpression("data[\"total\"]"), (Scriptable)scope, cx);
        resultSet = AggregationHelper.execute((IAggregationResultSet)ars, (AggregationDefinition[])aggregations, (StopSign)new StopSign());
        FactTableHelperTest2.assertEquals((int)resultSet[0].length(), (int)3);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getAggregationDataType(0), (int)3);
        FactTableHelperTest2.assertEquals((int)resultSet[0].getLevelIndex(this.dimLevel11), (int)0);
        resultSet[0].seek(0);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[0].seek(1);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        resultSet[0].seek(2);
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(3));
        FactTableHelperTest2.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(38.0));
        this.closeResultSets(resultSet);
        Context.exit();
        cx.close();
    }
}

