/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.EdgeCursor;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerMap;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerReleaser;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.Dataset2;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;

public class TestTimeDimension
extends TestCase {
    private static final String OUTPUT_FOLDER = "DtETestTempDataoutput";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private static String[] distinct(String[] sValues) {
        Arrays.sort(sValues);
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add(sValues[0]);
        int i = 1;
        while (i < sValues.length) {
            if (!sValues[i].equals(sValues[i - 1])) {
                tempList.add(sValues[i]);
            }
            ++i;
        }
        String[] result = new String[tempList.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (String)tempList.get(i2);
            ++i2;
        }
        return result;
    }

    public void testTimeDimension() throws Exception {
        String cubeName = "cube";
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager((String)engine.getSession().getTempDir());
        DocManagerMap.getDocManagerMap().set(String.valueOf(engine.hashCode()), String.valueOf(engine.getSession().getTempDir()) + engine.getSession().getEngine().hashCode(), documentManager);
        engine.addShutdownListener((IShutdownListener)new DocManagerReleaser((DataEngine)engine));
        this.createCube(documentManager);
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("l1");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("year");
        hier2.createLevel("month");
        hier2.createLevel("day");
        cqd.createMeasure("m1");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"l1\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge2level1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"year\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level2");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"month\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding41 = new Binding("edge2level3");
        binding41.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"day\"]"));
        cqd.addBinding((IBinding)binding41);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"m1\"]"));
        cqd.addBinding((IBinding)binding5);
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension2\"][\"day\"]", 4, "13"));
        cqd.addFilter((IFilterDefinition)filter);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        rowEdgeBindingNames.add("edge2level2");
        rowEdgeBindingNames.add("edge2level3");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
        documentManager.close();
    }

    protected static String getTempDir() {
        return String.valueOf(TestTimeDimension.getOutputFolder().getAbsolutePath()) + File.separator + "DataEngineSessionTemp" + File.separator;
    }

    protected static File getOutputFolder() {
        return new File(new File(System.getProperty("java.io.tmpdir")), OUTPUT_FOLDER);
    }

    private DataEngineContext createPresentationContext() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(TestTimeDimension.getTempDir());
        return context;
    }

    private void createCube(IDocumentManager documentManager) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[2];
        ILevelDefn[] levelDefs = new ILevelDefn[1];
        Dataset2 iterator = new Dataset2();
        levelDefs[0] = new LevelDefinition("l1", new String[]{"l1"}, null);
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        TestTimeDimension.assertEquals((String)hierarchy.getName(), (String)"dimension1");
        iterator = new Dataset2();
        levelDefs[0] = new LevelDefinition("l2", new String[]{"l2"}, null);
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)true, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        TestTimeDimension.assertEquals((String)hierarchy.getName(), (String)"dimension2");
        Cube cube = new Cube("cube", documentManager);
        cube.create((String[][])new String[][]{{"l1"}, {"l2"}}, (IDimension[])dimensions, (IDatasetIterator)new Dataset2(), new String[]{"m1"}, new StopSign());
        cube.close();
        documentManager.flush();
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingNames) throws Exception {
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, null, null, null);
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingNames, String columnAggr, String rowAggr, String overallAggr) throws Exception {
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, columnAggr, rowAggr, overallAggr, true);
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingNames, String columnAggr, String rowAggr, String overallAggr, boolean checkOutput) throws Exception {
        String output = this.getOutputFromCursor(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, columnAggr, rowAggr, overallAggr);
        System.out.println(output);
        this.close(cursor);
    }

    private void close(CubeCursor dataCursor) throws OLAPException {
        int i = 0;
        while (i < dataCursor.getOrdinateEdge().size()) {
            EdgeCursor edge = (EdgeCursor)dataCursor.getOrdinateEdge().get(i);
            edge.close();
            ++i;
        }
        dataCursor.close();
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingName, String[] columnAggrs) throws Exception {
        this.getOutputFromCursor(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingName, columnAggrs);
    }

    private String getOutputFromCursor(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingName, String[] columnAggrs) throws OLAPException {
        EdgeCursor edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(1);
        String[] lines = new String[columnEdgeBindingNames.size()];
        int i = 0;
        while (i < columnEdgeBindingNames.size()) {
            lines[i] = "\t\t";
            ++i;
        }
        while (edge1.next()) {
            i = 0;
            while (i < columnEdgeBindingNames.size()) {
                int n = i;
                lines[n] = String.valueOf(lines[n]) + cursor.getObject(columnEdgeBindingNames.get(i).toString()) + "\t\t";
                ++i;
            }
        }
        String output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = String.valueOf(output) + "\n" + lines[i2];
            ++i2;
        }
        while (edge2.next()) {
            String line = "";
            int i3 = 0;
            while (i3 < rowEdgeBindingNames.size()) {
                line = String.valueOf(line) + cursor.getObject(rowEdgeBindingNames.get(i3).toString()).toString() + "\t\t";
                ++i3;
            }
            edge1.beforeFirst();
            while (edge1.next()) {
                line = String.valueOf(line) + cursor.getObject(measureBindingName) + "\t\t";
            }
            output = String.valueOf(output) + "\n" + line;
        }
        String line = "total\t\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("total") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        line = "maxTotal1\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("maxTotal1") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        line = "maxTotal2\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("maxTotal2") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        line = "sumTotal1\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("sumTotal1") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        line = "sumTotal2\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("sumTotal2") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        line = "sumSumTotal1\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = String.valueOf(line) + cursor.getObject("sumSumTotal1") + "\t\t";
        }
        output = String.valueOf(output) + "\n" + line;
        return output;
    }

    private String getOutputFromCursor(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingNames, String columnAggr, String rowAggr, String overallAggr) throws OLAPException {
        EdgeCursor edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(1);
        String[] lines = new String[columnEdgeBindingNames.size()];
        int i = 0;
        while (i < columnEdgeBindingNames.size()) {
            lines[i] = "\t\t";
            ++i;
        }
        while (edge1.next()) {
            i = 0;
            while (i < columnEdgeBindingNames.size()) {
                int n = i;
                lines[n] = String.valueOf(lines[n]) + cursor.getObject(columnEdgeBindingNames.get(i).toString()) + "\t\t";
                ++i;
            }
        }
        if (rowAggr != null) {
            int n = lines.length - 1;
            lines[n] = String.valueOf(lines[n]) + "Total";
        }
        String output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = String.valueOf(output) + "\n" + lines[i2];
            ++i2;
        }
        while (edge2.next()) {
            String line = "";
            int i3 = 0;
            while (i3 < rowEdgeBindingNames.size()) {
                line = String.valueOf(line) + cursor.getObject(rowEdgeBindingNames.get(i3).toString()).toString() + "\t\t";
                ++i3;
            }
            edge1.beforeFirst();
            while (edge1.next()) {
                line = String.valueOf(line) + cursor.getObject(measureBindingNames) + "\t\t";
            }
            if (rowAggr != null) {
                line = String.valueOf(line) + cursor.getObject(rowAggr);
            }
            output = String.valueOf(output) + "\n" + line;
        }
        if (columnAggr != null) {
            String line = "Total\t\t";
            edge1.beforeFirst();
            while (edge1.next()) {
                line = String.valueOf(line) + cursor.getObject(columnAggr) + "\t\t";
            }
            if (overallAggr != null) {
                line = String.valueOf(line) + cursor.getObject(overallAggr);
            }
            output = String.valueOf(output) + "\n" + line;
        }
        return output;
    }
}

