/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;

public class BufferedPrimitiveDiskArrayTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInteger() throws IOException {
        int objectNumber = 1001;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(1);
        try {
            list.get(0);
            BufferedPrimitiveDiskArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        try {
            list.get(1);
            BufferedPrimitiveDiskArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new Integer(i));
            ++i;
        }
        BufferedPrimitiveDiskArrayTest.assertEquals((int)list.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            BufferedPrimitiveDiskArrayTest.assertEquals((Object)list.get(i), (Object)new Integer(i));
            ++i;
        }
        try {
            list.get(objectNumber);
            BufferedPrimitiveDiskArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        list.clear();
        list.close();
    }

    public void testSpecial() throws IOException {
        int objectNumber = 801;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(800);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new Integer(i));
            try {
                list.get(i + 1);
                BufferedPrimitiveDiskArrayTest.fail();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            ++i;
        }
        BufferedPrimitiveDiskArrayTest.assertEquals((int)list.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            BufferedPrimitiveDiskArrayTest.assertEquals((Object)list.get(i), (Object)new Integer(i));
            ++i;
        }
        try {
            list.get(objectNumber);
            BufferedPrimitiveDiskArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        list.clear();
        list.close();
    }

    public void testStress() throws IOException {
        int objectNumber = 10000;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(40000);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new Integer(i));
            ++i;
        }
        BufferedPrimitiveDiskArrayTest.assertEquals((int)list.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            BufferedPrimitiveDiskArrayTest.assertEquals((Object)list.get(i), (Object)new Integer(i));
            ++i;
        }
        list.clear();
        list.close();
    }

    public void testDouble() throws IOException {
        int objectNumber = 1001;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(700);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new Double(i));
            ++i;
        }
        BufferedPrimitiveDiskArrayTest.assertEquals((int)list.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            BufferedPrimitiveDiskArrayTest.assertEquals((Object)list.get(i), (Object)new Double(i));
            ++i;
        }
        list.close();
    }

    public void testBoolean() throws IOException {
        int objectNumber = 1001;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(500);
        int i = 0;
        while (i < objectNumber) {
            if (i % 2 == 0) {
                list.add((Object)new Boolean(false));
            } else {
                list.add((Object)new Boolean(true));
            }
            ++i;
        }
        BufferedPrimitiveDiskArrayTest.assertEquals((int)list.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            if (i % 2 == 0) {
                BufferedPrimitiveDiskArrayTest.assertEquals((Object)list.get(i), (Object)new Boolean(false));
            } else {
                BufferedPrimitiveDiskArrayTest.assertEquals((Object)list.get(i), (Object)new Boolean(true));
            }
            ++i;
        }
        list.close();
    }

    public void testString() throws IOException {
        int objectNumber = 200;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(300);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)("string" + i));
            ++i;
        }
        BufferedPrimitiveDiskArrayTest.assertEquals((int)list.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            BufferedPrimitiveDiskArrayTest.assertEquals((Object)list.get(i), (Object)("string" + i));
            ++i;
        }
        list.close();
    }

    public void testBytes() throws IOException {
        int objectNumber = 100;
        byte[] b = null;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(300);
        int i = 0;
        while (i < objectNumber) {
            b = new byte[]{(byte)i, (byte)(i + 1), (byte)(i + 2)};
            list.add((Object)new Bytes(b));
            ++i;
        }
        BufferedPrimitiveDiskArrayTest.assertEquals((int)list.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            b = ((Bytes)list.get(i)).bytesValue();
            BufferedPrimitiveDiskArrayTest.assertEquals((int)b[0], (int)i);
            BufferedPrimitiveDiskArrayTest.assertEquals((int)b[1], (int)(i + 1));
            BufferedPrimitiveDiskArrayTest.assertEquals((int)b[2], (int)(i + 2));
            ++i;
        }
        list.close();
    }

    public void testBigDecimal() throws IOException {
        int objectNumber = 3000;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(300);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        BufferedPrimitiveDiskArrayTest.assertEquals((int)list.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            BufferedPrimitiveDiskArrayTest.assertEquals((Object)list.get(i), (Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        list.close();
    }

    public void testDate() throws IOException {
        int objectNumber = 4101;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(500);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            BufferedPrimitiveDiskArrayTest.assertEquals((Object)list.get(i), (Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        list.close();
    }
}

